package jp.oarts.pirka.test.view;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.win.PirkaWindow;

public class OldServletTest02 extends PirkaWindow {

	public OldServletTest02() {
		FieldMap field = getFieldMap();
		field.setOfficialFieldName("sendAdrs", "͂");
		field.setAutoCheck("clr",false);
		field.setAutoCheck("returnButton",false);

		addCheck("sendAdrs", PirkaChecker.required);
		addErrorCheckReturner();
	}

	public void preDraw(){
		FieldMap field = getFieldMap();
		field.setValue("total1", (Integer) getSession("item001"));
		field.setValue("total2", (Integer) getSession("item002"));
		field.setValue("sendAdrs", (String) getSession("sendAdrs"));
	}
	
	public void clr() {
		putSession("item001", (Integer) 0);
		putSession("item002", (Integer) 0);
	}

	public PirkaWindow bill() {
		FieldMap field = getFieldMap();
		putSession("sendAdrs", field.getValueString("sendAdrs"));
		return new OldServletTest03();
	}

	public PirkaWindow returnButton() {
		return new OldServletTest01();
	}
}
