package jp.oarts.pirka.core.analyzer.cls;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import jp.oarts.pirka.core.res.PirkaRespons;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * NX̓NX
 * 
 * @author ito
 * 
 */
public class ClassAnalyzer implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -231081597705252549L;

	/**
	 * w肳ꂽIuWFNg͂ANV\bh̃}bv쐬<BR>
	 * }bvɒ~郁\bh͖߂lvoid܂PirkaResponsłp[^Ȃ̃\bhł
	 * 
	 * @param object
	 *            IuWFNg
	 * @return ANV}bv
	 */
	public static Map<String, Method> getMethodMap(Object object) {
		return getMethodMap(object, PirkaWindow.class, PirkaRespons.class);
	}

	/**
	 * 
	 * @param object
	 * @param rootClass
	 * @param returnClass
	 * @return \bh}bv
	 */
	public static Map<String, Method> getMethodMap(Object object, Class rootClass, Class returnClass) {

		Map<String, Method> map = new HashMap<String, Method>();

		if (!(rootClass.isInstance(object))) {
			return map;
		}

		Class classObject = object.getClass();

		Class baseClass = classObject;
		while (!baseClass.equals(rootClass)) {
			Method[] methods = baseClass.getDeclaredMethods();
			for (Method method : methods) {
				if (method.getParameterTypes().length == 0 //
						&& Modifier.isPublic(method.getModifiers()) //
						&& (method.getReturnType() == void.class //
						|| returnClass.isAssignableFrom(method.getReturnType()))) {
					if (!map.containsKey(method.getName())) {
						map.put(method.getName(), method);
					}
				}
			}
			baseClass = baseClass.getSuperclass();
		}
		return map;
	}
}
