package jp.oarts.pirka.core.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.app.EntryPointIF;

/**
 * pirka t@CAbv[h}l[W[
 * 
 * @author ito
 * 
 */
public class PirkaUploadManager implements Serializable {

	/** t@CǗԍ */
	private static long fileNo = 0;

	// CvbgXg[}bv
	private static Map<Long, InputStream> inputStreamMap = new HashMap<Long, InputStream>();

	/**
	 * t@CǗԍ̎擾
	 * 
	 * @return t@CǗԍ
	 */
	public static synchronized long getFileNo() {
		fileNo++;
		return fileNo;
	}

	/**
	 * t@CǗԍɑΉAEgvbgXg[̎擾
	 * 
	 * @param fileNo
	 *            t@CǗԍ
	 * @return AEgvbgXg[
	 * @throws IOException
	 */
	public static synchronized OutputStream getOutputStream(long fileNo) throws IOException {
		EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
		OutputStream os = entryPoint.getTempFileManager().getOutputStream(fileNo);
		return os;
	}

	/**
	 * t@CǗԍɑΉCvbgXg[̎擾
	 * 
	 * @param fileNo
	 *            t@CǗԍ
	 * @return CvbgXg[
	 * @throws IOException
	 */
	public static synchronized InputStream getInputStream(long fileNo) throws IOException {

		if (inputStreamMap.containsKey(fileNo)) {
			throw new IOException("Ɏ擾ς݂ł");
		}

		EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
		InputStream fis = entryPoint.getTempFileManager().getInputStream(fileNo);
		inputStreamMap.put(fileNo, fis);

		return fis;
	}

	/**
	 * Abv[ht@C̍폜
	 * 
	 * @param fileNo
	 *            폜st@CǗԍ
	 * @throws IOException
	 */
	private static synchronized void deleteFile(long fileNo) throws IOException {

		if (inputStreamMap.containsKey(fileNo)) {
			InputStream is = inputStreamMap.get(fileNo);
			inputStreamMap.remove(fileNo);

			if (is != null) {
				try {
					is.close(); // N[Y
				} catch (IOException e) {
				}
			}
		}

		EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
		entryPoint.getTempFileManager().delete(fileNo);
	}

	/**
	 * Abv[ht@C̍폜
	 * 
	 * @param deleteFineNoList
	 *            폜st@CǗԍXg
	 * @throws IOException
	 */
	public static synchronized void deleteFile(List<Long> deleteFineNoList) throws IOException {
		Long[] deleteFileNos = deleteFineNoList.toArray(new Long[0]);
		for (Long fileNo : deleteFileNos) {
			deleteFile(fileNo);
		}
	}

}
