package jp.oarts.pirka.core.util.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * DTORo[^[
 * 
 * @author ito
 * 
 */
public class DtoConverter implements Serializable {
	/**
	 * FieldMapIuWFNgi[Ăf[^MapIuWFNg쐬B<BR>
	 * [vListIuWFNgɒuB̏ꍇListIuWFNg̗vfƂMapIuWFNgi[<BR>
	 * <BR>
	 * {Iɂ̓`FbN{bNXȊO̓͏StringIuWFNgA`FbN{bNXBooleanIuWFNg<BR>
	 * ƂĒli[܂BSelect^Oł̕ITABŋ؂ꂽStringƂȂ܂B<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[ݒ肷邱Ƃɂ\ƂȂB
	 * 
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param converters
	 *            Ro[^[
	 * @return DTO(MapIuWFNg L[:ږ lFڒl)
	 */
	public static Map<String, Object> getDto(FieldMap fieldMap, Converter... converters) {
		return getDto(fieldMap, false, converters);
	}

	/**
	 * FieldMapIuWFNgi[Ăf[^MapIuWFNg쐬B<BR>
	 * [vListIuWFNgɒuB̏ꍇListIuWFNg̗vfƂMapIuWFNgi[<BR>
	 * <BR>
	 * {Iɂ̓`FbN{bNXȊO̓͏StringIuWFNgA`FbN{bNXBooleanIuWFNg<BR>
	 * ƂĒli[܂BSelect^Oł̕ITABŋ؂ꂽStringƂȂ܂B<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[ݒ肷邱Ƃɂ\ƂȂB
	 * 
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param inputCtrlOnly
	 *            true=̓Rg[̂
	 * @param converters
	 *            Ro[^[
	 * @return DTO(MapIuWFNg L[:ږ lFڒl)
	 */
	public static Map<String, Object> getDto(FieldMap fieldMap, boolean inputCtrlOnly, Converter... converters) {

		Map<String, Object> dto = new HashMap<String, Object>();
		Map<String, Converter> converterMap = createConverterMap(converters);

		getDtoMain(dto, fieldMap, converterMap, inputCtrlOnly);

		return dto;
	}

	/**
	 * getDto\bh̃C
	 * 
	 * @param dto
	 *            DTO(MapIuWFNgj
	 * @param fieldMap
	 *            tB[h}bv
	 * @param converterMap
	 *            Ro[^[}bv
	 * @param inputCtrlOnly
	 *            ̓Rg[̂
	 */
	private static void getDtoMain(Map<String, Object> dto, FieldMap fieldMap, Map<String, Converter> converterMap, boolean inputCtrlOnly) {

		Map<String, String> groupMap = createGroupMap(fieldMap);

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
			if (!cp.isLoop() && !cp.isGroupItem() && (!inputCtrlOnly || cp.isInputCtrl())) {
				Converter converter = converterMap.get(fieldName);
				if (converter == null) {
					dto.put(fieldName, fieldItem.getValue());
				} else if (converter.getDataConverter() == null) {
					dto.put(converter.getTargetFieldName(), fieldItem.getValue());
				} else {
					dto.put(converter.getTargetFieldName(), converter.getDataConverter().win2Target(fieldItem.getValue()));
				}
			}
			if (cp.isLoop()) {
				List<Map<String, Object>> dtoList = new ArrayList<Map<String, Object>>();
				dto.put(fieldName, dtoList);
				List<FieldMap> list = (List<FieldMap>) fieldItem.getValue();
				for (FieldMap childFieldMap : list) {
					Map<String, Object> childDto = new HashMap<String, Object>();
					getDtoMain(childDto, childFieldMap, converterMap, inputCtrlOnly);
					dtoList.add(childDto);
				}

			}
		}

		for (String fieldName : groupMap.keySet()) {
			Converter converter = converterMap.get(fieldName);
			if (converter == null) {
				dto.put(fieldName, fieldMap.getGroupValue(fieldName));
			} else if (converter.getDataConverter() == null) {
				dto.put(converter.getTargetFieldName(), fieldMap.getGroupValue(fieldName));
			} else {
				dto.put(converter.getTargetFieldName(), converter.getDataConverter().win2Target(fieldMap.getGroupValue(fieldName)));
			}
		}
	}

	/**
	 * DTOiMapIuWFNgj̓eFieldMapIuWFNg֊i[B<BR>
	 * [vListIuWFNgMapIuWFNgi[邱ƁB<BR>
	 * ڂ݂ȂꍇtB[h}bv̒l̒u͍sȂȂB<BR>
	 * ڂ݂lnull̎̓[v0񃋁[vA`FbN{bNXfalseȂ͋󕶎ZbgB<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂB<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[ݒ肷邱Ƃɂ\ƂȂB
	 * 
	 * @param window
	 *            EBhE
	 * @param dto
	 *            DTO(MapIuWFNg L[:ږ lFڒl)
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param converters
	 *            Ro[^[
	 */
	public static void setDto(PirkaWindow window, Map<String, Object> dto, FieldMap fieldMap, Converter... converters) {
		setDto(window, dto, fieldMap, false, converters);
	}

	/**
	 * DTOiMapIuWFNgj̓eFieldMapIuWFNg֊i[B<BR>
	 * [vListIuWFNgMapIuWFNgi[邱ƁB<BR>
	 * ڂ݂ȂꍇtB[h}bv̒l̒u͍sȂȂB<BR>
	 * ڂ݂lnull̎̓[v0񃋁[vA`FbN{bNXfalseȂ͋󕶎ZbgB<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂB<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[ݒ肷邱Ƃɂ\ƂȂB
	 * 
	 * @param window
	 *            EBhE
	 * @param dto
	 *            DTO(MapIuWFNg L[:ږ lFڒl)
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param inputCtrlOnly
	 *            true=̓Rg[̂
	 * @param converters
	 *            Ro[^[
	 */
	public static void setDto(PirkaWindow window, Map<String, Object> dto, FieldMap fieldMap, boolean inputCtrlOnly, Converter... converters) {

		Map<String, Converter> converterMap = createConverterMap(converters);

		setDtoMain(dto, fieldMap, converterMap, window, inputCtrlOnly);

	}

	/**
	 * setDtõC
	 * 
	 * @param dto
	 *            DTO(MapIuWFNg L[:ږ lFڒl)
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param converterMap
	 *            Ro[^[}bv
	 * @param window
	 *            EBhE
	 * @param inputCtrlOnly
	 *            true=̓Rg[̂
	 */
	private static void setDtoMain(Map<String, Object> dto, FieldMap fieldMap, Map<String, Converter> converterMap, PirkaWindow window, boolean inputCtrlOnly) {

		Map<String, String> groupMap = createGroupMap(fieldMap);

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
			if (!cp.isLoop() && !cp.isGroupItem() && (!inputCtrlOnly || cp.isInputCtrl())) {

				Converter converter = converterMap.get(fieldName);
				String targetFieldName = fieldName;
				if (converter != null) {
					targetFieldName = converter.getTargetFieldName();
				}
				if (dto.containsKey(targetFieldName)) {
					Object value = dto.get(targetFieldName);
					if (converter != null && converter.getDataConverter() != null) {
						value = converter.getDataConverter().target2Win(value);
					}

					if (cp.isCheckCtrl()) {
						if (value == null || !(value instanceof Boolean)) {
							fieldMap.setValue(fieldName, false);
						} else {
							fieldMap.setValue(fieldName, (Boolean) value);
						}
					} else {
						if (value == null) {
							fieldMap.setValue(fieldName, "");
						} else if (value instanceof Date) {
							fieldMap.setValue(fieldName, (Date) value);
						} else if (value instanceof Time) {
							fieldMap.setValue(fieldName, (Time) value);
						} else if (value instanceof Timestamp) {
							fieldMap.setValue(fieldName, (Timestamp) value);
						} else if (value instanceof BigDecimal) {
							fieldMap.setValue(fieldName, (BigDecimal) value);
						} else if (value instanceof Integer) {
							fieldMap.setValue(fieldName, (Integer) value);
						} else if (value instanceof Long) {
							fieldMap.setValue(fieldName, (Long) value);
						} else if (value instanceof String) {
							fieldMap.setValue(fieldName, (String) value);
						} else {
							fieldMap.setValue(fieldName, value.toString());
						}
					}
				}
			}

			if (cp.isLoop()) {
				Converter converter = converterMap.get(fieldName);
				String targetFieldName = fieldName;
				if (converter != null) {
					targetFieldName = converter.getTargetFieldName();
				}

				if (dto.containsKey(targetFieldName)) {
					fieldMap.clearFieldMap(fieldName);
					Object loopObject = dto.get(targetFieldName);
					Object[] loopDto = null;
					if (loopObject instanceof List) {
						loopDto = ((List) loopObject).toArray();
					} else if (loopObject instanceof Map[]) {
						loopDto = (Object[]) loopObject;
					}
					if (loopDto != null) {
						for (Object childDto : loopDto) {
							if (childDto != null && childDto instanceof Map) {
								FieldMap newFieldMap = window.createLoopFieldMap(fieldName);
								if (newFieldMap != null) {
									fieldMap.addFieldMap(fieldName, newFieldMap);
									setDtoMain((Map<String, Object>) childDto, newFieldMap, converterMap, window, inputCtrlOnly);
								}
							}
						}
					}
				}
			}
		}

		for (String fieldName : groupMap.keySet()) {
			Converter converter = converterMap.get(fieldName);
			String targetFieldName = fieldName;
			if (converter != null) {
				targetFieldName = converter.getTargetFieldName();
			}
			if (dto.containsKey(targetFieldName)) {
				Object value = dto.get(targetFieldName);
				if (converter != null && converter.getDataConverter() != null) {
					value = converter.getDataConverter().target2Win(value);
				}
				if (value == null) {
					fieldMap.setGroupValue(targetFieldName, "");
				} else if (value instanceof String) {
					fieldMap.setGroupValue(targetFieldName, (String) value);
				} else {
					fieldMap.setGroupValue(targetFieldName, "");
				}
			}
		}
	}

	/**
	 * Ro[^[̃}bv쐬
	 * 
	 * @param converters
	 *            Ro[^
	 * @return Ro[^}bv
	 */
	private static Map<String, Converter> createConverterMap(Converter... converters) {
		Map<String, Converter> map = new HashMap<String, Converter>();

		for (Converter converter : converters) {
			map.put(converter.getWindowFieldName(), converter);
		}

		return map;

	}

	/**
	 * tB[h}bvO[v}bv쐬
	 * 
	 * @param fieldMap
	 *            tB[h}bv
	 * @return O[v}bv
	 */
	private static Map<String, String> createGroupMap(FieldMap fieldMap) {
		Map<String, String> groupMap = new HashMap<String, String>();
		createGroupMapMain(groupMap, fieldMap, 0);

		return groupMap;

	}

	/**
	 * O[v}bvC
	 * 
	 * @param groupMap
	 *            O[v}bv
	 * @param fieldMap
	 *            tB[h}bv
	 * @param groupLevel
	 *            O[vx
	 */
	private static void createGroupMapMain(Map<String, String> groupMap, FieldMap fieldMap, int groupLevel) {

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
			if (cp.isGroupItem() && fieldItem.getCtrl().getGroupLevel() == groupLevel) {
				groupMap.put(fieldItem.getCtrl().getBaseName(), fieldItem.getCtrl().getBaseName());
			}

			if (cp.isLoop()) {
				List<FieldMap> list = (List<FieldMap>) fieldItem.getValue();
				for (FieldMap childFieldMap : list) {
					createGroupMapMain(groupMap, childFieldMap, groupLevel + 1);
				}

			}
		}

	}
}
