/*MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI

                           P L A Y U M I D I
                  (/dev/umixiX.Y Direct MIDI Player)

   Copyright(C) 2014-2019 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI*/

#define	PLAYUMIDI_SRC_MAIN

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<signal.h>
#include<unistd.h>
#include<ctype.h>
#include<errno.h>
#include<pthread.h>
#include"playumidi.h"


char	*gpstr_smfname;
char	*gpstr_devname;
char	*gpstr_mididev[MAX_UMIDI_PORT];
char	gstr_lang_smf[MAX_LANGCODE_STRING];
char	gstr_lang_terminal[MAX_LANGCODE_STRING];


/* ===================================================================*/
void Signal_Int(
		int	i_signal )	{

	Play_RequestStop();
	return;
}


/* ===================================================================*/
int Play_SMF(
		void )	{

	int			i_result	= 0x00;
	int			i_err;
	sig_t		t_sigerr;
	pthread_t	t_thread;
	char		str_default_devname[6]	= DEFAULT_DEV_NAME;

	MSleep_Ajust();

	if( NULL == gpstr_devname )
		{ gpstr_devname	= str_default_devname; }
	i_err	= MidiDevice_Init( gpstr_devname, gpstr_mididev );
	if( 0x00 != i_err )		{ return i_err; }

	t_sigerr	= signal( SIGINT, (void (*))Signal_Int );
	if( SIG_ERR == t_sigerr )	{
		i_result	= -0x01;
		fprintf(stderr, "Error!!: Can't Set Signal(SIGINT) (%d)\n", errno);
		goto goto_Play_SMF_TermDevice;
	}

	i_err	= PlayEvent_Initialize();
	if( 0x00 != i_err )		{
		i_result	= i_err;
		goto goto_Play_SMF_TermDevice;
	}

	i_err	= ReadSMF( gpstr_smfname );
	if( 0x00 != i_err )		{
		i_result	= i_err;
		goto goto_Play_SMF_TermPlayEvnet;
	}

	i_err	= pthread_create( &t_thread, NULL,
						(void *)PlayEvent_Play, (void *)NULL );
	if( 0x00 != i_err )	{
		i_result	= -0x02;
		fprintf(stderr, "Error!!: Can't Create Player-Thread (%d)\n", errno);
	}
	else	{
		pthread_join( t_thread, NULL );
	}

	MidiEvent_FreeMidiVarData();
	MidiEvent_FreeMidiEvnetInfo();
	
goto_Play_SMF_TermPlayEvnet:
	PlayEvent_Term();

goto_Play_SMF_TermDevice:
	MidiDevice_Term();

	return 0x00;
}


/* ===================================================================*/
void
	Copyright(
		void )	{
	
	fputs( "playumidi: Simple MIDI-File Player for RAW-MIDI Interface(USB MIDI). "
			STRING_VERSION "\n", stderr );
	fputs( " Copyright(C) 2014-2019 Koine Yuusuke(koinec@users.osdn.me).\n",
			stderr );
	fputs( " This software presented by 2-clause FreeBSD License.\n\n", stderr );

	return;
}


/* ===================================================================*/
void
	Usage(
		void )	{

	fputs( "usage: playumidi [option] MIDIfile(.mid)\n", stderr );
	fputs( "  -d device_name      Use RAW-MIDI device /dev/[device_name]X.Y"
			" (X & Y is auto-serarch)\n", stderr );
	fputs( "  -0 device_fullname  Use Port-0 RAW-MIDI device /dev/[device_fullname]\n", stderr );
	fputs( "  -1 device_fullname  Use Port-1 RAW-MIDI device /dev/[device_fullname]\n", stderr );
	fputs( "  -2 device_fullname  Use Port-2 RAW-MIDI device /dev/[device_fullname]\n", stderr );
	fputs( "  -3 device_fullname  Use Port-3 RAW-MIDI device /dev/[device_fullname]\n", stderr );
	fputs( "  -r                  Not auto-append XG/GS/GM REST code\n", stderr );
	fputs( "  -q                  Quiet mode (No output Meta-Event Text for console)\n", stderr );
	fputs( "  -v                  Verbose mode\n", stderr );
#ifdef SUPPORT_ICONV
	fputs( "  -l language_code    Text Language-Code in MIDI-File MetaEvent\n", stderr );
	fputs( "  -t language_code    Output Text Language-Code for Terminal\n", stderr );
#endif
	fputs( "  -h                  Help (This Message)\n", stderr );
#ifdef SUPPORT_ICONV
	fputs( "\n        The parameter \"language_code\" of Option -l & -t is ability\n", stderr );
	fputs( "        to specify a value that is displayed in the command \"iconv -l\"\n\n",
				stderr );
#endif

	return;
}


/* ===================================================================*/
int main(
		int argc,
		char *argv[] )	{

	int					i_ch;
	char				*pstr_temp;
#ifdef SUPPORT_ICONV
	int					i_len;
	char				*pstr_dest;
#endif
	extern		char	*optarg;
	extern		int		optind;
	extern		int		opterr;

	Copyright();

	gpstr_devname		= NULL;
	gpstr_mididev[0]	= NULL;
	gpstr_mididev[1]	= NULL;
	gpstr_mididev[2]	= NULL;
	gpstr_mididev[3]	= NULL;
	gb_mode				= MODE_DEFAULT;

	gstr_lang_smf[0]		= '\0';
	gstr_lang_terminal[0]	= '\0';

	while( -1 != (i_ch = getopt( argc, argv, "d:0:1:2:3:vqrhl:t:")))	{
		if( 'd' == i_ch )
			{ gpstr_devname	= optarg; }
		else if( '0' == i_ch )
			{ gpstr_mididev[0]	= optarg; }
		else if( '1' == i_ch )
			{ gpstr_mididev[1]	= optarg; }
		else if( '2' == i_ch )
			{ gpstr_mididev[2]	= optarg; }
		else if( '3' == i_ch )
			{ gpstr_mididev[3]	= optarg; }
		else if( 'v' == i_ch )
			{ gb_mode	|= MODE_VERBOSE; }
		else if( 'q' == i_ch )
			{ gb_mode	|= MODE_QUIET; }
		else if( 'r' == i_ch )
			{ gb_mode	|= MODE_NORESET; }
		else if( 'h' == i_ch )	{
			Usage();
			return 0x00;
		}
		else if( 'l' == i_ch )	{
			if( MAX_LANGCODE_STRING > strnlen( optarg, MAX_LANGCODE_STRING ) )	{
				strncpy( gstr_lang_smf, optarg, MAX_LANGCODE_STRING );
				pstr_temp	= gstr_lang_smf;
				while( '\0' != *pstr_temp )		{
					*pstr_temp	= toupper( *pstr_temp );
					pstr_temp++;
				}
			}
		}
		else if( 't' == i_ch )	{
			if( MAX_LANGCODE_STRING > strnlen( optarg, MAX_LANGCODE_STRING ) )	{
				strncpy( gstr_lang_terminal, optarg, MAX_LANGCODE_STRING );
				pstr_temp	= gstr_lang_terminal;
				while( '\0' != *pstr_temp )		{
					*pstr_temp	= toupper( *pstr_temp );
					pstr_temp++;
				}
			}
		}
		else 	{
			Usage();
			return 0x01;
		}
	}
	argc	-= optind;
	argv	+= optind;

	if( 1 != argc )		{
		Usage();
		return 0x01;
	}
	gpstr_smfname	= argv[0];
	if( IS_MSGVERBOSE )	
		{ printf( "  [MIDI File ]: %s\n", gpstr_smfname ); }

#ifdef SUPPORT_ICONV
	if( '\0' == gstr_lang_smf[0] )
		{ strncpy( gstr_lang_smf, DEFAULT_SMF_LANGCODE, MAX_LANGCODE_STRING ); }

	if( '\0' == gstr_lang_terminal[0] )	{
		pstr_temp	= getenv( ENVNAME_LANG );
		if( NULL != pstr_temp )		{
			i_len	= strnlen( pstr_temp, MAX_LANGCODE_STRING );		
			if( MAX_LANGCODE_STRING > i_len )		{
				while(( '.' != *pstr_temp ) && ('\0' != *pstr_temp ))
					{ pstr_temp++; }

				pstr_dest	= gstr_lang_terminal;
				while( '\0' != *pstr_temp++ )
					{ *pstr_dest++	= toupper( *pstr_temp ); }
				*pstr_dest	= '\0';
			}
		}
		
		if( '\0' == gstr_lang_terminal[0] )
			{ strncpy( gstr_lang_terminal, DEFAULT_TERM_LANGCODE, MAX_LANGCODE_STRING ); }
	}

	gt_iconv	= iconv_open( gstr_lang_terminal, gstr_lang_smf );
	if( (iconv_t)(-1) == gt_iconv )		{
		fprintf(stderr, "Error!!: Can't Initialize libiconv (%d)\n", errno);
		return 0x01;
	}
#endif

	Play_SMF();

#ifdef SUPPORT_ICONV
	iconv_close( gt_iconv );
#endif

	return 0x00;
}


/* EOF of main.c ******************************************************/
