/*MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI

                           P L A Y U M I D I
                  (/dev/umixiX.Y Direct MIDI Player)

   Copyright(C) 2014-2019 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI*/


#define	PLAYUMIDI_SRC_MSLEEP

#include<stdio.h>
#include<unistd.h>
#include<sys/time.h>
#include"playumidi.h"


long	gl_min_usleep	= DEFAULT_MIN_SLEEP;


/* ===================================================================*/
EXTERN_FUNC_MSLEEP
long	MSleep_Ajust(
			void )		{

	int					i_cnt;
	long				l_times;
	long				l_value;
	struct	timeval		tv_start;
	struct	timeval		tv_end;

	l_times		= 0;
	for( i_cnt = 0; i_cnt < MSLEEP_AJUST_COUNT; i_cnt++ )	{

		gettimeofday( &tv_start, NULL );
		usleep( MSLEEP_USLEEP_TIME );
		gettimeofday( &tv_end, NULL );

		if( tv_start.tv_sec == tv_end.tv_sec )	{
			l_value	= tv_end.tv_usec - tv_start.tv_usec;
		} else	{
			l_value	= (tv_end.tv_sec - tv_start.tv_sec) * 1000000;
			l_value	+= (tv_end.tv_usec + (1000000 - tv_start.tv_usec));
		}

		l_times		+= l_value;
	}
	
	l_times		/= MSLEEP_AJUST_COUNT; 
	
	gl_min_usleep	= l_times + (l_times / MSLEEP_BUFWAIT_DIV); 

	return gl_min_usleep;
}


/* ===================================================================*/
EXTERN_FUNC_MSLEEP
int		MSleep_MicroSleep(
			long	l_usleep )	{
	
	long	l_diff;
	struct	timeval		tv_start;
	struct	timeval		tv_end;

	gettimeofday( &tv_start, NULL );
	l_diff	= 0;
	do	{
		if( gl_min_usleep < (l_usleep-l_diff) )
			{ usleep( MSLEEP_USLEEP_TIME ); }

		gettimeofday( &tv_end, NULL );

		if( tv_start.tv_sec == tv_end.tv_sec )	{
			l_diff	= tv_end.tv_usec - tv_start.tv_usec;
		} else if( tv_start.tv_sec + 1 == tv_end.tv_sec )	{
			l_diff	= (tv_end.tv_usec + (1000000 - tv_start.tv_usec));
		} else	{
			l_diff	= (tv_end.tv_sec - tv_start.tv_sec) * 1000000;
			l_diff	+= (tv_end.tv_usec + (1000000 - tv_start.tv_usec));
		}

	}while( l_usleep > l_diff );

	return 0x00;
}


/* EOF of micro_sleep.c ************************************************/

