/*MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI

                           P L A Y U M I D I
                  (/dev/umixiX.Y Direct MIDI Player)

   Copyright(C) 2014-2019 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI*/


#define	PLAYUMIDI_SRC_MIDI_DEVICE

#include<stdio.h>
#include<unistd.h>
#include<string.h>
#include<fcntl.h>
#include<assert.h>
#include<dirent.h>
#include<sys/stat.h>
#include<sys/types.h>
#include<sys/uio.h>
#include"playumidi.h"

static	int	gi_mididev[MAX_UMIDI_PORT];


/* ===================================================================*/
int MidiDevice_IsExistUMidiDevice(
			char *pstr_dev )	{
	
	int				i_result;
	int				i_len;
	DIR		*p_dir;
	struct	dirent	*p_dent;

	i_len	= strnlen( pstr_dev, 256 );

	p_dir	= opendir("/dev/");
	if( NULL == p_dir )		{ return -0x01; }

	i_result	= 0x00;
	while( NULL != (p_dent = readdir( p_dir )))	{
		if( ( i_len == p_dent->d_namlen )
				&& (!strncmp( p_dent->d_name, pstr_dev, i_len ) ))	{
			i_result	= 0x01;
			break;
		}
	}

	closedir( p_dir );

	return i_result;
}


/* ===================================================================*/
EXTERN_FUNC_MIDI_DEVICE
int MidiDevice_Init(
			char	*pstr_basedev,
			char	*pstr_midiport[MAX_UMIDI_PORT] )	{

	int		i_cnt;
	int		i_device;
	int		i_port;
	int		i_chk;
	char	str_temp[256];
	char	str_mididev[MAX_UMIDI_PORT][256];

	/* Init. Midi Device Desc. Value */
	for( i_cnt = 0; i_cnt < MAX_UMIDI_PORT; i_cnt++ )
		{ gi_mididev[ i_cnt ] = -1; }

	/* Search /dev/umidiX.Y output Device Number(X) */
	for( i_device = 0; i_device < 15; i_device++ )	{
		snprintf( str_temp, 256, "%s%d.%d", pstr_basedev, i_device, 0 );
		if( 0 < MidiDevice_IsExistUMidiDevice( str_temp ) )
			{ break; }
	}

	/* Setting Output MidiDevice(/dev/????) */
	i_port	= 0;
	for( i_cnt = 0; i_cnt < MAX_UMIDI_PORT; i_cnt++ )	{
		if( NULL != pstr_midiport[i_cnt] )	{ continue; }

		for( i_port = 0; i_port < 15; i_port++ )	{
			snprintf( str_mididev[i_cnt], 256, "%s%d.%d", pstr_basedev, i_device, i_port );
			for( i_chk = 0; i_chk < MAX_UMIDI_PORT; i_chk++ )	{
				if( NULL == pstr_midiport[i_chk] )		{ continue; }
				if( !strncmp( str_mididev[i_cnt], pstr_midiport[i_chk], 256 ))
					{ i_chk = MAX_UMIDI_PORT + 1; }
			}

			if( MAX_UMIDI_PORT == i_chk )	{ break; }
		}

		if( 15 != i_port )	{ pstr_midiport[i_cnt]	= str_mididev[i_cnt]; }

	}

	for( i_cnt = 0; i_cnt < MAX_UMIDI_PORT; i_cnt++ )	{
		snprintf( str_temp, 256, "/dev/%s", pstr_midiport[i_cnt] );
		gi_mididev[i_cnt]	= open( str_temp, O_RDWR );
		if( 0 > gi_mididev[i_cnt] )		{
			fprintf( stderr, "Error!!: Can't Open MidiDevice (Device=%s Port=%d)\n",
						pstr_midiport[i_cnt], i_cnt );
		}
	}

	if( 0 > gi_mididev[0] )		{
		fputs( "Error!!: Can't Open RawMidi Device Port=0 => Can't play MIDI-File. Exit.\n",
			stderr );
		return -0x01;
	}

	return 0x00;
}


/* ===================================================================*/
EXTERN_FUNC_MIDI_DEVICE
int MidiDevice_Term(
		void )	{

	int		i_cnt;

	for( i_cnt = 0; i_cnt < MAX_UMIDI_PORT; i_cnt++ )	{
		if( 0 <= gi_mididev[i_cnt] )		{
			close( gi_mididev[i_cnt] );
			gi_mididev[i_cnt]	= -1;
		}
	}
	
	return 0x00;
}



/* ===================================================================*/
EXTERN_FUNC_MIDI_DEVICE
int MidiDevice_Write(
		int		i_port,
		Byte	*pb_data,
		size_t	sz_len	)	{

	int		i_cnt;
	size_t	sz_write;

	if( 0 == sz_len )	{ return 0x00; }

	i_cnt	= UMIDIDEV_RETRY_WRITE;
	for( ; (sz_len >0) && (i_cnt > 0); i_cnt-- )		{
		sz_write	= write( gi_mididev[i_port], pb_data, sz_len );
		sz_len	-= sz_write;
		pb_data	+= (int)sz_write;
	}

	return (int)sz_len;
}


/* EOF of midi_device.c ***********************************************/
