/*MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI

                           P L A Y U M I D I
                  (/dev/umixiX.Y Direct MIDI Player)

   Copyright(C) 2014-2019 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI*/


#define	PLAYUMIDI_SRC_MIDIEVENT

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include"playumidi.h"

MidiEventInfo	*gp_event		= NULL;
Byte			*gpb_vardata	= NULL;

Word			guw_division;
DWord			gdw_max_events;
DWord			gdw_max_metasize;


/* ===================================================================*/
EXTERN_FUNC_MIDIEVENT	int
    MidiEvent_GetMidiInfo(
            MidiInfo	*p_midi )    {

	p_midi->uw_division				= guw_division;
	p_midi->dw_max_events			= gdw_max_events;
	p_midi->dw_max_metasize			= gdw_max_metasize;
	p_midi->p_event					= gp_event;
	p_midi->pb_vardata				= gpb_vardata;
	
	return	0x00;
}


/* ===================================================================*/
EXTERN_FUNC_MIDIEVENT	void 
    MidiEvent_SetMidiDivision(
            Word	uw_division )    {
	
	guw_division	= uw_division;

    return;
}


/* ===================================================================*/
EXTERN_FUNC_MIDIEVENT	DWord 
    MidiEvent_GetMidiEvents(
            void )    {
	
	return	gdw_max_events;
}


/* ===================================================================*/
EXTERN_FUNC_MIDIEVENT   MidiEventInfo *
    MidiEvent_GetMidiEventPointer(
            void )    {

    return gp_event;
}


/* ===================================================================*/
EXTERN_FUNC_MIDIEVENT   Byte *
    MidiEvent_GetVarDataPointer(
            void )    {

    return gpb_vardata;
}


/* ===================================================================*/
EXTERN_FUNC_MIDIEVENT	int
	MidiEvent_AllocMidiVarData(
			DWord	dw_varsize,
			DWord	dw_metasize )	{

	if( NULL != gpb_vardata )	{ return -0x01; }

	gpb_vardata = (Byte *)malloc( dw_varsize );
	if( NULL == gpb_vardata )	{ return -0x02; }

	memset( gpb_vardata, 0x00, dw_varsize );

	gdw_max_metasize	= dw_metasize;
	
	return 0x00;
}


/* ===================================================================*/
EXTERN_FUNC_MIDIEVENT int
	MidiEvent_FreeMidiVarData(
			void )	{

	if( NULL != gp_event )	{
		free( gp_event );
		gp_event	= NULL;
	}

	return 0x00;
}


/* ===================================================================*/
EXTERN_FUNC_MIDIEVENT int
	MidiEvent_AllocMidiEventInfo(
			DWord	dw_events )	{

	size_t	sz_size;

	sz_size		= sizeof(MidiEventInfo) * dw_events;
	
	if( NULL != gp_event )	{ return -0x01; }

	gp_event	= (MidiEventInfo *)malloc( sz_size );
	if( NULL == gp_event )	{ return -0x02; }

	memset( gp_event, 0x00, sz_size );
	gdw_max_events	= dw_events;

	return 0x00;
}


/* ===================================================================*/
EXTERN_FUNC_MIDIEVENT int
	MidiEvent_FreeMidiEvnetInfo(
			void )	{

	if( NULL != gp_event )	{
		free( gp_event );
		gp_event	= NULL;
	}

	return 0x00;
}


/* EOF of midievent.c *************************************************/

