/*MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI

                           P L A Y U M I D I
                  (/dev/umixiX.Y Direct MIDI Player)

   Copyright(C) 2014-2019 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI*/


#define	PLAYUMIDI_SRC_PLAY_EVENT

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<string.h>
#include<fcntl.h>
#include<assert.h>
#include<pthread.h>
#include<errno.h>
#include<sys/stat.h>
#include<sys/types.h>
#include<sys/uio.h>
#include"playumidi.h"

DWord				gdw_tempo;
DWord				gdw_deltabase;
Word				guw_division;
int					gi_outport;
int					gi_prefix_channel;
Byte				gb_status			= PLAYSTATUS_INITIALIZE;
pthread_mutex_t		gt_mutex_status;
#ifdef SUPPORT_ICONV
char				*gpstr_buffer;
size_t				gsz_buffer;
#endif


/* ===================================================================*/
EXTERN_FUNC_PLAY_EVENT	void
	Play_RequestStop(
			void )		{

	if( PLAYSTATUS_PREPARE != gb_status )	{
		gb_status	= PLAYSTATUS_REQ_STOP;
	}

	return;
}


/* ===================================================================*/
int	PlayEvent_StopVoiceOut(
			void )		{
	
	int		i_port;
	int		i_channel;
	Byte	b_value[3 * 16];
	
	for( i_channel = 0; i_channel < 16; i_channel++)	{
		b_value[(i_channel * 3) + 0] = 0xb0 + (Byte)i_channel;
		b_value[(i_channel * 3) + 1] = 0x78;
		b_value[(i_channel * 3) + 2] = 0x00;
	}

	for( i_port = 0; i_port < MAX_UMIDI_PORT; i_port++ )	{
		MidiDevice_Write( i_port, b_value, (size_t)(3 * 16) );
	}
	return 0x00;
}
		

#ifdef SUPPORT_ICONV
/* ===================================================================*/
int	PlayEvent_ConvLanguage_toTerminal(
		char	*pstr_dest, 
		size_t	sz_dest,
		char	*pstr_src, 
		size_t	sz_src )	{

	int		i_errcount	= 0;
	size_t		sz_result;

	while(( 0 < sz_src ) && ( ICONV_PERMIT_ERRCOUNT > i_errcount ))		{
		sz_result	= iconv( gt_iconv,
				(const char **)&pstr_src, &sz_src,
				&pstr_dest, &sz_dest );
		if( -1 == sz_result )	{
			if( 0 < sz_src )	{
				*pstr_dest++	= *pstr_src++;
				sz_src--;
				sz_dest--;
			}
			i_errcount++;
		}
	}

	*pstr_dest	= '\0';

	return i_errcount;
}
#endif

/* ===================================================================*/
int	Play_OutputText_fromMetaEvent(
		Byte	*pb_str,
		int		i_len,
		char	*pstr_title )		{

	Byte		b_save;
	char		*pstr_dest;
	int			i_err;

	if( IS_MSGQUIET )	{ return 0x00; }

	i_err	= 0;
	b_save	= *(pb_str + i_len);
	*(pb_str + i_len)	= '\0';
#ifdef SUPPORT_ICONV
	i_err	= PlayEvent_ConvLanguage_toTerminal( gpstr_buffer,
					(size_t)(gsz_buffer - 1), (char *)pb_str, (size_t)i_len );
	if( ICONV_PERMIT_ERRCOUNT <= i_err )
		{ fprintf( stderr, "Error!!: iconv function error (%d)\n", errno ); }
	pstr_dest	= gpstr_buffer;
#else
	pstr_dest	= (char *)pb_str;
#endif

	if( -1 == gi_prefix_channel )
		{ printf("  [%-10s]: %s\n", pstr_title, pstr_dest ); }
	else
		{ printf("  [%-10s]: (Channel:%01d) %s\n", pstr_title, gi_prefix_channel, pstr_dest ); }

	*(pb_str + i_len)	= b_save;

	return 0x00;
}


/* ===================================================================*/
int	Play_OutputTimeRhythm(
		Byte	*pb_var )		{

	DWord	dw_numerator;
	DWord	dw_denominator;

	if( !IS_MSGVERBOSE )			{ return 0x00; }
	if( 0x04 != *(pb_var + 2) )		{ return 0x00; }

	dw_numerator	= (DWord)(*(pb_var + 3));
	dw_denominator	= 1 << (DWord)(*(pb_var + 4));

	printf( "  [Rhythm    ]: %d/%d \n", dw_numerator, dw_denominator );

	return 0x00;
}


/* ===================================================================*/
int	Play_OutputKeySignature(
		Byte	*pb_var )		{

	char	c_key;
	Byte	b_flag;
	char	*pstr_keyvalue[15][2]	= {
				{ STR_C_FLAT_MAJOR,		STR_A_FLAT_MINOR },
				{ STR_G_FLAT_MAJOR,		STR_E_FLAT_MINOR },
				{ STR_D_FLAT_MAJOR,		STR_B_FLAT_MINOR },
				{ STR_A_FLAT_MAJOR,		STR_F_MINOR },
				{ STR_E_FLAT_MAJOR,		STR_C_MINOR },
				{ STR_B_FLAT_MAJOR,		STR_G_MINOR },
				{ STR_F_MAJOR,			STR_D_MINOR },
				{ STR_C_MAJOR,			STR_A_MINOR },
				{ STR_G_MAJOR,			STR_E_MINOR },
				{ STR_D_MAJOR,			STR_B_MINOR },
				{ STR_A_MAJOR,			STR_F_SHARP_MINOR },
				{ STR_E_MAJOR,			STR_C_SHARP_MINOR },
				{ STR_B_MAJOR,			STR_G_SHARP_MINOR },
				{ STR_F_SHARP_MAJOR, 	STR_D_SHARP_MINOR },
				{ STR_C_SHARP_MAJOR, 	STR_A_SHARP_MINOR } };

	if( !IS_MSGVERBOSE )			{ return 0x00; }
	if( 0x02 != *(pb_var + 2) )		{ return 0x00; }

	c_key	= (char)(*(pb_var + 3)) + 7;
	b_flag	= (Byte)(*(pb_var + 4));
	
	if(( 0 > c_key ) || ( 14 < c_key ) || ( 1 < b_flag ))
		{ printf( "  [KeySign.  ]: Unknown Key (%d:%x)\n", (int)c_key, b_flag ); }
	else
		{ printf( "  [KeySign.  ]: %s\n", pstr_keyvalue[(int)c_key][b_flag] ); }

	return 0x00;
}


/* ===================================================================*/
int	Play_MetaEvent(
		MidiEventInfo	*p_mevent,
		Byte			*pb_var,
		int				i_len )		{

	int		i_ret	= 0x00;
	int		i_size	= 1;
	Byte	b_meta;
	Byte	b_temp;
	Byte	*pb_mdata;
	DWord	dw_temp;

	assert( NULL != p_mevent );

	b_meta	= p_mevent->b_data[1];

	if( 127 < (i_len - 3) )		{
		i_size	= DecodeValue( &dw_temp, (pb_var + 2) );
	}

	pb_mdata	= (pb_var + i_size + 2);
	i_len		-= (i_size + 2);

	if( SMF_META_TEMPO == b_meta )		{

		gdw_tempo	=   (((DWord)*(pb_var + 3)) << 16) |
						(((DWord)*(pb_var + 4)) << 8) |
						 ((DWord)*(pb_var + 5));
		gdw_deltabase	= gdw_tempo / (DWord)guw_division;
		
		if( IS_MSGVERBOSE )
			{ printf( "  [Tempo     ]: %d\n", (60000000 / gdw_tempo)); }

	}
	else if( SMF_META_PORT == b_meta )	{
		
		b_temp	= *(pb_var + 3);
		if( 4 > b_temp )	{ gi_outport	= (int)b_temp; }
	}
	else if( SMF_META_CHNPREFIX == b_meta )
		{ gi_prefix_channel	= (int)(*(pb_var + 3)); }
	/* Output Text for PC-Console */
	else if( SMF_META_TEXT == b_meta )
		{ Play_OutputText_fromMetaEvent( pb_mdata, i_len, "Text" ); }
	else if( SMF_META_COPYRIGHT == b_meta )
		{ Play_OutputText_fromMetaEvent( pb_mdata, i_len, "Copyright" ); }
	else if( SMF_META_TITLE == b_meta )
		{ Play_OutputText_fromMetaEvent( pb_mdata, i_len, "Title" ); }
	else if( SMF_META_INSTRUMENT == b_meta )
		{ Play_OutputText_fromMetaEvent( pb_mdata, i_len, "Instrument" ); }
	else if( SMF_META_LYLIC == b_meta )
		{ Play_OutputText_fromMetaEvent( pb_mdata, i_len, "Lylic" ); }
	else if( SMF_META_MARKER == b_meta )
		{ Play_OutputText_fromMetaEvent( pb_mdata, i_len, "Marker" ); }
	else if( SMF_META_QUEPOINT == b_meta )
		{ Play_OutputText_fromMetaEvent( pb_mdata, i_len, "Que Point" ); }
	else if( SMF_META_PROGRAM == b_meta )
		{ Play_OutputText_fromMetaEvent( pb_mdata, i_len, "Program" ); }
	else if( SMF_META_DEVICE == b_meta )
		{ Play_OutputText_fromMetaEvent( pb_mdata, i_len, "Device" ); }
	else if( SMF_META_TIMESIGNATURE == b_meta )
		{ Play_OutputTimeRhythm(pb_var); }
	else if( SMF_META_KEYSIGNATURE == b_meta )
		{ Play_OutputKeySignature( pb_var ); }
	/*else if( SMF_META_SMPTEOFFSET == b_meta )	{ ** Not Support for SMPTE TimeFormat ** }*/
	/*else if( SMF_META_SEQUENCENO == b_meta )	{ ** NONE Proc.(Ignore for SMF0/1)** }*/
	/*else if( SMF_META_TRACKEND == b_meta )	{ ** NONE Proc.** }*/
	/*else if( SMF_META_SPECIAL == b_meta )	{ ** NONE Proc.** }*/

	return i_ret;
}


/* ===================================================================*/
EXTERN_FUNC_PLAY_EVENT
	int	PlayEvent_Initialize(
			void  )		{

	int		i_result;

	i_result	= pthread_mutex_init( &gt_mutex_status, NULL);
	if( 0x00 != i_result )		{
		fputs( "Error!!: Cannot Init. pthread-mutex\n", stderr );
		return i_result;
	}

	return	i_result;
}


/* ===================================================================*/
EXTERN_FUNC_PLAY_EVENT
	int	PlayEvent_Term(
			void  )		{

	int		i_result;

	i_result	= pthread_mutex_destroy( &gt_mutex_status );
	if( 0x00 != i_result )		{
		fputs( "Error!!: Cannot Destroy pthread-mutex\n", stderr );
		return i_result;
	}
	gb_status	= PLAYSTATUS_INITIALIZE;

	return	i_result;
}


/* ===================================================================*/
EXTERN_FUNC_PLAY_EVENT
	void	PlayEvent_Play(
			void *v_arg )		{

	MidiEventInfo	*p_mevent;
	Byte			*pb_vardata;
	DWord			dw_events;

	Byte			*pb_data;
	Byte			b_status;
	int				i_len		= 0;
	DWord			dw_wait;
	MidiInfo		t_midi;

	
	/* *** MUTEX LOCK!!: gt_mutex_status *** */
	//pthread_mutex_lock( &gt_mutex_status );

	gb_status			= PLAYSTATUS_PREPARE;
	gi_outport			= 0;
	gi_prefix_channel	= -1;

	MidiEvent_GetMidiInfo( &t_midi );
	p_mevent	= t_midi.p_event;
	assert( NULL != p_mevent );

	pb_vardata	= t_midi.pb_vardata;
	assert( NULL != pb_vardata );

#ifdef SUPPORT_ICONV
	gsz_buffer	= ((t_midi.dw_max_metasize * 3) / 2) + 1;
	gpstr_buffer = (char *)malloc( gsz_buffer );
	if( NULL == gpstr_buffer )	{
		fprintf( stderr,
			"Error!!: Can't Alloc LangCode Convert Buffer Memory (%d)\n", errno );
		return;
	} 
#endif

	guw_division	= t_midi.uw_division;

	gdw_tempo	= DEFAULT_TEMPO;		/* Default tempo = 120 */
	gdw_deltabase	= gdw_tempo / (DWord)guw_division;

	gb_status	= PLAYSTATUS_PLAYING;

	pb_data		= NULL;

	//pthread_mutex_unlock( &gt_mutex_status );
	/* *** MUTEX UNLOCK!!: gt_mutex_status *** */

	for( dw_events = 0; dw_events < t_midi.dw_max_events; dw_events++ )	{

		assert( NULL != p_mevent );

		if( 0 < p_mevent->dw_delta )	{
			dw_wait	= (p_mevent->dw_delta * gdw_deltabase);
			MSleep_MicroSleep( (long)dw_wait );
		}

		if( IS_PLAYSTATUS_REQUEST( gb_status ) )	{
			if( PLAYSTATUS_REQ_STOP == gb_status )	{
				PlayEvent_StopVoiceOut();
				break;
			}
		}

		b_status	= p_mevent->b_data[0] & 0xf0;	
		if( (SMF_EVENT_NOTEOFF == b_status ) || ( SMF_EVENT_NOTEON == b_status ) ||
				( SMF_EVENT_KEYPRESSER == b_status ) || ( SMF_EVENT_CTRLCHANGE == b_status ) ||
				( SMF_EVENT_PITCHBEND == b_status ) )	 {

			pb_data	= p_mevent->b_data;			
			i_len	= 3;
		}
		else if( ( SMF_EVENT_PROGCHANGE == b_status ) ||
				( SMF_EVENT_CHNPRESSER == b_status ))		{

			pb_data	= p_mevent->b_data;			
			i_len	= 2;
		}
		else if( SMF_EVENT_SYSEX_META == b_status )		{

			b_status	= p_mevent->b_data[0];
			
			if( SMF_EVENT_SYSEX_F0 == b_status )	{
				pb_data	= (pb_vardata + p_mevent->dw_dataptr);
				i_len	= p_mevent->dw_length;
			}
			else if( SMF_EVENT_SYSEX_F7 == b_status )	{

				pb_data	= (pb_vardata + p_mevent->dw_dataptr);
				i_len	= p_mevent->dw_length;
			}
			else if( SMF_EVENT_META == b_status )	{
				
				pb_data	= (pb_vardata + p_mevent->dw_dataptr);
				i_len	= p_mevent->dw_length;

				i_len	= Play_MetaEvent( p_mevent, pb_data, i_len );
				
			}
		}

		MidiDevice_Write( gi_outport, pb_data, (size_t)i_len );

		p_mevent++;
	}

#ifdef SUPPORT_ICONV
	if( NULL != gpstr_buffer )	{ free( gpstr_buffer ); }
#endif

	return;
}


/* EOF of play_event.c **************************************************/
