/*MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI

                           P L A Y U M I D I
                  (/dev/umixiX.Y Direct MIDI Player)

   Copyright(C) 2014-2019 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI*/

#ifdef SUPPORT_ICONV
#include<iconv.h>
#endif

#include"config.h"
#include"smf.h"

#define	STRING_VERSION			"Version 0.8.2 (2019/08/11)"


typedef unsigned char	Byte;
typedef	unsigned int	DWord;
typedef	unsigned short	Word;

typedef struct  _smf_header {
	char	str_header[4];	/* "MThd"(0x4d, 0x54, 0x68,0x64) */
	DWord	dw_data_size;	/* Real DataSize - 32bit BigEndian */
	Word	uw_format;		/* SMF format 0 or 1 - BigEndian */
	Word	uw_tracks;		/* Tracks */
	Word	uw_deltabase;	/* DeltaTime BaseValue */
} __attribute__ ((packed)) SmfHeader;


typedef struct  _smf_track_header {
	char	str_header[4];	/* "MTrk" (0x4d, 0x54, 0x72, 0x6b) */
	DWord	dw_trksize;		/* Track Data Size */
} __attribute__ ((packed)) SmfTrackHeader;


typedef	struct	{
	DWord		dw_tracksize;
	Byte		*pb_data;

	Byte		*pb_now;
	Byte		b_run_status;
	DWord		dw_delta_now;
} TrackInfo;


typedef	struct	{
	DWord		dw_delta;
	DWord		dw_dataptr;
	DWord		dw_length;
	Byte		b_data[3];
	Byte		b_run_status;
#ifdef	VERIFY_EVENT
	Word		uw_track;
#endif
} MidiEventInfo;


typedef struct	{
	Word			uw_division;
	DWord			dw_max_events;
	DWord			dw_max_metasize;
	
	MidiEventInfo	*p_event;
	Byte			*pb_vardata;
} MidiInfo;


/* ===================================================================*/
#define BIG2LITTLE16(n)		(((((unsigned short)(n))&0x00ff)<<8)|\
								((((unsigned short)(n))&0xff00)>>8))

#define BIG2LITTLE32(n)		(((((unsigned int)(n))&0x000000ff)<<24)|\
								((((unsigned int)(n))&0x0000ff00)<< 8)|\
								((((unsigned int)(n))&0x00ff0000)>> 8)|\
								((((unsigned int)(n))&0xff000000)>>24))

#define	STR_C_MAJOR				"C Major"		/* #,b(Flat) = 0 */
#define	STR_A_MINOR				"A Minor"		/* #,b(Flat) = 0 */
#define	STR_G_MAJOR				"G Major"		/* # = 1 */
#define	STR_E_MINOR				"E Minor"		/* # = 1 */
#define	STR_D_MAJOR				"D Major"		/* # = 2 */
#define	STR_B_MINOR				"B Minor"		/* # = 2 */
#define	STR_A_MAJOR				"A Major"		/* # = 3 */
#define	STR_F_SHARP_MINOR		"F Sharp Minor"	/* # = 3 */
#define	STR_E_MAJOR				"E Major"		/* # = 4 */
#define	STR_C_SHARP_MINOR		"C Sharp Minor"	/* # = 4 */
#define	STR_B_MAJOR				"B Major"		/* # = 5 */
#define	STR_G_SHARP_MINOR		"G Sharp Minor"	/* # = 5 */
#define	STR_F_SHARP_MAJOR		"F Sharp Major"	/* # = 6 */
#define	STR_D_SHARP_MINOR		"D Sharp Minor"	/* # = 6 */
#define	STR_C_SHARP_MAJOR		"C Sharp Major"	/* # = 7 */
#define	STR_A_SHARP_MINOR		"A Sharp Minor"	/* # = 7 */

#define	STR_F_MAJOR				"F Major"		/* b(Flat) = 1 */
#define	STR_D_MINOR				"D Minor"		/* b(Flat) = 1 */
#define	STR_B_FLAT_MAJOR		"B Flat Major"	/* b(Flat) = 2 */
#define	STR_G_MINOR				"G Minor"		/* b(Flat) = 2 */
#define	STR_E_FLAT_MAJOR		"E Flat Major"	/* b(Flat) = 3 */
#define	STR_C_MINOR				"C Minor"		/* b(Flat) = 3 */
#define	STR_A_FLAT_MAJOR		"A Flat Major"	/* b(Flat) = 4 */
#define	STR_F_MINOR				"F Minor"		/* b(Flat) = 4 */
#define	STR_D_FLAT_MAJOR		"D Flat Major"	/* b(Flat) = 5 */
#define	STR_B_FLAT_MINOR		"B Flat Minor"	/* b(Flat) = 5 */
#define	STR_G_FLAT_MAJOR		"G Flat Major"	/* b(Flat) = 6 */
#define	STR_E_FLAT_MINOR		"E Flat Minor"	/* b(Flat) = 6 */
#define	STR_C_FLAT_MAJOR		"C Flat Major"	/* b(Flat) = 7 */
#define	STR_A_FLAT_MINOR		"A Flat Minor"	/* b(Flat) = 7 */

#define	PLAYSTATUS_INITIALIZE	0x00
#define	PLAYSTATUS_PREPARE		0x01
#define	PLAYSTATUS_PLAYING		0x10
#define	PLAYSTATUS_CLOSING		0x40
#define	PLAYSTATUS_REQ_STOP		0x21
#define	PLAYSTATUS_REQ_PAUSE	0x22
#define	PLAYSTATUS_ERROR		0xff

#define	DATAFLAG_GM				0x0001
#define	DATAFLAG_XG				0x0002
#define	DATAFLAG_GS				0x0004
#define	DATAFLAG_OTHER			0x0008
#define	DATAFLAG_GM_RESET		0x0010
#define	DATAFLAG_XG_RESET		0x0020
#define	DATAFLAG_GS_RESET		0x0040

#define	DATAFLAG_MASK_RESET		0x00f0


#define	IS_PLAYSTATUS_REQUEST(n)	(0x20==((n)&0xf0))


#define	MODE_DEFAULT	0x00
#define	MODE_VERBOSE	0x01
#define	MODE_QUIET		0x02
#define	MODE_NORESET	0x04

#define	IS_MSGVERBOSE	(gb_mode & MODE_VERBOSE)
#define	IS_MSGQUIET		(gb_mode & MODE_QUIET)
#define	IS_NORESET		(gb_mode & MODE_NORESET)

#ifndef	PLAYUMIDI_SRC_MAIN
	#define	EXTERN_FUNC_MAIN		extern
	#define	EXTERN_PARAM_MAIN		extern
#else
	#define	EXTERN_FUNC_MAIN
	#define	EXTERN_PARAM_MAIN
#endif
EXTERN_PARAM_MAIN	Byte	gb_mode;
#ifdef SUPPORT_ICONV
	EXTERN_PARAM_MAIN	iconv_t		gt_iconv;
#endif


#ifndef	PLAYUMIDI_SRC_READ_SMF
	#define	EXTERN_FUNC_READ_SMF		extern
#else
	#define	EXTERN_FUNC_READ_SMF	
#endif
EXTERN_FUNC_READ_SMF int DecodeValue( DWord *dw_delta, Byte *pb_now );
EXTERN_FUNC_READ_SMF int ReadMidiData( Byte *pb_fbuf );
EXTERN_FUNC_READ_SMF int ReadSMF( const char *pstr_filename );


#ifndef PLAYUMIDI_SRC_MIDIEVENT
    #define EXTERN_FUNC_MIDIEVENT     extern
#else
    #define EXTERN_FUNC_MIDIEVENT 
#endif
EXTERN_FUNC_MIDIEVENT int MidiEvent_GetMidiInfo( MidiInfo *p_midi );
EXTERN_FUNC_MIDIEVENT void MidiEvent_SetMidiDivision( Word uw_division ) ;
EXTERN_FUNC_MIDIEVENT DWord MidiEvent_GetMidiEvents( void );
EXTERN_FUNC_MIDIEVENT MidiEventInfo *MidiEvent_GetMidiEventPointer( void );
EXTERN_FUNC_MIDIEVENT Byte *MidiEvent_GetVarDataPointer( void );
EXTERN_FUNC_MIDIEVENT int MidiEvent_AllocMidiVarData( DWord dw_varsize, DWord dw_metasize );
EXTERN_FUNC_MIDIEVENT int MidiEvent_FreeMidiVarData( void );
EXTERN_FUNC_MIDIEVENT int MidiEvent_AllocMidiEventInfo( DWord dw_events );
EXTERN_FUNC_MIDIEVENT int MidiEvent_FreeMidiEvnetInfo( void );


#ifndef PLAYUMIDI_SRC_PLAY_EVENT
    #define EXTERN_FUNC_PLAY_EVENT     extern
#else
    #define EXTERN_FUNC_PLAY_EVENT 
#endif
EXTERN_FUNC_PLAY_EVENT void Play_RequestStop( void ); 
EXTERN_FUNC_PLAY_EVENT void PlayEvent_Play( void *v_arg );
EXTERN_FUNC_PLAY_EVENT int PlayEvent_Initialize( void );
EXTERN_FUNC_PLAY_EVENT int PlayEvent_Term( void ); 


#ifndef PLAYUMIDI_SRC_MSLEEP
    #define EXTERN_FUNC_MSLEEP     extern
#else
    #define EXTERN_FUNC_MSLEEP 
#endif
EXTERN_FUNC_MSLEEP long	MSleep_Ajust( void );
EXTERN_FUNC_MSLEEP int	MSleep_MicroSleep( long l_usleep );


#ifndef PLAYUMIDI_SRC_MIDI_DEVICE
    #define EXTERN_FUNC_MIDI_DEVICE     extern
#else
    #define EXTERN_FUNC_MIDI_DEVICE 
#endif
EXTERN_FUNC_MIDI_DEVICE int MidiDevice_Init( char *pstr_basedev, char *pstr_midiport[]);
EXTERN_FUNC_MIDI_DEVICE int MidiDevice_Term( void );
EXTERN_FUNC_MIDI_DEVICE int MidiDevice_Write( int i_port, Byte *pb_data, size_t sz_len );


#ifdef	VERIFY_EVENT
	#ifndef PLAYUMIDI_SRC_VERIFY_EVENT
		extern int Veryfy_Event( TrackInfo *p_track_start, Word uw_tracks );
	#endif
#endif

/* EOF of playumidi.h **************************************************/
