/*MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI

                           P L A Y U M I D I
                  (/dev/umixiX.Y Direct MIDI Player)

   Copyright(C) 2014-2019 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI*/


#define	PLAYUMIDI_SRC_READ_SMF

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>
#include<assert.h>
#include<errno.h>
#include<fcntl.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/uio.h>
#include"playumidi.h"


/* Global Param. */
Word		guw_tracks;
TrackInfo	*gp_trackinfo;

/* ===================================================================*/
EXTERN_FUNC_READ_SMF
	int	DecodeValue(
		DWord	*dw_delta,
		Byte 	*pb_now )	{
	
	int		i_result;
	Byte	b_val;
	DWord	dw_value;

	dw_value	= 0x00000000;
	i_result	= 0;

	do	{
		b_val		= *pb_now++;
		i_result	+= 1;
		dw_value	= (dw_value << 7) | (b_val & 0x7f);

	} while( 0x00 != (b_val & 0x80) );
	
	*dw_delta	= dw_value;
	return	i_result;
}
		

/* ===================================================================*/
int Read_SMFHeader(
		Byte	*pb_fbuf )	{

	SmfHeader	t_smfheader;

	memcpy( &t_smfheader, pb_fbuf, sizeof( SmfHeader ));

	if( 0 != strncmp( t_smfheader.str_header, SMF_HEADER_STRING, 4) )	{
		fputs( "Error! : File is not MIDI File\n", stderr );
		return -0x01;
	}

	t_smfheader.dw_data_size	= BIG2LITTLE32( t_smfheader.dw_data_size );
	t_smfheader.uw_format		= BIG2LITTLE16( t_smfheader.uw_format );
	t_smfheader.uw_tracks		= BIG2LITTLE16( t_smfheader.uw_tracks );
	t_smfheader.uw_deltabase	= BIG2LITTLE16( t_smfheader.uw_deltabase );

	if( IS_MSGVERBOSE )		{
		printf( "  [File Info ]: Format= %d, Tracks= %d, Delta= %d\n",
				t_smfheader.uw_format, 
				t_smfheader.uw_tracks, 
				t_smfheader.uw_deltabase );
	}

	guw_tracks	= t_smfheader.uw_tracks;
	MidiEvent_SetMidiDivision( t_smfheader.uw_deltabase );

	return sizeof(SmfHeader);
}


/* ===================================================================*/
int Read_SMFTrackHeader(
		Byte	*pb_buf )	{

	int		i_cnt;
	TrackInfo		*p_track;
	SmfTrackHeader	*p_trkheader;
	DWord			dw_delta;
	
	p_track	= (gp_trackinfo + 0);
	
	for( i_cnt = 0; i_cnt < (int)guw_tracks; i_cnt++ )	{
		p_trkheader	= (SmfTrackHeader *)pb_buf;

		if( 0x00 != strncmp( p_trkheader->str_header, SMF_TRKHEADER_STRING, 4))	{
			p_track->dw_tracksize	= 0;
			p_track->pb_data		= NULL;
			p_track->pb_now			= NULL;
		}
		
		p_track->dw_tracksize	= BIG2LITTLE32(p_trkheader->dw_trksize);
		p_track->pb_data		= pb_buf + sizeof(SmfTrackHeader);
		p_track->pb_now			= pb_buf + sizeof(SmfTrackHeader);

		DecodeValue( &dw_delta, p_track->pb_now );
		p_track->dw_delta_now	= dw_delta;		
		p_track->b_run_status	= 0x00;

		pb_buf	+= (sizeof(SmfTrackHeader) + p_track->dw_tracksize);
		p_track++;
	}


	return 0x00;
}


/* ===================================================================*/
int	SearchMinDeltaTrack(
		int		i_start_track )	{

	TrackInfo		*p_now_track;
	TrackInfo		*p_track;
	int				i_now_track;
	int				i_track;
	DWord			dw_delta;
	int				i_cnt;

	i_now_track		= i_start_track;
	p_now_track		= (gp_trackinfo + i_now_track);
	dw_delta		= p_now_track->dw_delta_now;

	if( 0 == dw_delta )		{ return i_now_track; }

	i_track	= i_now_track;

	for( i_cnt = 1; i_cnt < (int)guw_tracks; i_cnt++ )		{
		i_track	= (i_start_track + i_cnt) % guw_tracks;
		p_track	= (gp_trackinfo + i_track);
		
		if( NULL != p_track->pb_now )	{
			if( dw_delta > p_track->dw_delta_now )	{
				i_now_track	= i_track;
				p_now_track	= p_track;
				dw_delta	= p_track->dw_delta_now;
			}
			if( 0 == p_track->dw_delta_now )	{ break; }
		}
	}
			
	return i_now_track;
}


/* ===================================================================*/
Word CheckSMF_Vendor(
		Word	w_flag,
		Byte	*pb_now,
		DWord	dw_size )	{

	Byte	b_reset_xg[]	= MIDI_RESET_XG;
	Byte	b_reset_gs[]	= MIDI_RESET_GS;
	Byte	b_reset_gm[]	= MIDI_RESET_GM;
	Byte	*pb_reset;

	if( MIDI_VENDOR_YAMAHA == *pb_now )
		{ w_flag |= DATAFLAG_XG; }
	else if( MIDI_VENDOR_ROLAND == *pb_now )
		{ w_flag |= DATAFLAG_GS; }
	else
		{ w_flag |= (DATAFLAG_OTHER | DATAFLAG_GM); }

	if( (w_flag & DATAFLAG_XG) && !(w_flag & DATAFLAG_XG_RESET) )	{
		pb_reset	= b_reset_xg + 1;
		if( !memcmp( (pb_now + 2), (pb_reset + 2), (dw_size - 2) )
				&& ( dw_size == MIDI_RESETSIZE_XG - 1 ) )
			{ w_flag |= DATAFLAG_XG_RESET; }
	}

	if( (w_flag & DATAFLAG_GS) && !(w_flag & DATAFLAG_GS_RESET) )	{
		pb_reset	= b_reset_gs + 1;
		if( !memcmp( (pb_now + 2), (pb_reset + 2), (dw_size - 2) )
				&& ( dw_size == MIDI_RESETSIZE_GS - 1 ) )
			{ w_flag |= DATAFLAG_GS_RESET; }
	}
	
	if( !(w_flag & DATAFLAG_GM_RESET) )		{
		pb_reset	= b_reset_gm + 1;
		if( !memcmp( pb_now, pb_reset, dw_size )
				&& ( dw_size == MIDI_RESETSIZE_GM - 1 ) )
			{ w_flag |= DATAFLAG_GM_RESET; }
	}

	return w_flag;
}


/* ===================================================================*/
int	CheckSMFTrack(
		DWord	*dw_max_events,
		DWord	*dw_max_varsize,
		DWord	*dw_max_metasize,
		Word	*w_dataflag )
{
	int		i_result;
	int		i_track;
	int		i_temp;
	Byte	*pb_now;
	Byte	b_runstatus;
	Byte	b_value;
	Word	w_flag;
	DWord	dw_trksize;
	DWord	dw_events;
	DWord	dw_varsize;
	DWord	dw_metasize;
	DWord	dw_delta;
	DWord	dw_temp;
	TrackInfo	*p_track;

	dw_events		= 0;
	dw_varsize		= 0;
	dw_metasize		= 0;

	w_flag			= 0x0000;

	for( i_track = 0; i_track < guw_tracks; i_track++ )	{
		b_runstatus		= 0x00;

		p_track		= (gp_trackinfo + i_track);
		pb_now		= p_track->pb_data;
		dw_trksize	= p_track->dw_tracksize;

		do	{
			/* Read DeltaTime */
			i_result	= DecodeValue( &dw_delta, pb_now );
			if( 4 < i_result )		{
				fprintf( stderr, "Error!!: [Trk %d] DeltaTime Value is Wrong!", i_track );
				return 0x01;
			}
			dw_trksize	-= i_result;
			pb_now		+= i_result;
	
			b_value		= *pb_now;
			if( SMF_IS_RUNNING_STATUS(b_value) )	{
				b_value	= b_runstatus;
			}
			
			b_value		&= 0xf0;

			if( (SMF_EVENT_NOTEOFF == b_value ) ||
					( SMF_EVENT_NOTEON == b_value ) ||
					( SMF_EVENT_KEYPRESSER == b_value ) ||
					( SMF_EVENT_CTRLCHANGE == b_value ) ||
					( SMF_EVENT_PITCHBEND == b_value ) )		{

				if( SMF_IS_RUNNING_STATUS(*pb_now) )	{
					pb_now		+= 2;
					dw_trksize	-= 2;
				} else	{
					b_runstatus	= *pb_now;
					assert( b_runstatus & 0x80 );
					pb_now		+= 3;
					dw_trksize	-= 3;
				}
			
			}
			else if( ( SMF_EVENT_PROGCHANGE == b_value ) ||
						( SMF_EVENT_CHNPRESSER == b_value ))	{

				if( SMF_IS_RUNNING_STATUS(*pb_now) )	{
					pb_now		+= 1;
					dw_trksize	-= 1;
				} else	{
					b_runstatus	= *pb_now;
					assert( b_runstatus & 0x80 );
					pb_now		+= 2;
					dw_trksize	-= 2;
				}
			}
			else if( SMF_EVENT_SYSEX_META == b_value )	{

				if( SMF_EVENT_SYSEX_F0 == *pb_now )	{
					
					i_temp	= DecodeValue( &dw_temp, (pb_now + 1) );
					dw_varsize	+= (dw_temp + 1);
					pb_now		+= (i_temp + 1);
					dw_trksize	-= (i_temp + 1);

					w_flag = CheckSMF_Vendor( w_flag, pb_now, dw_temp );

					pb_now		+= dw_temp;
					dw_trksize	-= dw_temp;
				}
				else if( SMF_EVENT_SYSEX_F7 == *pb_now )	{

					i_temp	= DecodeValue( &dw_temp, (pb_now + 1) );
					dw_varsize	+= dw_temp;
					pb_now		+= (i_temp + dw_temp + 1);
					dw_trksize	-= (i_temp + dw_temp + 1);
				}
				else if( SMF_EVENT_META == *pb_now )	{

					i_temp	= DecodeValue( &dw_temp, (pb_now + 2) );
					dw_varsize	+= (dw_temp + i_temp + 2);
					pb_now		+= (dw_temp + i_temp + 2);
					dw_trksize	-= (dw_temp + i_temp + 2);
					
					if( dw_metasize < dw_temp )
						{ dw_metasize	= dw_temp; }

					if( SMF_META_TRACKEND == *(pb_now - (dw_temp + i_temp + 1)) )	{
						if( 0 != dw_trksize )	{
							fprintf( stderr, "WARNING! : [Trk %d] Track DataSize is Wrong!\n",
									i_track);
						}
#ifdef	VERIFY_EVENT
						if(( IS_MSGVERBOSE ) && ( 0 == dw_trksize ))
							{ fprintf( stderr, " [Trk %d] Track Check is OK.\n", i_track); }
#endif
					}
				}
			}

			dw_events++;
	
		} while( dw_trksize != 0);

	}

	if( !IS_NORESET )	{
		if( !(w_flag & DATAFLAG_MASK_RESET ) )	{
			dw_events++;
			
			if( w_flag & DATAFLAG_XG )		{
				dw_varsize	+= (MIDI_RESETSIZE_XG + MIDI_RESETSIZE_GM);
				dw_events++;
			}
			else if( w_flag & DATAFLAG_GS )
				{ dw_varsize	+= MIDI_RESETSIZE_GS; }
			else
				{ dw_varsize	+= MIDI_RESETSIZE_GM; }
		}
	}

	*dw_max_events			= dw_events;
	*dw_max_varsize			= dw_varsize;
	*dw_max_metasize		= dw_metasize;
	*w_dataflag				= w_flag;

	return	0x00;
}




/* ===================================================================*/
int SMF_SetMidiResetEvent(
		DWord	*pdw_varsize,
		DWord	*pdw_first_delta,
		Word	w_dataflag )
{
	int				i_events;
	MidiEventInfo	*p_mevent;
	Byte			*pb_vardata;
	Byte			b_reset_gs[]	= MIDI_RESET_GS;
	Byte			b_reset_gm[]	= MIDI_RESET_GM;
	Byte			b_reset_xg[]	= MIDI_RESET_XG;
	DWord			dw_events;
	DWord			dw_varsize;
	DWord			dw_first_delta;
	MidiInfo		t_midi;


	MidiEvent_GetMidiInfo( &t_midi );
	p_mevent		= t_midi.p_event;
	pb_vardata		= t_midi.pb_vardata;
	dw_events		= t_midi.dw_max_events;

	assert( NULL != p_mevent );
	assert( NULL != pb_vardata );

	i_events		= 0;
	dw_varsize		= 0;
	dw_first_delta	= 0;

	if( !(w_dataflag & DATAFLAG_MASK_RESET) )		{
		if( w_dataflag & DATAFLAG_XG )	{
			/* GM Reset ------------------------------*/
			p_mevent->b_data[0]		= SMF_EVENT_SYSEX_F0;
			p_mevent->dw_delta		= 0;
			p_mevent->dw_dataptr	= dw_varsize;
			p_mevent->dw_length		= MIDI_RESETSIZE_GM;

			memcpy( pb_vardata, b_reset_gm, MIDI_RESETSIZE_GM );

			pb_vardata		+= MIDI_RESETSIZE_GM;
			dw_varsize		+= MIDI_RESETSIZE_GM;
			p_mevent++;
			i_events++;

			/* XG Reset ------------------------------*/
			p_mevent->b_data[0]		= SMF_EVENT_SYSEX_F0;
			p_mevent->dw_delta		= (DWord)(t_midi.uw_division) / 10;	/* = 50ms */
			p_mevent->dw_dataptr	= dw_varsize;
			p_mevent->dw_length		= MIDI_RESETSIZE_XG;

			memcpy( pb_vardata, b_reset_xg, MIDI_RESETSIZE_XG );

			pb_vardata		+= MIDI_RESETSIZE_XG;
			dw_varsize		+= MIDI_RESETSIZE_XG;

			if( IS_MSGVERBOSE )
				{ fputs( "  [playumidi ]: Auto Append XG-RESET Event before first MIDI Event.\n",
						stderr ); }
		}
		else if( w_dataflag & DATAFLAG_GS )	{
			/* GS Reset ------------------------------*/
			p_mevent->b_data[0]		= SMF_EVENT_SYSEX_F0;
			p_mevent->dw_delta		= 0;
			p_mevent->dw_dataptr	= dw_varsize;
			p_mevent->dw_length		= MIDI_RESETSIZE_GS;

			memcpy( pb_vardata, b_reset_gs, MIDI_RESETSIZE_GS );

			pb_vardata		+= MIDI_RESETSIZE_GS;
			dw_varsize		+= MIDI_RESETSIZE_GS;

			if( IS_MSGVERBOSE )
				{ fputs( "  [playumidi ]: Auto Append GS-RESET Event before first MIDI Event.\n",
						stderr ); }
		}
		else	{
			/* GM Reset ------------------------------*/
			p_mevent->b_data[0]		= SMF_EVENT_SYSEX_F0;
			p_mevent->dw_delta		= 0;
			p_mevent->dw_dataptr	= dw_varsize;
			p_mevent->dw_length		= MIDI_RESETSIZE_GM;

			memcpy( pb_vardata, b_reset_gm, MIDI_RESETSIZE_GM );

			pb_vardata		+= MIDI_RESETSIZE_GM;
			dw_varsize		+= MIDI_RESETSIZE_GM;

			if( IS_MSGVERBOSE )
				{ fputs( "  [playumidi ]: Auto Append GM-RESET Event before first MIDI Event.\n",
						stderr ); }
		}

		p_mevent++;
		i_events++;
		dw_first_delta	= (DWord)(t_midi.uw_division) / 10;		/* = 50ms */
	}

	*pdw_varsize		= dw_varsize;
	*pdw_first_delta	= dw_first_delta;

	return i_events;
}


/* ===================================================================*/
int ReadSMFTrack(
		Word	w_dataflag )
{
	int				i_result;
	int				i_now_track			= 0;
	int				i_endtracks			= 0;
	int				i_cnt;
	MidiEventInfo	*p_midievent;
	MidiEventInfo	*p_now_event;
	Byte			*pb_vardata;
	Byte			*pb_now_vardata;
	Byte			b_data;
	DWord			dw_events;
	DWord			dw_now_varsize		= 0;
	DWord			dw_delta			= 0;
	DWord			dw_first_delta		= 0;
	DWord			dw_temp;
	TrackInfo		*p_now_track;
	TrackInfo		*p_track;
	size_t			sz_size;
	MidiInfo		t_midi;

	MidiEvent_GetMidiInfo( &t_midi );
	p_midievent		= t_midi.p_event;
	pb_vardata		= t_midi.pb_vardata;
	dw_events		= t_midi.dw_max_events;

	assert( NULL != p_midievent );
	assert( NULL != pb_vardata );

	p_now_event		= p_midievent;
	pb_now_vardata	= pb_vardata;
	p_now_track	= (gp_trackinfo + 0);

	if( !IS_NORESET )	{
		i_result	= SMF_SetMidiResetEvent( &dw_now_varsize, &dw_first_delta, w_dataflag );
		pb_now_vardata	+= dw_now_varsize;
		p_now_event		+= i_result;
		dw_events		-= i_result;
	}
	

	do	{

#ifndef	NDEBUG
		if( 0 == dw_events )	{ assert(0xff); }
#endif
		
		/* Proc.01 - Search Minimam Deltatime Track */
		i_now_track	= SearchMinDeltaTrack( i_now_track );
		p_now_track	= (gp_trackinfo + i_now_track);
		dw_delta	= p_now_track->dw_delta_now;

		/* Proc.02 - Set MidiEventInfo */
		p_now_event->dw_delta	= dw_delta + dw_first_delta;
		if( 0 < dw_first_delta )	{ dw_first_delta	= 0; }
	
		i_result	= DecodeValue( &dw_temp, p_now_track->pb_now );
		p_now_track->pb_now	+= i_result;

#ifdef	VERIFY_EVENT
		p_now_event->uw_track	= (Word)i_now_track;
#endif

		b_data	= *(p_now_track->pb_now);
		if( SMF_IS_RUNNING_STATUS(b_data) )		{
			p_now_event->b_run_status	= p_now_track->b_run_status;
			b_data	= p_now_track->b_run_status;
			assert( b_data & 0x80 );
		}
		b_data	= b_data & 0xf0;

		/* 3Byte Data */
		if( (SMF_EVENT_NOTEOFF == b_data ) || ( SMF_EVENT_NOTEON == b_data ) ||
				( SMF_EVENT_KEYPRESSER == b_data ) || ( SMF_EVENT_CTRLCHANGE == b_data ) ||
				( SMF_EVENT_PITCHBEND == b_data ) )		{

			if( 0x00 != p_now_event->b_run_status )		{
				p_now_event->b_data[0]	= p_now_track->b_run_status;
				p_now_event->b_data[1]	= *(p_now_track->pb_now + 0);
				p_now_event->b_data[2]	= *(p_now_track->pb_now + 1);
				p_now_track->pb_now	+= 2;
			} else	{
				p_now_event->b_data[0]	= *(p_now_track->pb_now + 0);
				p_now_event->b_data[1]	= *(p_now_track->pb_now + 1);
				p_now_event->b_data[2]	= *(p_now_track->pb_now + 2);
				p_now_track->pb_now	+= 3;
				p_now_track->b_run_status	= p_now_event->b_data[0];
				assert( p_now_event->b_data[0] & 0x80 );
			}
			p_now_event->dw_length	= 3;
		}
		/* 2Byte Data */
		else if( ( SMF_EVENT_PROGCHANGE == b_data ) || ( SMF_EVENT_CHNPRESSER == b_data ))	{

			if( 0x00 != p_now_event->b_run_status )		{
				p_now_event->b_data[0]	= p_now_track->b_run_status;
				p_now_event->b_data[1]	= *(p_now_track->pb_now + 0);
				p_now_track->pb_now	+= 1;
			} else	{
				p_now_event->b_data[0]	= *(p_now_track->pb_now + 0);
				p_now_event->b_data[1]	= *(p_now_track->pb_now + 1);
				p_now_track->pb_now	+= 2;
				p_now_track->b_run_status	= p_now_event->b_data[0];
				assert( p_now_event->b_data[0] & 0x80 );
			}
			p_now_event->dw_length	= 2;
		}
		/* Var Data */
		else if( SMF_EVENT_SYSEX_META == b_data )	{

			if( SMF_EVENT_SYSEX_F0 == *(p_now_track->pb_now) )	{

				/* Proc. 1Byte */
				p_now_event->b_data[0]	= *(p_now_track->pb_now + 0);
				p_now_event->dw_dataptr	= dw_now_varsize;

				*pb_now_vardata++	= p_now_event->b_data[0];		/* 1Byte */
				dw_now_varsize++;
				p_now_track->pb_now++;

				/* Proc. Length */
				i_result	= DecodeValue( &dw_temp, p_now_track->pb_now );
				sz_size		= (size_t)dw_temp;
				p_now_track->pb_now		+= i_result;

				/* Proc. Data */
				memcpy( pb_now_vardata, p_now_track->pb_now, sz_size);
				pb_now_vardata		+= sz_size;
				dw_now_varsize		+= sz_size;
				p_now_track->pb_now	+= sz_size;

				p_now_event->dw_length	= sz_size + 1;

				//p_now_track->b_run_status	= 0x00;
			}
			else if( SMF_EVENT_SYSEX_F7 == *(p_now_track->pb_now) )	{

				/* Proc. 1Byte */
				p_now_event->b_data[0]	= *(p_now_track->pb_now + 0);
				p_now_track->pb_now++;

				/* Proc. Length */
				i_result	= DecodeValue( &dw_temp, p_now_track->pb_now );
				sz_size		= (size_t)dw_temp;
				p_now_track->pb_now		+= i_result;

				/* Proc. Data */
				p_now_event->dw_dataptr	= dw_now_varsize;
				memcpy( pb_now_vardata, p_now_track->pb_now, sz_size);
				pb_now_vardata		+= sz_size;
				dw_now_varsize		+= sz_size;
				p_now_track->pb_now	+= sz_size;

				p_now_event->dw_length	= sz_size;

				//p_now_track->b_run_status	= 0x00;
			}
			else if( SMF_EVENT_META == *(p_now_track->pb_now) )	{

				/* Proc. 2Byte (MetaStatus(0xff) & MetaCode */
				p_now_event->b_data[0]	= *(p_now_track->pb_now + 0);
				p_now_event->b_data[1]	= *(p_now_track->pb_now + 1);

				/* Proc. Length */
				i_result	= DecodeValue( &dw_temp, (p_now_track->pb_now + 2) );
				sz_size		= (size_t)(dw_temp + i_result + 2);

				p_now_event->dw_dataptr	= dw_now_varsize;
				memcpy( pb_now_vardata, p_now_track->pb_now, sz_size);
				pb_now_vardata	+= sz_size;
				dw_now_varsize	+= sz_size;
				p_now_track->pb_now	+= sz_size;
				p_now_event->dw_length	= sz_size;

				if( SMF_META_TRACKEND == p_now_event->b_data[1] )	{
					p_now_track->pb_now	= NULL;
					p_now_track->dw_delta_now	= 0xffffffff;
					i_endtracks++;
				}
				
				//p_now_track->b_run_status	= 0x00;
			}

		}
#ifndef	NDEBUG
		else	{
			assert(0xff);
		}
#endif

		if( 0 < dw_delta )	{	
			for( i_cnt = 0; i_cnt < guw_tracks; i_cnt++ )		{
				p_track	= (gp_trackinfo + i_cnt);
				p_track->dw_delta_now	-= dw_delta;
			}
		}
		if( NULL != p_now_track->pb_now )	{
			i_result	= DecodeValue( &dw_temp, p_now_track->pb_now );
			p_now_track->dw_delta_now	= dw_temp;
		}

		/* Proc.*/
		p_now_event++;
		dw_events--;
		dw_delta	= 0;

	}while( guw_tracks > i_endtracks );

	return 0x00;
}


/* ===================================================================*/
EXTERN_FUNC_READ_SMF int
	ReadMidiData(
		Byte	*pb_fbuf )	{

	int				i_err;
	int				i_result			= 0x00;
	Byte			*pb_now;
	Word			w_dataflag;
	DWord			dw_max_events		= 0;
	DWord			dw_max_varsize		= 0;
	DWord			dw_max_metasize		= 0;
	
	pb_now	= pb_fbuf;
	
	/* Read MidiFile Header ----------------------------------*/
	i_err	= Read_SMFHeader( pb_now );
	if( 0 > i_err )		{ return i_err; }
	pb_now	+= i_err;
	
	/* Read MidiFile Track Header ----------------------------*/
	gp_trackinfo	= (TrackInfo *)malloc(
							sizeof(TrackInfo) * (int)guw_tracks);
	if( NULL == gp_trackinfo )		{ return -0x02; }

	i_result	= Read_SMFTrackHeader( pb_now );
	/* i_result is already 0 */

	/* Check & GetMemorySize from SMF ------------------------*/
	i_result	= CheckSMFTrack( &dw_max_events, &dw_max_varsize,
									&dw_max_metasize, &w_dataflag );
	if( 0 != i_result )		{ goto goto_ReadMidiData_post; }

	/* Alloc MidiEventInfo ---------------------------------- */
	i_result	= MidiEvent_AllocMidiEventInfo( dw_max_events );
	if( 0x00 != i_result )	{ goto goto_ReadMidiData_post; }

	i_result	= MidiEvent_AllocMidiVarData(
						dw_max_varsize + 1, dw_max_metasize );
	if( 0x00 != i_result )	{
		MidiEvent_FreeMidiEvnetInfo();
		goto goto_ReadMidiData_post;
	}

	/* Read TrackEvent/Data to MidiEventInfo ----------------*/
	i_result	= ReadSMFTrack( w_dataflag );

#ifdef VERIFY_EVENT
	i_result	= Veryfy_Event( gp_trackinfo, guw_tracks );
	if( 0x00 != i_result )		{
		MidiEvent_FreeMidiVarData();
		MidiEvent_FreeMidiEvnetInfo();
	}
#endif
	
goto_ReadMidiData_post:
	/* Free MidiFile TrackInfo  -----------------------------*/
	assert( NULL != gp_trackinfo );
	free( gp_trackinfo );
	gp_trackinfo	= NULL;

	return i_result;
}


/* ===================================================================*/
EXTERN_FUNC_READ_SMF int
	ReadSMF(
		const char	*pstr_filename )	{

	int				i_result	= 0x00;
	int				i_err;
	int				i_fd		= -0x01;
	size_t			sz_filesize;
	struct stat		t_status;
	Byte			*pb_filebuf	= NULL;

	/* Get Midi File Size ---*/
	i_err	= stat( pstr_filename, &t_status );
	if( -1 == i_err )	{
		i_result	= -0x01;
		fprintf( stderr, "Error!!: Can't get MIDI filesize (%d)\n", errno );
		goto goto_ReadSMF_ReadSMF_post;
	}
	sz_filesize	= (unsigned int)t_status.st_size;

	/* Open Midi File --- */
	i_fd	= open( pstr_filename, O_RDONLY );
	if( -1 == i_fd )	{
		i_result	= -0x02;
		fprintf( stderr,"Error!!: Can't open MIDI file (%d)\n", errno );
		goto goto_ReadSMF_ReadSMF_post;
	}

	/* Alloc Midi File Temporary Buffer --- */
	pb_filebuf = (Byte *)malloc( sz_filesize );
	if( NULL == pb_filebuf)	{
		i_result	= -0x03;
		fputs( "Error!!: Not Engouh Memory!\n", stderr );
		goto goto_ReadSMF_ReadSMF_post;
	}

	/* Read Midi File to Temporary Buffer --- */
	i_err	= (int)read( i_fd, pb_filebuf, sz_filesize );
	if( -1 == i_err )	{
		i_result	= -0x04;
		fprintf( stderr, "Error!!: Can't read MIDI file (%d)\n", errno );
		goto goto_ReadSMF_ReadSMF_post;
	}

	/* Close Midi File Descriptor --- */
	i_err	= close( i_fd );
	if( -1 == i_err )	{
		i_result	= -0x05;
		fprintf( stderr, "Error!!: Can't close MIDI file (%d)\n", errno );
		goto goto_ReadSMF_ReadSMF_post;
	}
	
	/* Read Midi File Header --- */
	i_result	= ReadMidiData( pb_filebuf );

goto_ReadSMF_ReadSMF_post:
	if( NULL != pb_filebuf )
		{ free( pb_filebuf ); }

	return i_result;
}


/* EOF of read_smf.c **************************************************/

