/*MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI

                           P L A Y U M I D I
                  (/dev/umixiX.Y Direct MIDI Player)

   Copyright(C) 2014-2019 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

MIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDIMIDI*/


#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<assert.h>
#include"playumidi.h"

/* ===================================================================*/
int	EncodeValue(
		Byte	*pb_value, 
		DWord	dw_delta )	{

	Byte	b_temp;
	Byte	b_data[4];
	int		i_len;
	int		i_cnt;
	*(pb_value + 0)	= 0x00;
	*(pb_value + 1)	= 0x00;
	*(pb_value + 2)	= 0x00;
	*(pb_value + 3)	= 0x00;

	i_len	= 0;
	do	{
		b_temp		= (Byte)(dw_delta & 0x0000007f);
		dw_delta	>>= 7; 
		if( 0 < i_len )	{ b_temp |= 0x80; }

		b_data[i_len++]	= b_temp;

	}while( dw_delta != 0x00000000 );

	for( i_cnt = 0; i_cnt < i_len; i_cnt++ )	{
		*(pb_value + i_cnt) 	= b_data[ i_len - i_cnt - 1 ];
	}

	return i_len;
}


/* ===================================================================*/
int	Veryfy_Event(
		TrackInfo	*p_track_start,
		Word		uw_tracks )	{

	int				i_track;
	DWord			dw_delta;
	DWord			dw_temp;
	DWord			dw_max_events;
	MidiEventInfo	*p_mevent;
	Byte			*pb_vartop;
	Byte			*pb_vardata;
	Byte			b_value[4];
	Byte			b_status;
	Byte			*pb_temp;
	TrackInfo		*p_track;
	int				i_len;
	int				i_result;


	p_mevent		= MidiEvent_GetMidiEventPointer();
	assert( NULL != p_mevent );

	pb_vartop		= MidiEvent_GetVarDataPointer();
	assert( NULL != pb_vartop );
	pb_vardata		= pb_vartop;

	dw_max_events	= MidiEvent_GetMidiEvents();

	/* Init TrackInfo */
	for( i_track = 0; i_track < uw_tracks; i_track++ )	{
		p_track		= (p_track_start + i_track);
		assert( NULL != p_track );

		p_track->pb_now			= p_track->pb_data;
		p_track->dw_delta_now	= 0;
	}


	for( ; dw_max_events > 0; dw_max_events-- )	{

		/* Encode Delta time */
		dw_delta	= p_mevent->dw_delta;
		for( i_track = 0; i_track < uw_tracks; i_track++ )	{
			p_track		= (p_track_start + i_track);		
			p_track->dw_delta_now	+= dw_delta;
		}

		/* Get Current TrackID */
		i_track		= (int)p_mevent->uw_track;
		p_track		= (p_track_start + i_track);		
		assert( NULL != p_track );

		/* Verify DeltaTime */
		i_len	= EncodeValue( b_value, p_track->dw_delta_now );
		if( 0 == i_len )	{
			fprintf(stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] DeltaTime Length = 0\n",
						i_track );
			return 0x01;
		}

		i_result	= memcmp( b_value, p_track->pb_now, i_len );
		if( 0 != i_result )	{
			DecodeValue( &dw_temp, p_track->pb_now );
			fprintf(stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] DeltaTime: Event:%d(%x %x %x %x) <=> MidiSrc:%d \n",
						i_track, i_len, b_value[0], b_value[1],
						b_value[2], b_value[3], dw_temp );
			return 0x02;
		}

		p_track->dw_delta_now	= 0;
		p_track->pb_now			+= i_len;

		/* Verify MidiEvent */
		b_status	= p_mevent->b_data[0] & 0xf0;

		if( (SMF_EVENT_NOTEOFF == b_status ) || ( SMF_EVENT_NOTEON == b_status ) ||
				( SMF_EVENT_KEYPRESSER == b_status ) || ( SMF_EVENT_CTRLCHANGE == b_status ) ||
				( SMF_EVENT_PITCHBEND == b_status ) ) 	{

			if( 0x00 != p_mevent->b_run_status )	{
				b_value[0]	= p_mevent->b_data[1];
				b_value[1]	= p_mevent->b_data[2];
				i_len		= 2;
			} else	{
				b_value[0]	= p_mevent->b_data[0];
				b_value[1]	= p_mevent->b_data[1];
				b_value[2]	= p_mevent->b_data[2];
				i_len		= 3;

			}

			i_result	= memcmp( b_value, p_track->pb_now, i_len );
			if( 0 != i_result )		{
				fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] 3Byte-Event: Event:%x %x %x <=> MidiSrc:%ld \n",
						i_track, b_value[0], b_value[1], b_value[2],
						(p_track->pb_data - p_track->pb_now) );
				return 0x03;
			}
			
			p_track->pb_now		+=  i_len;
		}
		else if( ( SMF_EVENT_PROGCHANGE == b_status ) ||
				( SMF_EVENT_CHNPRESSER == b_status ))		{

			if( 0x00 != p_mevent->b_run_status )	{
				b_value[0]	= p_mevent->b_data[1];
				i_len		= 1;
			} else	{
				b_value[0]	= p_mevent->b_data[0];
				b_value[1]	= p_mevent->b_data[1];
				i_len		= 2;

			}

			i_result	= memcmp( b_value, p_track->pb_now, i_len );
			if( 0 != i_result )		{
				fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] 2Byte-Event: Event:%x %x <=> MidiSrc:%ld \n",
						i_track, b_value[0], b_value[1],
						(p_track->pb_data - p_track->pb_now) );
				return 0x04;
			}
			
			p_track->pb_now		+=  i_len;
		}
		else if( SMF_EVENT_SYSEX_META == b_status )	{

			b_status	= p_mevent->b_data[0];
			if( SMF_EVENT_SYSEX_F0 == b_status )	{

				/* Check 1Byte */
				if( p_mevent->b_data[0] != *p_track->pb_now )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] SysEx(F0) Status: Code:%x <=> MidiSrc:%ld \n",
						i_track, p_mevent->b_data[0], (p_track->pb_data - p_track->pb_now) );
					return 0x05;
				}
				p_track->pb_now++;
				
				/* Check Length */
				i_len	= EncodeValue( b_value, (p_mevent->dw_length - 1) );
				i_result	= memcmp( b_value, p_track->pb_now, i_len );
				if( 0 != i_result )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] SysEx(F0) Size: Code:%d(%x %x %x %x)<=> MidiSrc:%ld \n",
						i_track, p_mevent->dw_length, b_value[0], b_value[1], b_value[2],
						b_value[3], (p_track->pb_data - p_track->pb_now) );
					return 0x05;
				}
				p_track->pb_now		+=  i_len;

				pb_temp	= (pb_vartop + p_mevent->dw_dataptr);
				if( pb_temp != pb_vardata )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] SysEx(F0) VarData Ptr. Error \n", i_track );
					return 0x06;
				}

				if( p_mevent->b_data[0] != *pb_temp )	{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] SysEx(F0) Data: First Byte(%x,%x) \n",
						i_track, p_mevent->b_data[0], *(p_track->pb_now) );
					return 0x0f;

				}
				pb_temp++;

				i_result	= memcmp( pb_temp, p_track->pb_now, p_mevent->dw_length - 1 );
				if( 0 != i_result )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] SysEx(F0) Data: len=%d \n", i_track, i_len );
					return 0x07;
				}
					
				p_track->pb_now		+= (p_mevent->dw_length - 1);
				pb_vardata			+= p_mevent->dw_length;

			} else if( SMF_EVENT_SYSEX_F7 == b_status )		{

				/* Check 1Byte */
				if( p_mevent->b_data[0] != *p_track->pb_now )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] SysEx(F7) Status: Code:%x <=> MidiSrc:%ld \n",
						i_track, p_mevent->b_data[0], (p_track->pb_data - p_track->pb_now) );
					return 0x08;
				}
				p_track->pb_now++;
				
				/* Check Length */
				i_len	= EncodeValue( b_value, p_mevent->dw_length );
				i_result	= memcmp( b_value, p_track->pb_now, i_len );
				if( 0 != i_result )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] SysEx(F7) Size: Code:%d(%x %x %x %x)<=> MidiSrc:%ld \n",
						i_track, p_mevent->dw_length, b_value[0], b_value[1], b_value[2],
						b_value[3], (p_track->pb_data - p_track->pb_now) );
					return 0x08;
				}
				p_track->pb_now		+=  i_len;

				pb_temp	= (pb_vartop + p_mevent->dw_dataptr);
				if( pb_temp != pb_vardata )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] SysEx(F7) VarData Ptr. Error \n", i_track );
					return 0x08;
				}

				i_result	= memcmp( pb_temp, p_track->pb_now, p_mevent->dw_length );
				if( 0 != i_result )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] SysEx(F7) Data: len=%d \n", i_track, i_len );
					return 0x09;
				}
					
				p_track->pb_now		+= p_mevent->dw_length;
				pb_vardata			+= p_mevent->dw_length;

			} else if( SMF_EVENT_META == b_status )		{

				/* Check 1Byte */
				if( p_mevent->b_data[0] != *(p_track->pb_now + 0) )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] Meta Status: Code:%x <=> MidiSrc:%x \n",
						i_track, p_mevent->b_data[0], *p_track->pb_now );
					return 0x08;
				}

				/* Check 2Byte */
				if( p_mevent->b_data[1] != *(p_track->pb_now + 1) )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] Meta Code: Code:%x <=> MidiSrc:%ld \n",
						i_track, p_mevent->b_data[1], (p_track->pb_data - p_track->pb_now) );
					return 0x08;
				}

				/* Check Length */
				i_len	= DecodeValue( &dw_temp, (p_track->pb_now + 2) );

				i_len	= EncodeValue( b_value, (p_mevent->dw_length - i_len - 2) );
				i_result	= memcmp( b_value, (p_track->pb_now + 2), i_len );
				if( 0 != i_result )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] Meta Size: Code:%d(%x %x %x %x)<=> MidiSrc:%ld \n",
						i_track, p_mevent->dw_length, b_value[0], b_value[1], b_value[2],
						b_value[3], (p_track->pb_data - p_track->pb_now) );
					return 0x08;
				}

				pb_temp	= (pb_vartop + p_mevent->dw_dataptr);
				if( pb_temp != pb_vardata )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] Meta VarData Ptr. Error \n", i_track );
					return 0x08;
				}

				i_result	= memcmp( pb_temp, p_track->pb_now, p_mevent->dw_length );
				if( 0 != i_result )		{
					fprintf( stderr, "Error!!: Fail Verify MidiEvent --"	\
						" [Trk %d] Meta Data: len=%d \n", i_track, i_len );
					return 0x09;
				}
					
				p_track->pb_now		+= p_mevent->dw_length;
				pb_vardata			+= p_mevent->dw_length;

			}
		}

		p_mevent++;
	}
	
	fputs( "Verify MidiEvent is Completed!!\n", stderr );

	return 0x00;
}


/* EOF of verify_event.c **********************************************/
