<?php
class Plugg_Search_Admin_Searchable extends Plugg_RoutingController
{
    private $_searchable;
    private $_searchablePlugin;
    
    public function __construct()
    {
        parent::__construct('View', 'Plugg_Search_Admin_Searchable_', dirname(__FILE__) . '/Searchable');
        $this->addFilter('_isValidSearchableRequested');
    }
    
    protected function _isValidSearchableRequestedBeforeFilter($context)
    {
        $this->_searchable = $this->isValidEntityRequested($context, 'Searchable', 'searchable_id');
        if (!$this->_searchablePlugin = $this->pluginManager->getPlugin($this->_searchable->get('plugin'))) {
            $context->response->setError($context->plugin->_('Invalid request'));
            $context->response->send($this->_application);
        }
        $searchable_name = $this->_searchable->get('name');
        $searchable_id = $this->_searchable->getId();
        $page_title = sprintf($this->_searchablePlugin->searchGetNicename($searchable_name), $this->_searchablePlugin->getNicename());
        $context->response->setPageInfo($page_title, array('path' => '/' . $searchable_id));
    }
    
    protected function _isValidSearchableRequestedAfterFilter($context){}

    protected function _doGetRoutes($context)
    {
        return array(
            'import' => array(
                'controller' => 'Import',
            ),
        );
    }
    
    public function getSearchable()
    {
        return $this->_searchable;
    }
    
    public function getSearchablePlugin()
    {
        return $this->_searchablePlugin;
    }
}