<?php
require_once 'Plugg/RoutingController.php';

class Plugg_User_Main_Identity extends Plugg_RoutingController
{
    private $_identity;

    public function __construct()
    {
        parent::__construct('View', 'Plugg_User_Main_Identity_', dirname(__FILE__) . '/Identity');
        $this->addControllerFilter(
            array('EditEmail', 'EditPassword', 'EditImage', 'Edit', 'Delete', 'EditStatus', 'Friend'),
            'isAuthenticated'
        );
        $this->addFilters(array('_isValidUserManagerEnabled', '_isValidIdentityRequested'));
    }

    protected function _isValidUserManagerEnabledBeforeFilter(Sabai_Application_Context $context)
    {
        // Check if user manager plugin is valid
        if (!$manager = $context->plugin->getManagerPlugin()) {
            $context->response
                ->setError($context->plugin->_('Invalid request'))
                ->send($this->_application);
        }
    }

    protected function _isValidUserManagerEnabledAfterFilter(Sabai_Application_Context $context){}

    protected function _isValidIdentityRequestedBeforeFilter(Sabai_Application_Context $context)
    {
        if (!$identity = $this->getRequestedUserIdentity($context, true)) {
            $context->response
                ->setError($context->plugin->_('Invalid request'))
                ->send($this->_application);
        }
    }

    protected function _isValidIdentityRequestedAfterFilter(Sabai_Application_Context $context){}

    protected function _doGetRoutes(Sabai_Application_Context $context)
    {
        return array(
            'edit_email' => array(
                'controller' => 'EditEmail',
            ),
            'edit_password' => array(
                'controller' => 'EditPassword',
            ),
            'edit_image' => array(
                'controller' => 'EditImage',
            ),
            'edit' => array(
                'controller' => 'Edit',
            ),
            'delete' => array(
                'controller' => 'Delete',
            ),
            'edit_status' => array(
                'controller' => 'EditStatus',
            ),
            'friend' => array(
                'controller' => 'Friend',
            ),
            'delete_autologin' => array(
                'controller' => 'DeleteAutologin',
            ),
        );
    }

    public function getRequestedUserIdentity(Sabai_Application_Context $context, $setPageInto = false)
    {
        if (!isset($this->_identity)) {
            $this->_identity = false;
            if ($id = $context->request->getAsInt('user_id')) {
                $identity = $this->locator->getService('UserIdentityFetcher')->fetchUserIdentity($id, true);
                if (!$identity->isAnonymous()) {
                    $context->response->setVars(array(
                        'identity' => $identity,
                        'is_owner' => $context->user->getId() == $identity->getId(),
                    ));
                    if ($setPageInto) {
                        $params = array();
                        if ($tab_id = $context->request->getAsInt('tab_id')) {
                            $params = array('tab_id' => $tab_id);
                        }
                        $context->response->setPageInfo(
                            $identity->getUsername(),
                            array('path' => '/' . $id, 'params' => $params)
                        );
                    }
                    $this->_identity = $identity;
                }
            }
        }
        return $this->_identity;
    }

    public function getExtraByIdentity(Sabai_Application_Context $context, $identity)
    {
        return $this->getEntityByIdentity($context, $identity, 'Extra');
    }

    public function getEntityByIdentity(Sabai_Application_Context $context, $identity, $entityName)
    {
        return $context->plugin->getModel()->$entityName->fetchByUser($identity->getId())->getNext();
    }
}