// Smtp.cpp: CSmtp NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "pochy.h"
#include "Smtp.h"
#include "base64.h"
#include "cram.h"
#include "lib.h" // for debug

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CSmtp::CSmtp()
{

}

CSmtp::~CSmtp()
{

}

BOOL CSmtp::Helo()
{
	CString hostname;
	char buf[256];

	if(gethostname(buf, 255) == -1){
		hostname = "unknown";
	}else{
		hostname = buf;
	}

	this->m_current_command="HELO "+hostname+"\r\n";
	send(this->m_sock, this->m_current_command, this->m_current_command.GetLength(), 0);
	if(this->SockRead(this->m_current_response) == -1){
		return FALSE;
	}
	if(this->m_current_response.Find("250") != 0 &&
		this->m_current_response.Find("354") != 0 &&
		this->m_current_response.Find("221") != 0)
	{
		return FALSE;
	}
	
	return TRUE;
}

BOOL CSmtp::Ehlo(CString user, CString password)
{
	CString hostname;
	char buf[512];

	if(gethostname(buf, 255) == -1){
		hostname = "unknown";
	}else{
		hostname = buf;
	}

	this->m_current_command="EHLO "+hostname+"\r\n";
	send(this->m_sock, this->m_current_command, this->m_current_command.GetLength(), 0);
	while(this->SockRead(this->m_current_response) != -1){
		if(this->m_current_response.Find("250") != 0 &&
			this->m_current_response.Find("354") != 0 &&
			this->m_current_response.Find("221") != 0)
		{
			return FALSE;
		}
		if(this->m_current_response.Find("AUTH") != -1){
			this->m_auth_response = this->m_current_response;
		}
		if(this->m_current_response[3] == ' '){
			break;
		}
	}
	return this->Auth(user, password);
}

BOOL CSmtp::Auth(CString user, CString password)
{
	char buf[512];
	char b64buf[512];
	int len;

	if(this->m_auth_response.Find("CRAM-MD5") != -1){
		CString challenge;
		unsigned char digest[16];
		memset(digest, 0, sizeof(digest));

		this->m_current_command = "AUTH CRAM-MD5\r\n";
		send(this->m_sock, this->m_current_command, this->m_current_command.GetLength(), 0);
		if(this->SockRead(this->m_current_response) == -1){
			return FALSE;
		}

		int p = this->m_current_response.Find(" ", 0);
		challenge = this->m_current_response.Mid(p+1);

		memset(buf, 0, sizeof(buf));
		if((len = from64tobits(buf, challenge, sizeof(buf)-1)) <= 0){
			return FALSE;
		}
		buf[len] = '\0';

		hmac_md5((unsigned char *)password.GetBuffer(0), password.GetLength(), 
			(unsigned char *)buf, strlen(buf), 
			(unsigned char *)digest, sizeof(digest));

		memset(buf, 0, sizeof(buf));
		sprintf(buf,
		"%s %02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
		user, digest[0], digest[1], digest[2], digest[3],
		digest[4], digest[5], digest[6], digest[7], digest[8],
		digest[9], digest[10], digest[11], digest[12], digest[13],
		digest[14], digest[15]);

		memset(b64buf, 0, sizeof(b64buf));
		to64frombits((unsigned char *)b64buf, (const unsigned char *)buf, strlen(buf));
		this->m_current_command.Format("%s\r\n", b64buf);
		send(this->m_sock, this->m_current_command, this->m_current_command.GetLength(), 0);
	}else if(this->m_auth_response.Find("PLAIN") != -1){
		sprintf(buf, "%s^%s^%s", user, user, password);
		len = strlen(buf);
		for(int c = len-1; c >= 0; c--){
			if (buf[c] == '^')
				buf[c] = '\0';
		}
		to64frombits((unsigned char *)b64buf, (const unsigned char *)buf, len);
		this->m_current_command.Format("AUTH PLAIN %s\r\n", b64buf);
		send(this->m_sock, this->m_current_command, this->m_current_command.GetLength(), 0);
	}else{
		return FALSE;
	}

	if(this->SockRead(this->m_current_response) == -1){
		return FALSE;
	}
	if(this->m_current_response.Find("235") == 0){
		return TRUE;
	}
	return FALSE;
}
