/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaErrPtg;
import org.apache.poi.hssf.record.formula.AreaNPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.ArrayPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DeletedArea3DPtg;
import org.apache.poi.hssf.record.formula.DeletedRef3DPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.ErrPtg;
import org.apache.poi.hssf.record.formula.ExpPtg;
import org.apache.poi.hssf.record.formula.FuncPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.IntersectionPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MemAreaPtg;
import org.apache.poi.hssf.record.formula.MemErrPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NameXPtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PercentPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.RangePtg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.RefErrorPtg;
import org.apache.poi.hssf.record.formula.RefNPtg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.TblPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.record.formula.UnknownPtg;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public abstract class Ptg {
    public static final Ptg[] EMPTY_PTG_ARRAY = new Ptg[0];
    public static final byte CLASS_REF = 0;
    public static final byte CLASS_VALUE = 32;
    public static final byte CLASS_ARRAY = 64;
    private byte ptgClass = 0;

    public static Ptg[] readTokens(int size, LittleEndianInput in) {
        ArrayList<Ptg> temp = new ArrayList<Ptg>(4 + size / 2);
        int pos = 0;
        boolean hasArrayPtgs = false;
        while (pos < size) {
            Ptg ptg = Ptg.createPtg(in);
            if (ptg instanceof ArrayPtg.Initial) {
                hasArrayPtgs = true;
            }
            pos += ptg.getSize();
            temp.add(ptg);
        }
        if (pos != size) {
            throw new RuntimeException("Ptg array size mismatch");
        }
        if (hasArrayPtgs) {
            Ptg[] result = Ptg.toPtgArray(temp);
            int i = 0;
            while (i < result.length) {
                if (result[i] instanceof ArrayPtg.Initial) {
                    result[i] = ((ArrayPtg.Initial)result[i]).finishReading(in);
                }
                ++i;
            }
            return result;
        }
        return Ptg.toPtgArray(temp);
    }

    public static Ptg createPtg(LittleEndianInput in) {
        byte id = in.readByte();
        if (id < 32) {
            return Ptg.createBasePtg(id, in);
        }
        Ptg retval = Ptg.createClassifiedPtg(id, in);
        if (id >= 96) {
            retval.setClass((byte)64);
        } else if (id >= 64) {
            retval.setClass((byte)32);
        } else {
            retval.setClass((byte)0);
        }
        return retval;
    }

    private static Ptg createClassifiedPtg(byte id, LittleEndianInput in) {
        int baseId = id & 0x1F | 0x20;
        switch (baseId) {
            case 32: {
                return new ArrayPtg.Initial(in);
            }
            case 33: {
                return FuncPtg.create(in);
            }
            case 34: {
                return FuncVarPtg.create(in);
            }
            case 35: {
                return new NamePtg(in);
            }
            case 36: {
                return new RefPtg(in);
            }
            case 37: {
                return new AreaPtg(in);
            }
            case 38: {
                return new MemAreaPtg(in);
            }
            case 39: {
                return new MemErrPtg(in);
            }
            case 41: {
                return new MemFuncPtg(in);
            }
            case 42: {
                return new RefErrorPtg(in);
            }
            case 43: {
                return new AreaErrPtg(in);
            }
            case 44: {
                return new RefNPtg(in);
            }
            case 45: {
                return new AreaNPtg(in);
            }
            case 57: {
                return new NameXPtg(in);
            }
            case 58: {
                return new Ref3DPtg(in);
            }
            case 59: {
                return new Area3DPtg(in);
            }
            case 60: {
                return new DeletedRef3DPtg(in);
            }
            case 61: {
                return new DeletedArea3DPtg(in);
            }
        }
        throw new UnsupportedOperationException(" Unknown Ptg in Formula: 0x" + Integer.toHexString(id) + " (" + id + ")");
    }

    private static Ptg createBasePtg(byte id, LittleEndianInput in) {
        switch (id) {
            case 0: {
                return new UnknownPtg(id);
            }
            case 1: {
                return new ExpPtg(in);
            }
            case 2: {
                return new TblPtg(in);
            }
            case 3: {
                return AddPtg.instance;
            }
            case 4: {
                return SubtractPtg.instance;
            }
            case 5: {
                return MultiplyPtg.instance;
            }
            case 6: {
                return DividePtg.instance;
            }
            case 7: {
                return PowerPtg.instance;
            }
            case 8: {
                return ConcatPtg.instance;
            }
            case 9: {
                return LessThanPtg.instance;
            }
            case 10: {
                return LessEqualPtg.instance;
            }
            case 11: {
                return EqualPtg.instance;
            }
            case 12: {
                return GreaterEqualPtg.instance;
            }
            case 13: {
                return GreaterThanPtg.instance;
            }
            case 14: {
                return NotEqualPtg.instance;
            }
            case 15: {
                return IntersectionPtg.instance;
            }
            case 16: {
                return UnionPtg.instance;
            }
            case 17: {
                return RangePtg.instance;
            }
            case 18: {
                return UnaryPlusPtg.instance;
            }
            case 19: {
                return UnaryMinusPtg.instance;
            }
            case 20: {
                return PercentPtg.instance;
            }
            case 21: {
                return ParenthesisPtg.instance;
            }
            case 22: {
                return MissingArgPtg.instance;
            }
            case 23: {
                return new StringPtg(in);
            }
            case 25: {
                return new AttrPtg(in);
            }
            case 28: {
                return ErrPtg.read(in);
            }
            case 29: {
                return BoolPtg.read(in);
            }
            case 30: {
                return new IntPtg(in);
            }
            case 31: {
                return new NumberPtg(in);
            }
        }
        throw new RuntimeException("Unexpected base token id (" + id + ")");
    }

    private static Ptg[] toPtgArray(List l) {
        if (l.isEmpty()) {
            return EMPTY_PTG_ARRAY;
        }
        Ptg[] result = new Ptg[l.size()];
        l.toArray(result);
        return result;
    }

    public static int getEncodedSize(Ptg[] ptgs) {
        int result = 0;
        int i = 0;
        while (i < ptgs.length) {
            result += ptgs[i].getSize();
            ++i;
        }
        return result;
    }

    public static int getEncodedSizeWithoutArrayData(Ptg[] ptgs) {
        int result = 0;
        int i = 0;
        while (i < ptgs.length) {
            Ptg ptg = ptgs[i];
            result = ptg instanceof ArrayPtg ? (result += 8) : (result += ptg.getSize());
            ++i;
        }
        return result;
    }

    public static int serializePtgs(Ptg[] ptgs, byte[] array, int offset) {
        int nTokens = ptgs.length;
        LittleEndianByteArrayOutputStream out = new LittleEndianByteArrayOutputStream(array, offset);
        ArrayList<Ptg> arrayPtgs = null;
        int k = 0;
        while (k < nTokens) {
            Ptg ptg = ptgs[k];
            ptg.write(out);
            if (ptg instanceof ArrayPtg) {
                if (arrayPtgs == null) {
                    arrayPtgs = new ArrayList<Ptg>(5);
                }
                arrayPtgs.add(ptg);
            }
            ++k;
        }
        if (arrayPtgs != null) {
            int i = 0;
            while (i < arrayPtgs.size()) {
                ArrayPtg p = (ArrayPtg)arrayPtgs.get(i);
                p.writeTokenValueBytes(out);
                ++i;
            }
        }
        return out.getWriteIndex() - offset;
    }

    public abstract int getSize();

    public abstract void write(LittleEndianOutput var1);

    public abstract String toFormulaString();

    public String toString() {
        return this.getClass().toString();
    }

    public final void setClass(byte thePtgClass) {
        if (this.isBaseToken()) {
            throw new RuntimeException("setClass should not be called on a base token");
        }
        this.ptgClass = thePtgClass;
    }

    public final byte getPtgClass() {
        return this.ptgClass;
    }

    public final char getRVAType() {
        if (this.isBaseToken()) {
            return '.';
        }
        switch (this.ptgClass) {
            case 0: {
                return 'R';
            }
            case 32: {
                return 'V';
            }
            case 64: {
                return 'A';
            }
        }
        throw new RuntimeException("Unknown operand class (" + this.ptgClass + ")");
    }

    public abstract byte getDefaultOperandClass();

    public abstract boolean isBaseToken();

    public static boolean doesFormulaReferToDeletedCell(Ptg[] ptgs) {
        int i = 0;
        while (i < ptgs.length) {
            if (Ptg.isDeletedCellRef(ptgs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isDeletedCellRef(Ptg ptg) {
        if (ptg == ErrPtg.REF_INVALID) {
            return true;
        }
        if (ptg instanceof DeletedArea3DPtg) {
            return true;
        }
        if (ptg instanceof DeletedRef3DPtg) {
            return true;
        }
        if (ptg instanceof AreaErrPtg) {
            return true;
        }
        return ptg instanceof RefErrorPtg;
    }
}

