/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class EscherContainerRecord
extends EscherRecord {
    public static final short DGG_CONTAINER = -4096;
    public static final short BSTORE_CONTAINER = -4095;
    public static final short DG_CONTAINER = -4094;
    public static final short SPGR_CONTAINER = -4093;
    public static final short SP_CONTAINER = -4092;
    public static final short SOLVER_CONTAINER = -4091;
    private final List _childRecords = new ArrayList();

    public int fillFields(byte[] data, int pOffset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, pOffset);
        int bytesWritten = 8;
        int offset = pOffset + 8;
        while (bytesRemaining > 0 && offset < data.length) {
            EscherRecord child = recordFactory.createRecord(data, offset);
            int childBytesWritten = child.fillFields(data, offset, recordFactory);
            bytesWritten += childBytesWritten;
            this.addChildRecord(child);
            if ((offset += childBytesWritten) < data.length || (bytesRemaining -= childBytesWritten) <= 0) continue;
            System.out.println("WARNING: " + bytesRemaining + " bytes remaining but no space left");
        }
        return bytesWritten;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        int remainingBytes = 0;
        Iterator iterator = this._childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            remainingBytes += r.getRecordSize();
        }
        LittleEndian.putInt(data, offset + 4, remainingBytes);
        int pos = offset + 8;
        iterator = this._childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            pos += r.serialize(pos, data, listener);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public int getRecordSize() {
        int childRecordsSize = 0;
        Iterator iterator = this._childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            childRecordsSize += r.getRecordSize();
        }
        return 8 + childRecordsSize;
    }

    public boolean hasChildOfType(short recordId) {
        Iterator iterator = this._childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            if (r.getRecordId() != recordId) continue;
            return true;
        }
        return false;
    }

    public EscherRecord getChild(int index) {
        return (EscherRecord)this._childRecords.get(index);
    }

    public List getChildRecords() {
        return new ArrayList(this._childRecords);
    }

    public Iterator getChildIterator() {
        return new ReadOnlyIterator(this._childRecords);
    }

    public void setChildRecords(List childRecords) {
        if (childRecords == this._childRecords) {
            throw new IllegalStateException("Child records private data member has escaped");
        }
        this._childRecords.clear();
        this._childRecords.addAll(childRecords);
    }

    public boolean removeChildRecord(EscherRecord toBeRemoved) {
        return this._childRecords.remove(toBeRemoved);
    }

    public List getChildContainers() {
        ArrayList<EscherContainerRecord> containers = new ArrayList<EscherContainerRecord>();
        Iterator iterator = this._childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            if (!(r instanceof EscherContainerRecord)) continue;
            containers.add((EscherContainerRecord)r);
        }
        return containers;
    }

    public String getRecordName() {
        switch (this.getRecordId()) {
            case -4096: {
                return "DggContainer";
            }
            case -4095: {
                return "BStoreContainer";
            }
            case -4094: {
                return "DgContainer";
            }
            case -4093: {
                return "SpgrContainer";
            }
            case -4092: {
                return "SpContainer";
            }
            case -4091: {
                return "SolverContainer";
            }
        }
        return "Container 0x" + HexDump.toHex(this.getRecordId());
    }

    public void display(PrintWriter w, int indent) {
        super.display(w, indent);
        Iterator iterator = this._childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            escherRecord.display(w, indent + 1);
        }
    }

    public void addChildRecord(EscherRecord record) {
        this._childRecords.add(record);
    }

    public void addChildBefore(EscherRecord record, int insertBeforeRecordId) {
        int i = 0;
        while (i < this._childRecords.size()) {
            EscherRecord rec = (EscherRecord)this._childRecords.get(i);
            if (rec.getRecordId() == insertBeforeRecordId) {
                this._childRecords.add(i++, record);
            }
            ++i;
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String nl = System.getProperty("line.separator");
        StringBuffer children = new StringBuffer();
        if (this._childRecords.size() > 0) {
            children.append("  children: " + nl);
            int count = 0;
            Iterator iterator = this._childRecords.iterator();
            while (iterator.hasNext()) {
                String newIndent = String.valueOf(indent) + "   ";
                EscherRecord record = (EscherRecord)iterator.next();
                children.append(String.valueOf(newIndent) + "Child " + count + ":" + nl);
                if (record instanceof EscherContainerRecord) {
                    EscherContainerRecord ecr = (EscherContainerRecord)record;
                    children.append(ecr.toString(newIndent));
                } else {
                    children.append(record.toString());
                }
                ++count;
            }
        }
        return String.valueOf(indent) + this.getClass().getName() + " (" + this.getRecordName() + "):" + nl + indent + "  isContainer: " + this.isContainerRecord() + nl + indent + "  options: 0x" + HexDump.toHex(this.getOptions()) + nl + indent + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + indent + "  numchildren: " + this._childRecords.size() + nl + indent + children.toString();
    }

    public EscherSpRecord getChildById(short recordId) {
        Iterator iterator = this._childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            if (r.getRecordId() != recordId) continue;
            return (EscherSpRecord)r;
        }
        return null;
    }

    public void getRecordsById(short recordId, List out) {
        Iterator iterator = this._childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            if (r instanceof EscherContainerRecord) {
                EscherContainerRecord c = (EscherContainerRecord)r;
                c.getRecordsById(recordId, out);
                continue;
            }
            if (r.getRecordId() != recordId) continue;
            out.add(r);
        }
    }

    private static final class ReadOnlyIterator
    implements Iterator {
        private final List _list;
        private int _index;

        public ReadOnlyIterator(List list) {
            this._list = list;
            this._index = 0;
        }

        public boolean hasNext() {
            return this._index < this._list.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._list.get(this._index++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

