/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.crypto;

import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.record.crypto.RC4;

final class Biff8RC4 {
    private static final int RC4_REKEYING_INTERVAL = 1024;
    private RC4 _rc4;
    private int _streamPos;
    private int _nextRC4BlockStart;
    private int _currentKeyIndex;
    private boolean _shouldSkipEncryptionOnCurrentRecord;
    private final Biff8EncryptionKey _key;

    public Biff8RC4(int initialOffset, Biff8EncryptionKey key) {
        if (initialOffset >= 1024) {
            throw new RuntimeException("initialOffset (" + initialOffset + ")>" + 1024 + " not supported yet");
        }
        this._key = key;
        this._streamPos = 0;
        this.rekeyForNextBlock();
        this._streamPos = initialOffset;
        int i = initialOffset;
        while (i > 0) {
            this._rc4.output();
            --i;
        }
        this._shouldSkipEncryptionOnCurrentRecord = false;
    }

    private void rekeyForNextBlock() {
        this._currentKeyIndex = this._streamPos / 1024;
        this._rc4 = this._key.createRC4(this._currentKeyIndex);
        this._nextRC4BlockStart = (this._currentKeyIndex + 1) * 1024;
    }

    private int getNextRC4Byte() {
        if (this._streamPos >= this._nextRC4BlockStart) {
            this.rekeyForNextBlock();
        }
        byte mask = this._rc4.output();
        ++this._streamPos;
        if (this._shouldSkipEncryptionOnCurrentRecord) {
            return 0;
        }
        return mask & 0xFF;
    }

    public void startRecord(int currentSid) {
        this._shouldSkipEncryptionOnCurrentRecord = Biff8RC4.isNeverEncryptedRecord(currentSid);
    }

    private static boolean isNeverEncryptedRecord(int sid) {
        switch (sid) {
            case 47: 
            case 225: 
            case 2057: {
                return true;
            }
        }
        return false;
    }

    public void skipTwoBytes() {
        this.getNextRC4Byte();
        this.getNextRC4Byte();
    }

    public void xor(byte[] buf, int pOffset, int pLen) {
        int nLeftInBlock = this._nextRC4BlockStart - this._streamPos;
        if (pLen <= nLeftInBlock) {
            this._rc4.encrypt(buf, pOffset, pLen);
            this._streamPos += pLen;
            return;
        }
        int offset = pOffset;
        int len = pLen;
        if (len > nLeftInBlock) {
            if (nLeftInBlock > 0) {
                this._rc4.encrypt(buf, offset, nLeftInBlock);
                this._streamPos += nLeftInBlock;
                offset += nLeftInBlock;
                len -= nLeftInBlock;
            }
            this.rekeyForNextBlock();
        }
        while (len > 1024) {
            this._rc4.encrypt(buf, offset, 1024);
            this._streamPos += 1024;
            offset += 1024;
            len -= 1024;
            this.rekeyForNextBlock();
        }
        this._rc4.encrypt(buf, offset, len);
        this._streamPos += len;
    }

    public int xorByte(int rawVal) {
        int mask = this.getNextRC4Byte();
        return (byte)(rawVal ^ mask);
    }

    public int xorShort(int rawVal) {
        int b0 = this.getNextRC4Byte();
        int b1 = this.getNextRC4Byte();
        int mask = (b1 << 8) + (b0 << 0);
        return rawVal ^ mask;
    }

    public int xorInt(int rawVal) {
        int b0 = this.getNextRC4Byte();
        int b1 = this.getNextRC4Byte();
        int b2 = this.getNextRC4Byte();
        int b3 = this.getNextRC4Byte();
        int mask = (b3 << 24) + (b2 << 16) + (b1 << 8) + (b0 << 0);
        return rawVal ^ mask;
    }

    public long xorLong(long rawVal) {
        int b0 = this.getNextRC4Byte();
        int b1 = this.getNextRC4Byte();
        int b2 = this.getNextRC4Byte();
        int b3 = this.getNextRC4Byte();
        int b4 = this.getNextRC4Byte();
        int b5 = this.getNextRC4Byte();
        int b6 = this.getNextRC4Byte();
        int b7 = this.getNextRC4Byte();
        long mask = ((long)b7 << 56) + ((long)b6 << 48) + ((long)b5 << 40) + ((long)b4 << 32) + ((long)b3 << 24) + (long)(b2 << 16) + (long)(b1 << 8) + (long)(b0 << 0);
        return rawVal ^ mask;
    }
}

