/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.ClientAnchor;

public final class HSSFClientAnchor
extends HSSFAnchor
implements ClientAnchor {
    short col1;
    int row1;
    short col2;
    int row2;
    int anchorType;

    public HSSFClientAnchor() {
    }

    public HSSFClientAnchor(int dx1, int dy1, int dx2, int dy2, short col1, int row1, short col2, int row2) {
        super(dx1, dy1, dx2, dy2);
        this.checkRange(dx1, 0, 1023, "dx1");
        this.checkRange(dx2, 0, 1023, "dx2");
        this.checkRange(dy1, 0, 255, "dy1");
        this.checkRange(dy2, 0, 255, "dy2");
        this.checkRange(col1, 0, 255, "col1");
        this.checkRange(col2, 0, 255, "col2");
        this.checkRange(row1, 0, 65280, "row1");
        this.checkRange(row2, 0, 65280, "row2");
        this.col1 = col1;
        this.row1 = row1;
        this.col2 = col2;
        this.row2 = row2;
    }

    public float getAnchorHeightInPoints(HSSFSheet sheet) {
        int y1 = this.getDy1();
        int y2 = this.getDy2();
        int row1 = Math.min(this.getRow1(), this.getRow2());
        int row2 = Math.max(this.getRow1(), this.getRow2());
        float points = 0.0f;
        if (row1 == row2) {
            points = (float)(y2 - y1) / 256.0f * this.getRowHeightInPoints(sheet, row2);
        } else {
            points += (256.0f - (float)y1) / 256.0f * this.getRowHeightInPoints(sheet, row1);
            int i = row1 + 1;
            while (i < row2) {
                points += this.getRowHeightInPoints(sheet, i);
                ++i;
            }
            points += (float)y2 / 256.0f * this.getRowHeightInPoints(sheet, row2);
        }
        return points;
    }

    private float getRowHeightInPoints(HSSFSheet sheet, int rowNum) {
        HSSFRow row = sheet.getRow(rowNum);
        if (row == null) {
            return sheet.getDefaultRowHeightInPoints();
        }
        return row.getHeightInPoints();
    }

    public short getCol1() {
        return this.col1;
    }

    public void setCol1(short col1) {
        this.checkRange(col1, 0, 255, "col1");
        this.col1 = col1;
    }

    public void setCol1(int col1) {
        this.setCol1((short)col1);
    }

    public short getCol2() {
        return this.col2;
    }

    public void setCol2(short col2) {
        this.checkRange(col2, 0, 255, "col2");
        this.col2 = col2;
    }

    public void setCol2(int col2) {
        this.setCol2((short)col2);
    }

    public int getRow1() {
        return this.row1;
    }

    public void setRow1(int row1) {
        this.checkRange(row1, 0, 65536, "row1");
        this.row1 = row1;
    }

    public int getRow2() {
        return this.row2;
    }

    public void setRow2(int row2) {
        this.checkRange(row2, 0, 65536, "row2");
        this.row2 = row2;
    }

    public void setAnchor(short col1, int row1, int x1, int y1, short col2, int row2, int x2, int y2) {
        this.checkRange(this.dx1, 0, 1023, "dx1");
        this.checkRange(this.dx2, 0, 1023, "dx2");
        this.checkRange(this.dy1, 0, 255, "dy1");
        this.checkRange(this.dy2, 0, 255, "dy2");
        this.checkRange(col1, 0, 255, "col1");
        this.checkRange(col2, 0, 255, "col2");
        this.checkRange(row1, 0, 65280, "row1");
        this.checkRange(row2, 0, 65280, "row2");
        this.col1 = col1;
        this.row1 = row1;
        this.dx1 = x1;
        this.dy1 = y1;
        this.col2 = col2;
        this.row2 = row2;
        this.dx2 = x2;
        this.dy2 = y2;
    }

    public boolean isHorizontallyFlipped() {
        if (this.col1 == this.col2) {
            return this.dx1 > this.dx2;
        }
        return this.col1 > this.col2;
    }

    public boolean isVerticallyFlipped() {
        if (this.row1 == this.row2) {
            return this.dy1 > this.dy2;
        }
        return this.row1 > this.row2;
    }

    public int getAnchorType() {
        return this.anchorType;
    }

    public void setAnchorType(int anchorType) {
        this.anchorType = anchorType;
    }

    private void checkRange(int value, int minRange, int maxRange, String varName) {
        if (value < minRange || value > maxRange) {
            throw new IllegalArgumentException(String.valueOf(varName) + " must be between " + minRange + " and " + maxRange);
        }
    }
}

