/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class HSSFOptimiser {
    public static void optimiseFonts(HSSFWorkbook workbook) {
        short[] newPos = new short[workbook.getWorkbook().getNumberOfFontRecords() + 1];
        boolean[] zapRecords = new boolean[newPos.length];
        int i = 0;
        while (i < newPos.length) {
            newPos[i] = (short)i;
            zapRecords[i] = false;
            ++i;
        }
        FontRecord[] frecs = new FontRecord[newPos.length];
        int i2 = 0;
        while (i2 < newPos.length) {
            if (i2 != 4) {
                frecs[i2] = workbook.getWorkbook().getFontRecordAt(i2);
            }
            ++i2;
        }
        i2 = 5;
        while (i2 < newPos.length) {
            int earlierDuplicate = -1;
            int j = 0;
            while (j < i2 && earlierDuplicate == -1) {
                FontRecord frCheck;
                if (j != 4 && (frCheck = workbook.getWorkbook().getFontRecordAt(j)).sameProperties(frecs[i2])) {
                    earlierDuplicate = j;
                }
                ++j;
            }
            if (earlierDuplicate != -1) {
                newPos[i2] = (short)earlierDuplicate;
                zapRecords[i2] = true;
            }
            ++i2;
        }
        i2 = 5;
        while (i2 < newPos.length) {
            int preDeletePos;
            int newPosition = preDeletePos = newPos[i2];
            int j = 0;
            while (j < preDeletePos) {
                if (zapRecords[j]) {
                    newPosition = (short)(newPosition - 1);
                }
                ++j;
            }
            newPos[i2] = newPosition;
            ++i2;
        }
        i2 = 5;
        while (i2 < newPos.length) {
            if (zapRecords[i2]) {
                workbook.getWorkbook().removeFontRecord(frecs[i2]);
            }
            ++i2;
        }
        workbook.resetFontCache();
        i2 = 0;
        while (i2 < workbook.getWorkbook().getNumExFormats()) {
            ExtendedFormatRecord xfr = workbook.getWorkbook().getExFormatAt(i2);
            xfr.setFontIndex(newPos[xfr.getFontIndex()]);
            ++i2;
        }
        HashSet<UnicodeString> doneUnicodeStrings = new HashSet<UnicodeString>();
        int sheetNum = 0;
        while (sheetNum < workbook.getNumberOfSheets()) {
            HSSFSheet s = workbook.getSheetAt(sheetNum);
            Iterator rIt = s.rowIterator();
            while (rIt.hasNext()) {
                HSSFRow row = (HSSFRow)rIt.next();
                Iterator cIt = row.cellIterator();
                while (cIt.hasNext()) {
                    HSSFRichTextString rtr;
                    UnicodeString u;
                    HSSFCell cell = (HSSFCell)cIt.next();
                    if (cell.getCellType() != 1 || doneUnicodeStrings.contains(u = (rtr = cell.getRichStringCellValue()).getRawUnicodeString())) continue;
                    short i3 = 5;
                    while (i3 < newPos.length) {
                        if (i3 != newPos[i3]) {
                            u.swapFontUse(i3, newPos[i3]);
                        }
                        i3 = (short)(i3 + 1);
                    }
                    doneUnicodeStrings.add(u);
                }
            }
            ++sheetNum;
        }
    }

    public static void optimiseCellStyles(HSSFWorkbook workbook) {
        short[] newPos = new short[workbook.getWorkbook().getNumExFormats()];
        boolean[] zapRecords = new boolean[newPos.length];
        int i = 0;
        while (i < newPos.length) {
            newPos[i] = (short)i;
            zapRecords[i] = false;
            ++i;
        }
        ExtendedFormatRecord[] xfrs = new ExtendedFormatRecord[newPos.length];
        int i2 = 0;
        while (i2 < newPos.length) {
            xfrs[i2] = workbook.getWorkbook().getExFormatAt(i2);
            ++i2;
        }
        i2 = 21;
        while (i2 < newPos.length) {
            int earlierDuplicate = -1;
            int j = 0;
            while (j < i2 && earlierDuplicate == -1) {
                ExtendedFormatRecord xfCheck = workbook.getWorkbook().getExFormatAt(j);
                if (xfCheck.equals(xfrs[i2])) {
                    earlierDuplicate = j;
                }
                ++j;
            }
            if (earlierDuplicate != -1) {
                newPos[i2] = (short)earlierDuplicate;
                zapRecords[i2] = true;
            }
            ++i2;
        }
        i2 = 21;
        while (i2 < newPos.length) {
            int preDeletePos;
            int newPosition = preDeletePos = newPos[i2];
            int j = 0;
            while (j < preDeletePos) {
                if (zapRecords[j]) {
                    newPosition = (short)(newPosition - 1);
                }
                ++j;
            }
            newPos[i2] = newPosition;
            ++i2;
        }
        i2 = 21;
        while (i2 < newPos.length) {
            if (zapRecords[i2]) {
                workbook.getWorkbook().removeExFormatRecord(xfrs[i2]);
            }
            ++i2;
        }
        int sheetNum = 0;
        while (sheetNum < workbook.getNumberOfSheets()) {
            HSSFSheet s = workbook.getSheetAt(sheetNum);
            Iterator rIt = s.rowIterator();
            while (rIt.hasNext()) {
                HSSFRow row = (HSSFRow)rIt.next();
                Iterator cIt = row.cellIterator();
                while (cIt.hasNext()) {
                    HSSFCell cell = (HSSFCell)cIt.next();
                    short oldXf = cell.getCellValueRecord().getXFIndex();
                    HSSFCellStyle newStyle = workbook.getCellStyleAt(newPos[oldXf]);
                    cell.setCellStyle(newStyle);
                }
            }
            ++sheetNum;
        }
    }
}

