/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import org.apache.poi.ss.formula.CellCacheEntry;
import org.apache.poi.ss.formula.FormulaCellCacheEntry;

final class FormulaCellCacheEntrySet {
    private static final FormulaCellCacheEntry[] EMPTY_ARRAY = new FormulaCellCacheEntry[0];
    private int _size;
    private FormulaCellCacheEntry[] _arr = EMPTY_ARRAY;

    public FormulaCellCacheEntry[] toArray() {
        int nItems = this._size;
        if (nItems < 1) {
            return EMPTY_ARRAY;
        }
        FormulaCellCacheEntry[] result = new FormulaCellCacheEntry[nItems];
        int j = 0;
        int i = 0;
        while (i < this._arr.length) {
            FormulaCellCacheEntry cce = this._arr[i];
            if (cce != null) {
                result[j++] = cce;
            }
            ++i;
        }
        if (j != nItems) {
            throw new IllegalStateException("size mismatch");
        }
        return result;
    }

    public void add(CellCacheEntry cce) {
        if (this._size * 3 >= this._arr.length * 2) {
            FormulaCellCacheEntry[] prevArr = this._arr;
            CellCacheEntry[] newArr = new FormulaCellCacheEntry[4 + this._arr.length * 3 / 2];
            int i = 0;
            while (i < prevArr.length) {
                FormulaCellCacheEntry prevCce = this._arr[i];
                if (prevCce != null) {
                    FormulaCellCacheEntrySet.addInternal(newArr, prevCce);
                }
                ++i;
            }
            this._arr = newArr;
        }
        if (FormulaCellCacheEntrySet.addInternal(this._arr, cce)) {
            ++this._size;
        }
    }

    private static boolean addInternal(CellCacheEntry[] arr, CellCacheEntry cce) {
        CellCacheEntry item;
        int startIx;
        int i = startIx = cce.hashCode() % arr.length;
        while (i < arr.length) {
            item = arr[i];
            if (item == cce) {
                return false;
            }
            if (item == null) {
                arr[i] = cce;
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < startIx) {
            item = arr[i];
            if (item == cce) {
                return false;
            }
            if (item == null) {
                arr[i] = cce;
                return true;
            }
            ++i;
        }
        throw new IllegalStateException("No empty space found");
    }

    public boolean remove(CellCacheEntry cce) {
        FormulaCellCacheEntry item;
        int startIx;
        FormulaCellCacheEntry[] arr = this._arr;
        if (this._size * 3 < this._arr.length && this._arr.length > 8) {
            boolean found = false;
            FormulaCellCacheEntry[] prevArr = this._arr;
            CellCacheEntry[] newArr = new FormulaCellCacheEntry[this._arr.length / 2];
            int i = 0;
            while (i < prevArr.length) {
                FormulaCellCacheEntry prevCce = this._arr[i];
                if (prevCce != null) {
                    if (prevCce == cce) {
                        found = true;
                        --this._size;
                    } else {
                        FormulaCellCacheEntrySet.addInternal(newArr, prevCce);
                    }
                }
                ++i;
            }
            this._arr = newArr;
            return found;
        }
        int i = startIx = cce.hashCode() % arr.length;
        while (i < arr.length) {
            item = arr[i];
            if (item == cce) {
                arr[i] = null;
                --this._size;
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < startIx) {
            item = arr[i];
            if (item == cce) {
                arr[i] = null;
                --this._size;
                return true;
            }
            ++i;
        }
        return false;
    }
}

