/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.dev;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;

public class OOXMLLister {
    private OPCPackage container;
    private PrintStream disp;

    public OOXMLLister(OPCPackage container) {
        this(container, System.out);
    }

    public OOXMLLister(OPCPackage container, PrintStream disp) {
        this.container = container;
        this.disp = disp;
    }

    public static long getSize(PackagePart part) throws IOException {
        InputStream in = part.getInputStream();
        byte[] b = new byte[8192];
        long size = 0L;
        int read = 0;
        while (read > -1) {
            read = in.read(b);
            if (read <= 0) continue;
            size += (long)read;
        }
        return size;
    }

    public void displayParts() throws Exception {
        ArrayList parts = this.container.getParts();
        Iterator iterator = parts.iterator();
        while (iterator.hasNext()) {
            PackagePart part = (PackagePart)iterator.next();
            this.disp.println(part.getPartName());
            this.disp.println("\t" + part.getContentType());
            if (!part.getPartName().toString().equals("/docProps/core.xml")) {
                this.disp.println("\t" + OOXMLLister.getSize(part) + " bytes");
            }
            if (part.isRelationshipPart()) continue;
            this.disp.println("\t" + part.getRelationships().size() + " relations");
            Iterator iterator2 = part.getRelationships().iterator();
            while (iterator2.hasNext()) {
                PackageRelationship rel = (PackageRelationship)iterator2.next();
                this.displayRelation(rel, "\t  ");
            }
        }
    }

    public void displayRelations() throws Exception {
        PackageRelationshipCollection rels = this.container.getRelationships();
        Iterator iterator = rels.iterator();
        while (iterator.hasNext()) {
            PackageRelationship rel = (PackageRelationship)iterator.next();
            this.displayRelation(rel, "");
        }
    }

    private void displayRelation(PackageRelationship rel, String indent) {
        this.disp.println(String.valueOf(indent) + "Relationship:");
        this.disp.println(String.valueOf(indent) + "\tFrom: " + rel.getSourceURI());
        this.disp.println(String.valueOf(indent) + "\tTo:   " + rel.getTargetURI());
        this.disp.println(String.valueOf(indent) + "\tID:   " + rel.getId());
        this.disp.println(String.valueOf(indent) + "\tMode: " + rel.getTargetMode());
        this.disp.println(String.valueOf(indent) + "\tType: " + rel.getRelationshipType());
    }

    public static void main(String[] args) throws Exception {
        File f;
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("\tjava HXFLister <filename>");
            System.exit(1);
        }
        if (!(f = new File(args[0])).exists()) {
            System.err.println("Error, file not found!");
            System.err.println("\t" + f.toString());
            System.exit(2);
        }
        OOXMLLister lister = new OOXMLLister((OPCPackage)OPCPackage.open(f.toString(), PackageAccess.READ));
        lister.disp.println(String.valueOf(f.toString()) + "\n");
        lister.displayParts();
        lister.disp.println();
        lister.displayRelations();
    }
}

