/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.StreamHelper;
import org.apache.poi.openxml4j.opc.internal.ContentTypeManager;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.dom4j.Document;

public class ZipContentTypeManager
extends ContentTypeManager {
    private static POILogger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.openxml4j.opc.internal.ZipContentTypeManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
    }

    public ZipContentTypeManager(InputStream in, OPCPackage pkg) throws InvalidFormatException {
        super(in, pkg);
    }

    public boolean saveImpl(Document content, OutputStream out) {
        ZipOutputStream zos = null;
        zos = out instanceof ZipOutputStream ? (ZipOutputStream)out : new ZipOutputStream(out);
        ZipEntry partEntry = new ZipEntry("[Content_Types].xml");
        try {
            zos.putNextEntry(partEntry);
            ByteArrayOutputStream outTemp = new ByteArrayOutputStream();
            StreamHelper.saveXmlInStream(content, out);
            ByteArrayInputStream ins = new ByteArrayInputStream(outTemp.toByteArray());
            byte[] buff = new byte[8192];
            while (((InputStream)ins).available() > 0) {
                int resultRead = ins.read(buff);
                if (resultRead == -1) break;
                zos.write(buff, 0, resultRead);
            }
            zos.closeEntry();
        }
        catch (IOException ioe) {
            logger.log(POILogger.ERROR, (Object)"Cannot write: [Content_Types].xml in Zip !", (Throwable)ioe);
            return false;
        }
        return true;
    }
}

