/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.xslf.usermodel.DrawingParagraph;
import org.apache.poi.xslf.usermodel.DrawingTable;
import org.apache.poi.xslf.usermodel.DrawingTableCell;
import org.apache.poi.xslf.usermodel.DrawingTableRow;
import org.apache.poi.xslf.usermodel.DrawingTextBody;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTable;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

public class XSLFCommonSlideData {
    private final CTCommonSlideData data;

    public XSLFCommonSlideData(CTCommonSlideData data) {
        this.data = data;
    }

    public List getText() {
        CTGroupShape gs = this.data.getSpTree();
        ArrayList<DrawingParagraph> out = new ArrayList<DrawingParagraph>();
        this.processShape(gs, out);
        Iterator<CTGroupShape> iterator = Arrays.asList(gs.getGrpSpArray()).iterator();
        while (iterator.hasNext()) {
            CTGroupShape shape = iterator.next();
            this.processShape(shape, out);
        }
        iterator = Arrays.asList(gs.getGraphicFrameArray()).iterator();
        while (iterator.hasNext()) {
            CTGraphicalObjectFrame frame = (CTGraphicalObjectFrame)iterator.next();
            CTGraphicalObjectData data = frame.getGraphic().getGraphicData();
            XmlCursor c = data.newCursor();
            c.selectPath("./*");
            while (c.toNextSelection()) {
                XmlObject o = c.getObject();
                if (!(o instanceof CTTable)) continue;
                DrawingTable table = new DrawingTable((CTTable)o);
                int i = 0;
                while (i < table.getRows().length) {
                    DrawingTableRow row = table.getRows()[i];
                    int j = 0;
                    while (j < row.getCells().length) {
                        DrawingTableCell cell = row.getCells()[j];
                        DrawingTextBody textBody = cell.getTextBody();
                        out.addAll(Arrays.asList(textBody.getParagraphs()));
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return out;
    }

    private void processShape(CTGroupShape gs, List out) {
        List<CTShape> shapes = Arrays.asList(gs.getSpArray());
        int i = 0;
        while (i < shapes.size()) {
            CTTextBody ctTextBody = shapes.get(i).getTxBody();
            if (ctTextBody != null) {
                DrawingTextBody textBody = new DrawingTextBody(ctTextBody);
                out.addAll(Arrays.asList(textBody.getParagraphs()));
            }
            ++i;
        }
    }
}

