/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.dev;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public final class XSSFDump {
    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            System.out.println("Dumping " + args[i]);
            ZipFile zip = new ZipFile(args[i]);
            XSSFDump.dump(zip);
            ++i;
        }
    }

    public static void dump(ZipFile zip) throws Exception {
        String zipname = zip.getName();
        int sep = zipname.lastIndexOf(46);
        File root = new File(zipname.substring(0, sep));
        root.mkdir();
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            String name = entry.getName();
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                File bs = new File(root, name.substring(0, idx));
                bs.mkdirs();
            }
            File f = new File(root, entry.getName());
            FileOutputStream out = new FileOutputStream(f);
            if (entry.getName().endsWith(".xml") || entry.getName().endsWith(".vml") || entry.getName().endsWith(".rels")) {
                try {
                    XmlObject xml = XmlObject.Factory.parse((InputStream)zip.getInputStream(entry));
                    XmlOptions options = new XmlOptions();
                    options.setSavePrettyPrint();
                    xml.save((OutputStream)out, options);
                }
                catch (Exception e) {
                    System.err.println("Failed to parse " + entry.getName() + ", dumping raw content");
                    XSSFDump.dump(zip.getInputStream(entry), out);
                }
            } else {
                XSSFDump.dump(zip.getInputStream(entry), out);
            }
            out.close();
        }
    }

    protected static void dump(InputStream is, OutputStream out) throws IOException {
        int pos;
        byte[] chunk = new byte[2048];
        while ((pos = is.read(chunk)) > 0) {
            out.write(chunk, 0, pos);
        }
    }
}

