/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.extractor;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XSSFEventBasedExcelExtractor
extends POIXMLTextExtractor {
    private OPCPackage container;
    private boolean includeSheetNames = true;
    private boolean formulasNotResults = false;

    public XSSFEventBasedExcelExtractor(String path) throws XmlException, OpenXML4JException, IOException {
        this((OPCPackage)OPCPackage.open(path));
    }

    public XSSFEventBasedExcelExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        super(null);
        this.container = container;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  XSSFEventBasedExcelExtractor <filename.xlsx>");
            System.exit(1);
        }
        XSSFEventBasedExcelExtractor extractor = new XSSFEventBasedExcelExtractor(args[0]);
        System.out.println(extractor.getText());
    }

    public void setIncludeSheetNames(boolean includeSheetNames) {
        this.includeSheetNames = includeSheetNames;
    }

    public void setFormulasNotResults(boolean formulasNotResults) {
        this.formulasNotResults = formulasNotResults;
    }

    public void processSheet(StringBuffer output, StylesTable styles, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, SAXException {
        InputSource sheetSource = new InputSource(sheetInputStream);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader sheetParser = saxParser.getXMLReader();
            MyXSSFSheetHandler handler = new MyXSSFSheetHandler(styles, strings, output);
            sheetParser.setContentHandler(handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public String getText() {
        try {
            ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(this.container);
            XSSFReader xssfReader = new XSSFReader(this.container);
            StylesTable styles = xssfReader.getStylesTable();
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            StringBuffer text = new StringBuffer();
            while (iter.hasNext()) {
                InputStream stream = (InputStream)iter.next();
                if (this.includeSheetNames) {
                    text.append(iter.getSheetName());
                    text.append('\n');
                }
                this.processSheet(text, styles, strings, stream);
                stream.close();
            }
            return text.toString();
        }
        catch (IOException e) {
            System.err.println(e);
            return null;
        }
        catch (SAXException se) {
            System.err.println(se);
            return null;
        }
        catch (OpenXML4JException o4je) {
            System.err.println(o4je);
            return null;
        }
    }

    class MyXSSFSheetHandler
    extends DefaultHandler {
        private StylesTable stylesTable;
        private ReadOnlySharedStringsTable sharedStringsTable;
        private final StringBuffer output;
        private boolean vIsOpen;
        private boolean fIsOpen;
        private xssfDataType nextDataType;
        private short formatIndex;
        private String formatString;
        private final DataFormatter formatter;
        private StringBuffer value = new StringBuffer();
        private StringBuffer formula = new StringBuffer();
        private boolean firstCellOfRow = true;

        public MyXSSFSheetHandler(StylesTable styles, ReadOnlySharedStringsTable strings, StringBuffer output) {
            this.stylesTable = styles;
            this.sharedStringsTable = strings;
            this.output = output;
            this.nextDataType = xssfDataType.NUMBER;
            this.formatter = new DataFormatter();
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("inlineStr".equals(name) || "v".equals(name)) {
                this.vIsOpen = true;
                this.value.setLength(0);
            } else if ("f".equals(name)) {
                String type;
                this.formula.setLength(0);
                if (this.nextDataType == xssfDataType.NUMBER) {
                    this.nextDataType = xssfDataType.FORMULA;
                }
                if ((type = attributes.getValue("t")) != null && type.equals("shared")) {
                    System.err.println("Warning - shared formulas not yet supported!");
                } else {
                    this.fIsOpen = true;
                }
            } else if ("row".equals(name)) {
                this.firstCellOfRow = true;
            } else if ("c".equals(name)) {
                this.nextDataType = xssfDataType.NUMBER;
                this.formatIndex = (short)-1;
                this.formatString = null;
                String cellType = attributes.getValue("t");
                String cellStyleStr = attributes.getValue("s");
                if ("b".equals(cellType)) {
                    this.nextDataType = xssfDataType.BOOLEAN;
                } else if ("e".equals(cellType)) {
                    this.nextDataType = xssfDataType.ERROR;
                } else if ("inlineStr".equals(cellType)) {
                    this.nextDataType = xssfDataType.INLINE_STRING;
                } else if ("s".equals(cellType)) {
                    this.nextDataType = xssfDataType.SST_STRING;
                } else if ("str".equals(cellType)) {
                    this.nextDataType = xssfDataType.FORMULA;
                } else if (cellStyleStr != null) {
                    int styleIndex = Integer.parseInt(cellStyleStr);
                    XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
                    this.formatIndex = style.getDataFormat();
                    this.formatString = style.getDataFormatString();
                    if (this.formatString == null) {
                        this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                    }
                }
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            String thisStr = null;
            if ("v".equals(name)) {
                this.vIsOpen = false;
                if (this.nextDataType.equals(xssfDataType.BOOLEAN)) {
                    char first = this.value.charAt(0);
                    thisStr = first == '0' ? "FALSE" : "TRUE";
                } else if (this.nextDataType.equals(xssfDataType.ERROR)) {
                    thisStr = "ERROR:" + this.value.toString();
                } else if (this.nextDataType.equals(xssfDataType.FORMULA)) {
                    thisStr = XSSFEventBasedExcelExtractor.this.formulasNotResults ? this.formula.toString() : this.value.toString();
                } else if (this.nextDataType.equals(xssfDataType.INLINE_STRING)) {
                    XSSFRichTextString rtsi = new XSSFRichTextString(this.value.toString());
                    thisStr = rtsi.toString();
                } else if (this.nextDataType.equals(xssfDataType.SST_STRING)) {
                    String sstIndex = this.value.toString();
                    try {
                        int idx = Integer.parseInt(sstIndex);
                        XSSFRichTextString rtss = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                        thisStr = rtss.toString();
                    }
                    catch (NumberFormatException ex) {
                        System.err.println("Failed to parse SST index '" + sstIndex + "': " + ex.toString());
                    }
                } else if (this.nextDataType.equals(xssfDataType.NUMBER)) {
                    String n = this.value.toString();
                    thisStr = this.formatString != null ? this.formatter.formatRawCellContents(Double.parseDouble(n), (int)this.formatIndex, this.formatString) : n;
                } else {
                    thisStr = "(TODO: Unexpected type: " + this.nextDataType + ")";
                }
                if (!this.firstCellOfRow) {
                    this.output.append('\t');
                }
                this.firstCellOfRow = false;
                this.output.append(thisStr);
            } else if ("f".equals(name)) {
                this.fIsOpen = false;
            } else if ("row".equals(name)) {
                this.output.append('\n');
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.vIsOpen) {
                this.value.append(ch, start, length);
            }
            if (this.fIsOpen) {
                this.formula.append(ch, start, length);
            }
        }
    }

    static class xssfDataType {
        public static final xssfDataType BOOLEAN = new xssfDataType();
        public static final xssfDataType ERROR = new xssfDataType();
        public static final xssfDataType FORMULA = new xssfDataType();
        public static final xssfDataType INLINE_STRING = new xssfDataType();
        public static final xssfDataType SST_STRING = new xssfDataType();
        public static final xssfDataType NUMBER = new xssfDataType();

        xssfDataType() {
        }
    }
}

