/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class XWPFTable
implements IBodyElement {
    protected StringBuffer text = new StringBuffer();
    private CTTbl ctTbl;
    protected List tableRows;
    protected List styleIDs;
    protected IBody part;

    public XWPFTable(CTTbl table, IBody part, int row, int col) {
        this(table, part);
        int i = 0;
        while (i < row) {
            XWPFTableRow tabRow = this.getRow(i) == null ? this.createRow() : this.getRow(i);
            this.tableRows.add(tabRow);
            int k = 0;
            while (k < col) {
                XWPFTableCell xWPFTableCell = tabRow.getCell(k) == null ? tabRow.createCell() : null;
                ++k;
            }
            ++i;
        }
    }

    public XWPFTable(CTTbl table, IBody part) {
        this.part = part;
        this.ctTbl = table;
        this.tableRows = new ArrayList();
        if (table.sizeOfTrArray() == 0) {
            this.createEmptyTable(table);
        }
        Iterator<CTRow> iterator = Arrays.asList(table.getTrArray()).iterator();
        while (iterator.hasNext()) {
            CTRow row = iterator.next();
            StringBuffer rowText = new StringBuffer();
            XWPFTableRow tabRow = new XWPFTableRow(row, this);
            this.tableRows.add(tabRow);
            Iterator<CTTc> iterator2 = Arrays.asList(row.getTcArray()).iterator();
            while (iterator2.hasNext()) {
                CTTc cell = iterator2.next();
                Iterator<CTP> iterator3 = Arrays.asList(cell.getPArray()).iterator();
                while (iterator3.hasNext()) {
                    CTP ctp = iterator3.next();
                    XWPFParagraph p = new XWPFParagraph(ctp, part);
                    if (rowText.length() > 0) {
                        rowText.append('\t');
                    }
                    rowText.append(p.getText());
                }
            }
            if (rowText.length() <= 0) continue;
            this.text.append(rowText);
            this.text.append('\n');
        }
    }

    private void createEmptyTable(CTTbl table) {
        table.addNewTr().addNewTc().addNewP();
        CTTblPr tblpro = table.addNewTblPr();
        tblpro.addNewTblW().setW(new BigInteger("0"));
        tblpro.getTblW().setType(STTblWidth.AUTO);
        CTTblBorders borders = tblpro.addNewTblBorders();
        borders.addNewBottom().setVal(STBorder.SINGLE);
        borders.addNewInsideH().setVal(STBorder.SINGLE);
        borders.addNewInsideV().setVal(STBorder.SINGLE);
        borders.addNewLeft().setVal(STBorder.SINGLE);
        borders.addNewRight().setVal(STBorder.SINGLE);
        borders.addNewTop().setVal(STBorder.SINGLE);
        this.getRows();
    }

    public CTTbl getCTTbl() {
        return this.ctTbl;
    }

    public String getText() {
        return this.text.toString();
    }

    public void addNewRowBetween(int start, int end) {
    }

    public void addNewCol() {
        if (this.ctTbl.sizeOfTrArray() == 0) {
            this.createRow();
        }
        int i = 0;
        while (i < this.ctTbl.sizeOfTrArray()) {
            XWPFTableRow tabRow = new XWPFTableRow(this.ctTbl.getTrArray(i), this);
            tabRow.createCell();
            ++i;
        }
    }

    public XWPFTableRow createRow() {
        int sizeCol = this.ctTbl.sizeOfTrArray() > 0 ? this.ctTbl.getTrArray(0).sizeOfTcArray() : 0;
        XWPFTableRow tabRow = new XWPFTableRow(this.ctTbl.addNewTr(), this);
        this.addColumn(tabRow, sizeCol);
        return tabRow;
    }

    public XWPFTableRow getRow(int pos) {
        if (pos >= 0 && pos < this.ctTbl.sizeOfTrArray()) {
            return (XWPFTableRow)this.getRows().get(pos);
        }
        return null;
    }

    public void setWidth(int width) {
        CTTblPr tblPr = this.getTrPr();
        CTTblWidth tblWidth = tblPr.isSetTblW() ? tblPr.getTblW() : tblPr.addNewTblW();
        tblWidth.setW(new BigInteger("" + width));
    }

    public int getWidth() {
        CTTblPr tblPr = this.getTrPr();
        return tblPr.isSetTblW() ? tblPr.getTblW().getW().intValue() : -1;
    }

    public int getNumberOfRows() {
        return this.ctTbl.sizeOfTrArray();
    }

    private CTTblPr getTrPr() {
        return this.ctTbl.getTblPr() != null ? this.ctTbl.getTblPr() : this.ctTbl.addNewTblPr();
    }

    private void addColumn(XWPFTableRow tabRow, int sizeCol) {
        if (sizeCol > 0) {
            int i = 0;
            while (i < sizeCol) {
                tabRow.createCell();
                ++i;
            }
        }
    }

    public String getStyleID() {
        return this.ctTbl.getTblPr().getTblStyle().getVal();
    }

    public void addRow(XWPFTableRow row) {
        this.ctTbl.addNewTr();
        this.ctTbl.setTrArray(this.getNumberOfRows() - 1, row.getCtRow());
        this.tableRows.add(row);
    }

    public boolean addRow(XWPFTableRow row, int pos) {
        if (pos >= 0 && pos <= this.tableRows.size()) {
            this.ctTbl.insertNewTr(pos);
            this.ctTbl.setTrArray(pos, row.getCtRow());
            this.tableRows.add(pos, row);
            return true;
        }
        return false;
    }

    public XWPFTableRow insertNewTableRow(int pos) {
        if (pos >= 0 && pos <= this.tableRows.size()) {
            CTRow row = this.ctTbl.insertNewTr(pos);
            XWPFTableRow tableRow = new XWPFTableRow(row, this);
            this.tableRows.add(pos, tableRow);
            return tableRow;
        }
        return null;
    }

    public boolean removeRow(int pos) throws IndexOutOfBoundsException {
        if (pos > 0 && pos < this.tableRows.size()) {
            this.ctTbl.removeTr(pos);
            this.tableRows.remove(pos);
            return true;
        }
        return false;
    }

    public List getRows() {
        return this.tableRows;
    }

    public BodyElementType getElementType() {
        return BodyElementType.TABLE;
    }

    public IBody getPart() {
        if (this.part != null) {
            return this.part.getPart();
        }
        return null;
    }

    public BodyType getPartType() {
        return this.part.getPartType();
    }

    public XWPFTableRow getRow(CTRow row) {
        int i = 0;
        while (i < this.getRows().size()) {
            if (((XWPFTableRow)this.getRows().get(i)).getCtRow() == row) {
                return this.getRow(i);
            }
            ++i;
        }
        return null;
    }
}

