/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogger;

public final class TextRulerAtom
extends RecordAtom {
    private byte[] _header;
    private byte[] _data;
    private int defaultTabSize;
    private int numLevels;
    private int[] tabStops;
    private int[] bulletOffsets = new int[5];
    private int[] textOffsets = new int[5];

    public TextRulerAtom() {
        this._header = new byte[8];
        this._data = new byte[0];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    protected TextRulerAtom(byte[] source, int start, int len) {
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
        try {
            this.read();
        }
        catch (Exception e) {
            this.logger.log(POILogger.ERROR, (Object)("Failed to parse TextRulerAtom: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public long getRecordType() {
        return RecordTypes.TextRulerAtom.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    private void read() {
        int pos = 0;
        short mask = LittleEndian.getShort((byte[])this._data);
        pos += 4;
        int[] nArray = new int[13];
        nArray[0] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 8;
        nArray[5] = 4;
        nArray[6] = 9;
        nArray[7] = 5;
        nArray[8] = 10;
        nArray[9] = 6;
        nArray[10] = 11;
        nArray[11] = 7;
        nArray[12] = 12;
        int[] bits = nArray;
        int i = 0;
        while (i < bits.length) {
            if ((mask & 1 << bits[i]) != 0) {
                switch (bits[i]) {
                    case 0: {
                        this.defaultTabSize = LittleEndian.getShort((byte[])this._data, (int)pos);
                        pos += 2;
                        break;
                    }
                    case 1: {
                        this.numLevels = LittleEndian.getShort((byte[])this._data, (int)pos);
                        pos += 2;
                        break;
                    }
                    case 2: {
                        short val = LittleEndian.getShort((byte[])this._data, (int)pos);
                        pos += 2;
                        this.tabStops = new int[val * 2];
                        int j = 0;
                        while (j < this.tabStops.length) {
                            this.tabStops[j] = LittleEndian.getUShort((byte[])this._data, (int)pos);
                            pos += 2;
                            ++j;
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        short val = LittleEndian.getShort((byte[])this._data, (int)pos);
                        pos += 2;
                        this.bulletOffsets[bits[i] - 3] = val;
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        short val = LittleEndian.getShort((byte[])this._data, (int)pos);
                        pos += 2;
                        this.textOffsets[bits[i] - 8] = val;
                    }
                }
            }
            ++i;
        }
    }

    public int getDefaultTabSize() {
        return this.defaultTabSize;
    }

    public int getNumberOfLevels() {
        return this.numLevels;
    }

    public int[] getTabStops() {
        return this.tabStops;
    }

    public int[] getTextOffsets() {
        return this.textOffsets;
    }

    public int[] getBulletOffsets() {
        return this.bulletOffsets;
    }

    public static TextRulerAtom getParagraphInstance() {
        byte[] byArray = new byte[18];
        byArray[2] = -90;
        byArray[3] = 15;
        byArray[4] = 10;
        byArray[8] = 16;
        byArray[9] = 3;
        byArray[12] = -7;
        byArray[14] = 65;
        byArray[15] = 1;
        byArray[16] = 65;
        byArray[17] = 1;
        byte[] data = byArray;
        TextRulerAtom ruler = new TextRulerAtom(data, 0, data.length);
        return ruler;
    }

    public void setParagraphIndent(short tetxOffset, short bulletOffset) {
        LittleEndian.putShort((byte[])this._data, (int)4, (short)tetxOffset);
        LittleEndian.putShort((byte[])this._data, (int)6, (short)bulletOffset);
        LittleEndian.putShort((byte[])this._data, (int)8, (short)bulletOffset);
    }
}

