/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.ListTables;
import org.apache.poi.hwpf.model.PAPX;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.SEPX;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.model.SubdocumentType;
import org.apache.poi.hwpf.sprm.CharacterSprmCompressor;
import org.apache.poi.hwpf.sprm.ParagraphSprmCompressor;
import org.apache.poi.hwpf.sprm.SprmBuffer;
import org.apache.poi.hwpf.usermodel.BookmarksImpl;
import org.apache.poi.hwpf.usermodel.CharacterProperties;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.ListEntry;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.hwpf.usermodel.Section;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableProperties;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class Range {
    private POILogger logger;
    public static final int TYPE_PARAGRAPH = 0;
    public static final int TYPE_CHARACTER = 1;
    public static final int TYPE_SECTION = 2;
    public static final int TYPE_TEXT = 3;
    public static final int TYPE_LISTENTRY = 4;
    public static final int TYPE_TABLE = 5;
    public static final int TYPE_UNDEFINED = 6;
    private WeakReference _parent;
    protected int _start;
    protected int _end;
    protected HWPFDocumentCore _doc;
    boolean _sectionRangeFound;
    protected List _sections;
    protected int _sectionStart;
    protected int _sectionEnd;
    protected boolean _parRangeFound;
    protected List _paragraphs;
    protected int _parStart;
    protected int _parEnd;
    protected boolean _charRangeFound;
    protected List _characters;
    protected int _charStart;
    protected int _charEnd;
    protected StringBuffer _text;
    static /* synthetic */ Class class$0;

    public Range(int start, int end, HWPFDocumentCore doc) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.usermodel.Range");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = POILogFactory.getLogger((Class)clazz);
        this._start = start;
        this._end = end;
        this._doc = doc;
        this._sections = this._doc.getSectionTable().getSections();
        this._paragraphs = this._doc.getParagraphTable().getParagraphs();
        this._characters = this._doc.getCharacterTable().getTextRuns();
        this._text = this._doc.getText();
        this._parent = new WeakReference<Object>(null);
        this.sanityCheckStartEnd();
    }

    protected Range(int start, int end, Range parent) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.usermodel.Range");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = POILogFactory.getLogger((Class)clazz);
        this._start = start;
        this._end = end;
        this._doc = parent._doc;
        this._sections = parent._sections;
        this._paragraphs = parent._paragraphs;
        this._characters = parent._characters;
        this._text = parent._text;
        this._parent = new WeakReference<Range>(parent);
        this.sanityCheckStartEnd();
    }

    protected Range(int startIdx, int endIdx, int idxType, Range parent) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.usermodel.Range");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = POILogFactory.getLogger((Class)clazz);
        this._doc = parent._doc;
        this._sections = parent._sections;
        this._paragraphs = parent._paragraphs;
        this._characters = parent._characters;
        this._text = parent._text;
        this._parent = new WeakReference<Range>(parent);
        this.sanityCheckStartEnd();
    }

    private void sanityCheckStartEnd() {
        if (this._start < 0) {
            throw new IllegalArgumentException("Range start must not be negative. Given " + this._start);
        }
        if (this._end < this._start) {
            throw new IllegalArgumentException("The end (" + this._end + ") must not be before the start (" + this._start + ")");
        }
    }

    public boolean usesUnicode() {
        return true;
    }

    public String text() {
        return this._text.substring(this._start, this._end);
    }

    /*
     * Unable to fully structure code
     */
    public static String stripFields(String text) {
        if (text.indexOf(19) != -1) ** GOTO lbl12
        return text;
lbl-1000:
        // 1 sources

        {
            first13 = text.indexOf(19);
            next13 = text.indexOf(19, first13 + 1);
            first14 = text.indexOf(20, first13 + 1);
            last15 = text.lastIndexOf(21);
            if (last15 < first13) break;
            if (next13 == -1 && first14 == -1) {
                text = String.valueOf(text.substring(0, first13)) + text.substring(last15 + 1);
                break;
            }
            text = first14 != -1 && (first14 < next13 || next13 == -1) ? String.valueOf(text.substring(0, first13)) + text.substring(first14 + 1, last15) + text.substring(last15 + 1) : String.valueOf(text.substring(0, first13)) + text.substring(last15 + 1);
lbl12:
            // 2 sources

            ** while (text.indexOf((int)19) > -1 && text.indexOf((int)21) > -1)
        }
lbl13:
        // 3 sources

        return text;
    }

    public int numSections() {
        this.initSections();
        return this._sectionEnd - this._sectionStart;
    }

    public int numParagraphs() {
        this.initParagraphs();
        return this._parEnd - this._parStart;
    }

    public int numCharacterRuns() {
        this.initCharacterRuns();
        return this._charEnd - this._charStart;
    }

    public CharacterRun insertBefore(String text) {
        this.initAll();
        this._text.insert(this._start, text);
        this._doc.getCharacterTable().adjustForInsert(this._charStart, text.length());
        this._doc.getParagraphTable().adjustForInsert(this._parStart, text.length());
        this._doc.getSectionTable().adjustForInsert(this._sectionStart, text.length());
        if (this._doc instanceof HWPFDocument) {
            ((BookmarksImpl)((HWPFDocument)this._doc).getBookmarks()).afterInsert(this._start, text.length());
        }
        this.adjustForInsert(text.length());
        this.adjustFIB(text.length());
        return this.getCharacterRun(0);
    }

    public CharacterRun insertAfter(String text) {
        this.initAll();
        this._text.insert(this._end, text);
        this._doc.getCharacterTable().adjustForInsert(this._charEnd - 1, text.length());
        this._doc.getParagraphTable().adjustForInsert(this._parEnd - 1, text.length());
        this._doc.getSectionTable().adjustForInsert(this._sectionEnd - 1, text.length());
        if (this._doc instanceof HWPFDocument) {
            ((BookmarksImpl)((HWPFDocument)this._doc).getBookmarks()).afterInsert(this._end, text.length());
        }
        this.adjustForInsert(text.length());
        return this.getCharacterRun(this.numCharacterRuns() - 1);
    }

    public CharacterRun insertBefore(String text, CharacterProperties props) {
        this.initAll();
        PAPX papx = (PAPX)this._paragraphs.get(this._parStart);
        short istd = papx.getIstd();
        StyleSheet ss = this._doc.getStyleSheet();
        CharacterProperties baseStyle = ss.getCharacterStyle(istd);
        byte[] grpprl = CharacterSprmCompressor.compressCharacterProperty(props, baseStyle);
        SprmBuffer buf = new SprmBuffer(grpprl, 0);
        this._doc.getCharacterTable().insert(this._charStart, this._start, buf);
        return this.insertBefore(text);
    }

    public CharacterRun insertAfter(String text, CharacterProperties props) {
        this.initAll();
        PAPX papx = (PAPX)this._paragraphs.get(this._parEnd - 1);
        short istd = papx.getIstd();
        StyleSheet ss = this._doc.getStyleSheet();
        CharacterProperties baseStyle = ss.getCharacterStyle(istd);
        byte[] grpprl = CharacterSprmCompressor.compressCharacterProperty(props, baseStyle);
        SprmBuffer buf = new SprmBuffer(grpprl, 0);
        this._doc.getCharacterTable().insert(this._charEnd, this._end, buf);
        ++this._charEnd;
        return this.insertAfter(text);
    }

    public Paragraph insertBefore(ParagraphProperties props, int styleIndex) {
        return this.insertBefore(props, styleIndex, "\r");
    }

    protected Paragraph insertBefore(ParagraphProperties props, int styleIndex, String text) {
        this.initAll();
        StyleSheet ss = this._doc.getStyleSheet();
        ParagraphProperties baseStyle = ss.getParagraphStyle(styleIndex);
        CharacterProperties baseChp = ss.getCharacterStyle(styleIndex);
        byte[] grpprl = ParagraphSprmCompressor.compressParagraphProperty(props, baseStyle);
        byte[] withIndex = new byte[grpprl.length + 2];
        LittleEndian.putShort((byte[])withIndex, (short)((short)styleIndex));
        System.arraycopy(grpprl, 0, withIndex, 2, grpprl.length);
        SprmBuffer buf = new SprmBuffer(withIndex, 2);
        this._doc.getParagraphTable().insert(this._parStart, this._start, buf);
        this.insertBefore(text, baseChp);
        return this.getParagraph(0);
    }

    public Paragraph insertAfter(ParagraphProperties props, int styleIndex) {
        return this.insertAfter(props, styleIndex, "\r");
    }

    protected Paragraph insertAfter(ParagraphProperties props, int styleIndex, String text) {
        this.initAll();
        StyleSheet ss = this._doc.getStyleSheet();
        ParagraphProperties baseStyle = ss.getParagraphStyle(styleIndex);
        CharacterProperties baseChp = ss.getCharacterStyle(styleIndex);
        byte[] grpprl = ParagraphSprmCompressor.compressParagraphProperty(props, baseStyle);
        byte[] withIndex = new byte[grpprl.length + 2];
        LittleEndian.putShort((byte[])withIndex, (short)((short)styleIndex));
        System.arraycopy(grpprl, 0, withIndex, 2, grpprl.length);
        SprmBuffer buf = new SprmBuffer(withIndex, 2);
        this._doc.getParagraphTable().insert(this._parEnd, this._end, buf);
        ++this._parEnd;
        this.insertAfter(text, baseChp);
        return this.getParagraph(this.numParagraphs() - 1);
    }

    public void delete() {
        this.initAll();
        int numSections = this._sections.size();
        int numRuns = this._characters.size();
        int numParagraphs = this._paragraphs.size();
        int x = this._charStart;
        while (x < numRuns) {
            CHPX chpx = (CHPX)this._characters.get(x);
            chpx.adjustForDelete(this._start, this._end - this._start);
            ++x;
        }
        x = this._parStart;
        while (x < numParagraphs) {
            PAPX papx = (PAPX)this._paragraphs.get(x);
            papx.adjustForDelete(this._start, this._end - this._start);
            ++x;
        }
        x = this._sectionStart;
        while (x < numSections) {
            SEPX sepx = (SEPX)this._sections.get(x);
            sepx.adjustForDelete(this._start, this._end - this._start);
            ++x;
        }
        if (this._doc instanceof HWPFDocument) {
            ((BookmarksImpl)((HWPFDocument)this._doc).getBookmarks()).afterDelete(this._start, this._end - this._start);
        }
        this._text.delete(this._start, this._end);
        Range parent = (Range)this._parent.get();
        if (parent != null) {
            parent.adjustForInsert(-(this._end - this._start));
        }
        this.adjustFIB(-(this._end - this._start));
    }

    public Table insertBefore(TableProperties props, int rows) {
        ParagraphProperties parProps = new ParagraphProperties();
        parProps.setFInTable(true);
        parProps.setItap(1);
        int oldEnd = this._end;
        int columns = props.getItcMac();
        int x = 0;
        while (x < rows) {
            Paragraph cell = this.insertBefore(parProps, 4095);
            cell.insertAfter(String.valueOf('\u0007'));
            int y = 1;
            while (y < columns) {
                cell = cell.insertAfter(parProps, 4095);
                cell.insertAfter(String.valueOf('\u0007'));
                ++y;
            }
            cell = cell.insertAfter(parProps, 4095, String.valueOf('\u0007'));
            cell.setTableRowEnd(props);
            ++x;
        }
        int newEnd = this._end;
        int diff = newEnd - oldEnd;
        return new Table(this._start, this._start + diff, this, 1);
    }

    public Table insertTableBefore(short columns, int rows) {
        ParagraphProperties parProps = new ParagraphProperties();
        parProps.setFInTable(true);
        parProps.setItap(1);
        int oldEnd = this._end;
        int x = 0;
        while (x < rows) {
            Paragraph cell = this.insertBefore(parProps, 4095);
            cell.insertAfter(String.valueOf('\u0007'));
            int y = 1;
            while (y < columns) {
                cell = cell.insertAfter(parProps, 4095);
                cell.insertAfter(String.valueOf('\u0007'));
                ++y;
            }
            cell = cell.insertAfter(parProps, 4095, String.valueOf('\u0007'));
            cell.setTableRowEnd(new TableProperties((short)columns));
            ++x;
        }
        int newEnd = this._end;
        int diff = newEnd - oldEnd;
        return new Table(this._start, this._start + diff, this, 1);
    }

    public ListEntry insertBefore(ParagraphProperties props, int listID, int level, int styleIndex) {
        ListTables lt = this._doc.getListTables();
        if (lt.getLevel(listID, level) == null) {
            throw new NoSuchElementException("The specified list and level do not exist");
        }
        int ilfo = lt.getOverrideIndexFromListID(listID);
        props.setIlfo(ilfo);
        props.setIlvl((byte)level);
        return (ListEntry)this.insertBefore(props, styleIndex);
    }

    public ListEntry insertAfter(ParagraphProperties props, int listID, int level, int styleIndex) {
        ListTables lt = this._doc.getListTables();
        if (lt.getLevel(listID, level) == null) {
            throw new NoSuchElementException("The specified list and level do not exist");
        }
        int ilfo = lt.getOverrideIndexFromListID(listID);
        props.setIlfo(ilfo);
        props.setIlvl((byte)level);
        return (ListEntry)this.insertAfter(props, styleIndex);
    }

    public void replaceText(String newText, boolean addAfter) {
        if (addAfter) {
            int originalEnd = this.getEndOffset();
            this.insertAfter(newText);
            new Range(this.getStartOffset(), originalEnd, this).delete();
        } else {
            int originalStart = this.getStartOffset();
            int originalEnd = this.getEndOffset();
            this.insertBefore(newText);
            new Range(originalStart + newText.length(), originalEnd + newText.length(), this).delete();
        }
    }

    public void replaceText(String pPlaceHolder, String pValue, int pOffset) {
        int absPlaceHolderIndex = this.getStartOffset() + pOffset;
        Range subRange = new Range(absPlaceHolderIndex, absPlaceHolderIndex + pPlaceHolder.length(), this);
        subRange.insertBefore(pValue);
        subRange = new Range(absPlaceHolderIndex + pValue.length(), absPlaceHolderIndex + pPlaceHolder.length() + pValue.length(), this);
        subRange.delete();
    }

    public void replaceText(String pPlaceHolder, String pValue) {
        boolean keepLooking = true;
        while (keepLooking) {
            String text = this.text();
            int offset = text.indexOf(pPlaceHolder);
            if (offset >= 0) {
                this.replaceText(pPlaceHolder, pValue, offset);
                continue;
            }
            keepLooking = false;
        }
    }

    public CharacterRun getCharacterRun(int index) {
        short istd;
        this.initCharacterRuns();
        if (index + this._charStart >= this._charEnd) {
            throw new IndexOutOfBoundsException("CHPX #" + index + " (" + (index + this._charStart) + ") not in range [" + this._charStart + "; " + this._charEnd + ")");
        }
        CHPX chpx = (CHPX)this._characters.get(index + this._charStart);
        if (chpx == null) {
            return null;
        }
        if (this instanceof Paragraph) {
            istd = ((Paragraph)this)._istd;
        } else {
            int[] point = this.findRange(this._paragraphs, Math.max(chpx.getStart(), this._start), Math.min(chpx.getEnd(), this._end));
            this.initParagraphs();
            int parStart = Math.max(point[0], this._parStart);
            if (parStart >= this._paragraphs.size()) {
                return null;
            }
            PAPX papx = (PAPX)this._paragraphs.get(point[0]);
            istd = papx.getIstd();
        }
        CharacterRun chp = new CharacterRun(chpx, this._doc.getStyleSheet(), istd, this);
        return chp;
    }

    public Section getSection(int index) {
        this.initSections();
        SEPX sepx = (SEPX)this._sections.get(index + this._sectionStart);
        Section sep = new Section(sepx, this);
        return sep;
    }

    public Paragraph getParagraph(int index) {
        this.initParagraphs();
        if (index + this._parStart >= this._parEnd) {
            throw new IndexOutOfBoundsException("Paragraph #" + index + " (" + (index + this._parStart) + ") not in range [" + this._parStart + "; " + this._parEnd + ")");
        }
        PAPX papx = (PAPX)this._paragraphs.get(index + this._parStart);
        return Paragraph.newParagraph(this, papx);
    }

    public int type() {
        return 6;
    }

    public Table getTable(Paragraph paragraph) {
        Paragraph previous;
        if (!paragraph.isInTable()) {
            throw new IllegalArgumentException("This paragraph doesn't belong to a table");
        }
        Paragraph r = paragraph;
        if (r._parent.get() != this) {
            throw new IllegalArgumentException("This paragraph is not a child of this range instance");
        }
        r.initAll();
        int tableLevel = paragraph.getTableLevel();
        int tableEndInclusive = r._parStart;
        if (r._parStart != 0 && (previous = Paragraph.newParagraph(this, (PAPX)this._paragraphs.get(r._parStart - 1))).isInTable() && previous.getTableLevel() == tableLevel && previous._sectionEnd >= r._sectionStart) {
            throw new IllegalArgumentException("This paragraph is not the first one in the table");
        }
        Range overallRange = this._doc.getOverallRange();
        int limit = this._paragraphs.size();
        while (tableEndInclusive < limit - 1) {
            Paragraph next = Paragraph.newParagraph(overallRange, (PAPX)this._paragraphs.get(tableEndInclusive + 1));
            if (!next.isInTable() || next.getTableLevel() < tableLevel) break;
            ++tableEndInclusive;
        }
        this.initAll();
        if (tableEndInclusive >= this._parEnd) {
            this.logger.log(POILogger.WARN, (Object)"The table's bounds ", (Object)("[" + this._parStart + "; " + tableEndInclusive + ")"), (Object)" fall outside of this Range paragraphs numbers ", (Object)("[" + this._parStart + "; " + this._parEnd + ")"));
        }
        if (tableEndInclusive < 0) {
            throw new ArrayIndexOutOfBoundsException("The table's end is negative, which isn't allowed!");
        }
        int endOffsetExclusive = ((PropertyNode)this._paragraphs.get(tableEndInclusive)).getEnd();
        return new Table(paragraph.getStartOffset(), endOffsetExclusive, this, paragraph.getTableLevel());
    }

    protected void initAll() {
        this.initCharacterRuns();
        this.initParagraphs();
        this.initSections();
    }

    private void initParagraphs() {
        if (!this._parRangeFound) {
            int[] point = this.findRange(this._paragraphs, this._start, this._end);
            this._parStart = point[0];
            this._parEnd = point[1];
            this._parRangeFound = true;
        }
    }

    private void initCharacterRuns() {
        if (!this._charRangeFound) {
            int[] point = this.findRange(this._characters, this._start, this._end);
            this._charStart = point[0];
            this._charEnd = point[1];
            this._charRangeFound = true;
        }
    }

    private void initSections() {
        if (!this._sectionRangeFound) {
            int[] point = this.findRange(this._sections, this._sectionStart, this._start, this._end);
            this._sectionStart = point[0];
            this._sectionEnd = point[1];
            this._sectionRangeFound = true;
        }
    }

    private static int binarySearchStart(List rpl, int start) {
        if (((PropertyNode)rpl.get(0)).getStart() >= start) {
            return 0;
        }
        int low = 0;
        int high = rpl.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            PropertyNode node = (PropertyNode)rpl.get(mid);
            if (node.getStart() < start) {
                low = mid + 1;
                continue;
            }
            if (node.getStart() > start) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low - 1;
    }

    private static int binarySearchEnd(List rpl, int foundStart, int end) {
        if (((PropertyNode)rpl.get(rpl.size() - 1)).getEnd() <= end) {
            return rpl.size() - 1;
        }
        int low = foundStart;
        int high = rpl.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            PropertyNode node = (PropertyNode)rpl.get(mid);
            if (node.getEnd() < end) {
                low = mid + 1;
                continue;
            }
            if (node.getEnd() > end) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    private int[] findRange(List rpl, int start, int end) {
        int startIndex = Range.binarySearchStart(rpl, start);
        while (startIndex > 0 && ((Range)rpl.get(startIndex - 1)).getStartOffset() >= start) {
            --startIndex;
        }
        int endIndex = Range.binarySearchEnd(rpl, startIndex, end);
        while (endIndex < rpl.size() - 1 && ((PropertyNode)rpl.get(endIndex + 1)).getEnd() <= end) {
            ++endIndex;
        }
        if (startIndex < 0 || startIndex >= rpl.size() || startIndex > endIndex || endIndex < 0 || endIndex >= rpl.size()) {
            throw new AssertionError();
        }
        return new int[]{startIndex, endIndex + 1};
    }

    private int[] findRange(List rpl, int min, int start, int end) {
        int x = min;
        if (rpl.size() == min) {
            return new int[]{min, min};
        }
        PropertyNode node = (PropertyNode)rpl.get(x);
        while (node == null || node.getEnd() <= start && x < rpl.size() - 1) {
            if (++x >= rpl.size()) {
                return new int[2];
            }
            node = (PropertyNode)rpl.get(x);
        }
        if (node.getStart() > end) {
            return new int[2];
        }
        if (node.getEnd() <= start) {
            return new int[]{rpl.size(), rpl.size()};
        }
        int y = x;
        while (y < rpl.size()) {
            node = (PropertyNode)rpl.get(y);
            if (node != null && (node.getStart() >= end || node.getEnd() > end)) {
                if (node.getStart() < end) {
                    return new int[]{x, y + 1};
                }
                return new int[]{x, y};
            }
            ++y;
        }
        return new int[]{x, rpl.size()};
    }

    protected void reset() {
        this._charRangeFound = false;
        this._parRangeFound = false;
        this._sectionRangeFound = false;
    }

    protected void adjustFIB(int adjustment) {
        FileInformationBlock fib = this._doc.getFileInformationBlock();
        int currentEnd = 0;
        SubdocumentType[] values = SubdocumentType.values();
        int i = 0;
        while (i < values.length) {
            SubdocumentType type = values[i];
            int currentLength = fib.getSubdocumentTextStreamLength(type);
            if (this._start <= (currentEnd += currentLength)) {
                fib.setSubdocumentTextStreamLength(type, currentLength + adjustment);
                break;
            }
            ++i;
        }
    }

    private void adjustForInsert(int length) {
        this._end += length;
        this.reset();
        Range parent = (Range)this._parent.get();
        if (parent != null) {
            parent.adjustForInsert(length);
        }
    }

    public int getStartOffset() {
        return this._start;
    }

    public int getEndOffset() {
        return this._end;
    }

    protected HWPFDocumentCore getDocument() {
        return this._doc;
    }

    public String toString() {
        return "Range from " + this.getStartOffset() + " to " + this.getEndOffset() + " (chars)";
    }

    public boolean sanityCheck() {
        int right;
        int left;
        if (this._start < 0) {
            throw new AssertionError();
        }
        if (this._start > this._text.length()) {
            throw new AssertionError();
        }
        if (this._end < 0) {
            throw new AssertionError();
        }
        if (this._end > this._text.length()) {
            throw new AssertionError();
        }
        if (this._start > this._end) {
            throw new AssertionError();
        }
        if (this._charRangeFound) {
            int c = this._charStart;
            while (c < this._charEnd) {
                CHPX chpx = (CHPX)this._characters.get(c);
                left = Math.max(this._start, chpx.getStart());
                if (left >= (right = Math.min(this._end, chpx.getEnd()))) {
                    throw new AssertionError();
                }
                ++c;
            }
        }
        if (this._parRangeFound) {
            int p = this._parStart;
            while (p < this._parEnd) {
                PAPX papx = (PAPX)this._paragraphs.get(p);
                left = Math.max(this._start, papx.getStart());
                if (left >= (right = Math.min(this._end, papx.getEnd()))) {
                    throw new AssertionError();
                }
                ++p;
            }
        }
        return true;
    }
}

