package poi.support;

/**
 * Support AtmicInteger Class.<br>
 * for Java 1.4.<br>
 */
public class SynchronizedInteger {

	private Object lock = new Object();

	private int value = 0;

	public SynchronizedInteger(int value) {
		this.value = value;
	}

	public int getAndIncrement() {
		synchronized (lock) {
			int ret = value;
			value++;
			return ret;
		}
	}

	public int incrementAndGet() {
		synchronized (lock) {
			value++;
			return value;
		}
	}
}
