<?php
/**
 * PokoX - Super Light Weight MVC Controller for PHP.
 *
 * @version 1.0
 * @copyright Copyright (c) 2003 - 2005 Akira Kaze
 *
 * Character set is EUC-JP.
 *
 * For LICENSE information, please view the COPYRIGHT.txt file that was 
 * distributed with this source code. If the COPYRIGHT.txt file is missing, 
 * please visit the PokoX homepage: http://www.glamenv-septzen.net/
 *
 * $Id: pokox.inc.php,v 1.3 2005/07/10 20:58:28 fenjin Exp $
 */

if(defined('_POKOX_KERNEL')) return;
define('_POKOX_KERNEL', 1);

/*
 * PokoX Ƽ省ʸ
 * !WARNING!
 * GET/POSTΥ̾Ǥ"."ưŪ"_"ѴƤޤ
 * Τᥨ̾ˤȤ륭ʸǤ"."ˤ볬ز
 * ϻԲ!
 */

if(!defined('POKOX_STORY_KEY')) {
/**
 * ȡ꡼ФΥʸ
 *
 * @since 1.0
 * @type string
 */
define('POKOX_STORY_KEY', 'pokox_story');
}

if(!defined('POKOX_STORY_KEY_PREV')) {
/**
 * ΥڡΥȡ꡼ФΥʸʤС
 *
 * @since 1.0
 * @type string
 */
define('POKOX_STORY_KEY_PREV', 'pokox_story_prev');
}

if(!defined('POKOX_DIR')) {
/**
 * PokoX饤֥ǥ쥯ȥ
 *
 * @since 1.0
 * @type string
 */
define('POKOX_DIR', dirname(__FILE__));
}


if(!defined('POKOX_STORY_DIR')) {
/**
 * PokoXȡ꡼饹ǥ쥯ȥʥǥեȡ
 *
 * @since 1.0
 * @type string
 */
define('POKOX_STORY_DIR', realpath(POKOX_DIR."/story/"));
}

if(!defined('POKOX_STORY_AUTOLOAD')) {
/**
 * ȡ꡼饹μưɤ߹ߵǽON/OFF
 *
 * @since 1.0
 * @type string
 */
define('POKOX_STORY_AUTOLOAD', 1);
}

if(!defined('POKOX_ERROR_LEVEL')) {
/**
 * PokoXνϤ륨顼٥
 *
 * @since 1.0
 * @type string
 */
define('POKOX_ERROR_LEVEL', E_USER_WARNING);
}

/**
 * ȡ꡼⥸塼¹Ԥ
 * ƥץ졼ȥ󤫤ƥץ졼ȥ꥽Ϥ
 * Ϥ롣
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
class PokoX
{
	/**
	 * PokoX饤󥹥
	 *
	 * @access public
	 * @since 1.0
	 * @type PokoXRenderer
	 */
	var $renderer = null;

	/**
	 * ⥸塼
	 *
	 * @access private
	 * @since 1.0
	 * @type array
	 */
	var $_modules;

	/**
	 * ⥸塼Υ󥹥󥹥Υå
	 * (idο줿⥸塼Υ󥹥󥹤å롣)
	 *
	 * @access private
	 * @since 1.0
	 * @type array
	 */
	var $_module_stacks;

	/**
	 * dispatchХե饰
	 *
	 * @access private
	 * @since 1.0
	 * @type bool
	 */
	var $_dispatched = false;

	/**
	 * escapeХե饰
	 *
	 * @access private
	 * @since 1.0
	 * @type bool
	 */
	var $_escaped = false;

	/**
	 * escapeΥե饰
	 *
	 * @access private
	 * @since 1.0
	 * @type bool
	 */
	var $_ignore_renderer = false;

	/**
	 * PokoX󥹥󥹤Singletonǥѥ롣
	 *
	 * @return PokoX PokoX󥹥󥹤ؤλ
	 * @access public
	 * @since 1.0
	 */
	function &getInstance()
	{
		static $instance = null;
		if(is_null($instance)) {
			$instance = new PokoX();
		}
		return $instance;
	}

	/**
	 * PokoX ؿ(HTML)
	 *
	 * @param string ȡ꡼ͥ졼饹̾
	 * @param string 饯饹̾
	 * @access public
	 * @since 1.0
	 */
	function run($StoryClassName, $RendererClassName)
	{
		echo PokoX::_run($StoryClassName, $RendererClassName);
	}

	/**
	 * PokoX ؿ
	 *
	 * @param string ȡ꡼ͥ졼饹̾
	 * @param string 饯饹̾
	 * @return string 
	 * @access public
	 * @since 1.0
	 */
	function _run($StoryClassName, $RendererClassName)
	{

		// Create Singleton Instance
		$pokox =& PokoX::getInstance();

		// Load Story Class
		if(!class_exists($StoryClassName)) {
			if(POKOX_STORY_AUTOLOAD) {
				// Story Class File Name
				$sbfn = "/$StoryClassName.class.php";
				if(file_exists(POKOX_STORY_DIR.$sbfn)) {
					require_once(POKOX_STORY_DIR.$sbfn);
				} else {
					user_error(
						"Not found Story Class File for '$StoryClassName'!", 
						POKOX_ERROR_LEVEL
						);
				}
			} else {
				user_error(
					"Not found Story Class '$StoryClassName'!", 
					POKOX_ERROR_LEVEL
					);
			}
		}

		// Load Renderer Class
		if(!class_exists($RendererClassName)) {
			user_error(
				"Not found Renderer Class '$RendererClassName'",
				POKOX_ERROR_LEVEL
				);
		}

		// Create Story Instance
		$story =& new $StoryClassName();
		// Create Renderer Instance
		$pokox->renderer =& new $RendererClassName();
		// Start Story
		$story->start($pokox);
		// (Re-)Declare $_POKOX Variable as Global Variable
		GLOBAL $_POKOX;
		// Update Previous Story
		if(isset($_POKOX[POKOX_STORY_KEY])) {
			$_POKOX[POKOX_STORY_KEY_PREV] = $_POKOX[POKOX_STORY_KEY];
		}
		// Get Story
		$_POKOX[POKOX_STORY_KEY] = $story->story($pokox);

		// Hook BEFORE Execute Chain
		if(function_exists("POKOX_STORY_PREHOOK")) {
			call_user_func("POKOX_STORY_PREHOOK", $pokox);
		}

		// Get Current Story
		$pokox_story = (isset($_POKOX[POKOX_STORY_KEY])) ? 
			$_POKOX[POKOX_STORY_KEY] : "*";
		// Get Current ACI
		$pokox_aci = (isset($_POKOX["pokox_aci"])) ? 
			$_POKOX["pokox_aci"] : "*";

		// Construct Module Chain
		$pokox->_modules = $pokox->_parsePokoXDirectives(
			$pokox_aci, $pokox_story, "POKOX_MODULE_STORY");
		// Invoke Module Chain
		$pokox->_invokeModuleChain();

		// Hook AFTER Execute Chain
		if(function_exists("POKOX_STORY_POSTHOOK")) {
			call_user_func("POKOX_STORY_POSTHOOK", $pokox);
		}

		// Assign Auto Template Variables
		$pokox->renderer->assign(
			'POKOX_STORY_KEY', POKOX_STORY_KEY);
		$pokox->renderer->assign(
			'POKOX_STORY_KEY_PREV', POKOX_STORY_KEY_PREV);
		$pokox->renderer->assign(
			'POKOX_ACI', @$_POKOX['pokox_aci']);
		$pokox->renderer->assign(
			'POKOX_STORY', $_POKOX[POKOX_STORY_KEY]);
		$pokox->renderer->assign(
			'POKOX_STORY_PREV', @$_POKOX[POKOX_STORY_KEY_PREV]);
		
		// escapeƤʤƤƤ椬ƤС
		if((!$pokox->_escaped) || 
			($pokox->_escaped && !$pokox->_ignore_renderer)) {
			// Execute PokoXRenderer & Get Output
			$contents = $pokox->renderer->parseTemplate(
				$pokox->_parsePokoXDirectives(
					$pokox_aci, 
					$pokox_story,
					"POKOX_TEMPLATE_STORY")
				);
		}

		// End Story
		$story->end($pokox);

		return $contents;
	}

	/**
	 * PokoXϢ󤫤顢ʲ̤ͥ˽äϢĴ١
	 * ҥåȤ餽͡orƥץ졼ȥ꥽ʸˤ֤
	 * <br /><br />
	 * <note>
	 * ̡ͥ"$aci.$story" > "$aci.*" > "*.$story" > "*.*"
	 * </note>
	 *
	 * @param string ߤACI
	 * @param string ߤΥȡ꡼
	 * @param string ϤϢ̾
	 * @return mixed ޤϥƥץ졼ȥ꥽ʸ
	 * @access private
	 * @since 1.0
	 */
	function _parsePokoXDirectives($aci, $story, $directives)
	{
		foreach($GLOBALS[$directives] as $directive => $value) {
			switch($directive) {
				case "$aci.$story" :
				case "$aci.*" :
				case "*.$story" :
				case "*.*" :
					return $value;
			}
		}
	}

	/**
	 * ⥸塼¹ԥ᥽å
	 *
	 * @access private
	 * @since 1.0
	 */
	function _invokeModuleChain()
	{
		if(!isset($this->_modules)) {
			// ⤷⳺ȡ꡼¸ߤʤСǽƤ
			$this->_modules = array();
		}
		reset($this->_modules);
		do {
			// dispatchե饰̵Ƥ
			if($this->_dispatched) {
				$this->_dispatched = false;
			}
			foreach($this->_modules as $key => $params) {
				$elements = explode('.', $key);
				$class_name = $elements[0];
				if(count($elements) == 2) {
					$mid = $elements[1];
				} else {
					$mid = null;
				}
				$module =& new $class_name();
				$module->execute($this, $params, $mid);
				if($mid) {
					// ⥸塼IDؼƤСåѤǤ
					$this->_module_stacks[$mid] =& $module;
				}
				// escapedե饰ͭˤʤäƤХ롼פȴ롣
				if($this->_escaped) break;
				// dispatchե饰ͭˤʤäƤХ롼פȴ롣
				if($this->_dispatched) break;
			}
			if($this->_escaped) {
				break;
			}
			if($this->_dispatched) {
				// ⥸塼κƹ
				global $_POKOX;
				unset($this->_modules);
				$this->_modules = array();
				$this->_modules = $this->_parsePokoXDirectives(
					$_POKOX['pokox_aci'], 
					$_POKOX[POKOX_STORY_KEY],
					"POKOX_MODULE_STORY");
				if(!isset($this->_modules)) {
					$this->_modules = array();
				}
				reset($this->_modules);
			}
		// dispatchͭƤС٥⥸塼¹Ԥ롣
		} while($this->_dispatched);
	}

	/**
	 * ȡ꡼ڤؤȤ(Notify dispatching to new story)
	 *
	 * @access public
	 * @param string ȡ꡼
	 * @since 1.0
	 */
	function dispatch($NewStory)
	{
		global $_POKOX;
		$this->_dispatched = true;
		$_POKOX[POKOX_STORY_KEY] = $NewStory;
	}

	/**
	 * ⥸塼ζλȤ(Notify break module chain)
	 *
	 * @access public
	 * @param bool HTML󥰽򥹥åפ뤫ݤ(Default: true)
	 * @since 1.0
	 */
	function escape($ignore_renderer = true)
	{
		$this->_escaped = true;
		$this->_ignore_renderer = $ignore_renderer;
	}

	/**
	 * ⥸塼륹åѤޤ줿⥸塼륤󥹥󥹤Ф
	 *
	 * @param string ⥸塼ID
	 * @return PokoXModule ⥸塼뤬̵null֤
	 * @access public
	 * @since 1.0
	 */
	function &getStackedModule($mid)
	{
		if(isset($this->_module_stacks[$mid])) {
			return $this->_module_stacks[$mid];
		} else {
			return null;
		}
	}
}

/**
 * PokoXݡ˥饹
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package pokox
 * @since 1.0
 */
/* interface or abstract */
class PokoXRenderer
{
	/**
	 * ºݤΥƥץ졼ȥ֥
	 *
	 * @access public
	 * @type object
	 * @since 1.0
	 */
	var $engine;

	/**
	 * 󥹥ȥ饯
	 *
	 * @access public
	 * @since 1.0
	 */
	function &PokoXRenderer()
	{
	}

	/**
	 * ͤγե᥽å
	 *
	 * @param string ƥץ졼¦ѿ̾
	 * @param mixed դ
	 * @access public
	 * @since 1.0
	 */
	function assign($name, $value)
	{
		$error = 'PokoXRenderer::assign($name, $value) must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}

	/**
	 * ͤγե᥽å
	 *
	 * @param string ƥץ졼¦ѿ̾
	 * @param mixed դ͡ʻϤ
	 * @access public
	 * @since 1.0
	 */
	function assign_by_ref($name, &$value)
	{
		$error = 'PokoXRenderer::assign_by_ref($name, &$value) must be '
			.'overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}

	/**
	 * ƥץ졼Ƚ᥽å
	 *
	 * @param string ƥץ졼ȥ꥽ʸ
	 * @return string ƥץ졼ȽΥƥʸ
	 * @access public
	 * @since 1.0
	 */
	function parseTemplate($template)
	{
		$error = 'PokoXRenderer::parseTemplate($template) must be ';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}
}

/**
 * PokoXȡ꡼Ѵݡ˥饹
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package pokox
 * @since 1.0
 */
/* interface or abstract */
class PokoXStory
{
	/**
	 * ȡ꡼ѥ᥽å
	 *
	 * @access public
	 * @since 1.0
	 */
	function start()
	{
		$error = 'PokoXStory::start() must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}

	/**
	 * ȡ꡼᥽å
	 *
	 * @return string ȡ꡼
	 * @access public
	 * @since 1.0
	 */
	function story()
	{
		$error = 'PokoXStory::story() must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}

	/**
	 * ȡ꡼λ˼¹Ԥ᥽å
	 *
	 * @access public
	 * @since 1.0
	 */
	function end()
	{
		$error = 'PokoXStory::end() must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}
}

/**
 * PokoX⥸塼ݡ˥饹
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package pokox
 * @since 1.0
 */
/* interface or abstract */
class PokoXModule
{
	/**
	 * ⥸塼¹ԥ᥽å
	 *
	 * @param PokoX PokoXȥ饪֥ȥ󥹥
	 * @param array ѥ᡼
	 * @param string ʻꤵƤС˥⥸塼ID
	 * @access public
	 * @since 1.0
	 */
	function execute(&$pokox, $params, $mid = null)
	{
		$error = 'PokoXStory::execute(&$pokox, $params, $mid = null) '
			.'must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}
}

/**
 * ХåؿPokoX⥸塼<br />
 * 'function' (&$pokox, $params, $mid = null)ΥХåؿƤ֡
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package pokox
 * @since 1.0
 */
class PokoXUserFuncModule extends PokoXModule
{
	/**
	 * ⥸塼¹ԥ᥽å
	 *
	 * @param PokoX PokoXȥ饪֥ȥ󥹥
	 * @param array ѥ᡼
	 * @param string ʻꤵƤС˥⥸塼ID
	 * @access public
	 * @since 1.0
	 */
	function execute(&$pokox, $params, $mid = null)
	{
		if(isset($params["function"]) && 
			function_exists($params["function"])) {
			call_user_func(
				$params["function"],
				$pokox,
				$params,
				$mid);
		}
	}
}

/**
 * PokoXѥƥȸvar_dump()ʰץ<br />
 * assign줿ͤǸvar_dumpľܽϤޤƥץ졼ȥ꥽
 * Ȥޤ
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package pokox
 * @since 1.0
 */
class PokoXVarDumpRenderer extends PokoXRenderer
{
	var $engine;
	var $templates;

	function &PokoXVarDumpRenderer()
	{
		$this->templates = array();
	}

	function assign($name, $value)
	{
		$this->templates[$name] = $value;
	}

	function assign_by_ref($name, &$value)
	{
		$this->templates[$name] = $value;
	}

	function parseTemplate($template)
	{
		ob_start();
		var_dump($this->templates);
		$output = ob_get_contents();
		ob_end_clean();
		return $output;
	}
}

/**
 * ץPHP(HTML)߼Υƥץ졼ȥ饹
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package pokox
 * @since 1.0
 */
class PokoXSimpleRenderer extends PokoXRenderer
{
	/**
	 * ƥץ졼ȤݻϢ
	 *
	 * @access public
	 * @type array
	 * @since 1.0
	 */
	var $engine;

	/**
	 * 󥹥ȥ饯
	 *
	 * @access public
	 * @since 1.0
	 */
	function &PokoXSimpleRenderer()
	{
		$this->engine = array();
	}

	/**
	 * ͤγե᥽å
	 *
	 * @param string ƥץ졼¦ѿ̾
	 * @param mixed դ
	 * @access public
	 * @since 1.0
	 */
	function assign($name, $value)
	{
		$this->engine[$name] = $value;
	}

	/**
	 * ͤγե᥽å
	 *
	 * @param string ƥץ졼¦ѿ̾
	 * @param mixed դ͡ʻϤ
	 * @access public
	 * @since 1.0
	 */
	function assign_by_ref($name, &$value)
	{
		$this->engine[$name] = $value;
	}

	/**
	 * ƥץ졼Ƚ᥽å
	 *
	 * @param string ƥץ졼PHP(HTML)ե̾
	 * @return string ƥץ졼ȽΥƥʸ
	 * @access public
	 * @since 1.0
	 */
	function parseTemplate($_template)
	{
		// ƥץ졼$template['name']ȤƼФ褦Х
		// פ˥ԡ롣
		$GLOBALS['template'] = $this->engine;
		// ϥХåե󥰳
		// (ob_start()/ob_end_*()ϥͥȲǽʤΤǡob_start()
		// ĤդƤɬפϤǤ̵
		ob_start();
		require_once($_template);
		$contents = ob_get_contents();
		// ϥХåե󥰽λ&Хåեꥢ
		ob_end_clean();
		// Х륹פ롣
		unset($GLOBALS['template']);
		return $contents;
	}
}
?>
