<?php
/*
 * This file is part of the PokoX package.
 * Copyright (c) 2003 - 2005 Akira Kaze
 *
 * Character set is EUC-JP.
 *
 * For license information, please view the COPYRIGHT.txt file that was 
 * distributed with this source code. If the COPYRIGHT.txt file is missing, 
 * please visit the PokoX homepage: http://www.glamenv-septzen.net/
 *
 * $Id: AuthSessionBase.class.php,v 1.3 2005/07/10 20:59:22 fenjin Exp $
 */

/**
 * <pre>
 * ǧڷϥȡ꡼ΰ٤Ѵ쥯饹
 *
 * åѤǧڤԤȡ꡼饹Τδ쥯饹
 * auth()story()ݥ᥽åɤǥޥ롣
 * (auth()ǧڤ$_POKOX['pokox.aci']ηԤ)
 * (Templateǥѥ)
 * </pre>
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
class AuthSessionBase extends PokoXStory
{

	var $_pokox;

	function auth()
	{
		$error = 'AuthSessionBase::auth() must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}

	function logout()
	{
		session_unset();
		session_destroy();
		$GLOBALS["_POKOX"] = null;
		// for ADOdb Session Library
		/*
		$conn =& $GLOBALS['ADODB_CONN'];
		if(!$conn->IsConnected()) {
			$conn->Connect();
		}
		*/
	}

	function start(&$pokox)
	{
		global $POKOX_STORY_PARAMS;

		$this->_pokox = $pokox;

		$lifetime = @$POKOX_STORY_PARAMS["session_lifetime"];
		$path = @$POKOX_STORY_PARAMS["session_path"];
		$domain = @$POKOX_STORY_PARAMS["session_domain"];
		$secure = @$POKOX_STORY_PARAMS["session_secure"];
		$name = @$POKOX_STORY_PARAMS["session_name"];

		session_set_cookie_params($lifetime, $path, $domain, $secure);
		if(isset($name) && $name != "") {
			session_name($name);
		}
		session_start();

		if(!isset($_SESSION["POKOX_SESSION_VARS"])) {
			$_SESSION["POKOX_SESSION_VARS"] = array();
		}
		$GLOBALS["_POKOX"] =& $_SESSION["POKOX_SESSION_VARS"];
	}

	function story(&$pokox)
	{
		$error = 'AuthSessionBase::story() must be overriden';
		trigger_error($error, POKOX_ERROR_LEVEL);
		exit;
	}
	
	function end(&$pokox)
	{
	}

}

/**
 * 󤷤ʤƤACIͿ롢CMSϤưΰ٤ǧڥȡ꡼饹
 * story()᥽åɤΤ߼Ƥ롣auth()ʬϤΥ饹Ŭ
 * ޥ롣
 *
 * auth()᥽åɤ̵ͤ뤵롣
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
class OpenSpaceBase extends AuthSessionBase
{
	function story(&$pokox)
	{
		if(isset($_GET[POKOX_STORY_KEY])) {
			$story = $_GET[POKOX_STORY_KEY];
		} else if(isset($_POST[POKOX_STORY_KEY])) {
			$story = $_POST[POKOX_STORY_KEY];
		} else {
			$story = "";
		}

		if($story == "logout") {
			$this->logout();
		}

		$this->auth();

		return $story;
	}
}

/**
 * 󤷤ʤACIͿ줺ʤפǧڥȡ꡼饹
 * story()᥽åɤΤ߼Ƥ롣auth()ʬϤΥ饹Ŭ
 * ޥ롣
 *
 * auth()᥽åɤǧڤtrue, Ԥfalse֤ȡ
 *
 * @author Akira Kaze <feng-jing-gsyc-2s@glamenv-septzen.net>
 * @package PokoX
 * @since 1.0
 */
class ShieldSpotBase extends AuthSessionBase
{
	function story(&$pokox)
	{
		if(!$this->auth()) return "login";

		if(isset($_GET[POKOX_STORY_KEY])) {
			$story = $_GET[POKOX_STORY_KEY];
		} else if(isset($_POST[POKOX_STORY_KEY])) {
			$story = $_POST[POKOX_STORY_KEY];
		} else {
			$story = "";
		}

		switch($story) {
			case "logout" :
				$this->logout();
				//return $story;
//				return "login";
			default : 
				return $story;
		}
	}
}
?>