/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import portablesimulator.IMatrixBuilder;
import portablesimulator.PSItem;
import portablesimulator.PSWrap;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class MatrixBuilderSkilled
implements IMatrixBuilder {
    SkillSet targetSkill;
    int weaponSlotCount;
    ArrayList<PSItem> fetch;
    ArrayList<PSItem> targetDeco;
    int[] decosScore;
    int[] maxScoreOfSlot;
    int needTotal;
    int[] needAboutParts;
    int[] needAboutCopie;
    int[] topOfTheParts;
    ArrayList<ArrayList> arrayColumnList = new ArrayList();
    int[] columnIndex;
    int[] columnWeight;
    boolean endOfMatrix;
    long skipCount;
    long returnCount;

    public MatrixBuilderSkilled(SkillSet targetSkills0, int slotCount) {
        this.targetSkill = targetSkills0;
        this.weaponSlotCount = slotCount;
        this.targetDeco = Repository.getBaseItems().listDecoration;
        this.decosScore = new int[this.targetDeco.size()];
        for (int x = 0; x < this.targetDeco.size(); ++x) {
            PSItem deco = this.targetDeco.get(x);
            int score = 0;
            for (int i = 0; i < deco.skills.size(); ++i) {
                SkillKind kind = deco.skills.kind(i);
                int point = deco.skills.point(i);
                boolean positive = deco.skills.positive(i);
                for (int j = 0; j < this.targetSkill.size(); ++j) {
                    SkillKind targetKind = this.targetSkill.kind(j);
                    int targetPoint = this.targetSkill.point(j);
                    boolean targetPositive = this.targetSkill.positive(j);
                    if (targetKind != kind) continue;
                    if (targetPositive) {
                        if (point < 0 || targetPoint <= 0) continue;
                        score += point;
                        continue;
                    }
                    if (point > 0 || targetPoint >= 0) continue;
                    score -= point;
                }
            }
            if (score <= 0) continue;
            this.decosScore[x] = score;
        }
        this.maxScoreOfSlot = new int[4];
        this.maxScoreOfSlot[0] = this.calcScoreForSlot(0, this.targetDeco);
        this.maxScoreOfSlot[1] = this.calcScoreForSlot(1, this.targetDeco);
        this.maxScoreOfSlot[2] = this.calcScoreForSlot(2, this.targetDeco);
        this.maxScoreOfSlot[3] = this.calcScoreForSlot(3, this.targetDeco);
    }

    public int calcScoreForSlot(int maxSlot, ArrayList<PSItem> listDeco) {
        int max = 0;
        for (int x = 0; x < this.targetDeco.size(); ++x) {
            PSItem deco = this.targetDeco.get(x);
            int score = this.decosScore[x];
            int slot = deco.slotCount;
            if (score <= 0 || slot <= 0 || maxSlot < slot) continue;
            if (maxSlot >= slot + 1) {
                score += this.calcScoreForSlot(maxSlot - slot, listDeco);
            }
            if (max >= score) continue;
            max = score;
        }
        return max;
    }

    @Override
    public void addColumn(ArrayList column) {
        this.arrayColumnList.add(column);
    }

    @Override
    public long iteratorCount() {
        long x = 1L;
        for (int i = 0; i < this.arrayColumnList.size(); ++i) {
            ArrayList column = this.arrayColumnList.get(i);
            x *= (long)column.size();
        }
        return x;
    }

    @Override
    public void start() {
        int i;
        ArrayList array0 = this.arrayColumnList.get(0);
        PSWrap w00 = (PSWrap)array0.get(0);
        if (w00.item.itemType != 1) {
            ArrayList array1 = this.arrayColumnList.get(1);
            this.arrayColumnList.set(0, array1);
            this.arrayColumnList.set(1, array0);
        }
        this.columnIndex = new int[this.arrayColumnList.size()];
        this.columnWeight = new int[this.arrayColumnList.size()];
        this.needAboutParts = new int[this.arrayColumnList.size()];
        this.needAboutCopie = new int[this.arrayColumnList.size()];
        this.topOfTheParts = new int[this.arrayColumnList.size()];
        for (int i2 = 0; i2 < this.arrayColumnList.size(); ++i2) {
            int weight = 1;
            for (int x = i2 + 1; x < this.arrayColumnList.size(); ++x) {
                int width = this.arrayColumnList.get(x).size();
                weight *= width;
            }
            this.columnWeight[i2] = weight;
        }
        for (ArrayList column : this.arrayColumnList) {
            for (Object obj : column) {
                PSWrap wrap = (PSWrap)obj;
                SkillSet skillW = wrap.maskedSkills;
                if (skillW != null && skillW.isFixedBy(this.targetSkill)) continue;
                wrap.maskedSkills = wrap.item.skills.fixColumnBy(this.targetSkill);
            }
        }
        for (i = 0; i < this.arrayColumnList.size(); ++i) {
            ArrayList column = this.arrayColumnList.get(i);
            PSWrap top = null;
            for (Object obj : column) {
                PSWrap wrap = (PSWrap)obj;
                int tmp = this.maxScoreOfSlot[wrap.item.slotCount];
                SkillSet skills = wrap.maskedSkills;
                for (int x = 0; x < skills.size(); ++x) {
                    SkillKind kind = skills.kind(x);
                    int point = skills.point(x);
                    boolean positive = skills.positive(x);
                    if (positive) {
                        if (point <= 0) continue;
                        if (point > this.targetSkill.point(x)) {
                            tmp += this.targetSkill.point(x);
                            continue;
                        }
                        tmp += point;
                        continue;
                    }
                    if (point >= 0) continue;
                    if (point < this.targetSkill.point(x)) {
                        tmp -= this.targetSkill.point(x);
                        continue;
                    }
                    tmp -= point;
                }
                if (tmp < 0) {
                    tmp = 0;
                }
                wrap.maskedSkillsSummary = tmp;
                if (top == null) {
                    top = wrap;
                    continue;
                }
                if (tmp <= top.maskedSkillsSummary) continue;
                top = wrap;
            }
            this.topOfTheParts[i] = top == null ? 0 : top.maskedSkillsSummary;
            Collections.sort(column, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    PSWrap w1 = (PSWrap)o1;
                    PSWrap w2 = (PSWrap)o2;
                    if (w1.item.isCopieSkill) {
                        if (w2.item.isCopieSkill) {
                            return 0;
                        }
                        return -1;
                    }
                    if (w2.item.isCopieSkill) {
                        return 1;
                    }
                    if (w1.maskedSkillsSummary > w2.maskedSkillsSummary) {
                        return -1;
                    }
                    if (w1.maskedSkillsSummary == w2.maskedSkillsSummary) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        this.needTotal = 0;
        for (i = 0; i < this.targetSkill.size(); ++i) {
            if (this.targetSkill.positive(i)) {
                if (this.targetSkill.point(i) <= 0) continue;
                this.needTotal += this.targetSkill.point(i);
                continue;
            }
            if (this.targetSkill.point(i) >= 0) continue;
            this.needTotal -= this.targetSkill.point(i);
        }
        if (this.weaponSlotCount >= 1) {
            this.needTotal = this.needTotal >= this.maxScoreOfSlot[this.weaponSlotCount] ? (this.needTotal -= this.maxScoreOfSlot[this.weaponSlotCount]) : 0;
        }
        for (i = 0; i < this.arrayColumnList.size(); ++i) {
            int need = this.needTotal;
            int needBody = this.needTotal;
            for (int j = i + 1; j < this.arrayColumnList.size(); ++j) {
                need -= this.topOfTheParts[j];
                if (this.topOfTheParts[0] > this.topOfTheParts[j]) {
                    needBody -= this.topOfTheParts[0];
                    continue;
                }
                needBody -= this.topOfTheParts[j];
            }
            this.needAboutParts[i] = need;
            this.needAboutCopie[i] = needBody;
        }
        this.skipCount = 0L;
    }

    int getFailedColumn(ArrayList listWrap) {
        boolean hasBodyCopie = false;
        for (int x = 0; x < listWrap.size(); ++x) {
            PSWrap wrap = (PSWrap)listWrap.get(x);
            if (!wrap.item.isCopieSkill) continue;
            hasBodyCopie = true;
            break;
        }
        int summary = 0;
        int failed = -1;
        if (hasBodyCopie) {
            PSWrap body = (PSWrap)listWrap.get(0);
            summary = body.maskedSkillsSummary;
            for (int x = 1; x < listWrap.size(); ++x) {
                PSWrap wrap = (PSWrap)listWrap.get(x);
                summary = wrap.item.isCopieSkill ? (summary += body.maskedSkillsSummary) : (summary += wrap.maskedSkillsSummary);
                if (this.needAboutCopie[x] <= summary) continue;
                return x;
            }
        } else {
            for (int x = 0; x < listWrap.size(); ++x) {
                PSWrap wrap = (PSWrap)listWrap.get(x);
                if (this.needAboutParts[x] <= (summary += wrap.maskedSkillsSummary)) continue;
                return x;
            }
        }
        return -1;
    }

    boolean fetchInternal(ArrayList result) {
        if (this.endOfMatrix) {
            return false;
        }
        result.clear();
        for (int i = 0; i < this.arrayColumnList.size(); ++i) {
            ArrayList e = this.arrayColumnList.get(i);
            result.add(e.get(this.columnIndex[i]));
        }
        return true;
    }

    @Override
    public long skipCount() {
        return this.skipCount - this.returnCount;
    }

    @Override
    public boolean next(ArrayList result) {
        while (true) {
            boolean ret;
            if (!(ret = this.fetchInternal(result))) {
                return false;
            }
            int failed = this.getFailedColumn(result);
            if (failed < 0) break;
            boolean hasBodyCopie = false;
            for (int x = 0; x < result.size(); ++x) {
                PSWrap wrap = (PSWrap)result.get(x);
                if (!wrap.item.isCopieSkill) continue;
                hasBodyCopie = true;
                break;
            }
            if (hasBodyCopie || failed == 0) {
                this.skipToNext(failed);
                continue;
            }
            this.skipToNext(failed - 1);
        }
        this.skipToNext(this.arrayColumnList.size() - 1);
        PSWrap head = (PSWrap)result.get(1);
        PSWrap body = (PSWrap)result.get(0);
        result.set(0, head);
        result.set(1, body);
        ++this.returnCount;
        return true;
    }

    boolean skipToNext(int column) {
        block7: {
            if (this.endOfMatrix) {
                return false;
            }
            if (column < 0) {
                this.endOfMatrix = true;
                return false;
            }
            boolean firstEnter = true;
            do {
                long orgSkip = this.skipCount;
                int n = column;
                this.columnIndex[n] = this.columnIndex[n] + 1;
                if (firstEnter) {
                    this.skipCount += (long)this.columnWeight[column];
                    firstEnter = false;
                    boolean deced = false;
                    if (column + 1 <= this.arrayColumnList.size()) {
                        for (int j = column + 1; j < this.arrayColumnList.size(); ++j) {
                            int x1 = this.columnWeight[j] * this.columnIndex[j];
                            this.skipCount -= (long)x1;
                            if (x1 == 0) continue;
                            deced = true;
                        }
                    }
                }
                for (int j = column + 1; j < this.arrayColumnList.size(); ++j) {
                    this.columnIndex[j] = 0;
                }
                ArrayList e = this.arrayColumnList.get(column);
                if (this.columnIndex[column] < e.size()) break block7;
            } while (--column >= 0);
            this.endOfMatrix = true;
            return false;
        }
        return true;
    }
}

