/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import portablesimulator.MatrixBuilder;
import portablesimulator.PSItem;
import portablesimulator.PSWrap;
import portablesimulator.csv.PSSession;
import portablesimulator.skillset.SkillSet;

public final class PSArmorSet
implements Comparable {
    public int weaponSlotCount = 0;
    public int totalSlotCount = 0;
    public int shellFire = 0;
    public int shellWater = 0;
    public int shellIce = 0;
    public int shellThunder = 0;
    public int shellDragon = 0;
    public int bodyCopieCount;
    public final ArrayList<PSWrap> listItems = new ArrayList();
    public SkillSet targetSkills;
    public SkillSet setSkills;
    public int defMax;
    public int defInitial;
    public int mysetNumber = -1;
    public String mysetName = null;
    public String mysetPicturePath = null;
    public PSSession session = null;

    public PSArmorSet makeSetCopy() {
        PSArmorSet obj = new PSArmorSet();
        obj.listItems.addAll(this.listItems);
        obj.mysetNumber = this.mysetNumber;
        obj.mysetName = this.mysetName;
        obj.weaponSlotCount = this.weaponSlotCount;
        if (this.session != null) {
            obj.session = this.session.makeCopy();
        }
        obj.targetSkills = new SkillSet();
        obj.targetSkills.set_all(this.targetSkills);
        obj.setSkills = new SkillSet();
        obj.setSkills.set_all(this.setSkills);
        obj.calculateUseList(obj.targetSkills);
        return obj;
    }

    public void calculateUseList(SkillSet useMaskedSkills) {
        this.bodyCopieCount = 0;
        this.defMax = 0;
        this.defInitial = 0;
        this.totalSlotCount = 0;
        this.shellFire = 0;
        this.shellWater = 0;
        this.shellIce = 0;
        this.shellThunder = 0;
        this.shellDragon = 0;
        SkillSet skills = new SkillSet();
        if (skills != null && useMaskedSkills != null) {
            skills.initWithColumn(useMaskedSkills);
        }
        PSWrap body = this.listItems.get(1);
        if (body.item.isVirtual && body.virtualList != null) {
            PSWrap seek = null;
            for (int x = 0; x < body.virtualList.size(); ++x) {
                PSWrap internal = body.virtualList.get(x);
                if (seek != null && internal.item.defMax <= seek.item.defMax) continue;
                seek = internal;
            }
            if (seek != null) {
                body = seek;
                if (body.maskedSkills == null) {
                    body.maskedSkills = new SkillSet();
                }
            }
        }
        for (int i = 0; i < this.listItems.size(); ++i) {
            PSWrap wrap = this.listItems.get(i);
            boolean fromVirtual = false;
            if (wrap.item.isVirtual && wrap.virtualList != null) {
                PSWrap seek = null;
                for (int x = 0; x < wrap.virtualList.size(); ++x) {
                    PSWrap internal = wrap.virtualList.get(x);
                    if (seek != null && internal.item.defMax <= seek.item.defMax) continue;
                    seek = internal;
                }
                if (seek != null) {
                    wrap = seek;
                    fromVirtual = true;
                    if (wrap.maskedSkills == null && useMaskedSkills != null) {
                        wrap.maskedSkills = new SkillSet().fixColumnBy(useMaskedSkills);
                    }
                }
            }
            PSItem item = wrap.item;
            this.defMax += item.defMax;
            this.defInitial += item.defInitial;
            if (!fromVirtual) {
                this.shellFire += item.shellFire;
                this.shellWater += item.shellWater;
                this.shellIce += item.shellIce;
                this.shellThunder += item.shellThunder;
                this.shellDragon += item.shellDragon;
            }
            this.totalSlotCount += item.slotCount;
            if (item.isCopieSkill) {
                wrap = body;
                item = wrap.item;
                ++this.bodyCopieCount;
            }
            if (skills == null || fromVirtual) continue;
            if (useMaskedSkills != null) {
                if (skills.listKind == useMaskedSkills.listKind) {
                    wrap.maskedSkills = wrap.item.skills.fixColumnBy(useMaskedSkills);
                    skills.sum_fixed(wrap.maskedSkills);
                    continue;
                }
                skills.sum_fixed(wrap.maskedSkills);
                continue;
            }
            skills.sum_all(item.skills);
        }
        this.setSkills = skills;
    }

    public int createChildSet(boolean onlyCharm, Collection<PSArmorSet> list, TreeSet<PSArmorSet> already) {
        int count = 0;
        ArrayList<PSWrap> newSet = new ArrayList<PSWrap>(this.listItems.size());
        for (int i = 0; i < this.listItems.size(); ++i) {
            if (onlyCharm && i != 5) continue;
            newSet.clear();
            newSet.addAll(this.listItems);
            ArrayList<PSWrap> childI = this.listItems.get((int)i).childArmors;
            for (int n = 0; n < childI.size(); ++n) {
                newSet.set(i, (PSWrap)childI.get(n));
                PSArmorSet newSetObj = this.makeSetCopy();
                newSetObj.listItems.clear();
                newSetObj.listItems.addAll(newSet);
                if (already.contains(newSetObj)) continue;
                already.add(newSetObj);
                list.add(newSetObj);
                ++count;
            }
        }
        return count;
    }

    public void drawArmorSets(List<PSArmorSet> listList, boolean searchMatome, boolean searchCharmMatome) {
        MatrixBuilder matrix = new MatrixBuilder();
        for (PSWrap item : this.listItems) {
            ArrayList<PSWrap> list = new ArrayList<PSWrap>();
            if (item.item.itemType == 5) {
                if (searchCharmMatome) {
                    list.add(item);
                    if (item.sameArmors != null) {
                        for (PSWrap same : item.sameArmors) {
                            list.add(same);
                        }
                    }
                } else {
                    if (item.charmGroup != null) {
                        for (PSWrap same : item.charmGroup) {
                            list.add(same);
                        }
                    } else {
                        list.add(item);
                    }
                    if (item.sameArmors != null) {
                        for (PSWrap same : item.sameArmors) {
                            list.add(same);
                        }
                    }
                }
            } else if (searchMatome) {
                list.add(item);
                for (PSWrap same : item.sameArmors) {
                    list.add(same);
                }
            } else if (!item.item.isVirtual) {
                list.add(item);
                for (PSWrap same : item.sameArmors) {
                    list.add(same);
                }
            } else {
                if (item.item.isVirtualNone) {
                    list.add(item);
                }
                if (item.virtualList != null) {
                    list.addAll(item.virtualList);
                }
                for (PSWrap same : item.sameArmors) {
                    list.add(same);
                }
            }
            matrix.addColumn(list);
        }
        matrix.start();
        ArrayList fetch = new ArrayList(this.listItems.size());
        while (matrix.next(fetch)) {
            PSArmorSet set = this.makeSetCopy();
            set.listItems.clear();
            for (PSWrap item : fetch) {
                set.listItems.add(item);
            }
            set.calculateUseList(null);
            listList.add(set);
        }
    }

    public String getShellValuesAsText() {
        int shellTotal = this.shellFire + this.shellWater + this.shellIce + this.shellThunder + this.shellDragon;
        return "\u706b[" + this.shellFire + "] " + "\u6c34[" + this.shellWater + "] " + "\u6c37[" + this.shellIce + "] " + "\u96f7[" + this.shellThunder + "] " + "\u9f8d[" + this.shellDragon + "] " + "\u8a08[" + shellTotal + "]";
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(String.valueOf(this.defMax));
        str.append("[");
        str.append(String.valueOf(this.weaponSlotCount));
        str.append("]");
        for (int i = 0; i < this.listItems.size(); ++i) {
            str.append(",");
            str.append(this.listItems.get((int)i).item.getArmorNameAndSlot());
        }
        str.append(",");
        str.append(this.getShellValuesAsText());
        return str.toString();
    }

    public int hashCode() {
        int x = 0;
        for (int i = 0; i < this.listItems.size(); ++i) {
            x += this.listItems.get(i).hashCode();
        }
        return x;
    }

    public int compareTo(Object o) {
        PSArmorSet set = (PSArmorSet)o;
        if (set == this) {
            return 0;
        }
        for (int i = 0; i < this.listItems.size(); ++i) {
            PSWrap a2;
            PSWrap a1 = this.listItems.get(i);
            if (a1 == (a2 = set.listItems.get(i))) continue;
            int x = a1.item.compareTo(a2.item);
            if (x > 0) {
                return 1;
            }
            if (x >= 0) continue;
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }
}

