/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import portablesimulator.PSItem;
import portablesimulator.PSItemMaterial;
import portablesimulator.csv.CSVReader;
import portablesimulator.csv.PSBaseItems;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillPoint;

class MH3GDataIO {
    public void readAll() throws IOException {
        this.readSkillsCSV("data_mh3g/MH3SKILL.csv");
        this.readSkillCategories("data_mh3g/conf/CATEGORY.txt");
        this.readSkillFukugo("data_mh3g/conf/FUKUGO.txt");
        ArrayList<PSItem> listEquipHead = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipBody = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipArm = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipWeist = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipLeg = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipHead = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipBody = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipArm = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipWeist = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipLeg = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipHead = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipBody = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipArm = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipWeist = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipLeg = new ArrayList<PSItem>();
        this.readEquipmentCSV(0, "data_mh3g/MH3EQUIP_HEAD.csv", listEquipHead);
        this.readEquipmentCSV(1, "data_mh3g/MH3EQUIP_BODY.csv", listEquipBody);
        this.readEquipmentCSV(2, "data_mh3g/MH3EQUIP_ARM.csv", listEquipArm);
        this.readEquipmentCSV(3, "data_mh3g/MH3EQUIP_WST.csv", listEquipWeist);
        this.readEquipmentCSV(4, "data_mh3g/MH3EQUIP_LEG.csv", listEquipLeg);
        this.readEquipmentCSV(0, "data_mh3g/MH3EQUIP_USER_HEAD.csv", listUserEquipHead);
        this.readEquipmentCSV(1, "data_mh3g/MH3EQUIP_USER_BODY.csv", listUserEquipBody);
        this.readEquipmentCSV(2, "data_mh3g/MH3EQUIP_USER_ARM.csv", listUserEquipArm);
        this.readEquipmentCSV(3, "data_mh3g/MH3EQUIP_USER_WST.csv", listUserEquipWeist);
        this.readEquipmentCSV(4, "data_mh3g/MH3EQUIP_USER_LEG.csv", listUserEquipLeg);
        this.readEquipmentCSV(0, "data_mh3g/MH3EQUIP_TRASH_HEAD.csv", listTrashEquipHead);
        this.readEquipmentCSV(1, "data_mh3g/MH3EQUIP_TRASH_BODY.csv", listTrashEquipBody);
        this.readEquipmentCSV(2, "data_mh3g/MH3EQUIP_TRASH_ARM.csv", listTrashEquipArm);
        this.readEquipmentCSV(3, "data_mh3g/MH3EQUIP_TRASH_WST.csv", listTrashEquipWeist);
        this.readEquipmentCSV(4, "data_mh3g/MH3EQUIP_TRASH_LEG.csv", listTrashEquipLeg);
        ArrayList<PSItem> listDecoration = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserDecoration = new ArrayList<PSItem>();
        ArrayList listTrashDecoration = new ArrayList();
        this.readDecorationCSV(6, "data_mh3g/MH3DECO.csv", listDecoration);
        this.readDecorationCSV(6, "data_mh3g/MH3DECO_USER.csv", listUserDecoration);
        this.readDecorationCSV(6, "data_mh3g/MH3DECO_TRASH.csv", listUserDecoration);
        PSBaseItems cont = Repository.getBaseItems();
        cont.listBaseEquipHead = listEquipHead;
        cont.listBaseEquipBody = listEquipBody;
        cont.listBaseEquipArm = listEquipArm;
        cont.listBaseEquipWeist = listEquipWeist;
        cont.listBaseEquipLeg = listEquipLeg;
        cont.listBaseCharm = new ArrayList();
        cont.listBaseDecoration = listDecoration;
        cont.listUserEquipHead = listUserEquipHead;
        cont.listUserEquipBody = listUserEquipBody;
        cont.listUserEquipArm = listUserEquipArm;
        cont.listUserEquipWeist = listUserEquipWeist;
        cont.listUserEquipLeg = listUserEquipLeg;
        cont.listUserCharm = new ArrayList();
        cont.listUserDecoration = listUserDecoration;
        cont.listTrashEquipHead = listTrashEquipHead;
        cont.listTrashEquipBody = listTrashEquipBody;
        cont.listTrashEquipArm = listTrashEquipArm;
        cont.listTrashEquipWeist = listTrashEquipWeist;
        cont.listTrashEquipLeg = listTrashEquipLeg;
        cont.listTrashCharm = new ArrayList();
        cont.listTrashDecoration = listTrashDecoration;
        cont.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSkillsCSV(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        ArrayList<String> str = new ArrayList<String>();
        try {
            while (in.readLine(str)) {
                String skillName = (String)str.get(0);
                String skillKind = (String)str.get(1);
                int skillPoint = Integer.parseInt((String)str.get(2));
                int hunterType = Integer.parseInt((String)str.get(3));
                SkillKind kindObj = null;
                kindObj = categories.findKindByName(skillKind);
                if (kindObj == null) {
                    kindObj = new SkillKind(skillKind);
                    categories.addSkillKind(kindObj);
                }
                SkillPoint rank = new SkillPoint(kindObj, skillPoint, skillPoint > 0, skillName);
                categories.addPoint(rank);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readEquipmentCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = null;
        ArrayList<String> str = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();
        try {
            try {
                in = new CSVReader(fileName);
            }
            catch (IOException e) {
                if (in != null) {
                    in.close();
                }
                return;
            }
            while (in.readLine(str)) {
                int i;
                PSItem item = new PSItem(itemType);
                Iterator it = str.iterator();
                item.name = (String)it.next();
                item.genderType = Integer.parseInt((String)it.next());
                item.hunterType = Integer.parseInt((String)it.next());
                item.rareRank = Integer.parseInt((String)it.next());
                item.slotCount = Integer.parseInt((String)it.next());
                item.existHunterRank = Integer.parseInt((String)it.next());
                item.existTownRank = Integer.parseInt((String)it.next());
                item.defInitial = Integer.parseInt((String)it.next());
                item.defMax = Integer.parseInt((String)it.next());
                item.shellFire = Integer.parseInt((String)it.next());
                item.shellWater = Integer.parseInt((String)it.next());
                item.shellIce = Integer.parseInt((String)it.next());
                item.shellThunder = Integer.parseInt((String)it.next());
                item.shellDragon = Integer.parseInt((String)it.next());
                for (i = 0; it.hasNext() && i < 5; ++i) {
                    String name = (String)it.next();
                    int point = 0;
                    try {
                        if (name.length() == 0) {
                            it.next();
                            continue;
                        }
                        point = Integer.parseInt((String)it.next());
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (name.equals("\u80f4\u7cfb\u7d71\u8907\u88fd") || name.equals("\u80f4\u7cfb\u7d71\u500d\u52a0") || name.equals("\u80f4\u7cfb\u7d71\u500d\u5316")) {
                        item.isCopieSkill = true;
                        continue;
                    }
                    if (name.startsWith("---")) continue;
                    SkillKind kind = categories.findKindByName(name);
                    if (kind == null) {
                        System.out.println("Kind [" + name + "] not found for item " + item);
                        continue;
                    }
                    item.skills.set(kind, point, true);
                }
                for (i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = ((String)it.next()).intern();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt((String)it.next());
                        item.materialAList.add(material);
                        continue;
                    }
                    if (!it.hasNext()) continue;
                    it.next();
                }
                list.add(item);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDecorationCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = null;
        ArrayList<String> str = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();
        try {
            try {
                in = new CSVReader(fileName);
            }
            catch (IOException e) {
                if (in != null) {
                    in.close();
                }
                return;
            }
            while (in.readLine(str)) {
                PSItemMaterial material;
                int i;
                PSItem item = new PSItem(itemType);
                Iterator it = str.iterator();
                item.name = (String)it.next();
                item.rareRank = Integer.parseInt((String)it.next());
                item.slotCount = Integer.parseInt((String)it.next());
                item.existHunterRank = Integer.parseInt((String)it.next());
                item.existTownRank = Integer.parseInt((String)it.next());
                for (i = 0; it.hasNext() && i < 2; ++i) {
                    String name = (String)it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    int point = Integer.parseInt((String)it.next());
                    if (name.startsWith("---")) continue;
                    SkillKind kind = categories.findKindByName(name);
                    item.skills.set(kind, point, true);
                }
                for (i = 0; it.hasNext() && i < 4; ++i) {
                    material = new PSItemMaterial();
                    material.name = ((String)it.next()).intern();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt((String)it.next());
                        item.materialAList.add(material);
                        continue;
                    }
                    if (!it.hasNext()) continue;
                    it.next();
                }
                for (i = 0; it.hasNext() && i < 4; ++i) {
                    material = new PSItemMaterial();
                    material.name = (String)it.next();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt((String)it.next());
                        item.materialBList.add(material);
                        continue;
                    }
                    if (!it.hasNext()) continue;
                    it.next();
                }
                list.add(item);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCharmCSVFile(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = new CSVReader(fileName);
        ArrayList infoList = new ArrayList();
        ArrayList<String> str = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();
        try {
            while (in.readLine(str)) {
                PSItem item = new PSItem(itemType);
                Iterator it = str.iterator();
                item.name = (String)it.next();
                item.slotCount = Integer.parseInt((String)it.next());
                for (int i = 0; it.hasNext() && i < 2; ++i) {
                    String name = (String)it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    int point = Integer.parseInt((String)it.next());
                    try {
                        SkillKind kind = categories.findKindByName(name);
                        item.skills.set(kind, point, true);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                list.add(item);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSkillCategories(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        ArrayList<String> str = new ArrayList<String>();
        try {
            block3: while (in.readLine(str)) {
                String categoryName = (String)str.get(0);
                categories.addCategory(categoryName);
                int i = 1;
                while (true) {
                    if (i >= str.size()) continue block3;
                    String skillName = (String)str.get(i);
                    categories.setCategory(categoryName, skillName);
                    ++i;
                }
                break;
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSkillFukugo(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        ArrayList<String> str = new ArrayList<String>();
        try {
            while (in.readLine(str)) {
                String nameFukugo = (String)str.get(0);
                SkillPoint pointFukugo = Repository.getSkillCategories().pointNameToPoint(nameFukugo);
                if (pointFukugo == null) {
                    System.out.println("\u8907\u5408\u30b9\u30ad\u30eb\u5931\u6557\uff11\uff1a" + nameFukugo);
                    continue;
                }
                ArrayList<SkillPoint> listPoint = new ArrayList<SkillPoint>();
                for (int i = 1; i < str.size(); ++i) {
                    String name2 = (String)str.get(i);
                    SkillPoint point2 = Repository.getSkillCategories().pointNameToPoint(name2);
                    if (point2 == null) {
                        System.out.println("\u8907\u5408\u30b9\u30ad\u30eb\u5931\u6557\uff12\uff1a" + name2);
                        continue;
                    }
                    listPoint.add(point2);
                }
                Repository.getFukugo().mapFukugo.put(pointFukugo, listPoint);
            }
        }
        finally {
            in.close();
        }
    }
}

