/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import portablesimulator.PSItem;
import portablesimulator.PSItemMaterial;
import portablesimulator.csv.CSVReader;
import portablesimulator.csv.PSBaseItems;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillPoint;

class MHP2GDataIO {
    public void readAll() throws IOException {
        this.readSkillsCSV("data_mhp2g/SKILL_EQ.csv");
        this.readSkillFukugo("data_mhp2g/conf/FUKUGO.txt");
        ArrayList<PSItem> listEquipHead = new ArrayList<PSItem>();
        this.readEquipmentCSV(0, "data_mhp2g/MHP2EQUIP_HEAD.csv", listEquipHead);
        ArrayList<PSItem> listEquipBody = new ArrayList<PSItem>();
        this.readEquipmentCSV(1, "data_mhp2g/MHP2EQUIP_BODY.csv", listEquipBody);
        ArrayList<PSItem> listEquipArm = new ArrayList<PSItem>();
        this.readEquipmentCSV(2, "data_mhp2g/MHP2EQUIP_ARM.csv", listEquipArm);
        ArrayList<PSItem> listEquipWeist = new ArrayList<PSItem>();
        this.readEquipmentCSV(3, "data_mhp2g/MHP2EQUIP_WST.csv", listEquipWeist);
        ArrayList<PSItem> listEquipLeg = new ArrayList<PSItem>();
        this.readEquipmentCSV(4, "data_mhp2g/MHP2EQUIP_LEG.csv", listEquipLeg);
        ArrayList<PSItem> listDecoration = new ArrayList<PSItem>();
        this.readDecorationCSV(6, "data_mhp2g/MHP2EQUIP_DECO.csv", listDecoration);
        PSBaseItems cont = Repository.getBaseItems();
        cont.listBaseEquipHead = listEquipHead;
        cont.listBaseEquipBody = listEquipBody;
        cont.listBaseEquipArm = listEquipArm;
        cont.listBaseEquipWeist = listEquipWeist;
        cont.listBaseEquipLeg = listEquipLeg;
        cont.listBaseCharm = new ArrayList();
        cont.listBaseDecoration = listDecoration;
        cont.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSkillsCSV(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        ArrayList<String> str = new ArrayList<String>();
        try {
            while (in.readLine(str)) {
                String skillName = (String)str.get(0);
                String skillKind = (String)str.get(1);
                int skillPoint = Integer.parseInt((String)str.get(2));
                int hunterType = Integer.parseInt((String)str.get(3));
                String category = (String)str.get(4);
                SkillKind kindObj = null;
                kindObj = categories.findKindByName(skillKind);
                if (kindObj == null) {
                    kindObj = new SkillKind(skillKind);
                    categories.addSkillKind(kindObj);
                }
                SkillPoint rank = new SkillPoint(kindObj, skillPoint, skillPoint > 0, skillName);
                categories.addPoint(rank);
                categories.setCategory(category, skillName);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readEquipmentCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        ArrayList<String> str = new ArrayList<String>();
        try (CSVReader in = new CSVReader(fileName);){
            while (in.readLine(str)) {
                PSItemMaterial material;
                int i;
                PSItem item = new PSItem(itemType);
                Iterator it = str.iterator();
                item.name = (String)it.next();
                item.genderType = Integer.parseInt((String)it.next());
                item.hunterType = Integer.parseInt((String)it.next());
                item.rareRank = Integer.parseInt((String)it.next());
                item.slotCount = Integer.parseInt((String)it.next());
                if (item.rareRank >= 9) {
                    item.existHunterRank = 3;
                    item.existTownRank = 3;
                } else if (item.rareRank >= 6) {
                    item.existHunterRank = 2;
                    item.existTownRank = 2;
                } else {
                    item.existHunterRank = 1;
                    item.existTownRank = 1;
                }
                item.defInitial = Integer.parseInt((String)it.next());
                item.defMax = Integer.parseInt((String)it.next());
                item.shellFire = Integer.parseInt((String)it.next());
                item.shellWater = Integer.parseInt((String)it.next());
                item.shellIce = Integer.parseInt((String)it.next());
                item.shellThunder = Integer.parseInt((String)it.next());
                item.shellDragon = Integer.parseInt((String)it.next());
                for (i = 0; it.hasNext() && i < 5; ++i) {
                    String name = (String)it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    int point = Integer.parseInt((String)it.next());
                    if (name.equals("\u306a\u3057")) continue;
                    if (name.startsWith("\u80f4\u7cfb\u500d\u52a0")) {
                        item.isCopieSkill = true;
                        continue;
                    }
                    SkillKind kind = Repository.getSkillCategories().findKindByName(name);
                    if (kind == null) {
                        System.out.println("Unknown Kind " + name);
                        continue;
                    }
                    item.skills.set(kind, point, true);
                }
                for (i = 0; it.hasNext() && i < 5; ++i) {
                    material = new PSItemMaterial();
                    material.name = (String)it.next();
                    if (material.name.length() != 0 && it.hasNext()) {
                        material.count = Integer.parseInt((String)it.next());
                        item.materialAList.add(material);
                        continue;
                    }
                    if (!it.hasNext()) continue;
                    it.next();
                }
                for (i = 0; it.hasNext() && i < 2; ++i) {
                    material = new PSItemMaterial();
                    material.name = (String)it.next();
                    if (material.name.length() != 0 && it.hasNext()) {
                        material.count = Integer.parseInt((String)it.next());
                        item.materialBList.add(material);
                        continue;
                    }
                    if (!it.hasNext()) continue;
                    it.next();
                }
                list.add(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDecorationCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        ArrayList<String> str = new ArrayList<String>();
        try (CSVReader in = new CSVReader(fileName);){
            while (in.readLine(str)) {
                int i;
                PSItem item = new PSItem(itemType);
                Iterator it = str.iterator();
                item.name = (String)it.next();
                item.rareRank = Integer.parseInt((String)it.next());
                item.slotCount = Integer.parseInt((String)it.next());
                item.existHunterRank = 0;
                item.existTownRank = 0;
                for (int i2 = 0; it.hasNext() && i2 < 2; ++i2) {
                    String name = (String)it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    if (name.equals("\u306a\u3057")) {
                        if (!it.hasNext()) continue;
                        it.next();
                        continue;
                    }
                    int point = Integer.parseInt((String)it.next());
                    SkillKind kind = Repository.getSkillCategories().findKindByName(name);
                    if (kind == null) {
                        System.out.println("Unknown Decoration Kind " + name);
                        continue;
                    }
                    item.skills.set(kind, point, true);
                }
                String level = (String)it.next();
                if (level.equals("\u4e0b")) {
                    item.existHunterRank = 1;
                    item.existTownRank = 1;
                }
                if (level.equals("\u4e0a")) {
                    item.existHunterRank = 2;
                    item.existTownRank = 2;
                }
                if (level.equals("\uff27")) {
                    item.existHunterRank = 3;
                    item.existTownRank = 99;
                }
                for (i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = (String)it.next();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt((String)it.next());
                        item.materialAList.add(material);
                        continue;
                    }
                    if (!it.hasNext()) continue;
                    it.next();
                }
                for (i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = (String)it.next();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt((String)it.next());
                        item.materialBList.add(material);
                        continue;
                    }
                    if (!it.hasNext()) continue;
                    it.next();
                }
                list.add(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSkillCategories(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        ArrayList<String> str = new ArrayList<String>();
        try {
            block3: while (in.readLine(str)) {
                String categoryName = (String)str.get(0);
                categories.addCategory(categoryName);
                int i = 1;
                while (true) {
                    if (i >= str.size()) continue block3;
                    String skillName = (String)str.get(i);
                    categories.setCategory(categoryName, skillName);
                    ++i;
                }
                break;
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSkillFukugo(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        ArrayList<String> str = new ArrayList<String>();
        try {
            while (in.readLine(str)) {
                String nameFukugo = (String)str.get(0);
                SkillPoint pointFukugo = Repository.getSkillCategories().pointNameToPoint(nameFukugo);
                if (pointFukugo == null) {
                    System.out.println("\u8907\u5408\u30b9\u30ad\u30eb\u5931\u6557\uff11\uff1a" + nameFukugo);
                    continue;
                }
                ArrayList<SkillPoint> listPoint = new ArrayList<SkillPoint>();
                for (int i = 1; i < str.size(); ++i) {
                    String name2 = (String)str.get(i);
                    SkillPoint point2 = Repository.getSkillCategories().pointNameToPoint(name2);
                    if (point2 == null) {
                        System.out.println("\u8907\u5408\u30b9\u30ad\u30eb\u5931\u6557\uff12\uff1a" + name2);
                        continue;
                    }
                    listPoint.add(point2);
                }
                Repository.getFukugo().mapFukugo.put(pointFukugo, listPoint);
            }
        }
        finally {
            in.close();
        }
    }
}

