/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.csv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import portablesimulator.csv.CSVReader;
import portablesimulator.csv.PSSession;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class PSConfig {
    public int themeNumber = 0;
    public boolean themeLabelColorful = false;
    public PSSession lastSession = new PSSession();
    public String fontName = "Dialog";
    public int fontSize = 12;
    public int fontStyle = 0;
    File file;
    List<String> cache1 = new ArrayList<String>();

    public PSConfig(String configFile) {
        this.file = new File(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readProperties() throws IOException {
        String key;
        int i;
        if (!this.file.isFile()) {
            return;
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        try (FileInputStream in = new FileInputStream(this.file);){
            String line;
            InputStreamReader reader = new InputStreamReader(in);
            BufferedReader buff = new BufferedReader(reader);
            while ((line = buff.readLine()) != null) {
                int x;
                if (line.length() == 0 || line.charAt(0) == '#' || (x = line.indexOf(61)) < 0) continue;
                String key2 = line.substring(0, x);
                String value = line.substring(x + 1);
                properties.put(key2, value);
            }
        }
        try {
            this.themeNumber = Integer.parseInt((String)properties.get("themeNumber"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.fontName = (String)properties.get("fontName");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.fontStyle = Integer.parseInt((String)properties.get("fontStyle"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.fontSize = Integer.parseInt((String)properties.get("fontSize"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchHunterRank = Integer.parseInt((String)properties.get("searchHunterRank"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchTownRank = Integer.parseInt((String)properties.get("searchTownRank"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchGenderType = Integer.parseInt((String)properties.get("searchGenderType"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchHunterType = Integer.parseInt((String)properties.get("searchHunterType"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchWeaponSlotCount = Integer.parseInt((String)properties.get("searchWeaponSlotCount"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchMaxCount = Long.parseLong((String)properties.get("searchMaxCount"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchSkills = this.StringToSkillSet((String)properties.get("searchSkills"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchMatome = Boolean.parseBoolean((String)properties.get("searchMatome"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchPlusOneFast = Boolean.parseBoolean((String)properties.get("searchPlusOneFast"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchFukugo = Boolean.parseBoolean((String)properties.get("searchFukugo"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchPlusAlpha = Boolean.parseBoolean((String)properties.get("searchPlusAlpha"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchCharmCSVLevel = Integer.parseInt((String)properties.get("searchCharmCSVLevel"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchCharmMatome = Boolean.parseBoolean((String)properties.get("searchCharmMatome"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.lastSession.searchOrderByDeffence = Boolean.parseBoolean((String)properties.get("searchOrderByDeffence"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        ArrayList<String> str = new ArrayList<String>();
        for (i = 0; i < 8; ++i) {
            key = "candidateUnchecked." + i;
            this.lastSession.items.candidateUnchecked[i].clear();
            String value = (String)properties.get(key);
            if (value == null) continue;
            CSVReader.bunkatu(value, ',', str);
            this.lastSession.items.candidateUnchecked[i].addAll(str);
        }
        for (i = 0; i < 8; ++i) {
            key = "viewUnchecked." + i;
            this.lastSession.items.viewUnchecked[i].clear();
            String value = (String)properties.get(key);
            if (value == null) continue;
            CSVReader.bunkatu(value, ',', str);
            this.lastSession.items.viewUnchecked[i].addAll(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProperties() throws IOException {
        String value;
        String key;
        int i;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("themeNumber", Integer.toString(this.themeNumber));
        properties.put("fontName", this.fontName);
        properties.put("fontStyle", Integer.toString(this.fontStyle));
        properties.put("fontSize", Integer.toString(this.fontSize));
        properties.put("searchHunterRank", Integer.toString(this.lastSession.searchHunterRank));
        properties.put("searchTownRank", Integer.toString(this.lastSession.searchTownRank));
        properties.put("searchGenderType", Integer.toString(this.lastSession.searchGenderType));
        properties.put("searchHunterType", Integer.toString(this.lastSession.searchHunterType));
        properties.put("searchWeaponSlotCount", Integer.toString(this.lastSession.searchWeaponSlotCount));
        properties.put("searchSkills", this.SkillSetToString(this.lastSession.searchSkills));
        properties.put("searchMaxCount", Long.toString(this.lastSession.searchMaxCount));
        properties.put("searchMatome", Boolean.toString(this.lastSession.searchMatome));
        properties.put("searchFukugo", Boolean.toString(this.lastSession.searchFukugo));
        properties.put("searchPlusFast", Boolean.toString(this.lastSession.searchPlusOneFast));
        properties.put("searchPlusAlpha", Boolean.toString(this.lastSession.searchPlusAlpha));
        properties.put("searchCharmCSVLevel", Integer.toString(this.lastSession.searchCharmCSVLevel));
        properties.put("searchCharmMatome", Boolean.toString(this.lastSession.searchCharmMatome));
        properties.put("searchOrderByDeffence", Boolean.toString(this.lastSession.searchOrderByDeffence));
        for (i = 0; i < 8; ++i) {
            key = "candidateUnchecked." + i;
            value = this.renketu(this.lastSession.items.candidateUnchecked[i]);
            properties.put(key, value);
        }
        for (i = 0; i < 8; ++i) {
            key = "viewUnchecked." + i;
            value = this.renketu(this.lastSession.items.viewUnchecked[i]);
            properties.put(key, value);
        }
        try (FileOutputStream out = new FileOutputStream(this.file);){
            OutputStreamWriter writer = new OutputStreamWriter(out);
            BufferedWriter buff = new BufferedWriter(writer);
            for (String key2 : properties.keySet()) {
                String value2 = (String)properties.get(key2);
                buff.write(key2);
                buff.write("=");
                if (value2 == null) {
                    value2 = "";
                }
                buff.write(value2);
                buff.write("\n");
            }
            buff.flush();
        }
    }

    public String renketu(Collection<String> list) {
        String[] array = new String[list.size()];
        list.toArray(array);
        return this.renketu(array);
    }

    public String renketu(String[] values) {
        StringBuilder str = new StringBuilder();
        for (String elem : values) {
            if (str.length() != 0) {
                str.append(",");
            }
            if (elem.indexOf(44) > 0) {
                str.append('\"');
                str.append(elem);
                str.append('\"');
                continue;
            }
            str.append(elem);
        }
        return str.toString();
    }

    public String SkillSetToString(SkillSet set) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < set.size(); ++i) {
            list.add(set.kind((int)i).name + "=" + set.point(i) + (set.positive(i) ? "+" : "-"));
        }
        return this.renketu(list);
    }

    public SkillSet StringToSkillSet(String str) {
        SkillSet set = new SkillSet();
        CSVReader.bunkatu(str, ',', this.cache1);
        for (String value : this.cache1) {
            int x = value.indexOf("=");
            String kind = value.substring(0, x);
            value = value.substring(x + 1);
            boolean positiveRange = false;
            if (value.endsWith("+")) {
                positiveRange = true;
                value = value.substring(0, value.length() - 1);
            } else if (value.endsWith("-")) {
                positiveRange = false;
                value = value.substring(0, value.length() - 1);
            }
            SkillKind kindObj = Repository.getSkillCategories().findKindByName(kind);
            set.set(kindObj, Integer.valueOf(value), positiveRange);
        }
        return set;
    }
}

