/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.gui;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import portablesimulator.PSArmorSet;

public class MyListCellArmorSetText
extends DefaultListCellRenderer {
    public Font font = null;
    public List<Integer> widthList = null;
    public Map<String, Integer> cache = new HashMap<String, Integer>();

    public int stringWidth(String text) {
        if (text.length() <= 3 || text.startsWith("\u706b[")) {
            return text.getBytes().length;
        }
        Integer x = this.cache.get(text);
        if (x == null) {
            x = text.getBytes().length;
            this.cache.put(text, x);
        }
        return x;
    }

    public List<Integer> calculateWidth(JList list) {
        if (this.widthList == null) {
            this.widthList = new ArrayList<Integer>();
            if (list.getModel().getSize() > 0) {
                ArrayList<String> line = new ArrayList<String>();
                for (int i = 0; i < list.getModel().getSize(); ++i) {
                    PSArmorSet set = (PSArmorSet)list.getModel().getElementAt(i);
                    line.clear();
                    this.formatArmor(set, line);
                    while (this.widthList.size() < line.size()) {
                        this.widthList.add(0);
                    }
                    for (int x = 0; x < line.size(); ++x) {
                        String v = (String)line.get(x);
                        Integer prev = this.widthList.get(x);
                        int width = this.stringWidth(v);
                        if (prev >= width) continue;
                        this.widthList.set(x, width);
                    }
                }
            }
        }
        return this.widthList;
    }

    public void formatArmor(PSArmorSet set, List<String> line) {
        line.add(String.valueOf(set.defMax));
        line.add("[" + set.weaponSlotCount + "]");
        for (int x = 0; x < set.listItems.size(); ++x) {
            line.add(set.listItems.get((int)x).item.name);
        }
        line.add(set.getShellValuesAsText());
    }

    public void fitArmorLine(JList list, List<String> line) {
        List<Integer> widthList = this.calculateWidth(list);
        for (int x = 0; x < line.size(); ++x) {
            String v = line.get(x);
            Integer fit = widthList.get(x);
            int width = this.stringWidth(v);
            if (width >= fit) continue;
            int step = fit - width;
            StringBuilder str = new StringBuilder(v);
            for (int n = 0; n < step; ++n) {
                str.append(" ");
            }
            line.set(x, str.toString());
        }
    }

    @Override
    public Component getListCellRendererComponent(JList jlist, Object o, int i, boolean bln, boolean bln1) {
        PSArmorSet set = (PSArmorSet)o;
        if (this.font == null) {
            this.font = new Font("Monospaced", 0, 12);
        }
        String value = "";
        if (set != null) {
            ArrayList<String> line = new ArrayList<String>();
            this.formatArmor(set, line);
            this.fitArmorLine(jlist, line);
            StringBuilder str = new StringBuilder();
            for (int x = 0; x < line.size(); ++x) {
                if (x != 0) {
                    str.append(",");
                }
                str.append((String)line.get(x));
            }
            value = str.toString();
        }
        this.setFont(this.font);
        super.getListCellRendererComponent((JList<?>)jlist, value, i, bln, bln1);
        this.setFont(this.font);
        return this;
    }
}

