/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.skillset;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillPoint;

public final class SkillSet
implements Comparable {
    private static final boolean debug = false;
    public SkillKind[] listKind;
    public boolean isRefListKind;
    public boolean[] listPositive;
    public int[] listPoint;
    public int size;
    public static final Comparator<SkillPoint> SKILLPOINT_POINT_COMPARATOR = new Comparator<SkillPoint>(){

        @Override
        public int compare(SkillPoint A, SkillPoint B) {
            int n = A.skillPoint - B.skillPoint;
            if (n < 0) {
                return 1;
            }
            if (n > 0) {
                return -1;
            }
            n = A.skillKind.name.compareTo(B.skillKind.name);
            return n;
        }
    };
    public static final Comparator<SkillPoint> SKILLPOINT_NAME_COMPARATOR = new Comparator<SkillPoint>(){

        @Override
        public int compare(SkillPoint A, SkillPoint B) {
            int n = A.skillKind.name.compareTo(B.skillKind.name);
            return n;
        }
    };

    public SkillSet() {
        this(5);
    }

    public SkillSet(int capacity) {
        this.listKind = new SkillKind[capacity];
        this.listPositive = new boolean[capacity];
        this.listPoint = new int[capacity];
        this.isRefListKind = false;
        this.size = 0;
    }

    public void initWithColumn(SkillSet filter) {
        if (filter.listKind == null) {
            this.isRefListKind = false;
            this.listKind = null;
            this.listPositive = null;
            this.listPoint = null;
            this.size = 0;
        } else {
            this.isRefListKind = true;
            filter.isRefListKind = true;
            this.listKind = filter.listKind;
            this.listPositive = new boolean[filter.listPositive.length];
            this.listPoint = new int[filter.listPoint.length];
            this.size = filter.size;
        }
    }

    private void copyWhenReferences() {
        if (this.isRefListKind) {
            SkillKind[] newKind = new SkillKind[this.listKind.length];
            for (int i = 0; i < this.size; ++i) {
                newKind[i] = this.listKind[i];
            }
            this.listKind = newKind;
            this.isRefListKind = false;
        }
    }

    public void ensureCapacity(int newSize) {
        if (this.listKind == null || newSize > this.listKind.length) {
            SkillKind[] newKind = new SkillKind[newSize];
            int[] newPoint = new int[newSize];
            boolean[] newRange = new boolean[newSize];
            if (this.listKind != null) {
                for (int i = 0; i < this.listPoint.length; ++i) {
                    newKind[i] = this.listKind[i];
                    newPoint[i] = this.listPoint[i];
                    newRange[i] = this.listPositive[i];
                }
            }
            this.listKind = newKind;
            this.listPoint = newPoint;
            this.listPositive = newRange;
            this.isRefListKind = false;
        }
    }

    public void clear() {
        this.size = 0;
    }

    public int indexOfKind(SkillKind kind) {
        for (int i = 0; i < this.size; ++i) {
            if (this.kind(i) != kind) continue;
            return i;
        }
        return -1;
    }

    public int pointOfKind(SkillKind kind) {
        for (int i = 0; i < this.size; ++i) {
            if (this.listKind[i] != kind) continue;
            return this.listPoint[i];
        }
        return 0;
    }

    public void set(SkillKind kind, int point, boolean range) {
        if (kind == null) {
            throw new NullPointerException();
        }
        int index = this.indexOfKind(kind);
        if (index < 0) {
            this.copyWhenReferences();
            index = this.size++;
            if (this.listKind == null) {
                this.ensureCapacity(10);
            } else if (index >= this.listKind.length) {
                this.ensureCapacity(this.listKind.length * 2 + 10);
            }
        }
        this.listKind[index] = kind;
        this.listPositive[index] = range;
        this.listPoint[index] = point;
    }

    public void removeAtIndex(int x) {
        this.copyWhenReferences();
        while (x < this.size - 1) {
            this.listKind[x] = this.listKind[x + 1];
            this.listPositive[x] = this.listPositive[x + 1];
            this.listPoint[x] = this.listPoint[x + 1];
            ++x;
        }
        --this.size;
    }

    public boolean isFixedBy(SkillSet filter) {
        if (this.listKind == filter.listKind) {
            return true;
        }
        if (this.size != filter.size) {
            return false;
        }
        for (int i = 0; i < filter.size; ++i) {
            if (this.listKind[i] == filter.listKind[i]) continue;
            return false;
        }
        return true;
    }

    public SkillSet fixColumnBy(SkillSet filter) {
        SkillSet obj = new SkillSet();
        obj.initWithColumn(filter);
        for (int i = 0; i < filter.size; ++i) {
            SkillKind kind = filter.listKind[i];
            int index = this.indexOfKind(kind);
            int point = index < 0 ? 0 : this.listPoint[index];
            boolean range = index < 0 ? true : this.listPositive[index];
            obj.listPoint[i] = point;
            obj.listPositive[i] = range;
        }
        return obj;
    }

    public int size() {
        return this.size;
    }

    public void minus_fixed(SkillSet slotSkill) {
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.listPoint[n] = this.listPoint[n] - slotSkill.listPoint[i];
        }
    }

    public void minus_only(SkillSet slotSkill) {
        for (int i = 0; i < this.size; ++i) {
            int x = slotSkill.indexOfKind(this.listKind[i]);
            if (x < 0) continue;
            int n = i;
            this.listPoint[n] = this.listPoint[n] - slotSkill.point(x);
        }
    }

    public void add_only(SkillSet slotSkill) {
        for (int i = 0; i < this.size; ++i) {
            int x = slotSkill.indexOfKind(this.listKind[i]);
            if (x < 0) continue;
            int n = i;
            this.listPoint[n] = this.listPoint[n] + slotSkill.point(x);
        }
    }

    public void sum_all(SkillSet sum) {
        if (this.size == 0) {
            this.set_all(sum);
            return;
        }
        if (sum.size == 0) {
            return;
        }
        if (this.isFixedBy(sum)) {
            this.sum_fixed(sum);
            return;
        }
        for (int i = 0; i < sum.size; ++i) {
            int n;
            SkillKind kind = sum.listKind[i];
            int point = sum.listPoint[i];
            boolean range = sum.listPositive[i];
            int index = this.indexOfKind(kind);
            if (index < 0) {
                index = this.size;
                n = 0;
            } else {
                range = this.listPositive[index];
                n = this.listPoint[index];
            }
            this.set(kind, n + sum.listPoint[i], range);
        }
    }

    public void sum_fixed(SkillSet slotSkill) {
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.listPoint[n] = this.listPoint[n] + slotSkill.listPoint[i];
        }
    }

    public void set_all(SkillSet slotSkill) {
        this.initWithColumn(slotSkill);
        for (int i = 0; i < this.size; ++i) {
            this.listPositive[i] = slotSkill.listPositive[i];
            this.listPoint[i] = slotSkill.listPoint[i];
        }
    }

    public boolean isOver(SkillSet slotSkill) {
        int targetKind;
        SkillKind kind;
        int i;
        for (i = 0; i < slotSkill.size; ++i) {
            kind = slotSkill.listKind[i];
            targetKind = this.indexOfKind(kind);
            if (targetKind == -1) continue;
            boolean range = slotSkill.listPositive[i];
            int point1 = this.listPoint[i];
            int point2 = slotSkill.listPoint[targetKind];
            if (!(range ? point1 < point2 : point2 > point1)) continue;
            return false;
        }
        for (i = 0; i < this.size; ++i) {
            kind = this.listKind[i];
            targetKind = slotSkill.indexOfKind(kind);
            if (targetKind != -1) continue;
            return false;
        }
        return true;
    }

    public String skillToString(Comparator<SkillPoint> comp, boolean ignoreZero) {
        AbstractCollection value = null;
        value = comp == null ? new ArrayList() : new TreeSet<SkillPoint>(comp);
        for (int i = 0; i < this.size; ++i) {
            if (ignoreZero) {
                if (this.listPoint[i] == 0) continue;
                value.add(new SkillPoint(this.listKind[i], this.listPoint[i], this.listPositive[i]));
                continue;
            }
            value.add(new SkillPoint(this.listKind[i], this.listPoint[i], this.listPositive[i]));
        }
        StringBuilder str = new StringBuilder();
        str.append("{");
        for (SkillPoint p : value) {
            if (str.length() != 1) {
                str.append(",");
            }
            str.append(p.skillKind.name);
            if (p.skillPoint > 0) {
                str.append("+");
            }
            str.append(p.skillPoint);
            if (p.positiveRange) continue;
            str.append("--");
        }
        str.append("}");
        return str.toString();
    }

    public String toString() {
        return this.skillToString(null, false);
    }

    public List<String> getNamedSkillNameForDisplay() {
        ArrayList<String> result = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.size; ++i) {
            SkillPoint point = new SkillPoint(this.listKind[i], this.listPoint[i], this.listPositive[i]);
            SkillPoint name = categories.getNearSkillPoint(point);
            if (name == null) continue;
            result.add(name.pointName);
        }
        return result;
    }

    public List<String> getNamedSkillNameForSearch() {
        ArrayList<String> result = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();
        for (int i = 0; i < this.size; ++i) {
            SkillPoint point = new SkillPoint(this.listKind[i], this.listPoint[i], this.listPositive[i]);
            SkillPoint name = categories.getMatchSkillPoint(point);
            if (name != null) {
                result.add(name.pointName);
                continue;
            }
            if (this.listPoint[i] % 5 == 0 || this.listPoint[i] >= 0) continue;
            int x = this.listPoint[i];
            while (x % 5 != 0) {
                --x;
            }
            point = new SkillPoint(this.listKind[i], x, false);
            name = categories.getMatchSkillPoint(point);
            if (name == null) continue;
            result.add(name.pointName + "\u3092\u9664\u5916");
        }
        return result;
    }

    public SkillSet getNamedSkillSetForDisplay() {
        ArrayList list = new ArrayList();
        SkillCategories categories = Repository.getSkillCategories();
        SkillSet result = new SkillSet();
        for (int i = 0; i < this.size; ++i) {
            SkillPoint point = new SkillPoint(this.listKind[i], this.listPoint[i], this.listPositive[i]);
            SkillPoint name = categories.getNearSkillPoint(point);
            if (name == null) continue;
            result.set(name.skillKind, name.skillPoint, name.positiveRange);
        }
        return result;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.listKind.length; ++i) {
            if (this.listKind[i] == null) continue;
            try {
                String name = this.listKind[i].name;
                if (name == null) continue;
                n += name.hashCode() * this.listPoint[i];
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return n & Integer.MAX_VALUE;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int compareTo(Object o) {
        SkillSet set1 = this;
        SkillSet set2 = (SkillSet)o;
        if (this == o) {
            return 0;
        }
        if (set1.isFixedBy(set2)) {
            for (SkillKind kind : set1.listKind) {
                int point2;
                int point1 = set1.pointOfKind(kind);
                if (point1 < (point2 = set2.pointOfKind(kind))) {
                    return -1;
                }
                if (point1 <= point2) continue;
                return 1;
            }
            return 0;
        }
        for (SkillKind kind : Repository.getSkillCategories().listupKind()) {
            int point2;
            int point1 = set1.pointOfKind(kind);
            if (point1 < (point2 = set2.pointOfKind(kind))) {
                return -1;
            }
            if (point1 <= point2) continue;
            return 1;
        }
        return 0;
    }

    public String canonicalString() {
        StringBuffer str = new StringBuffer();
        boolean first = true;
        for (SkillKind kind : Repository.getSkillCategories().listupKind()) {
            for (int i = 0; i < this.listKind.length; ++i) {
                SkillKind kind2 = this.listKind[i];
                if (kind != kind2 || this.listPoint[i] == 0) continue;
                if (!first) {
                    str.append(",");
                } else {
                    first = false;
                }
                str.append(kind2.name);
                str.append("=");
                str.append(this.listPoint[i]);
                if (this.listPositive[i]) continue;
                str.append("-");
            }
        }
        return str.toString();
    }

    public final SkillKind kind(int x) {
        return this.listKind[x];
    }

    public final boolean positive(int x) {
        return this.listPositive[x];
    }

    public final int point(int x) {
        return this.listPoint[x];
    }

    public int totalDiffPoint() {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            int point = this.listPositive[i] ? this.listPoint[i] : -this.listPoint[i];
            if (point <= 0) continue;
            total += point;
        }
        return total;
    }

    public int maxDiffPoint() {
        int max = 0;
        for (int i = 0; i < this.size; ++i) {
            int point = this.listPositive[i] ? this.listPoint[i] : -this.listPoint[i];
            if (point <= 0 || max >= point) continue;
            max = point;
        }
        return max;
    }

    public boolean isZero() {
        for (int i = 0; i < this.size; ++i) {
            if (this.listPoint[i] == 0) continue;
            return false;
        }
        return true;
    }
}

