package portablesimulator;

import portablesimulator.skillset.SkillSet;
import java.util.ArrayList;
import java.util.List;
import portablesimulator.csv.PSBaseItems;
import portablesimulator.csv.Repository;

public final class PSItem implements Comparable {

    public PSItem(int itemType) {
        this.itemSeq = staticSeq ++;
        this.itemType = itemType;
    }

    public PSItem(int itemType, String name) {
        this.itemSeq = staticSeq ++;
        this.itemType = itemType;
        this.name = name;
    }
    private static int staticSeq = 0;
    public final int itemSeq;
    public final int itemType;
    public String name = "--";
    public int genderType = 0; //(0=,1=j,2=)
    public int hunterType = 0; //(0=,1=m,2=Ki[)
    public int rareRank = 0; //Ax
    public int slotCount = 0; //Xbg
    public int existHunterRank = 0; //莞^HRi99=Ws
    public int existTownRank = 0; //莞^i99=s
    public int defInitial = 0; //h
    public int defMax = 0; //ŏIh
    public int shellFire = 0; //Αϐ
    public int shellWater = 0; //ϐ
    public int shellIce = 0; //Xϐ
    public int shellThunder = 0; //ϐ
    public int shellDragon = 0; //
    public ArrayList<PSItem> sameGroup = null;
    public ArrayList<PSItemMaterial> materialAList = new ArrayList<PSItemMaterial>();
    public ArrayList<PSItemMaterial> materialBList = new ArrayList<PSItemMaterial>();
    public SkillSet skills = new SkillSet(5);
    public boolean isCopieSkill = false;
    public boolean isVirtual = false;
    public boolean isVirtualNone = false;
    public boolean viewFound;
    public int viewCount;
    
    public int _hashCode = -1;
    
    @Override
    public int hashCode() {
        if (_hashCode  < 0) {
            _hashCode = name.hashCode() * (slotCount + 1);
            _hashCode = _hashCode & 0x7fffffff;
        }
        return _hashCode;
    }

    public String formatGenderType() {
        switch (genderType) {
            case 0:
                return "jp";
            case 1:
                return "j";
            case 2:
                return "";
        }
        return "s";
    }

    public String formatHunterType() {
        switch (hunterType) {
            case 0:
                return "mKi[p";
            case 1:
                return "m";
            case 2:
                return "Ki[";
        }
        return "s";
    }

    public String formatPartsName() {
        switch (itemType) {
            case PSItemType.TYPE_HEAD:
                return "h";

            case PSItemType.TYPE_BODY:
                return "h";

            case PSItemType.TYPE_ARM:
                return "rh";

            case PSItemType.TYPE_WEIST:
                return "h";

            case PSItemType.TYPE_LEG:
                return "h";

            case PSItemType.TYPE_CHARM:
                return "";

            case PSItemType.TYPE_DECORATION:
                return "i";
        }
        return "s";
    }

    public String getArmorNameAndSlot() {
        PSItem item = this;
        if (item.isVirtualNone) {
            return item.name;
        } else if (item.isCopieSkill) {
            return item.name + "[n]";
        } else {
            if (item.itemType == PSItemType.TYPE_CHARM) {
                return item.name + item.skills.skillToString(null, true) + "[" + item.slotCount + "]";
            }else {
                return item.name + "[" + item.slotCount + "]";
            }
        }
    }

    public String getArmorName() {
        PSItem item = this;
        if (item.isVirtualNone) {
            return item.name;
        } else if (item.isCopieSkill) {
            return item.name;
        } else {
            if (item.itemType == PSItemType.TYPE_CHARM) {
                return item.name + item.skills.skillToString(null, true);
            }else {
                return item.name;
            }
        }
    }

    public String toString() {
        return getArmorNameAndSlot();
    }

    public String getFormatted() {
        StringBuilder str = new StringBuilder();
        String LF = "\n";

        str.append("HR[" + existHunterRank + "] / :[" + existTownRank + "]" + LF);
        str.append(name + " Rare[" + rareRank + "][" + formatGenderType() + " " + formatHunterType() + "]" + LF);
        if (itemType != PSItemType.TYPE_CHARM && itemType != PSItemType.TYPE_DECORATION) {
            str.append("h[" + defMax + "(" + defInitial + ")]" + LF);
        }
        str.append("X[" + slotCount + "]" + LF);

        if (itemType != PSItemType.TYPE_CHARM && itemType != PSItemType.TYPE_DECORATION) {
            str.append(
                    "[" + shellFire + "]"
                    + "[" + shellWater + "]"
                    + "[X" + shellIce + "]"
                    + "[" + shellThunder + "]"
                    + "[" + shellDragon + "]" + LF);
        }

        if (this.isCopieSkill) {
            str.append("[n]" + LF);
        }else {            
            str.append("XL|Cg[");
            str.append(skills.skillToString(null, false));
            str.append("]" + LF);
        }

        if (itemType != PSItemType.TYPE_CHARM) {
            str.append("fވꗗ{" + LF);
            for (PSItemMaterial mt : materialAList) {
                str.append("@");
                str.append(mt.name + "~" + mt.count + LF);
            }
            str.append("}" + LF);

            if (materialBList.isEmpty() == false) {
                str.append("fވꗗÂQ{" + LF);
                for (PSItemMaterial mt : materialBList) {
                    str.append("@");
                    str.append(mt.name + "~" + mt.count + LF);
                }
                str.append("}" + LF);
            }
        }

        return str.toString();
    }

    public boolean equals(Object t) {
        if (this == t) {
            return true;
        }
        return compareTo((PSItem)t) == 0;
    }

    public int compareTo(Object o) {

        if (this == o) {
            return 0;
        }

        PSItem item = (PSItem)o;

        int x = 0;

        if (x == 0) {
            x = itemSeq - item.itemSeq;
        }

        if (x == 0) {
            x = itemType - item.itemType;
        }

        if (x == 0) {
            if (isVirtual == false && item.isVirtual == false && itemType != PSItemType.TYPE_CHARM) {
                x = itemSeq - item.itemSeq;
            }
        }

        if (x == 0) {
            x = rareRank - item.rareRank;
        }

        if (x == 0) {
            x = genderType - item.genderType;
        }

        if (x == 0) {
            x = hunterType - item.hunterType;
        }

        if (x == 0) {
            x = name.compareTo(item.name);
        }

        if (x == 0) {
            x = slotCount - item.slotCount;
        }

        if (x == 0) {
            x = skills.compareTo(item.skills);
        }

        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }


    static ArrayList<ArrayList<PSItem>> cachedVirtual = new ArrayList<ArrayList<PSItem>>();

    public static final int VIRTUAL_NONE = -2;
    public static final int VIRTUAL_COPIE = -1;
    public static final int VIRTUAL_SLOT0 = 0;
    public static final int VIRTUAL_SLOT1 = 1;
    public static final int VIRTUAL_SLOT2 = 2;
    public static final int VIRTUAL_SLOT3 = 3;

    public static PSItem getVirtualItem(int itemType, int slotCount) {
        while (cachedVirtual.size() <= itemType) {
            cachedVirtual.add(new ArrayList<PSItem>());
        }
        List<PSItem> list = cachedVirtual.get(itemType);

        if (list.size() == 0) {
            if (itemType == PSItemType.TYPE_CHARM) {
                for (int i = -2; i <= 3; ++i) {
                    PSItem item = null;
                    switch (i) {
                        case -2://none
                            item = new PSItem(itemType, "Ȃ");
                            item.isVirtual = true;
                            item.isVirtualNone = true;
                            break;
                        case -1://copie
                            item = new PSItem(itemType, "Copie");
                            item.isVirtual = false;
                            item.isCopieSkill = true;
                            break;
                        case 0: //slot0
                            item = new PSItem(itemType, "Ȃ");
                            item.isVirtual = true;
                            item.slotCount = 0;
                            break;
                        case 1: //slot1
                            item = new PSItem(itemType, "");
                            item.isVirtual = true;
                            item.slotCount = 1;
                            break;
                        case 2: //slot2
                            item = new PSItem(itemType, "");
                            item.isVirtual = true;
                            item.slotCount = 2;
                            break;
                        case 3: //slot3
                            item = new PSItem(itemType, "");
                            item.isVirtual = true;
                            item.slotCount = 3;
                            break;
                    }
                    list.add(item);
                }
            }else {
                for (int i = -2; i <= 3; ++i) {
                    PSItem item = null;
                    switch (i) {
                        case -2://none
                            item = new PSItem(itemType, "Ȃ");
                            item.isVirtual = true;
                            item.isVirtualNone = true;
                            break;
                        case -1://copie
                            item = new PSItem(itemType, "Copie");
                            item.isVirtual = false;
                            item.isCopieSkill = true;
                            break;
                        case 0: //slot0
                            item = new PSItem(itemType, "Ȃ");
                            item.isVirtual = true;
                            item.slotCount = 0;
                            break;
                        case 1: //slot1
                            item = new PSItem(itemType, "XbgP");
                            item.isVirtual = true;
                            item.slotCount = 1;
                            break;
                        case 2: //slot2
                            item = new PSItem(itemType, "XbgQ");
                            item.isVirtual = true;
                            item.slotCount = 2;
                            break;
                        case 3: //slot3
                            item = new PSItem(itemType, "XbgR");
                            item.isVirtual = true;
                            item.slotCount = 3;
                            break;
                    }
                    list.add(item);
                }
            }
        }
        return list.get(slotCount + 2);
    }

    public static PSItem getInstanceByName(int itemType, String name) {
        PSItem found = null;
        List<PSItem> itemList = null;
        PSBaseItems datas = Repository.getBaseItems();
        switch (itemType) {
            case PSItemType.TYPE_HEAD:
                itemList = datas.listEquipHead;
                break;
            case PSItemType.TYPE_BODY:
                itemList = datas.listEquipBody;
                break;
            case PSItemType.TYPE_ARM:
                itemList = datas.listEquipArm;
                break;
            case PSItemType.TYPE_WEIST:
                itemList = datas.listEquipWeist;
                break;
            case PSItemType.TYPE_LEG:
                itemList = datas.listEquipLeg;
                break;
            case PSItemType.TYPE_CHARM:
                itemList = null;
                break;
            case PSItemType.TYPE_DECORATION:
                itemList = datas.listDecoration;
                break;
            default:
                return null;
        }
        for (int slotCount = -2; slotCount <= 3; ++slotCount) {
            PSItem item = PSItem.getVirtualItem(itemType, slotCount);
            if (item.name.equals(name)) {
                found = item;
                break;
            }
        }
        if (found == null && itemType != PSItemType.TYPE_CHARM) {
            for (PSItem item : itemList) {
                if (item.name.equals(name)) {
                    found = item;
                    break;
                }
            }
        }
        return found;
    }
}
