package portablesimulator.csv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import portablesimulator.PSItem;
import portablesimulator.PSItemType;

public class PSBaseItems {
    public ArrayList<PSItem> listEquipHead = new ArrayList<PSItem>();
    public ArrayList<PSItem> listEquipBody = new ArrayList<PSItem>();
    public ArrayList<PSItem> listEquipArm = new ArrayList<PSItem>();
    public ArrayList<PSItem> listEquipWeist = new ArrayList<PSItem>();
    public ArrayList<PSItem> listEquipLeg = new ArrayList<PSItem>();
    public ArrayList<PSItem> listCharm = new ArrayList<PSItem>();
    public ArrayList<PSItem> listDecoration = new ArrayList<PSItem>();

    public ArrayList<PSItem> listBaseEquipHead = new ArrayList<PSItem>();
    public ArrayList<PSItem> listBaseEquipBody = new ArrayList<PSItem>();
    public ArrayList<PSItem> listBaseEquipArm = new ArrayList<PSItem>();
    public ArrayList<PSItem> listBaseEquipWeist = new ArrayList<PSItem>();
    public ArrayList<PSItem> listBaseEquipLeg = new ArrayList<PSItem>();
    public ArrayList<PSItem> listBaseCharm = new ArrayList<PSItem>();
    public ArrayList<PSItem> listBaseDecoration = new ArrayList<PSItem>();

    public ArrayList<PSItem> listUserEquipHead = new ArrayList<PSItem>();
    public ArrayList<PSItem> listUserEquipBody = new ArrayList<PSItem>();
    public ArrayList<PSItem> listUserEquipArm = new ArrayList<PSItem>();
    public ArrayList<PSItem> listUserEquipWeist = new ArrayList<PSItem>();
    public ArrayList<PSItem> listUserEquipLeg = new ArrayList<PSItem>();
    public ArrayList<PSItem> listUserCharm = new ArrayList<PSItem>();
    public ArrayList<PSItem> listUserDecoration = new ArrayList<PSItem>();

    public ArrayList<PSItem> listTrashEquipHead = new ArrayList<PSItem>();
    public ArrayList<PSItem> listTrashEquipBody = new ArrayList<PSItem>();
    public ArrayList<PSItem> listTrashEquipArm = new ArrayList<PSItem>();
    public ArrayList<PSItem> listTrashEquipWeist = new ArrayList<PSItem>();
    public ArrayList<PSItem> listTrashEquipLeg = new ArrayList<PSItem>();
    public ArrayList<PSItem> listTrashCharm = new ArrayList<PSItem>();
    public ArrayList<PSItem> listTrashDecoration = new ArrayList<PSItem>();

    public int maxHunterRank = 1;
    public int maxTownRank = 1;

    public void invalidate() {
        revalidate();
    }

    private void revalidate() {
        listEquipHead = revalidate2(listBaseEquipHead, listUserEquipHead, listTrashEquipHead);
        listEquipBody = revalidate2(listBaseEquipBody, listUserEquipBody, listTrashEquipBody);
        listEquipArm = revalidate2(listBaseEquipArm, listUserEquipArm, listTrashEquipArm);
        listEquipWeist = revalidate2(listBaseEquipWeist, listUserEquipWeist, listTrashEquipWeist);
        listEquipLeg = revalidate2(listBaseEquipLeg, listUserEquipLeg, listTrashEquipLeg);
        listCharm = revalidate2(listBaseCharm, listUserCharm, listTrashCharm);
        listDecoration = revalidate2(listBaseDecoration, listUserDecoration, listTrashDecoration);

        maxHunterRank = 1;
        maxTownRank = 1;
        
        Object[] listList = {
            listEquipHead, listEquipBody, listEquipArm,
            listEquipWeist, listEquipLeg, listCharm, listDecoration
        };

        for(Object o : listList) {
            ArrayList<PSItem> list = (ArrayList<PSItem>)o;
            for(PSItem item : list) {
                if (item.existHunterRank != 99 && maxHunterRank < item.existHunterRank) {
                    maxHunterRank = item.existHunterRank;
                }
                if (item.existTownRank != 99 && maxTownRank < item.existTownRank) {
                    maxTownRank = item.existTownRank;
                }
            }
        }
    }

    private ArrayList<PSItem> revalidate2(ArrayList<PSItem> base, ArrayList<PSItem> user, ArrayList<PSItem> trash) {
        ArrayList<PSItem> list = new ArrayList<PSItem>();

        list.addAll(base);

        for(int i = 0; i < user.size(); ++ i) {
            int j;
            PSItem item = user.get(i);
            while((j = seekOverwriteSource(list, item)) >= 0) {
                list.remove(j);
            }
        }
        for(int i = 0; i < trash.size(); ++ i) {
            int j;
            PSItem item = trash.get(i);
            while((j = seekOverwriteSource(trash, item)) >= 0) {
                trash.remove(j);
            }
        }
        list.addAll(user);
        Collections.sort(list, new Comparator() {
            public int compare(Object o1, Object o2) {
                PSItem item1 = (PSItem)o1;
                PSItem item2 = (PSItem)o2;

                if (item1.rareRank != item2.rareRank) {
                    return item1.rareRank < item2.rareRank ? -1 : 1;
                }
                if (item1.hunterType != item2.hunterType) {
                    return item1.hunterType < item2.hunterType ? -1 : 1;
                }
                return item1.name.compareTo(item2.name);
            }
        });

        return list;
    }

    public static int seekOverwriteSource(ArrayList<PSItem> list, PSItem user) {
        for(int i = 0; i < list.size(); ++ i) {
            String name = list.get(i).name;
            int genderType = list.get(i).genderType;
            int slotCount = list.get(i).slotCount;
            int itemType = list.get(i).itemType;

            if (itemType == PSItemType.TYPE_DECORATION) {
                if (name.equals(user.name)
                 && slotCount == user.slotCount) {
                    return i;
                }
            }else {
                if (name.equals(user.name)
                 && genderType == user.genderType) {
                    return i;
                }
            }
        }
        return -1;
    }
}
