package portablesimulator.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import portablesimulator.PSItem;
import portablesimulator.PSItemType;
import portablesimulator.PSWrap;
import portablesimulator.csv.PSConfig;
import portablesimulator.csv.Repository;

public class MyCheckBoxForCandidate extends JCheckBoxEx {

    public final PSItem item;
    public final PSFrame frame;
    private static Timer timer = new Timer(true);
    private TimerTask task;
    private ActionListener al;
    private JPopupMenu menu;
    private JMenuItem menuItemSelectOnly;
    private JMenuItem menuItemSelectExclude;
    private JMenuItem menuItemSelectSame;
    private JMenuItem menuItemSelectAll;
    private JMenuItem menuItemCancel;

    public MyCheckBoxForCandidate(final PSFrame frame, final PSItem item) {
        this.frame = frame;
        this.item = item;
        this.task = null;

        setSelected(Repository.getConfig().lastSession.items.isCandidateChecked(item));
        if (item.itemType == PSItemType.TYPE_CHARM) {
            setText(item.name + item.skills.skillToString(null, true) + "[" + item.slotCount + "]");
        } else {
            setText(item.name + "[" + item.slotCount + "]");
        }
        addMouseListener(new MouseAdapter() {

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 1) {
                    if (me.getButton() != MouseEvent.BUTTON1) {
                        showPopupMenu(me.getX(), me.getY());
                    } else if ((me.getModifiers() & MouseEvent.CTRL_MASK) != 0) {
                        showPopupMenu(me.getX(), me.getY());
                    }
                }
            }

            public void mousePressed(MouseEvent me) {
                schedulePopup(me.getX(), me.getY());
            }

            public void mouseReleased(MouseEvent me) {
                cancelPopup();
            }

            public void mouseExited(MouseEvent me) {
                cancelPopup();
            }
        });
        al = new ActionListener() {

            public void actionPerformed(ActionEvent ae) {
                menuActionPerformed(ae);
            }
        };
        addActionListener(al);
    }

    public void showPopupMenu(final int x, final int y) {
        PSItem e = item;

        this.menu = new JPopupMenu();
        menuItemSelectOnly = new JMenuItem(e.getArmorName() + "̂");
        menuItemSelectOnly.addActionListener(al);
        menu.add(menuItemSelectOnly);

        menuItemSelectExclude = new JMenuItem(e.getArmorName() + "ȊO");
        menuItemSelectExclude.addActionListener(al);
        menu.add(menuItemSelectExclude);

        menuItemSelectSame = new JMenuItem(e.formatPartsName() + "S");
        menuItemSelectSame.addActionListener(al);
        menu.add(menuItemSelectSame);

        menuItemSelectAll = new JMenuItem("Sʂ̑S");
        menuItemSelectAll.addActionListener(al);
        menu.add(menuItemSelectAll);

        menuItemCancel = new JMenuItem("LZ");
        menu.add(menuItemCancel);

        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                menu.show(MyCheckBoxForCandidate.this, x, y);
            }
        });
    }

    public void menuActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this) {
            frame.doPrintTextArea(item.getFormatted(), "ACeڍ");
        } else {
            List<MyCheckBoxForCandidate> list;
            if (item.itemType == PSItemType.TYPE_CHARM) {
                list = frame.getCandidate3List();
            } else {
                list = frame.getCandidateList();
            }

            if (ae.getSource() == this.menuItemSelectOnly) {
                for (MyCheckBoxForCandidate box : list) {
                    if (box.item.itemType == item.itemType) {
                        box.setSelected(box.item == item);
                    }
                }
            }else if (ae.getSource() == this.menuItemSelectExclude) {
                for (MyCheckBoxForCandidate box : list) {
                    if (box.item.itemType == item.itemType) {
                        box.setSelected(box.item != item);
                    }
                }
            } else if (ae.getSource() == this.menuItemSelectAll) {
                for (MyCheckBoxForCandidate box : list) {
                    box.setSelected(true);
                }
            } else if (ae.getSource() == this.menuItemSelectSame) {
                for (MyCheckBoxForCandidate box : list) {
                    if (box.item.itemType == item.itemType) {
                        box.setSelected(true);
                    }
                }
            }
        }
    }

    public void schedulePopup(final int x, final int y) {
        task = new TimerTask() {

            @Override
            public void run() {
                synchronized (timer) {
                    task = null;
                    showPopupMenu(x, y);
                }
            }
        };
        timer.schedule(task, 1000);
    }

    public void cancelPopup() {
        synchronized (timer) {
            if (task != null) {
                task.cancel();
                task = null;
            }
        }
    }
}
