package portablesimulator.gui;

import portablesimulator.gui.progress.ProgressDialog;
import portablesimulator.gui.progress.ProgressDoubleDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import portablesimulator.Engine;
import portablesimulator.skillset.SkillSet;
import portablesimulator.skillset.SkillPoint;
import portablesimulator.PSArmorSet;
import portablesimulator.PSItem;
import portablesimulator.PSItemMaterial;
import portablesimulator.PSItemType;
import portablesimulator.PSItemList;
import portablesimulator.PSWrap;
import portablesimulator.csv.PSBaseItems;
import portablesimulator.csv.PSConfig;
import portablesimulator.csv.PSMySet;
import portablesimulator.csv.PSSession;
import portablesimulator.csv.PSSearchItems;
import portablesimulator.csv.Repository;
import portablesimulator.decoration.DecorationCount;
import portablesimulator.decoration.DecorationMatcherFull;
import portablesimulator.decoration.DecorationSlot;
import portablesimulator.decoration.PlusOneFinder;
import portablesimulator.gui.themes.ThemeManagerDialog;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillKind;

public class PSFrame extends javax.swing.JFrame {
    public PSFrame(PSSession session) {
        this.session = session;
        this.items = session.items;
        initComponents();

        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle desktopBounds = env.getMaximumWindowBounds();
        this.setBounds(desktopBounds);

        doRepaintSkillCategoryItems();

        jListResult.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                PSFrame.this.jListResultValueChanged(e);
            }
        });

        jTextFieldSkillSearch.setDocument(new DefaultStyledDocument());
        jTextFieldSkillSearch.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent de) {
                doSkillSearch();
            }

            public void removeUpdate(DocumentEvent de) {
                doSkillSearch();
            }

            public void changedUpdate(DocumentEvent de) {
                doSkillSearch();
            }
        });

        jTextFieldCandidateSearch.setDocument(new DefaultStyledDocument());
        jTextFieldCandidateSearch.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent de) {
                doTextSearchCandidate();
            }

            public void removeUpdate(DocumentEvent de) {
                doTextSearchCandidate();
            }

            public void changedUpdate(DocumentEvent de) {
                doTextSearchCandidate();
            }
        });

        jTextFieldCandidate2Search.setDocument(new DefaultStyledDocument());
        jTextFieldCandidate2Search.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent de) {
                doTextSearchCandidate2();
            }

            public void removeUpdate(DocumentEvent de) {
                doTextSearchCandidate2();
            }

            public void changedUpdate(DocumentEvent de) {
                doTextSearchCandidate2();
            }
        });

        jTextFieldCandidate3Search.setDocument(new DefaultStyledDocument());
        jTextFieldCandidate3Search.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent de) {
                doTextSearchCandidate3();
            }

            public void removeUpdate(DocumentEvent de) {
                doTextSearchCandidate3();
            }

            public void changedUpdate(DocumentEvent de) {
                doTextSearchCandidate3();
            }
        });
        jTextFieldMySetFind.setDocument(new DefaultStyledDocument());
        jTextFieldMySetFind.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent de) {
                doTextSearchMySetFind();
            }

            public void removeUpdate(DocumentEvent de) {
                doTextSearchMySetFind();
            }

            public void changedUpdate(DocumentEvent de) {
                doTextSearchMySetFind();
            }
        });
        jTextFieldCheckSearch.setDocument(new DefaultStyledDocument());
        jTextFieldCheckSearch.getDocument().addDocumentListener(new DocumentListener() {
            public void insertUpdate(DocumentEvent de) {
                doTextSearchCheck();
            }

            public void removeUpdate(DocumentEvent de) {
                doTextSearchCheck();
            }

            public void changedUpdate(DocumentEvent de) {
                doTextSearchCheck();
            }
        });

        jTextFieldUserArmorMaster.setDocument(new DefaultStyledDocument());
        jTextFieldUserArmorMaster.getDocument().addDocumentListener(new DocumentListener() {
            public void insertUpdate(DocumentEvent de) {
                doTextSearchUserArmorMaster();
            }

            public void removeUpdate(DocumentEvent de) {
                doTextSearchUserArmorMaster();
            }

            public void changedUpdate(DocumentEvent de) {
                doTextSearchUserArmorMaster();
            }
        });
        jTextFieldUserArmorUser.setDocument(new DefaultStyledDocument());
        jTextFieldUserArmorUser.getDocument().addDocumentListener(new DocumentListener() {
            public void insertUpdate(DocumentEvent de) {
                doTextSearchUserArmorUser();
            }

            public void removeUpdate(DocumentEvent de) {
                doTextSearchUserArmorUser();
            }

            public void changedUpdate(DocumentEvent de) {
                doTextSearchUserArmorUser();
            }
        });
        jTextFieldUserArmorTrash.setDocument(new DefaultStyledDocument());
        jTextFieldUserArmorTrash.getDocument().addDocumentListener(new DocumentListener() {
            public void insertUpdate(DocumentEvent de) {
                doTextSearchUserArmorTrash();
            }

            public void removeUpdate(DocumentEvent de) {
                doTextSearchUserArmorTrash();
            }

            public void changedUpdate(DocumentEvent de) {
                doTextSearchUserArmorTrash();
            }
        });

        updateSearchStatus();

        try {
            InputStream in = PSFrame.class.getResourceAsStream("dragon.jpg");
            Image imageIcon = ImageIO.read(in);
            in.close();
            if (imageIcon != null) {
                this.setIconImage(imageIcon);
            }
        } catch (Throwable e) {
        }

        jPanelCandidate3.setVisible(Repository.getResource().existCharm());
        jCheckBoxFukugo.setVisible(Repository.getResource().existFukugo());
        doRepaintStatusLabel();

        Thread t = new Thread() {

            public void run() {
                while (true) {
                    try {
                        SwingUtilities.invokeLater(new Runnable() {

                            public void run() {
                                long ava = Runtime.getRuntime().freeMemory();
                                long total = Runtime.getRuntime().totalMemory();
                                long used = total - ava;
                                long percent = used * 100 / total;
                                used /= 1024 * 1024;
                                total /= 1024 * 1024;
                                jButtonMemory.setText(used + "MB/" + total + "MB (" + percent + "%)");
                            }
                        });
                        Thread.sleep(1000);
                    } catch (Throwable e) {
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jSeparator1 = new javax.swing.JSeparator();
        jPanelToolBar = new javax.swing.JPanel();
        jButtonMemory = new javax.swing.JButton();
        jButtonColorDefault = new javax.swing.JButton();
        jButtonCredit = new javax.swing.JButton();
        jLabelStatus = new javax.swing.JLabel();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanelSearch = new javax.swing.JPanel();
        jLabelHR = new javax.swing.JLabel();
        jComboBoxHR = new javax.swing.JComboBox();
        jLabelTownRank = new javax.swing.JLabel();
        jComboBoxTownRank = new javax.swing.JComboBox();
        jLabelWeaponType = new javax.swing.JLabel();
        jComboBoxWeaponType = new javax.swing.JComboBox();
        jLabelGender = new javax.swing.JLabel();
        jComboBoxGender = new javax.swing.JComboBox();
        jLabel8 = new javax.swing.JLabel();
        jComboBoxWeaponSlot = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldMaxCount = new javax.swing.JTextField();
        jCheckBoxMatome = new javax.swing.JCheckBox();
        jCheckBoxCharmMatome = new javax.swing.JCheckBox();
        jCheckBoxCharmCSV = new javax.swing.JCheckBox();
        jLabelSkill = new javax.swing.JLabel();
        jScrollPane4 = new javax.swing.JScrollPane();
        jPanelSearchSkill = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButtonCandidate2Check = new javax.swing.JButton();
        jCheckBoxOrderByDeffence = new javax.swing.JCheckBox();
        jCheckBoxPlusAlpha = new javax.swing.JCheckBox();
        jCheckBoxPlusOneFast = new javax.swing.JCheckBox();
        jCheckBoxFukugo = new javax.swing.JCheckBox();
        jTextFieldSkillSearch = new javax.swing.JTextField();
        jButtonSkillReset = new javax.swing.JButton();
        jSplitPane2 = new javax.swing.JSplitPane();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jSplitPane8 = new javax.swing.JSplitPane();
        jPanelCheck = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jTextFieldCheckSearch = new javax.swing.JTextField();
        jSeparator3 = new javax.swing.JSeparator();
        jScrollPane5 = new javax.swing.JScrollPane();
        jPanelCheckArmor = new javax.swing.JPanel();
        jPanelResult = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jComboBoxStyleResultList = new javax.swing.JComboBox();
        jComboBoxOrderResult = new javax.swing.JComboBox();
        jComboBoxCheckDeffence = new javax.swing.JComboBox();
        jButtonSaveToMyset = new javax.swing.JButton();
        jButtonQuickPlusOne = new javax.swing.JButton();
        jSeparator4 = new javax.swing.JSeparator();
        jScrollPane1 = new javax.swing.JScrollPane();
        jListResult = new javax.swing.JList();
        jSplitPane5 = new javax.swing.JSplitPane();
        jSplitPane3 = new javax.swing.JSplitPane();
        jPanelCandidate = new javax.swing.JPanel();
        jTextFieldCandidateSearch = new javax.swing.JTextField();
        jScrollPane2 = new javax.swing.JScrollPane();
        jPanelCandidateArmor = new javax.swing.JPanel();
        jToggleCandidateBySearchCondition = new javax.swing.JToggleButton();
        jPanelCandidate2 = new javax.swing.JPanel();
        jTextFieldCandidate2Search = new javax.swing.JTextField();
        jScrollPane3 = new javax.swing.JScrollPane();
        jPanelCandidate2Armor = new javax.swing.JPanel();
        jToggleCandidate2BySearchCondition = new javax.swing.JToggleButton();
        jSplitPane6 = new javax.swing.JSplitPane();
        jPanelCandidate3 = new javax.swing.JPanel();
        jTextFieldCandidate3Search = new javax.swing.JTextField();
        jScrollPane6 = new javax.swing.JScrollPane();
        jPanelCandidate3Armor = new javax.swing.JPanel();
        jToggleCandidate3BySearchCondition = new javax.swing.JToggleButton();
        jSeparator2 = new javax.swing.JSeparator();
        jPanel2 = new javax.swing.JPanel();
        jComboBoxCharmType = new javax.swing.JComboBox();
        jComboBoxCharmSkillKind1 = new javax.swing.JComboBox();
        jComboBoxCharmSkillPoint1 = new javax.swing.JComboBox();
        jComboBoxCharmSkillKind2 = new javax.swing.JComboBox();
        jComboBoxCharmSkillPoint2 = new javax.swing.JComboBox();
        jComboBoxCharmSlot = new javax.swing.JComboBox();
        jPanel4 = new javax.swing.JPanel();
        jButtonAddCharm = new javax.swing.JButton();
        jButtonCleanupCharm = new javax.swing.JButton();
        jButtonImportCharmCSV = new javax.swing.JButton();
        jPanelCandidateAction = new javax.swing.JPanel();
        jPanelMyset = new javax.swing.JPanel();
        jButtonMySetName = new javax.swing.JButton();
        jButtonMySetPicture = new javax.swing.JButton();
        jButtonMySetImport = new javax.swing.JButton();
        jButtonMySetRemove = new javax.swing.JButton();
        jButtonMySetSearchAgain = new javax.swing.JButton();
        jSeparator6 = new javax.swing.JSeparator();
        jScrollPane7 = new javax.swing.JScrollPane();
        jListMyset = new javax.swing.JList();
        jTextFieldMySetFind = new javax.swing.JTextField();
        jPanelSkillPlus = new javax.swing.JPanel();
        jScrollPane8 = new javax.swing.JScrollPane();
        jPanelSkillPlusContent = new javax.swing.JPanel();
        jPanelUserArmor = new javax.swing.JPanel();
        jPanel6 = new javax.swing.JPanel();
        jLabelUserArmorGender = new javax.swing.JLabel();
        jLabelUserArmorHunterType = new javax.swing.JLabel();
        jLabelUserArmorRare = new javax.swing.JLabel();
        jLabelUserArmorSlot = new javax.swing.JLabel();
        jLabelUserArmorHunterRank = new javax.swing.JLabel();
        jLabelUserArmorTownRank = new javax.swing.JLabel();
        jLabelUserArmorInitialDeffence = new javax.swing.JLabel();
        jLabelUserArmorFinalDeffence = new javax.swing.JLabel();
        jLabelUserArmorShellFire = new javax.swing.JLabel();
        jLabelUserArmorShellWater = new javax.swing.JLabel();
        jLabelUserArmorShellBrizard = new javax.swing.JLabel();
        jLabelUserArmorShellThunder = new javax.swing.JLabel();
        jLabelUserArmorShellDragon = new javax.swing.JLabel();
        jLabelUserArmorName = new javax.swing.JLabel();
        jLabelUserArmorMaterialA = new javax.swing.JLabel();
        jTextFieldUserArmorName = new javax.swing.JTextField();
        jComboBoxUserArmorGender = new javax.swing.JComboBox();
        jComboBoxUserArmorHunterType = new javax.swing.JComboBox();
        jSpinnerUserArmorRare = new javax.swing.JSpinner();
        jSpinnerUserArmorSlot = new javax.swing.JSpinner();
        jSpinnerUserArmorHunterRank = new javax.swing.JSpinner();
        jSpinnerUserArmorTownRank = new javax.swing.JSpinner();
        jSpinnerUserArmorInitialDeffence = new javax.swing.JSpinner();
        jSpinnerUserArmorFinalDeffence = new javax.swing.JSpinner();
        jSpinnerUserArmorShellFire = new javax.swing.JSpinner();
        jSpinnerUserArmorShellWater = new javax.swing.JSpinner();
        jSpinnerUserArmorShellBrizard = new javax.swing.JSpinner();
        jSpinnerUserArmorShellThunder = new javax.swing.JSpinner();
        jSpinnerUserArmorShellDragon = new javax.swing.JSpinner();
        jButtonUserNewArmor = new javax.swing.JButton();
        jButtonUserSaveArmor = new javax.swing.JButton();
        jLabelUserArmorSkill1 = new javax.swing.JLabel();
        jLabelUserArmorSkill2 = new javax.swing.JLabel();
        jLabelUserArmorSkill3 = new javax.swing.JLabel();
        jLabelUserArmorSkill4 = new javax.swing.JLabel();
        jLabelUserArmorSkill5 = new javax.swing.JLabel();
        jComboBoxUserArmorSkill1 = new javax.swing.JComboBox();
        jComboBoxUserArmorSkill2 = new javax.swing.JComboBox();
        jComboBoxUserArmorSkill3 = new javax.swing.JComboBox();
        jComboBoxUserArmorSkill4 = new javax.swing.JComboBox();
        jComboBoxUserArmorSkill5 = new javax.swing.JComboBox();
        jSpinnerUserArmorSkillPoint1 = new javax.swing.JSpinner();
        jSpinnerUserArmorSkillPoint2 = new javax.swing.JSpinner();
        jSpinnerUserArmorSkillPoint3 = new javax.swing.JSpinner();
        jSpinnerUserArmorSkillPoint4 = new javax.swing.JSpinner();
        jSpinnerUserArmorSkillPoint5 = new javax.swing.JSpinner();
        jButtonUserTrashArmor = new javax.swing.JButton();
        jLabelUserArmorPartsType = new javax.swing.JLabel();
        jComboBoxUserArmorPartsType = new javax.swing.JComboBox();
        jLabelUserArmorMaterialB = new javax.swing.JLabel();
        jPanel7 = new javax.swing.JPanel();
        jTextFieldMaterialA1 = new javax.swing.JTextField();
        jSpinnerMaterialCountA1 = new javax.swing.JSpinner();
        jTextFieldMaterialA2 = new javax.swing.JTextField();
        jSpinnerMaterialCountA2 = new javax.swing.JSpinner();
        jTextFieldMaterialA3 = new javax.swing.JTextField();
        jSpinnerMaterialCountA3 = new javax.swing.JSpinner();
        jTextFieldMaterialA4 = new javax.swing.JTextField();
        jSpinnerMaterialCountA4 = new javax.swing.JSpinner();
        jTextFieldMaterialB1 = new javax.swing.JTextField();
        jSpinnerMaterialCountB1 = new javax.swing.JSpinner();
        jTextFieldMaterialB2 = new javax.swing.JTextField();
        jSpinnerMaterialCountB2 = new javax.swing.JSpinner();
        jTextFieldMaterialB3 = new javax.swing.JTextField();
        jSpinnerMaterialCountB3 = new javax.swing.JSpinner();
        jTextFieldMaterialB4 = new javax.swing.JTextField();
        jSpinnerMaterialCountB4 = new javax.swing.JSpinner();
        jCheckBoxDuplicateSkill = new javax.swing.JCheckBox();
        jTextFieldUserArmorMaster = new javax.swing.JTextField();
        jTextFieldUserArmorTrash = new javax.swing.JTextField();
        jButton6 = new javax.swing.JButton();
        jTextFieldUserArmorUser = new javax.swing.JTextField();
        jScrollPane11 = new javax.swing.JScrollPane();
        jPanelUserArmorMaster = new javax.swing.JPanel();
        jScrollPane12 = new javax.swing.JScrollPane();
        jPanelUserArmorUser = new javax.swing.JPanel();
        jScrollPane15 = new javax.swing.JScrollPane();
        jPanelUserArmorTrash = new javax.swing.JPanel();
        jLabel29 = new javax.swing.JLabel();
        jLabel31 = new javax.swing.JLabel();
        jLabel32 = new javax.swing.JLabel();
        jButton9 = new javax.swing.JButton();
        jButton10 = new javax.swing.JButton();
        jButton11 = new javax.swing.JButton();
        jTabbedPane2 = new javax.swing.JTabbedPane();
        jPanelDetail = new javax.swing.JPanel();
        jButtonArmorSkillSeek = new javax.swing.JButton();
        jButtonCopyArmorSet = new javax.swing.JButton();
        jSplitPane4 = new javax.swing.JSplitPane();
        jScrollPane9 = new javax.swing.JScrollPane();
        jTextAreaDetail = new javax.swing.JTextArea();
        jPanelMysetPicture = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle(Engine.VERSION);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowIconified(java.awt.event.WindowEvent evt) {
                formWindowIconified(evt);
            }
        });
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentMoved(java.awt.event.ComponentEvent evt) {
                formComponentMoved(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanelToolBar.setLayout(new java.awt.GridBagLayout());

        jButtonMemory.setText("- MB");
        jButtonMemory.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMemoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        jPanelToolBar.add(jButtonMemory, gridBagConstraints);

        jButtonColorDefault.setText("Look And Feel");
        jButtonColorDefault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonColorDefaultActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        jPanelToolBar.add(jButtonColorDefault, gridBagConstraints);

        jButtonCredit.setText("Credit");
        jButtonCredit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCreditActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        jPanelToolBar.add(jButtonCredit, gridBagConstraints);

        jLabelStatus.setText("Welcome");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        jPanelToolBar.add(jLabelStatus, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(jPanelToolBar, gridBagConstraints);

        jSplitPane1.setDividerLocation(250);

        jPanelSearch.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jPanelSearch.setLayout(new java.awt.GridBagLayout());

        jLabelHR.setText("HR");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jLabelHR, gridBagConstraints);

        jComboBoxHR.setModel(createHRModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jComboBoxHR, gridBagConstraints);

        jLabelTownRank.setText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jLabelTownRank, gridBagConstraints);

        jComboBoxTownRank.setModel(createTownRankModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jComboBoxTownRank, gridBagConstraints);

        jLabelWeaponType.setText("m^Ki[");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jLabelWeaponType, gridBagConstraints);

        jComboBoxWeaponType.setModel(createWeaponTypeModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jComboBoxWeaponType, gridBagConstraints);

        jLabelGender.setText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jLabelGender, gridBagConstraints);

        jComboBoxGender.setModel(createGenderModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jComboBoxGender, gridBagConstraints);

        jLabel8.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jLabel8, gridBagConstraints);

        jComboBoxWeaponSlot.setModel(createWesponSlotModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jComboBoxWeaponSlot, gridBagConstraints);

        jLabel1.setText("ʍső");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelSearch.add(jLabel1, gridBagConstraints);

        jTextFieldMaxCount.setText("9999");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelSearch.add(jTextFieldMaxCount, gridBagConstraints);

        jCheckBoxMatome.setText("܂Ƃߌ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelSearch.add(jCheckBoxMatome, gridBagConstraints);

        jCheckBoxCharmMatome.setText("܂Ƃ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelSearch.add(jCheckBoxCharmMatome, gridBagConstraints);

        jCheckBoxCharmCSV.setText("SCSV");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelSearch.add(jCheckBoxCharmCSV, gridBagConstraints);

        jLabelSkill.setText("XL");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelSearch.add(jLabelSkill, gridBagConstraints);

        jPanelSearchSkill.setLayout(new java.awt.GridBagLayout());
        jScrollPane4.setViewportView(jPanelSearchSkill);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelSearch.add(jScrollPane4, gridBagConstraints);

        jButton1.setText("");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelSearch.add(jButton1, gridBagConstraints);

        jButtonCandidate2Check.setText("Ώۖĥ݂Ō");
        jButtonCandidate2Check.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCandidate2CheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelSearch.add(jButtonCandidate2Check, gridBagConstraints);

        jCheckBoxOrderByDeffence.setText("h䏇");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelSearch.add(jCheckBoxOrderByDeffence, gridBagConstraints);

        jCheckBoxPlusAlpha.setText("{ȃ");
        jCheckBoxPlusAlpha.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPlusAlphaActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelSearch.add(jCheckBoxPlusAlpha, gridBagConstraints);

        jCheckBoxPlusOneFast.setText("+p");
        jCheckBoxPlusOneFast.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPlusOneFastActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelSearch.add(jCheckBoxPlusOneFast, gridBagConstraints);

        jCheckBoxFukugo.setText("XL");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelSearch.add(jCheckBoxFukugo, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanelSearch.add(jTextFieldSkillSearch, gridBagConstraints);

        jButtonSkillReset.setText("Zbg");
        jButtonSkillReset.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSkillResetActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanelSearch.add(jButtonSkillReset, gridBagConstraints);

        jSplitPane1.setLeftComponent(jPanelSearch);

        jSplitPane2.setDividerLocation(500);
        jSplitPane2.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jTabbedPane1.addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
                jTabbedPane1AncestorAdded(evt);
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });

        jSplitPane8.setDividerLocation(250);

        jPanelCheck.setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jTextFieldCheckSearch, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelCheck.add(jPanel1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelCheck.add(jSeparator3, gridBagConstraints);

        jScrollPane5.setViewportView(jPanelCheckArmor);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelCheck.add(jScrollPane5, gridBagConstraints);

        jSplitPane8.setLeftComponent(jPanelCheck);

        jPanelResult.setLayout(new java.awt.GridBagLayout());

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jLabel5.setText("X^C");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel3.add(jLabel5, gridBagConstraints);

        jLabel6.setText("Œh");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel3.add(jLabel6, gridBagConstraints);

        jLabel9.setText("\[g");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel3.add(jLabel9, gridBagConstraints);

        jComboBoxStyleResultList.setModel(createStyleModel());
        jComboBoxStyleResultList.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxStyleResultListActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel3.add(jComboBoxStyleResultList, gridBagConstraints);

        jComboBoxOrderResult.setModel(createResultOrderModel());
        jComboBoxOrderResult.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxOrderResultActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel3.add(jComboBoxOrderResult, gridBagConstraints);

        jComboBoxCheckDeffence.setModel(new DefaultComboBoxModel());
        jComboBoxCheckDeffence.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxCheckDeffenceActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel3.add(jComboBoxCheckDeffence, gridBagConstraints);

        jButtonSaveToMyset.setText("I}CZbg");
        jButtonSaveToMyset.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSaveToMysetActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(jButtonSaveToMyset, gridBagConstraints);

        jButtonQuickPlusOne.setText("Quick+1");
        jButtonQuickPlusOne.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonQuickPlusOneActionPerformed(evt);
            }
        });
        jPanel3.add(jButtonQuickPlusOne, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelResult.add(jPanel3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelResult.add(jSeparator4, gridBagConstraints);

        jListResult.setModel(new DefaultListModel());
        jListResult.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jListResultFocusGained(evt);
            }
        });
        jScrollPane1.setViewportView(jListResult);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelResult.add(jScrollPane1, gridBagConstraints);

        jSplitPane8.setRightComponent(jPanelResult);

        jTabbedPane1.addTab("", jSplitPane8);

        jSplitPane5.setDividerLocation(500);
        jSplitPane5.addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
                jSplitPane5AncestorMoved(evt);
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });

        jSplitPane3.setDividerLocation(250);

        jPanelCandidate.setMinimumSize(new java.awt.Dimension(100, 224));
        jPanelCandidate.setPreferredSize(new java.awt.Dimension(100, 224));
        jPanelCandidate.setLayout(new java.awt.GridBagLayout());

        jTextFieldCandidateSearch.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldCandidateSearchActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanelCandidate.add(jTextFieldCandidateSearch, gridBagConstraints);

        jScrollPane2.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane2.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        jPanelCandidateArmor.addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
                jPanelCandidateArmorAncestorAdded(evt);
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });
        jPanelCandidateArmor.setLayout(new java.awt.GridBagLayout());
        jScrollPane2.setViewportView(jPanelCandidateArmor);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelCandidate.add(jScrollPane2, gridBagConstraints);

        jToggleCandidateBySearchCondition.setText("\؊@ij");
        jToggleCandidateBySearchCondition.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleCandidateBySearchConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        jPanelCandidate.add(jToggleCandidateBySearchCondition, gridBagConstraints);

        jSplitPane3.setLeftComponent(jPanelCandidate);

        jPanelCandidate2.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanelCandidate2.add(jTextFieldCandidate2Search, gridBagConstraints);

        jScrollPane3.setViewportView(jPanelCandidate2Armor);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelCandidate2.add(jScrollPane3, gridBagConstraints);

        jToggleCandidate2BySearchCondition.setText("\؊@ij");
        jToggleCandidate2BySearchCondition.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleCandidate2BySearchConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelCandidate2.add(jToggleCandidate2BySearchCondition, gridBagConstraints);

        jSplitPane3.setRightComponent(jPanelCandidate2);

        jSplitPane5.setLeftComponent(jSplitPane3);

        jSplitPane6.setDividerLocation(300);

        jPanelCandidate3.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanelCandidate3.add(jTextFieldCandidate3Search, gridBagConstraints);

        jScrollPane6.setViewportView(jPanelCandidate3Armor);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelCandidate3.add(jScrollPane6, gridBagConstraints);

        jToggleCandidate3BySearchCondition.setText("\؊@ij");
        jToggleCandidate3BySearchCondition.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleCandidate3BySearchConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelCandidate3.add(jToggleCandidate3BySearchCondition, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelCandidate3.add(jSeparator2, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jComboBoxCharmType.setModel(createCharmNameModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jComboBoxCharmType, gridBagConstraints);

        jComboBoxCharmSkillKind1.setModel(createSkillKindModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jComboBoxCharmSkillKind1, gridBagConstraints);

        jComboBoxCharmSkillPoint1.setModel(createSkillPointModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jComboBoxCharmSkillPoint1, gridBagConstraints);

        jComboBoxCharmSkillKind2.setModel(createSkillKindModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(jComboBoxCharmSkillKind2, gridBagConstraints);

        jComboBoxCharmSkillPoint2.setModel(createSkillPointModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jComboBoxCharmSkillPoint2, gridBagConstraints);

        jComboBoxCharmSlot.setModel(createCharmSlotModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(jComboBoxCharmSlot, gridBagConstraints);

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jButtonAddCharm.setText("ǉ");
        jButtonAddCharm.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddCharmActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel4.add(jButtonAddCharm, gridBagConstraints);

        jButtonCleanupCharm.setText("|");
        jButtonCleanupCharm.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCleanupCharmActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add(jButtonCleanupCharm, gridBagConstraints);

        jButtonImportCharmCSV.setText("C|[g");
        jButtonImportCharmCSV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonImportCharmCSVActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel4.add(jButtonImportCharmCSV, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jPanel4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelCandidate3.add(jPanel2, gridBagConstraints);

        jSplitPane6.setLeftComponent(jPanelCandidate3);
        jSplitPane6.setRightComponent(jPanelCandidateAction);

        jSplitPane5.setRightComponent(jSplitPane6);

        jTabbedPane1.addTab("Ώۖh", jSplitPane5);

        jPanelMyset.setLayout(new java.awt.GridBagLayout());

        jButtonMySetName.setText("OύX");
        jButtonMySetName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMySetNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelMyset.add(jButtonMySetName, gridBagConstraints);

        jButtonMySetPicture.setText("摜ύX");
        jButtonMySetPicture.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMySetPictureActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        jPanelMyset.add(jButtonMySetPicture, gridBagConstraints);

        jButtonMySetImport.setText("C|[g");
        jButtonMySetImport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMySetImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelMyset.add(jButtonMySetImport, gridBagConstraints);

        jButtonMySetRemove.setText("폜");
        jButtonMySetRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMySetRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelMyset.add(jButtonMySetRemove, gridBagConstraints);

        jButtonMySetSearchAgain.setText("ɐݒ");
        jButtonMySetSearchAgain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMySetSearchAgainActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        jPanelMyset.add(jButtonMySetSearchAgain, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelMyset.add(jSeparator6, gridBagConstraints);

        jListMyset.setModel(new DefaultListModel());
        jListMyset.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListMysetValueChanged(evt);
            }
        });
        jListMyset.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jListMysetFocusGained(evt);
            }
        });
        jListMyset.addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
                jListMysetAncestorAdded(evt);
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });
        jScrollPane7.setViewportView(jListMyset);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelMyset.add(jScrollPane7, gridBagConstraints);

        jTextFieldMySetFind.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTextFieldMySetFindFocusGained(evt);
            }
        });
        jTextFieldMySetFind.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jTextFieldMySetFindKeyPressed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelMyset.add(jTextFieldMySetFind, gridBagConstraints);

        jTabbedPane1.addTab("}CZbg", jPanelMyset);

        jPanelSkillPlus.setLayout(new javax.swing.BoxLayout(jPanelSkillPlus, javax.swing.BoxLayout.LINE_AXIS));

        jScrollPane8.setViewportView(jPanelSkillPlusContent);

        jPanelSkillPlus.add(jScrollPane8);

        jTabbedPane1.addTab("XL+1", jPanelSkillPlus);

        jPanelUserArmor.setLayout(new java.awt.GridBagLayout());

        jPanel6.setLayout(new java.awt.GridBagLayout());

        jLabelUserArmorGender.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorGender.setText("");
        jLabelUserArmorGender.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorGender, gridBagConstraints);

        jLabelUserArmorHunterType.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorHunterType.setText("n^[^Cv");
        jLabelUserArmorHunterType.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorHunterType, gridBagConstraints);

        jLabelUserArmorRare.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorRare.setText("Ax");
        jLabelUserArmorRare.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorRare, gridBagConstraints);

        jLabelUserArmorSlot.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorSlot.setText("Xbg");
        jLabelUserArmorSlot.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorSlot, gridBagConstraints);

        jLabelUserArmorHunterRank.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorHunterRank.setText("n^[N");
        jLabelUserArmorHunterRank.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorHunterRank, gridBagConstraints);

        jLabelUserArmorTownRank.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorTownRank.setText("N");
        jLabelUserArmorTownRank.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorTownRank, gridBagConstraints);

        jLabelUserArmorInitialDeffence.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorInitialDeffence.setText("h");
        jLabelUserArmorInitialDeffence.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorInitialDeffence, gridBagConstraints);

        jLabelUserArmorFinalDeffence.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorFinalDeffence.setText("ŏIh");
        jLabelUserArmorFinalDeffence.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorFinalDeffence, gridBagConstraints);

        jLabelUserArmorShellFire.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorShellFire.setText("Αϐ");
        jLabelUserArmorShellFire.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorShellFire, gridBagConstraints);

        jLabelUserArmorShellWater.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorShellWater.setText("ϐ");
        jLabelUserArmorShellWater.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorShellWater, gridBagConstraints);

        jLabelUserArmorShellBrizard.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorShellBrizard.setText("Xϐ");
        jLabelUserArmorShellBrizard.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorShellBrizard, gridBagConstraints);

        jLabelUserArmorShellThunder.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorShellThunder.setText("ϐ");
        jLabelUserArmorShellThunder.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorShellThunder, gridBagConstraints);

        jLabelUserArmorShellDragon.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorShellDragon.setText("ϐ");
        jLabelUserArmorShellDragon.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorShellDragon, gridBagConstraints);

        jLabelUserArmorName.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorName.setText("O");
        jLabelUserArmorName.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorName, gridBagConstraints);

        jLabelUserArmorMaterialA.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelUserArmorMaterialA.setText("fA");
        jLabelUserArmorMaterialA.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorMaterialA, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jTextFieldUserArmorName, gridBagConstraints);

        jComboBoxUserArmorGender.setModel(createGenderModel2());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jComboBoxUserArmorGender, gridBagConstraints);

        jComboBoxUserArmorHunterType.setModel(createWeaponTypeModel2());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jComboBoxUserArmorHunterType, gridBagConstraints);

        jSpinnerUserArmorRare.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorRare, gridBagConstraints);

        jSpinnerUserArmorSlot.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorSlot, gridBagConstraints);

        jSpinnerUserArmorHunterRank.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorHunterRank, gridBagConstraints);

        jSpinnerUserArmorTownRank.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorTownRank, gridBagConstraints);

        jSpinnerUserArmorInitialDeffence.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorInitialDeffence, gridBagConstraints);

        jSpinnerUserArmorFinalDeffence.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorFinalDeffence, gridBagConstraints);

        jSpinnerUserArmorShellFire.setMinimumSize(new java.awt.Dimension(80, 28));
        jSpinnerUserArmorShellFire.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorShellFire, gridBagConstraints);

        jSpinnerUserArmorShellWater.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorShellWater, gridBagConstraints);

        jSpinnerUserArmorShellBrizard.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorShellBrizard, gridBagConstraints);

        jSpinnerUserArmorShellThunder.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorShellThunder, gridBagConstraints);

        jSpinnerUserArmorShellDragon.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorShellDragon, gridBagConstraints);

        jButtonUserNewArmor.setText("VK쐬");
        jButtonUserNewArmor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonUserNewArmorActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jButtonUserNewArmor, gridBagConstraints);

        jButtonUserSaveArmor.setText("\ۑ");
        jButtonUserSaveArmor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonUserSaveArmorActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jButtonUserSaveArmor, gridBagConstraints);

        jLabelUserArmorSkill1.setText("XLP");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorSkill1, gridBagConstraints);

        jLabelUserArmorSkill2.setText("XLQ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorSkill2, gridBagConstraints);

        jLabelUserArmorSkill3.setText("XLR");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorSkill3, gridBagConstraints);

        jLabelUserArmorSkill4.setText("XLS");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorSkill4, gridBagConstraints);

        jLabelUserArmorSkill5.setText("XLT");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorSkill5, gridBagConstraints);

        jComboBoxUserArmorSkill1.setModel(createSkillKindModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jComboBoxUserArmorSkill1, gridBagConstraints);

        jComboBoxUserArmorSkill2.setModel(createSkillKindModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jComboBoxUserArmorSkill2, gridBagConstraints);

        jComboBoxUserArmorSkill3.setModel(createSkillKindModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jComboBoxUserArmorSkill3, gridBagConstraints);

        jComboBoxUserArmorSkill4.setModel(createSkillKindModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jComboBoxUserArmorSkill4, gridBagConstraints);

        jComboBoxUserArmorSkill5.setModel(createSkillKindModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jComboBoxUserArmorSkill5, gridBagConstraints);

        jSpinnerUserArmorSkillPoint1.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorSkillPoint1, gridBagConstraints);

        jSpinnerUserArmorSkillPoint2.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorSkillPoint2, gridBagConstraints);

        jSpinnerUserArmorSkillPoint3.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorSkillPoint3, gridBagConstraints);

        jSpinnerUserArmorSkillPoint4.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorSkillPoint4, gridBagConstraints);

        jSpinnerUserArmorSkillPoint5.setPreferredSize(new java.awt.Dimension(80, 28));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jSpinnerUserArmorSkillPoint5, gridBagConstraints);

        jButtonUserTrashArmor.setText("\ݔ");
        jButtonUserTrashArmor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonUserTrashArmorActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jButtonUserTrashArmor, gridBagConstraints);

        jLabelUserArmorPartsType.setText("^Cv");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorPartsType, gridBagConstraints);

        jComboBoxUserArmorPartsType.setModel(createPartsNameModel());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jComboBoxUserArmorPartsType, gridBagConstraints);

        jLabelUserArmorMaterialB.setText("fB");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jLabelUserArmorMaterialB, gridBagConstraints);

        jPanel7.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel7.add(jTextFieldMaterialA1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel7.add(jSpinnerMaterialCountA1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel7.add(jTextFieldMaterialA2, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        jPanel7.add(jSpinnerMaterialCountA2, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel7.add(jTextFieldMaterialA3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        jPanel7.add(jSpinnerMaterialCountA3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel7.add(jTextFieldMaterialA4, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 0;
        jPanel7.add(jSpinnerMaterialCountA4, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel7.add(jTextFieldMaterialB1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel7.add(jSpinnerMaterialCountB1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel7.add(jTextFieldMaterialB2, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        jPanel7.add(jSpinnerMaterialCountB2, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel7.add(jTextFieldMaterialB3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        jPanel7.add(jSpinnerMaterialCountB3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel7.add(jTextFieldMaterialB4, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        jPanel7.add(jSpinnerMaterialCountB4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        jPanel6.add(jPanel7, gridBagConstraints);

        jCheckBoxDuplicateSkill.setText("n");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jCheckBoxDuplicateSkill, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelUserArmor.add(jPanel6, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.8;
        jPanelUserArmor.add(jTextFieldUserArmorMaster, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.8;
        jPanelUserArmor.add(jTextFieldUserArmorTrash, gridBagConstraints);

        jButton6.setText("S");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelUserArmor.add(jButton6, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.8;
        jPanelUserArmor.add(jTextFieldUserArmorUser, gridBagConstraints);

        jPanelUserArmorMaster.addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
                jPanelUserArmorMasterAncestorAdded(evt);
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });
        jScrollPane11.setViewportView(jPanelUserArmorMaster);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        jPanelUserArmor.add(jScrollPane11, gridBagConstraints);

        jScrollPane12.setViewportView(jPanelUserArmorUser);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        jPanelUserArmor.add(jScrollPane12, gridBagConstraints);

        jScrollPane15.setViewportView(jPanelUserArmorTrash);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        jPanelUserArmor.add(jScrollPane15, gridBagConstraints);

        jLabel29.setText("}X^[");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelUserArmor.add(jLabel29, gridBagConstraints);

        jLabel31.setText("[Uh");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelUserArmor.add(jLabel31, gridBagConstraints);

        jLabel32.setText("S~");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelUserArmor.add(jLabel32, gridBagConstraints);

        jButton9.setText("<html><br />p<br /><br /></html>");
        jButton9.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton9ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelUserArmor.add(jButton9, gridBagConstraints);

        jButton10.setText("<html><br />p<br /><br /></html>");
        jButton10.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton10ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelUserArmor.add(jButton10, gridBagConstraints);

        jButton11.setText("<html><br />p<br /><br /></html>");
        jButton11.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton11ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelUserArmor.add(jButton11, gridBagConstraints);

        jTabbedPane1.addTab("ǉh", jPanelUserArmor);

        jSplitPane2.setTopComponent(jTabbedPane1);

        jPanelDetail.setLayout(new java.awt.GridBagLayout());

        jButtonArmorSkillSeek.setText("ǉXLT");
        jButtonArmorSkillSeek.setEnabled(false);
        jButtonArmorSkillSeek.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonArmorSkillSeekActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanelDetail.add(jButtonArmorSkillSeek, gridBagConstraints);

        jButtonCopyArmorSet.setText("Rs[");
        jButtonCopyArmorSet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCopyArmorSetActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        jPanelDetail.add(jButtonCopyArmorSet, gridBagConstraints);

        jSplitPane4.setDividerLocation(600);

        jTextAreaDetail.setColumns(20);
        jTextAreaDetail.setEditable(false);
        jTextAreaDetail.setRows(5);
        jScrollPane9.setViewportView(jTextAreaDetail);

        jSplitPane4.setLeftComponent(jScrollPane9);

        jPanelMysetPicture.setLayout(new javax.swing.BoxLayout(jPanelMysetPicture, javax.swing.BoxLayout.LINE_AXIS));
        jSplitPane4.setRightComponent(jPanelMysetPicture);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelDetail.add(jSplitPane4, gridBagConstraints);

        jTabbedPane2.addTab("Zbg", jPanelDetail);

        jSplitPane2.setBottomComponent(jTabbedPane2);

        jSplitPane1.setRightComponent(jSplitPane2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jSplitPane1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    public PSItem getUserArmorSelected(JPanel panel) {
        int l = panel.getComponentCount();
        for(int i = 0; i < l; ++ i) {
            Component c = panel.getComponent(i);
            if (c instanceof MyRadioButtonForItems) {
                MyRadioButtonForItems x = (MyRadioButtonForItems)c;
                if (x.isSelected()) {
                    return x.getValue();
                }
            }
        }
        return null;
    }

    private void jButton9ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton9ActionPerformed
        PSItem item = getUserArmorSelected(jPanelUserArmorMaster);
        if (item != null) {
            userArmorInit(item);
            colorUserArmor(item);
        }
    }//GEN-LAST:event_jButton9ActionPerformed

    private void jButton10ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton10ActionPerformed
        PSItem item = getUserArmorSelected(jPanelUserArmorUser);
        if (item != null) {
            userArmorInit(item);
            colorUserArmor(item);
        }
    }//GEN-LAST:event_jButton10ActionPerformed

    private void jButton11ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton11ActionPerformed
        PSItem item = getUserArmorSelected(jPanelUserArmorTrash);
        if (item != null) {
            userArmorInit(item);
            colorUserArmor(item);
        }
    }//GEN-LAST:event_jButton11ActionPerformed

    private void jButtonQuickPlusOneActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonQuickPlusOneActionPerformed
        if (myEngine != null) {
            try {
                jTabbedPane1.setSelectedIndex(3);
                jPanelSkillPlusContent.removeAll();
                jPanelSkillPlusContent.setLayout(new GridBagLayout());
                myEngine.findPlusOne(this, new ProgressDialog(this, true));
            } catch (Throwable e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(PSFrame.this, e);
            }
        }
    }//GEN-LAST:event_jButtonQuickPlusOneActionPerformed

    private void jButtonSkillResetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSkillResetActionPerformed
        // TODO add your handling code here:
        if (JOptionPane.showConfirmDialog(this, "XLZbg܂", null, JOptionPane.YES_NO_OPTION) != JOptionPane.YES_OPTION) {
            return;
        }
        JPanel parent = jPanelSearchSkill;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            SkillPoint sp = null;
            if (c instanceof MyCheckBoxForSkillPoint) {
                MyCheckBoxForSkillPoint box = (MyCheckBoxForSkillPoint) c;
                if (box.isSelected()) {
                    box.setSelected(false);
                }
            }
        }
        doRepaintStatusLabel();
    }//GEN-LAST:event_jButtonSkillResetActionPerformed

    private void jListResultFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jListResultFocusGained
        this.jListResultValueChanged(null);
    }//GEN-LAST:event_jListResultFocusGained

    private PSSession session = null;
    private PSSearchItems items = null;
    private Engine myEngine = null;
    private ProgressDialog progress;

    public void startScan() {
        catchupSession();
        catchupCandidateItems();

        if (session.searchPlusAlpha) {
            jPanelSkillPlusContent.removeAll();
            jPanelCheckArmor.removeAll();
            jPanelSkillPlusContent.setLayout(new GridBagLayout());
            jTextFieldCheckSearch.setText("");
            progress = new ProgressDialog(this, true);
        }else if (session.searchPlusOneFast) {
            jPanelSkillPlusContent.removeAll();
            jPanelSkillPlusContent.setLayout(new GridBagLayout());
            jTextFieldCheckSearch.setText("");
            progress = new ProgressDialog(this, true);
        }else {
            jPanelCheckArmor.removeAll();
            jListResult.setModel(new DefaultListModel());
            progress = new ProgressDialog(this, true);
        }
    }

    public void doScan(final List<SkillSet> searchSkills) {
        if (session.searchPlusAlpha) {
            jTabbedPane1.setSelectedIndex(3);

            final ProgressDoubleDialog progress = new ProgressDoubleDialog(this, true);

            Thread _t = new Thread() {

                public void run() {
                    try {
                        ButtonGroup buttonGroup = new ButtonGroup();
                        ArrayList<SkillPoint> seekList = Repository.getSkillCategories().listPoints();
                        HashSet<String> alreadyDone = new HashSet<String>();
                        HashSet<String> alreadyQueued = new HashSet<String>();
                        progress.startProgress();
                        ArrayList<SkillSet> needRetest = new ArrayList<SkillSet>();
                        
                        int ppmax = searchSkills.size();

                        for (int pp0 = 0; pp0 < ppmax; ++ pp0) {
                            if (progress.isCanceled()) {
                                break;
                            }

                            SkillSet skills = (SkillSet)searchSkills.remove(0);
                            progress.setTitle("ǉXL (" + pp0 + "/" + ppmax + ")");

                            PSSession search2 = session.makeCopy();
                            search2.searchCharmMatome = false;
                            search2.searchMatome = false;
                            search2.searchPlusAlpha = false;
                            search2.searchPlusOneFast = false;
                            search2.searchMaxCount = 1;
                            search2.searchSkills = skills;

                            Engine superEngine = new Engine(search2, items);

                            List<Engine> baseEngineList = new ArrayList<Engine>();
                            baseEngineList.add(superEngine);
                            ArrayList<SkillSet> listFailed = new ArrayList<SkillSet>();

                            ArrayList<SkillPoint> seekList2 = seekList;

                            for (int x = 0; x < baseEngineList.size(); ++x) {
                                if (progress.isCanceled()) {
                                    break;
                                }
                                Engine baseEngine = baseEngineList.get(x);

                                progress.appendTextLine("Skill: " + baseEngine.session.searchSkills.getNamedSkillNameForSearch() + " +\n");

                                for (int i = 0; i < seekList2.size(); ++i) {
                                    SkillPoint seek = seekList2.get(i);

                                    long px = x * seekList2.size() + i;
                                    long pe = baseEngineList.size() * seekList2.size();

                                    progress.progress(px * 100.0 / pe);
                                    //System.out.println(px +" /" + pe);
                                    SkillSet newSkill = new SkillSet();
                                    newSkill.set_all(skills);
                                    int skillX = newSkill.indexOfKind(seek.skillKind);
                                    if (skillX >= 0) {
                                        int pointX = newSkill.point(skillX);
                                        boolean rangeX = newSkill.positive(skillX);
                                        if (rangeX) {
                                            if (pointX >= seek.skillPoint) {
                                                continue;
                                            }
                                        }else {
                                            if (pointX <= seek.skillPoint) {
                                                continue;
                                            }
                                        }
                                    }
                                    newSkill.set(seek.skillKind, seek.skillPoint, seek.positiveRange);

                                    if (alreadyDone.contains(newSkill.canonicalString())) {
                                        continue;
                                    }
                                    alreadyDone.add(newSkill.canonicalString());
                                    //str.append("\nSearch: " + newSkill);
                                    //progress.println(str.toString());

                                    boolean doSkip = false;
                                    /*if (baseEngine.listResultSearch.isEmpty()) {
                                    }else {
                                    }*/

                                    if (!doSkip) {
                                        if (alreadyFailed(newSkill, listFailed)) {
                                            doSkip = true;
                                        }
                                    }
                                    if (doSkip) {
                                        //str.append(" - skip");
                                        //progress.println(str.toString());
                                        continue;
                                    }

                                    boolean doneCheck = false;
                                    boolean found = false;
                                    
                                   
                                    if (!doneCheck) {
                                        PSSession search3 = session.makeCopy();
                                        search3.searchMaxCount = 1;
                                        search3.searchPlusOneFast = false;
                                        search3.searchPlusAlpha = false;
                                        search3.searchSkills = newSkill;

                                        myEngine = new Engine(search3, items);
                                        myEngine.useAnotherCheck = false;

                                        found = myEngine.pageActionScan(PSFrame.this, progress.getInternalProgress());
                                        doneCheck = true;
                                    }

                                    if (found) {
                                        StringBuffer str = new StringBuffer();
                                        str.append(newSkill.getNamedSkillNameForSearch() +" = \n");
                                        progress.appendTextLine(str.toString());
                                        
                                        SkillSet skill2_2 = new SkillSet();
                                        skill2_2.set_all(newSkill);
                                        if (alreadyQueued.contains(skill2_2.canonicalString())) {
                                            //nothing
                                        }else {
                                            alreadyQueued.add(skill2_2.canonicalString());
                                            searchSkills.add(skill2_2);
                                            ppmax ++;

                                            addSkillButtonToPlusOne(buttonGroup, skill2_2, 1, "");
                                        }
                                        if (seek.positiveRange == false) {
                                            needRetest.add(newSkill);
                                        }
                                    }else {
                                        listFailed.add(newSkill);
                                    }
                                    if (progress.isCanceled()) {
                                        break;
                                    }
                                }
                                if (progress.isCanceled()) {
                                    break;
                                }
                                baseEngine.listResultSearch = null;
                                baseEngine.plusOneFinder = null;
                                baseEngine.listForCheck = null;
                                baseEngine.listResultChecked = null;
                                baseEngine = null;
                            }
                        }

                        if (progress.isCanceled()) {
                            progress.appendTextLine("\nf");
                        }else {
                            Collection<SkillSet> listRetest = listupRetestSkills(needRetest);
                            for (SkillSet retest: listRetest) {
                                PSSession search3 = session.makeCopy();
                                search3.searchMaxCount = 1;
                                search3.searchPlusOneFast = false;
                                search3.searchPlusAlpha = false;
                                search3.searchSkills = retest;

                                myEngine = new Engine(search3, items);
                                myEngine.useAnotherCheck = false;

                                if (myEngine.pageActionScan(PSFrame.this, progress.getInternalProgress())) {
                                    StringBuffer str = new StringBuffer();
                                    str.append(retest.getNamedSkillNameForSearch() + " = \n");
                                    progress.appendTextLine(str.toString());

                                    addSkillButtonToPlusOne(buttonGroup, retest, 1, "");
                                }else {
                                    StringBuffer str = new StringBuffer();
                                    str.append(retest.getNamedSkillNameForSearch() + " = ~\n");
                                    progress.appendTextLine(str.toString());
                                }
                                //System.out.println("result = " + myEngine.listResultSearch);
                            }
                            progress.appendTextLine("\n");
                        }
                        progress.finishProgress();
                    } catch (Throwable e) {
                        progress.cancelProgress();
                        progress.finishProgress();
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(PSFrame.this, e);
                    }
                }
            };
            _t.start();
            progress.setVisible(true);

            return;
        }

        Thread _thread = new Thread() {

            public void run() {
                try {
                    TreeSet<PSArmorSet> tempList = new TreeSet<PSArmorSet>();

                    for (SkillSet skills : searchSkills) {
                        //System.out.println("Scanning " + skills);
                        session = session.makeCopy();
                        session.searchSkills = skills;
                        myEngine = new Engine(session, items);
                        myEngine.pageActionScan(PSFrame.this, progress);
                        tempList.addAll(myEngine.listResultSearch);
                        System.out.println("result " + myEngine.listResultSearch.size() +" += " + tempList.size());
                    }
                    progress.finishProgress();

                    myEngine.listResultSearch = new ArrayList(tempList);

                    SwingUtilities.invokeLater(new Runnable() {

                        public void run() {
                            myEngine.clearViewCount(true);
                            myEngine.pagePrepareCheck();
                            doRepaintCheckItems();
                            doRepaintResultList();
                            jTabbedPane1.setSelectedIndex(0);
                        }
                    });
                } catch (Throwable e) {
                    myEngine = null;
                    progress.cancelProgress();
                    progress.finishProgress();
                    jListResult.setModel(new DefaultListModel());
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(PSFrame.this, e);
                }
            }
        };
        _thread.start();
        progress.setVisible(true);
    }

    public HashSet<SkillSet> listupRetestSkills(Collection<SkillSet> listMinusSkill) {
        HashSet<SkillSet> ret = new HashSet<SkillSet>();
        boolean proc = false;
        for(SkillSet set : listMinusSkill) {
            for (int i = 0; i < set.size(); ++ i) {
                if (set.positive(i) == false) {
                    SkillSet newSet = new SkillSet();
                    newSet.set_all(set);
                    newSet.set(set.kind(i), set.point(i) + 1, true);
                    ret.add(newSet);
                    proc = true;
                }
            }
        }
        if (proc) {
            ret.addAll(listupRetestSkills(ret));
        }
        return ret;
    }
    
    public void addSkillButtonToPlusOne(final ButtonGroup bg, final SkillSet skills, final int count, final String example) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                JRadioButton b = new JRadioButton(skills.getNamedSkillNameForSearch().toString());

                GridBagConstraints cc = new GridBagConstraints();
                cc.gridx = 0;
                cc.gridy = GridBagConstraints.RELATIVE;
                cc.weightx = 1.0;
                cc.fill = java.awt.GridBagConstraints.BOTH;
                cc.anchor = java.awt.GridBagConstraints.NORTHWEST;
                jPanelSkillPlusContent.add(b, cc);
                bg.add(b);
                b.addActionListener(new ActionListener() {

                    public void actionPerformed(ActionEvent ae) {
                        if (JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(null, "ɐݒ肵܂", "", JOptionPane.OK_CANCEL_OPTION)) {
                            setSearchSkill(skills);
                        }
                    }
                });
                if (example.length() > 0) {
                    JLabel label = new JLabel("      " + String.valueOf(count) + (count == 100 ? "ȏ" : ""));
                    JLabel label2 = new JLabel("      " + example);
                    cc = new GridBagConstraints();
                    cc.gridx = 0;
                    cc.gridy = GridBagConstraints.RELATIVE;
                    cc.weightx = 1.0;
                    cc.fill = java.awt.GridBagConstraints.BOTH;
                    cc.anchor = java.awt.GridBagConstraints.NORTHWEST;
                    jPanelSkillPlusContent.add(label, cc);
                    cc = new GridBagConstraints();
                    cc.gridx = 0;
                    cc.gridy = GridBagConstraints.RELATIVE;
                    cc.weightx = 1.0;
                    cc.fill = java.awt.GridBagConstraints.BOTH;
                    cc.anchor = java.awt.GridBagConstraints.NORTHWEST;
                    jPanelSkillPlusContent.add(label2, cc);
                }
            }
        });
    }

    private void jButtonCandidate2CheckActionPerformed(java.awt.event.ActionEvent evt) {                                                       
        catchupSession();
        session.searchWithUsableStatus = true;
        if (session.searchSkills.isZero() && session.searchPlusOneFast) {
            JOptionPane.showMessageDialog(this, "XLw肹ɁA{P͂ł܂", "G[", JOptionPane.OK_OPTION);
            return;
        }
        jTabbedPane1.setSelectedIndex(1);

        boolean overCount = false;
        for (MyComboBoxForUsableCount box : getCandidate2List()) {
            PSItem item = box.item;
            if (item.existHunterRank > session.searchHunterRank
                    && item.existTownRank > session.searchTownRank) {
                if (box.getValue() != 0) {
                    overCount = true;
                    break;
                }
            } else {
                if (box.getValue() != Integer.MAX_VALUE) {
                    overCount = true;
                    break;
                }
            }
        }

        if (overCount) {
            int x = JOptionPane.showConfirmDialog(this, "iHR(܂TR)v܂B"
                    + "\n̂܂ܑsɂ́Au͂vA"
                    + "\nđsɂ́AuvA"
                    + "\n߂ɂ́AuLZvĂB", "iHR, TRmFĂB", JOptionPane.YES_NO_CANCEL_OPTION);
            if (x == JOptionPane.YES_OPTION) {
                //
            } else if (x == JOptionPane.NO_OPTION) {
                for (MyComboBoxForUsableCount box : getCandidate2List()) {
                    PSItem item = box.item;
                    if (item.existHunterRank > session.searchHunterRank
                            && item.existTownRank > session.searchTownRank) {
                        if (box.getValue() != 0) {
                            box.setValue(0);
                        }
                    } else {
                        if (box.getValue() != Integer.MAX_VALUE) {
                            box.setValue(Integer.MAX_VALUE);
                        }
                    }
                }
            } else { //Cancel
                return;
            }
        }
        startScan();
        ArrayList<SkillSet> searchList = Repository.getFukugo().searchFilter(session);
        doScan(searchList);
    }                                                      

    private void jListResultValueChanged(javax.swing.event.ListSelectionEvent evt) {                                         
        PSArmorSet set = (PSArmorSet) jListResult.getSelectedValue();
        if (set == null) {
            return;
        }

        printArmorSetDetail(set, false);
        doPaintPictureWithArmorSet(set);
    }                                        

    private void jComboBoxCheckDeffenceActionPerformed(java.awt.event.ActionEvent evt) {                                                       
        doRepaintResultList();
    }                                                      

    private void jButtonCopyArmorSetActionPerformed(java.awt.event.ActionEvent evt) {                                                    
        Toolkit kit = Toolkit.getDefaultToolkit();
        Clipboard clip = kit.getSystemClipboard();

        StringSelection ss = new StringSelection(jTextAreaDetail.getText());
        clip.setContents(ss, ss);
    }                                                   

    private void jSplitPane5AncestorMoved(javax.swing.event.AncestorEvent evt) {                                          
    }                                         

    private void jComboBoxOrderResultActionPerformed(java.awt.event.ActionEvent evt) {                                                     
        doRepaintResultList();
    }                                                    

    private void formComponentMoved(java.awt.event.ComponentEvent evt) {                                    
    }                                   

    private void jButtonSaveToMysetActionPerformed(java.awt.event.ActionEvent evt) {                                                   
        PSArmorSet set = (PSArmorSet) jListResult.getSelectedValue();
        if (set == null) {
            JOptionPane.showMessageDialog(this, "ɑIĂB");
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "I}CZbgɓo^܂H", null, JOptionPane.YES_NO_OPTION) != JOptionPane.YES_OPTION) {
            return;
        }
        PSMySet myset = Repository.getMySet();
        set = set.makeSetCopy();
        set.mysetName = "untitled";
        set.mysetNumber = myset.listMyset.size() + 1;
        myset.listMyset.add(set);
        //PSWrap charm = set.listItems.get(PSItemType.TYPE_CHARM);
        doStyleMysetList(true, "");
    }                                                  
    /**/
    private void jListMysetValueChanged(javax.swing.event.ListSelectionEvent evt) {                                        
        PSArmorSet set = (PSArmorSet) jListMyset.getSelectedValue();
        if (set == null) {
            return;
        }

        printArmorSetDetail(set, false);
        doPaintPictureWithArmorSet(set);
    }                                       

    private void jListMysetFocusGained(java.awt.event.FocusEvent evt) {                                       
        jListMysetValueChanged(null);
    }                                      

    private void jButtonMySetRemoveActionPerformed(java.awt.event.ActionEvent evt) {                                                   
        PSArmorSet set = (PSArmorSet) jListMyset.getSelectedValue();
        if (set == null) {
            JOptionPane.showMessageDialog(this, "ɑIĂB");
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "{ɍ폜܂H", null, JOptionPane.YES_NO_OPTION) != JOptionPane.YES_OPTION) {
            return;
        }
        PSMySet myset = Repository.getMySet();
        myset.listMyset.remove(set);
        for (int i = 0; i < myset.listMyset.size(); ++i) {
            set = myset.listMyset.get(i);
            set.mysetNumber = i + 1;
        }
        doStyleMysetList(true, "");
    }                                                  

    private void jButtonMySetNameActionPerformed(java.awt.event.ActionEvent evt) {                                                 
        PSArmorSet set = (PSArmorSet) jListMyset.getSelectedValue();
        if (set == null) {
            JOptionPane.showMessageDialog(this, "ɑIĂB");
            return;
        }
        String input = JOptionPane.showInputDialog(this, "V̂", set.mysetName);
        if (input == null) {
            return;
        }
        set.mysetName = input;
        doStyleMysetList(true, "");
    }                                                

    private void jButtonAddCharmActionPerformed(java.awt.event.ActionEvent evt) {                                                
        String name = (String) MyComboBoxUtil.getComboSelectedValue(jComboBoxCharmType);
        SkillKind kind1 = (SkillKind) MyComboBoxUtil.getComboSelectedValue(jComboBoxCharmSkillKind1);
        int n1 = MyComboBoxUtil.getComboSelectedInt(jComboBoxCharmSkillPoint1, 0);
        SkillKind kind2 = (SkillKind) MyComboBoxUtil.getComboSelectedValue(jComboBoxCharmSkillKind2);
        int n2 = MyComboBoxUtil.getComboSelectedInt(jComboBoxCharmSkillPoint2, 0);
        int slot = MyComboBoxUtil.getComboSelectedInt(jComboBoxCharmSlot, 0);
        if (name == null || name.length() == 0) {
            JOptionPane.showMessageDialog(this, "̃^CvIĂB");
            return;
        }
        if ((kind1 == null || n1 == 0) && slot == 0) {
            JOptionPane.showMessageDialog(this, "XL܂̓Xbgw肵ĂB");
            return;
        }

        PSItem item = new PSItem(PSItemType.TYPE_CHARM, name);
        item.slotCount = slot;
        if (kind1 != null && n1 != 0) {
            item.skills.set(kind1, n1, true);
        }
        if (kind2 != null && n2 != 0) {
            item.skills.set(kind2, n2, true);
        }

        Repository.getBaseItems().listBaseCharm.add(item);
        Repository.getBaseItems().invalidate();
        catchupCandidateItems();
        doRepaintCandidate3Items();
    }                                               

    private void jButtonCandidateSearchCancelActionPerformed(java.awt.event.ActionEvent evt) {                                                             
        jTextFieldCandidateSearch.setText("");
    }                                                            

    private void jButtonCheckSelectCancelActionPerformed(java.awt.event.ActionEvent evt) {                                                         
        jTextFieldCheckSearch.setText("");
    }                                                        

    public void setSearchSkill(SkillSet skills) {
        session.searchSkills = skills;
        updateSearchStatus();
    }

    public void updateSearchStatus() {
        jTextFieldMaxCount.setText(Long.toString(session.searchMaxCount));
        jCheckBoxMatome.setSelected(session.searchMatome);
        jCheckBoxCharmCSV.setSelected(session.searchCharmCSVLevel > 0);
        jCheckBoxCharmMatome.setSelected(session.searchCharmMatome);
        jCheckBoxOrderByDeffence.setSelected(session.searchOrderByDeffence);
        jCheckBoxFukugo.setSelected(session.searchFukugo);
        jCheckBoxPlusAlpha.setSelected(session.searchPlusAlpha);
        jCheckBoxPlusOneFast.setSelected(session.searchPlusOneFast);

        MyComboBoxUtil.setComboSelectedInt(this.jComboBoxGender, session.searchGenderType);
        MyComboBoxUtil.setComboSelectedInt(this.jComboBoxHR, session.searchHunterRank);
        MyComboBoxUtil.setComboSelectedInt(this.jComboBoxWeaponType, session.searchHunterType);
        MyComboBoxUtil.setComboSelectedInt(this.jComboBoxTownRank, session.searchTownRank);
        MyComboBoxUtil.setComboSelectedInt(this.jComboBoxWeaponSlot, session.searchWeaponSlotCount);

        SkillSet skills = session.searchSkills;

        JPanel parent = this.jPanelSearchSkill;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (c instanceof MyCheckBoxForSkillPoint) {
                MyCheckBoxForSkillPoint box = (MyCheckBoxForSkillPoint) c;
                SkillKind kind = box.skillPoint.skillKind;
                int point = box.skillPoint.skillPoint;
                boolean range = box.skillPoint.positiveRange;

                int index = skills.indexOfKind(kind);
                if (index < 0) {
                    box.setSelected(false);
                    continue;
                }
                if (skills.point(index) != point) {
                    box.setSelected(false);
                    continue;
                }
                if (skills.positive(index) != range) {
                    box.setSelected(false);
                    continue;
                }
                box.setSelected(true);
            }
        }
        doRepaintStatusLabel();
    }

    private void jButtonMySetSearchAgainActionPerformed(java.awt.event.ActionEvent evt) {                                                        
        PSArmorSet set = (PSArmorSet) jListMyset.getSelectedValue();
        if (set == null) {
            JOptionPane.showMessageDialog(this, "ɑIĂB");
            return;
        }

        PSSession newSearch = set.session.makeCopy();
        newSearch.searchMatome = session.searchMatome;
        newSearch.searchFukugo = session.searchFukugo;
        newSearch.searchPlusOneFast = session.searchPlusOneFast;
        newSearch.searchCharmMatome = session.searchCharmMatome;
        newSearch.searchCharmCSVLevel = session.searchCharmCSVLevel;
        newSearch.searchWithUsableStatus = session.searchWithUsableStatus;

        this.session = newSearch;
        this.session.searchSkills = set.targetSkills;
        Repository.getConfig().lastSession = newSearch;
        updateSearchStatus();
    }                                                       

    private void jButtonMySetPictureActionPerformed(java.awt.event.ActionEvent evt) {                                                    
        PSArmorSet set = (PSArmorSet) jListMyset.getSelectedValue();
        if (set == null) {
            JOptionPane.showMessageDialog(this, "ɑIĂB");
            return;
        }
        FileDialog fd = new FileDialog(this, "摜t@CIĂ", FileDialog.LOAD);
        fd.setVisible(true);

        String path = fd.getDirectory();
        if (path != null) {
            File f = new File(new File(fd.getDirectory()), fd.getFile());
            try {
                ImageIO.read(f);
            } catch (Throwable e) {
                JOptionPane.showMessageDialog(this, "摜J܂ł");
                return;
            }
            boolean localCopie = false;
            if (JOptionPane.showConfirmDialog(this, "[JɃRs[܂H", null, JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
                for (int i = 10000; i < 99999; ++i) {
                    int x = f.getName().lastIndexOf('.');
                    String ext = ".jpg";
                    if (x >= 0) {
                        ext = f.getName().substring(x);
                    }
                    File f2 = new File("MysetPicture." + i + ext);
                    if (f2.isFile() || f.isDirectory()) {
                        continue;
                    }
                    FileInputStream in = null;
                    FileOutputStream out = null;
                    try {
                        in = new FileInputStream(f);
                        out = new FileOutputStream(f2);
                        byte[] buffer = new byte[32768];

                        int size;
                        while ((size = in.read(buffer)) > 0) {
                            out.write(buffer, 0, size);
                        }
                    } catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "VXeG[Ԃ܂");
                        return;
                    } finally {
                        if (in != null) {
                            try {
                                in.close();
                            } catch (Throwable e) {
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            } catch (Throwable e) {
                            }
                        }
                    }
                    localCopie = true;
                    f = f2;
                    break;
                }
            }
            if (localCopie) {
                set.mysetPicturePath = f.getName();
            } else {
                set.mysetPicturePath = f.getPath();
            }
            doPaintPictureWithArmorSet(set);
        }
    }                                                   

    private void jButtonColorDefaultActionPerformed(java.awt.event.ActionEvent evt) {                                                    
        ThemeManagerDialog dialog = new ThemeManagerDialog(this, true);
        dialog.setVisible(true);
    }                                                   

    private void jButtonArmorSkillSeekActionPerformed(java.awt.event.ActionEvent evt) {                                                      
        if (prevPrintedArmorSet != null) {
            PSArmorSet set = prevPrintedArmorSet;
            prevPrintedArmorSet = null;
            printArmorSetDetail(set, true);
        }
    }                                                     

    private void formWindowIconified(java.awt.event.WindowEvent evt) {                                     
        System.gc();
    }                                    

    private void jButtonMemoryActionPerformed(java.awt.event.ActionEvent evt) {                                              
        System.gc();
    }                                             

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {                                         
        catchupSession();
        if (session.searchPlusOneFast) {
            if (session.searchSkills.isZero()) {
                JOptionPane.showMessageDialog(this, "XLw肹ɁA{P͂ł܂", "G[", JOptionPane.OK_OPTION);
                return;
            }
        }
        session.searchWithUsableStatus = false;
        startScan();
        ArrayList<SkillSet> searchList = Repository.getFukugo().searchFilter(session);
        doScan(searchList);
    }                           

    private void jToggleCandidateBySearchConditionActionPerformed(java.awt.event.ActionEvent evt) {                                                                  
        boolean controlVisible = jToggleCandidateBySearchCondition.isSelected();
        catchupSession();
        for (MyCheckBoxForCandidate box : getCandidateList()) {
            if (!controlVisible) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (session.isExistForThisHunter(box.item)) {
                    if (session.isExistForSkill(box.item)) {
                        visible = true;
                    }
                }
                box.setVisible(visible);
            }
        }
    }                                                                 

    private void jTextFieldCandidateSearchActionPerformed(java.awt.event.ActionEvent evt) {
        jTextFieldCandidateSearch.setText("");
    }                                                         

    private void jButtonCandidate2SearchCancelActionPerformed(java.awt.event.ActionEvent evt) {                                                              
        jTextFieldCandidate2Search.setText("");
    }                                                             

    private void jButtonCandidate3SearchCancelActionPerformed(java.awt.event.ActionEvent evt) {                                                              
        jTextFieldCandidate3Search.setText("");
    }                                                             

    private void jToggleCandidate2BySearchConditionActionPerformed(java.awt.event.ActionEvent evt) {                                                                   
        boolean controlVisible = jToggleCandidate2BySearchCondition.isSelected();
        catchupSession();
        for (MyComboBoxForUsableCount box : getCandidate2List()) {
            if (!controlVisible) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (session.isExistForThisHunter(box.item)) {
                    if (session.isExistForSkill(box.item)) {
                        visible = true;
                    }
                }
                box.setVisible(visible);
            }
        }
    }                                                                  

    private void jToggleCandidate3BySearchConditionActionPerformed(java.awt.event.ActionEvent evt) {                                                                   
        boolean controlVisible = jToggleCandidate3BySearchCondition.isSelected();
        catchupSession();
        for (MyCheckBoxForCandidate box : getCandidate3List()) {
            if (!controlVisible) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (session.isExistForThisHunter(box.item)) {
                    if (session.isExistForSkill(box.item)) {
                        visible = true;
                    }
                }
                box.setVisible(visible);
            }
        }
    }                                                                  

    private void jButtonCleanupCharmActionPerformed(java.awt.event.ActionEvent evt) {                                                    
        catchupCandidateItems();
        List<MyCheckBoxForCandidate> listRemove = new ArrayList<MyCheckBoxForCandidate>();
        for (MyCheckBoxForCandidate box : getCandidate3List()) {
            if (box.isSelected() == false) {
                listRemove.add(box);
            }
        }

        if (listRemove.size() == 0) {
            JOptionPane.showMessageDialog(this, "XgŃ`FbNĂȂo^{^łB");
            return;
        }

        if (JOptionPane.showConfirmDialog(this, "XgŃ`FbNĂȂA"
                + listRemove.size()
                + "̂o^܂B", "mF", JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION) {
            for (int i = 0; i < listRemove.size(); ++i) {
                MyCheckBoxForCandidate box = listRemove.get(i);
                PSItem item = box.item;
                items.setCandidateChecked(item, true);
                Repository.getBaseItems().listBaseCharm.remove(item);
                Repository.getBaseItems().invalidate();
            }
            doRepaintCandidate3Items();
        }
    }                                                   

    private void jComboBoxStyleResultListActionPerformed(java.awt.event.ActionEvent evt) {                                                         
        MyComboBoxElement boxItem = MyComboBoxUtil.getComboSelected(jComboBoxStyleResultList);
        if (boxItem.getLabel().equals("X^C")) {
            doStyleResultList(true);
        } else {
            doStyleResultList(false);
        }
    }                                                        

    private void jButtonCreditActionPerformed(java.awt.event.ActionEvent evt) {                                              
        CreditDialog dlg = new CreditDialog(this, true);
        dlg.setVisible(true);
    }                                             

    private void jButtonImportCharmCSVActionPerformed(java.awt.event.ActionEvent evt) {                                                      
        FileDialog fd = new FileDialog(this, "CHARM.csvIĂ", FileDialog.LOAD);
        fd.setVisible(true);

        String path = fd.getDirectory();
        if (path != null) {
            List<PSItem> listCharm = new ArrayList<PSItem>();
            File f = new File(new File(fd.getDirectory()), fd.getFile());
            try {
                listCharm = Repository.getResource().readCharmCSV(f.getAbsolutePath());
            } catch (Throwable e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "t@CJ܂ł");
                return;
            }
            int addCount = 0;
            List<PSItem> listOriginal = Repository.getBaseItems().listBaseCharm;
            for (PSItem item : listCharm) {
                boolean doubly = false;
                for (PSItem test : listOriginal) {
                    if (test.slotCount == item.slotCount && test.skills.equals(item.skills)) {
                        doubly = true;
                        break;
                    }
                }
                if (doubly == false) {
                    listOriginal.add(item);
                    addCount++;
                }
            }
            Repository.getBaseItems().invalidate();
            JOptionPane.showMessageDialog(this, addCount + "ǉ܂B");
            catchupCandidateItems();
            doRepaintCandidate3Items();
        }
    }                                                     

    private void jButtonMySetImportActionPerformed(java.awt.event.ActionEvent evt) {                                                   
        FileDialog fd = new FileDialog(this, "MYSET.txtIĂ", FileDialog.LOAD);
        fd.setVisible(true);

        String path = fd.getDirectory();
        if (path != null) {
            ArrayList<PSArmorSet> listArmorSet = new ArrayList<PSArmorSet>();
            File f = new File(new File(fd.getDirectory()), fd.getFile());
            PSMySet myset = Repository.getMySet();
            try {
                myset.readMySetTXTFile(f.getPath(), listArmorSet);
            } catch (Throwable e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "t@CJ܂ł");
                return;
            }
            int addCount = 0;
            for (PSArmorSet set : listArmorSet) {
                boolean doubly = false;
                for (PSArmorSet seek : myset.listMyset) {
                    if (set.equals(seek)) {
                        doubly = true;
                        break;
                    }
                }
                if (!doubly) {
                    myset.listMyset.add(set);
                    addCount++;
                }
            }
            for (int i = 0; i < myset.listMyset.size(); ++i) {
                PSArmorSet set = myset.listMyset.get(i);
                set.mysetNumber = i + 1;
            }
            JOptionPane.showMessageDialog(this, addCount + "ǉ܂B");
            doStyleMysetList(true, "");
        }
    }                                                  

    private void jCheckBoxPlusOneActionPerformed(java.awt.event.ActionEvent evt) {                                                 
    }                                                

    private void jTextFieldMySetFindFocusGained(java.awt.event.FocusEvent evt) {                                                
    }                                               

    private void jTextFieldMySetFindKeyPressed(java.awt.event.KeyEvent evt) {                                               
    }                                              

    private void JButtonMysetReleaseActionPerformed(java.awt.event.ActionEvent evt) {                                                    
        jTextFieldMySetFind.setText("");
    }                                                   

    private void jCheckBoxPlusAlphaActionPerformed(java.awt.event.ActionEvent evt) {                                                   
        if (jCheckBoxPlusAlpha.isSelected()) {
            jCheckBoxPlusOneFast.setSelected(false);
        }
    }                                                  

    private void jCheckBoxPlusOneFastActionPerformed(java.awt.event.ActionEvent evt) {                                                     
        if (jCheckBoxPlusOneFast.isSelected()) {
            jCheckBoxPlusAlpha.setSelected(false);
        }
    }                                                    

    private void jTabbedPane1AncestorAdded(javax.swing.event.AncestorEvent evt) {                                           
    }                                          

    private void jPanelCandidateArmorAncestorAdded(javax.swing.event.AncestorEvent evt) {                                                   
        tabMoved(jPanelCandidate);
    }                                                  

    private void jListMysetAncestorAdded(javax.swing.event.AncestorEvent evt) {                                         
        tabMoved(jListMyset);
    }                                        

    private void jPanelUserArmorMasterAncestorAdded(javax.swing.event.AncestorEvent evt) {                                                    
        tabMoved(jPanelUserArmorMaster);
    }                                                   

    private void jButtonUserNewArmorActionPerformed(java.awt.event.ActionEvent evt) {
        userArmorInit(new PSItem(0));
        colorUserArmor(null);
    }                                        

    private void jButtonUserSaveArmorActionPerformed(java.awt.event.ActionEvent evt) {
        int hunterRank = Repository.getBaseItems().maxHunterRank;
        int townRank = Repository.getBaseItems().maxTownRank;
        PSItem item = readUserArmorPanel();
        colorUserArmor(item);
        int opt = JOptionPane.showConfirmDialog(rootPane, "{Ƀ[Uۑ܂?", "mF", JOptionPane.OK_CANCEL_OPTION);
        if (opt != JOptionPane.OK_OPTION) {
            return;
        }
        userArmorSave(item);
        if (hunterRank != Repository.getBaseItems().maxHunterRank
         || townRank != Repository.getBaseItems().maxTownRank) {
            jComboBoxHR.setModel(createHRModel());
            jComboBoxTownRank.setModel(createTownRankModel());
        }
    }                                        

    private void jButtonUserTrashArmorActionPerformed(java.awt.event.ActionEvent evt) {
        int hunterRank = Repository.getBaseItems().maxHunterRank;
        int townRank = Repository.getBaseItems().maxTownRank;

        PSItem item = readUserArmorPanel();
        colorUserArmor(item);
        int opt = JOptionPane.showConfirmDialog(rootPane, "{ɂݔۑ܂?", "mF", JOptionPane.OK_CANCEL_OPTION);
        if (opt != JOptionPane.OK_OPTION) {
            return;
        }
        userArmorTrash(item);

        if (hunterRank != Repository.getBaseItems().maxHunterRank
         || townRank != Repository.getBaseItems().maxTownRank) {
            jComboBoxHR.setModel(createHRModel());
            jComboBoxTownRank.setModel(createTownRankModel());
        }
    }                                        

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton10;
    private javax.swing.JButton jButton11;
    private javax.swing.JButton jButton6;
    private javax.swing.JButton jButton9;
    private javax.swing.JButton jButtonAddCharm;
    private javax.swing.JButton jButtonArmorSkillSeek;
    private javax.swing.JButton jButtonCandidate2Check;
    private javax.swing.JButton jButtonCleanupCharm;
    private javax.swing.JButton jButtonColorDefault;
    private javax.swing.JButton jButtonCopyArmorSet;
    private javax.swing.JButton jButtonCredit;
    private javax.swing.JButton jButtonImportCharmCSV;
    private javax.swing.JButton jButtonMemory;
    private javax.swing.JButton jButtonMySetImport;
    private javax.swing.JButton jButtonMySetName;
    private javax.swing.JButton jButtonMySetPicture;
    private javax.swing.JButton jButtonMySetRemove;
    private javax.swing.JButton jButtonMySetSearchAgain;
    private javax.swing.JButton jButtonQuickPlusOne;
    private javax.swing.JButton jButtonSaveToMyset;
    private javax.swing.JButton jButtonSkillReset;
    private javax.swing.JButton jButtonUserNewArmor;
    private javax.swing.JButton jButtonUserSaveArmor;
    private javax.swing.JButton jButtonUserTrashArmor;
    private javax.swing.JCheckBox jCheckBoxCharmCSV;
    private javax.swing.JCheckBox jCheckBoxCharmMatome;
    private javax.swing.JCheckBox jCheckBoxDuplicateSkill;
    private javax.swing.JCheckBox jCheckBoxFukugo;
    private javax.swing.JCheckBox jCheckBoxMatome;
    private javax.swing.JCheckBox jCheckBoxOrderByDeffence;
    private javax.swing.JCheckBox jCheckBoxPlusAlpha;
    private javax.swing.JCheckBox jCheckBoxPlusOneFast;
    private javax.swing.JComboBox jComboBoxCharmSkillKind1;
    private javax.swing.JComboBox jComboBoxCharmSkillKind2;
    private javax.swing.JComboBox jComboBoxCharmSkillPoint1;
    private javax.swing.JComboBox jComboBoxCharmSkillPoint2;
    private javax.swing.JComboBox jComboBoxCharmSlot;
    private javax.swing.JComboBox jComboBoxCharmType;
    private javax.swing.JComboBox jComboBoxCheckDeffence;
    private javax.swing.JComboBox jComboBoxGender;
    private javax.swing.JComboBox jComboBoxHR;
    private javax.swing.JComboBox jComboBoxOrderResult;
    private javax.swing.JComboBox jComboBoxStyleResultList;
    private javax.swing.JComboBox jComboBoxTownRank;
    private javax.swing.JComboBox jComboBoxUserArmorGender;
    private javax.swing.JComboBox jComboBoxUserArmorHunterType;
    private javax.swing.JComboBox jComboBoxUserArmorPartsType;
    private javax.swing.JComboBox jComboBoxUserArmorSkill1;
    private javax.swing.JComboBox jComboBoxUserArmorSkill2;
    private javax.swing.JComboBox jComboBoxUserArmorSkill3;
    private javax.swing.JComboBox jComboBoxUserArmorSkill4;
    private javax.swing.JComboBox jComboBoxUserArmorSkill5;
    private javax.swing.JComboBox jComboBoxWeaponSlot;
    private javax.swing.JComboBox jComboBoxWeaponType;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel29;
    private javax.swing.JLabel jLabel31;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabelGender;
    private javax.swing.JLabel jLabelHR;
    private javax.swing.JLabel jLabelSkill;
    private javax.swing.JLabel jLabelStatus;
    private javax.swing.JLabel jLabelTownRank;
    private javax.swing.JLabel jLabelUserArmorFinalDeffence;
    private javax.swing.JLabel jLabelUserArmorGender;
    private javax.swing.JLabel jLabelUserArmorHunterRank;
    private javax.swing.JLabel jLabelUserArmorHunterType;
    private javax.swing.JLabel jLabelUserArmorInitialDeffence;
    private javax.swing.JLabel jLabelUserArmorMaterialA;
    private javax.swing.JLabel jLabelUserArmorMaterialB;
    private javax.swing.JLabel jLabelUserArmorName;
    private javax.swing.JLabel jLabelUserArmorPartsType;
    private javax.swing.JLabel jLabelUserArmorRare;
    private javax.swing.JLabel jLabelUserArmorShellBrizard;
    private javax.swing.JLabel jLabelUserArmorShellDragon;
    private javax.swing.JLabel jLabelUserArmorShellFire;
    private javax.swing.JLabel jLabelUserArmorShellThunder;
    private javax.swing.JLabel jLabelUserArmorShellWater;
    private javax.swing.JLabel jLabelUserArmorSkill1;
    private javax.swing.JLabel jLabelUserArmorSkill2;
    private javax.swing.JLabel jLabelUserArmorSkill3;
    private javax.swing.JLabel jLabelUserArmorSkill4;
    private javax.swing.JLabel jLabelUserArmorSkill5;
    private javax.swing.JLabel jLabelUserArmorSlot;
    private javax.swing.JLabel jLabelUserArmorTownRank;
    private javax.swing.JLabel jLabelWeaponType;
    private javax.swing.JList jListMyset;
    private javax.swing.JList jListResult;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanelCandidate;
    private javax.swing.JPanel jPanelCandidate2;
    private javax.swing.JPanel jPanelCandidate2Armor;
    private javax.swing.JPanel jPanelCandidate3;
    private javax.swing.JPanel jPanelCandidate3Armor;
    private javax.swing.JPanel jPanelCandidateAction;
    private javax.swing.JPanel jPanelCandidateArmor;
    private javax.swing.JPanel jPanelCheck;
    private javax.swing.JPanel jPanelCheckArmor;
    private javax.swing.JPanel jPanelDetail;
    private javax.swing.JPanel jPanelMyset;
    private javax.swing.JPanel jPanelMysetPicture;
    private javax.swing.JPanel jPanelResult;
    private javax.swing.JPanel jPanelSearch;
    private javax.swing.JPanel jPanelSearchSkill;
    private javax.swing.JPanel jPanelSkillPlus;
    private javax.swing.JPanel jPanelSkillPlusContent;
    private javax.swing.JPanel jPanelToolBar;
    private javax.swing.JPanel jPanelUserArmor;
    private javax.swing.JPanel jPanelUserArmorMaster;
    private javax.swing.JPanel jPanelUserArmorTrash;
    private javax.swing.JPanel jPanelUserArmorUser;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane11;
    private javax.swing.JScrollPane jScrollPane12;
    private javax.swing.JScrollPane jScrollPane15;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JScrollPane jScrollPane6;
    private javax.swing.JScrollPane jScrollPane7;
    private javax.swing.JScrollPane jScrollPane8;
    private javax.swing.JScrollPane jScrollPane9;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JSeparator jSeparator6;
    private javax.swing.JSpinner jSpinnerMaterialCountA1;
    private javax.swing.JSpinner jSpinnerMaterialCountA2;
    private javax.swing.JSpinner jSpinnerMaterialCountA3;
    private javax.swing.JSpinner jSpinnerMaterialCountA4;
    private javax.swing.JSpinner jSpinnerMaterialCountB1;
    private javax.swing.JSpinner jSpinnerMaterialCountB2;
    private javax.swing.JSpinner jSpinnerMaterialCountB3;
    private javax.swing.JSpinner jSpinnerMaterialCountB4;
    private javax.swing.JSpinner jSpinnerUserArmorFinalDeffence;
    private javax.swing.JSpinner jSpinnerUserArmorHunterRank;
    private javax.swing.JSpinner jSpinnerUserArmorInitialDeffence;
    private javax.swing.JSpinner jSpinnerUserArmorRare;
    private javax.swing.JSpinner jSpinnerUserArmorShellBrizard;
    private javax.swing.JSpinner jSpinnerUserArmorShellDragon;
    private javax.swing.JSpinner jSpinnerUserArmorShellFire;
    private javax.swing.JSpinner jSpinnerUserArmorShellThunder;
    private javax.swing.JSpinner jSpinnerUserArmorShellWater;
    private javax.swing.JSpinner jSpinnerUserArmorSkillPoint1;
    private javax.swing.JSpinner jSpinnerUserArmorSkillPoint2;
    private javax.swing.JSpinner jSpinnerUserArmorSkillPoint3;
    private javax.swing.JSpinner jSpinnerUserArmorSkillPoint4;
    private javax.swing.JSpinner jSpinnerUserArmorSkillPoint5;
    private javax.swing.JSpinner jSpinnerUserArmorSlot;
    private javax.swing.JSpinner jSpinnerUserArmorTownRank;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JSplitPane jSplitPane3;
    private javax.swing.JSplitPane jSplitPane4;
    private javax.swing.JSplitPane jSplitPane5;
    private javax.swing.JSplitPane jSplitPane6;
    private javax.swing.JSplitPane jSplitPane8;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTabbedPane jTabbedPane2;
    private javax.swing.JTextArea jTextAreaDetail;
    private javax.swing.JTextField jTextFieldCandidate2Search;
    private javax.swing.JTextField jTextFieldCandidate3Search;
    private javax.swing.JTextField jTextFieldCandidateSearch;
    private javax.swing.JTextField jTextFieldCheckSearch;
    private javax.swing.JTextField jTextFieldMaterialA1;
    private javax.swing.JTextField jTextFieldMaterialA2;
    private javax.swing.JTextField jTextFieldMaterialA3;
    private javax.swing.JTextField jTextFieldMaterialA4;
    private javax.swing.JTextField jTextFieldMaterialB1;
    private javax.swing.JTextField jTextFieldMaterialB2;
    private javax.swing.JTextField jTextFieldMaterialB3;
    private javax.swing.JTextField jTextFieldMaterialB4;
    private javax.swing.JTextField jTextFieldMaxCount;
    private javax.swing.JTextField jTextFieldMySetFind;
    private javax.swing.JTextField jTextFieldSkillSearch;
    private javax.swing.JTextField jTextFieldUserArmorMaster;
    private javax.swing.JTextField jTextFieldUserArmorName;
    private javax.swing.JTextField jTextFieldUserArmorTrash;
    private javax.swing.JTextField jTextFieldUserArmorUser;
    private javax.swing.JToggleButton jToggleCandidate2BySearchCondition;
    private javax.swing.JToggleButton jToggleCandidate3BySearchCondition;
    private javax.swing.JToggleButton jToggleCandidateBySearchCondition;
    // End of variables declaration//GEN-END:variables

    private void catchupSession() {
        PSSession newSession = new PSSession();

        newSession.searchHunterRank = MyComboBoxUtil.getComboSelectedInt(jComboBoxHR, 0);
        newSession.searchTownRank = MyComboBoxUtil.getComboSelectedInt(jComboBoxTownRank, 0);
        newSession.searchGenderType = MyComboBoxUtil.getComboSelectedInt(jComboBoxGender, 0);
        newSession.searchHunterType = MyComboBoxUtil.getComboSelectedInt(jComboBoxWeaponType, 0);
        newSession.searchWeaponSlotCount = MyComboBoxUtil.getComboSelectedInt(jComboBoxWeaponSlot, 0);
        newSession.searchMaxCount = Long.parseLong(jTextFieldMaxCount.getText());
        newSession.searchMatome = jCheckBoxMatome.isSelected();
        newSession.searchFukugo = jCheckBoxFukugo.isSelected();
        newSession.searchPlusOneFast = jCheckBoxPlusOneFast.isSelected();
        newSession.searchPlusAlpha = jCheckBoxPlusAlpha.isSelected();
        newSession.searchCharmMatome = jCheckBoxCharmMatome.isSelected();
        newSession.searchCharmCSVLevel = this.jCheckBoxCharmCSV.isSelected() ? 1 : 0;
        newSession.searchOrderByDeffence = jCheckBoxOrderByDeffence.isSelected();
        newSession.searchWithUsableStatus = session.searchWithUsableStatus;
        SkillSet skillForm = new SkillSet();

        JPanel parent = jPanelSearchSkill;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            SkillPoint sp = null;
            if (c instanceof MyCheckBoxForSkillPoint) {
                MyCheckBoxForSkillPoint box = (MyCheckBoxForSkillPoint) c;
                if (box.isSelected()) {
                    sp = box.skillPoint;
                }
            }
            if (sp == null) {
                continue;
            }

            boolean mergeTurn = false;
            int sp2 = skillForm.indexOfKind(sp.skillKind);
            if (sp2 >= 0) {
                if (sp.skillKind == skillForm.kind(sp2)) {
                    if (sp.skillPoint > skillForm.point(sp2)) {
                        mergeTurn = true;
                    }
                }
            }
            if (!mergeTurn) {
                skillForm.set(sp.skillKind, sp.skillPoint, sp.positiveRange);
            }
        }

        this.session = newSession;
        this.session.searchSkills = skillForm;
        Repository.getConfig().lastSession = this.session;
    }

    private void catchupCandidateItems() {
        initializeData("Ώۖh");
        DecorationCount counter = new DecorationCount(new ArrayList<PSItem>());
        items.searchUsableCount = counter;

        for (MyCheckBoxForCandidate box : getCandidateList()) {
            items.setCandidateChecked(box.item, box.isSelected());
        }
        for (MyComboBoxForUsableCount box : getCandidate2List()) {
            counter.set(box.item, box.getValue());
        }
        for (MyCheckBoxForCandidate box : getCandidate3List()) {
            items.setCandidateChecked(box.item, box.isSelected());
        }
    }

    private void catchupCheckItems() {
        JPanel parent = jPanelCheckArmor;

        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (c instanceof MyCheckBoxForCheckTool) {
                MyCheckBoxForCheckTool box = (MyCheckBoxForCheckTool) c;
                items.setViewChecked(box.wrap.item, box.isSelected());
            }
        }
    }

    public ComboBoxModel createHRModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        for (int n = Repository.getBaseItems().maxHunterRank; n >= 1; -- n) {
            String name = String.valueOf(n);
            MyComboBoxElement item = new MyComboBoxElement(Zenkaku(name), n);
            model.addElement(item);
        }
        return model;
    }

    public ComboBoxModel createTownRankModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        for (int n = Repository.getBaseItems().maxTownRank; n >= 1; -- n) {
            String name = String.valueOf(n);
            MyComboBoxElement item = new MyComboBoxElement("" + Zenkaku(name), n);
            model.addElement(item);
        }
        return model;
    }

    public ComboBoxModel createGenderModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        MyComboBoxElement[] itemList = {
            new MyComboBoxElement("j", 1),
            new MyComboBoxElement("", 2),};
        for (MyComboBoxElement item : itemList) {
            model.addElement(item);
        }
        return model;
    }

    public ComboBoxModel createGenderModel2() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        MyComboBoxElement[] itemList = {
            new MyComboBoxElement("jp", 0),
            new MyComboBoxElement("j", 1),
            new MyComboBoxElement("", 2),};
        for (MyComboBoxElement item : itemList) {
            model.addElement(item);
        }
        return model;
    }

    public ComboBoxModel createWeaponTypeModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        MyComboBoxElement[] itemList = {
            new MyComboBoxElement("m", 1),
            new MyComboBoxElement("Ki[", 2)
        };
        for (MyComboBoxElement item : itemList) {
            model.addElement(item);
        }
        return model;
    }

    public ComboBoxModel createWeaponTypeModel2() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        MyComboBoxElement[] itemList = {
            new MyComboBoxElement("p", 0),
            new MyComboBoxElement("m", 1),
            new MyComboBoxElement("Ki[", 2)
        };
        for (MyComboBoxElement item : itemList) {
            model.addElement(item);
        }
        return model;
    }

    public ComboBoxModel createWesponSlotModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        MyComboBoxElement[] itemList = {
            new MyComboBoxElement("XȂ", 0),
            new MyComboBoxElement("őP", 1),
            new MyComboBoxElement("őQ", 2),
            new MyComboBoxElement("őR", 3),
            new MyComboBoxElement("iȂ", -1),};
        for (MyComboBoxElement item : itemList) {
            model.addElement(item);
        }
        return model;
    }

    public ComboBoxModel createPartsNameModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        model.addElement(new MyComboBoxElement("h", PSItemType.TYPE_HEAD));
        model.addElement(new MyComboBoxElement("h", PSItemType.TYPE_BODY));
        model.addElement(new MyComboBoxElement("rh", PSItemType.TYPE_ARM));
        model.addElement(new MyComboBoxElement("h", PSItemType.TYPE_WEIST));
        model.addElement(new MyComboBoxElement("h", PSItemType.TYPE_LEG));
        model.addElement(new MyComboBoxElement("", PSItemType.TYPE_CHARM));
        model.addElement(new MyComboBoxElement("i", PSItemType.TYPE_DECORATION));
        return model;
    }

    private void repaintCandidateItemsSub(JPanel parent, Map<String, List<PSItem>> map) {
        parent.removeAll();
        parent.setLayout(new GridBagLayout());
        DecorationCount counter = items.searchUsableCount;

        //System.out.println(myItems);
        //System.out.println(counter);

        GridBagConstraints cc;
        for (String name : map.keySet()) {
            cc = new java.awt.GridBagConstraints();
            cc.gridx = 0;
            cc.fill = java.awt.GridBagConstraints.BOTH;
            cc.anchor = java.awt.GridBagConstraints.NORTHWEST;

            JLabel label = new JLabel(name);
            parent.add(label, cc);

            for (PSItem item : map.get(name)) {
                cc = new java.awt.GridBagConstraints();
                cc.gridx = 0;
                cc.fill = java.awt.GridBagConstraints.BOTH;
                cc.anchor = java.awt.GridBagConstraints.NORTHWEST;

                if (item.itemType == PSItemType.TYPE_DECORATION) {
                    Integer x = null;
                    int value = Integer.MAX_VALUE;
                    if (counter != null) {
                        x = counter.get(item);
                        if (x != null) {
                            value = x;
                        }
                    }
                    MyComboBoxForUsableCount box = new MyComboBoxForUsableCount(this, item, value);
                    parent.add(box, cc);
                } else {
                    MyCheckBoxForCandidate box = new MyCheckBoxForCandidate(this, item);
                    box.setForegroundEx(Repository.getResource().getArmorColor(item));
                    parent.add(box, cc);
                }
            }
        }

        cc = new java.awt.GridBagConstraints();
        cc.gridx = 0;
        cc.fill = java.awt.GridBagConstraints.BOTH;
        cc.anchor = java.awt.GridBagConstraints.NORTHWEST;
        cc.weightx = 1.0;
        cc.weighty = 1.0;

        JPanel fit = new JPanel();
        parent.add(fit, cc);
    }

    public void doRepaintCandidateItems() {
        PSBaseItems items = Repository.getBaseItems();
        LinkedHashMap<String, List<PSItem>> map = new LinkedHashMap<String, List<PSItem>>();
        map.put("sht", items.listEquipHead);
        map.put("sht", items.listEquipBody);
        map.put("srht", items.listEquipArm);
        map.put("sht", items.listEquipWeist);
        map.put("sht", items.listEquipLeg);
        repaintCandidateItemsSub(jPanelCandidateArmor, map);
        SwingUtilities.updateComponentTreeUI(jPanelCandidateArmor);
        jToggleCandidateBySearchCondition.setSelected(false);
    }

    public void doRepaintCandidate2Items() {
        PSBaseItems items = Repository.getBaseItems();
        LinkedHashMap<String, List<PSItem>> map = new LinkedHashMap<String, List<PSItem>>();
        map.put("sit", items.listDecoration);
        repaintCandidateItemsSub(jPanelCandidate2Armor, map);
        SwingUtilities.updateComponentTreeUI(jPanelCandidate2Armor);
        jToggleCandidate2BySearchCondition.setSelected(false);
    }

    public void doRepaintCandidate3Items() {
        PSBaseItems items = Repository.getBaseItems();
        LinkedHashMap<String, List<PSItem>> map = new LinkedHashMap<String, List<PSItem>>();
        map.put("st", items.listCharm);
        repaintCandidateItemsSub(jPanelCandidate3Armor, map);
        SwingUtilities.updateComponentTreeUI(jPanelCandidate3Armor);
        jToggleCandidate3BySearchCondition.setSelected(false);
    }

    public void doPrintTextArea(final String text, final String page) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                if (page.equals("Zbg")) {
                    PSFrame.this.jTextAreaDetail.setText(text);
                    SwingUtilities.invokeLater(new Runnable() {

                        public void run() {
                            jTextAreaDetail.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                        }
                    });
                }
                JTabbedPane parent = jTabbedPane2;
                Component c = null;
                for (int i = 0; i < parent.getTabCount(); ++i) {
                    String title = parent.getTitleAt(i);
                    if (title.equals(page)) {
                        c = parent.getComponentAt(i);
                        parent.setSelectedIndex(i);
                        break;
                    }
                }
                if (c == null) {
                    c = new MyPanelForText();
                    parent.addTab(page, c);
                    parent.setSelectedIndex(parent.getTabCount() - 1);
                }
                if (c instanceof MyPanelForText) {
                    MyPanelForText textPanel = (MyPanelForText) c;
                    textPanel.setText(text);
                }
            }
        });
    }

    public void doRepaintCheckItems() {
        JPanel parent = jPanelCheckArmor;

        GridBagConstraints cc;

        parent.removeAll();
        parent.setLayout(new GridBagLayout());

        if (myEngine == null) {
            return;
        }

        PSItemList items = myEngine.listForCheck;
        Map<String, List<PSWrap>> map = new LinkedHashMap<String, List<PSWrap>>();
        map.put("sht", items.listEquipHead);
        map.put("sht", items.listEquipBody);
        map.put("srht", items.listEquipArm);
        map.put("sht", items.listEquipWeist);
        map.put("sht", items.listEquipLeg);
        if (Repository.getResource().existCharm()) {
            map.put("st", items.listCharm);
        }

        for (String name : map.keySet()) {
            List<PSWrap> list = map.get(name);

            cc = new java.awt.GridBagConstraints();
            cc.gridx = 0;
            cc.fill = java.awt.GridBagConstraints.BOTH;
            cc.anchor = java.awt.GridBagConstraints.NORTHWEST;

            JLabel label = new JLabel(name);
            parent.add(label, cc);

            for (PSWrap item : list) {
                cc = new java.awt.GridBagConstraints();
                cc.gridx = 0;
                cc.fill = java.awt.GridBagConstraints.BOTH;
                cc.anchor = java.awt.GridBagConstraints.NORTHWEST;

                MyCheckBoxForCheckTool box = new MyCheckBoxForCheckTool(this, item);
                parent.add(box, cc);
                box.setForegroundEx(Repository.getResource().getArmorColor(item.item));
            }
        }

        cc = new java.awt.GridBagConstraints();
        cc.gridx = 0;
        cc.fill = java.awt.GridBagConstraints.BOTH;
        cc.anchor = java.awt.GridBagConstraints.NORTHWEST;
        cc.weightx = 1.0;
        cc.weighty = 1.0;

        JPanel fit = new JPanel();
        parent.add(fit, cc);

        SwingUtilities.updateComponentTreeUI(parent);
    }

    public void doRepaintResultList() {
        catchupCheckItems();
        jListResult.setModel(new DefaultListModel());

        if (myEngine == null) {
            return;
        }

        try {
            PSConfig config = Repository.getConfig();
            DefaultListModel model = new DefaultListModel();
            TreeSet<Integer> deffence = new TreeSet<Integer>(new Comparator<Integer>() {

                public int compare(Integer n1, Integer n2) {
                    return n2.compareTo(n1);
                }
            });
            Object obj = jComboBoxCheckDeffence.getSelectedItem();
            int selDef = 0;
            if (obj != null && obj instanceof Integer) {
                selDef = (Integer) obj;
            }

            myEngine.clearViewCount(false);
            int dispNumber = 1;
            String dispName = "";
            Integer x = (Integer) MyComboBoxUtil.getComboSelectedInt(jComboBoxOrderResult, 0);
            if (x != null) {
                ArmorSetComparator comp = new ArmorSetComparator(x);
                Collections.sort(myEngine.listResultSearch, comp);
            }
            myEngine.listResultChecked = new ArrayList<PSArmorSet>();
            for (PSArmorSet myset : myEngine.listResultSearch) {
                boolean filter = false;

                for (PSWrap armor : myset.listItems) {
                    if (items.isViewChecked(armor.item) == false) {
                        filter = true;
                        break;
                    }
                }
                if (!filter) {
                    deffence.add(myset.defMax);
                    if (myset.defMax >= selDef) {
                        myset.mysetNumber = dispNumber++;
                        myset.mysetName = dispName;
                        myset.session = session;
                        model.addElement(myset);
                        myEngine.listResultChecked.add(myset);
                        for (PSWrap wrap : myset.listItems) {
                            wrap.item.viewCount++;
                        }
                    }
                }
            }
            jListResult.setModel(model);
            DefaultComboBoxModel combo = new DefaultComboBoxModel();
            Object sel = null;
            combo.addElement(0);
            for (Integer n : deffence) {
                combo.addElement(n);
                if (n.equals(selDef)) {
                    sel = n;
                }
            }
            combo.setSelectedItem(obj);

            for (int i = 0; i < jPanelCheckArmor.getComponentCount(); ++i) {
                Component c = jPanelCheckArmor.getComponent(i);
                if (c instanceof MyCheckBoxForCheckTool) {
                    MyCheckBoxForCheckTool cb = (MyCheckBoxForCheckTool) c;
                    cb.updateViewCount();
                }
            }
            jComboBoxCheckDeffence.setModel(combo);
            SwingUtilities.updateComponentTreeUI(jPanelCheckArmor);
        } catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void doRepaintSkillCategoryItems() {
        SkillCategories categories = Repository.getSkillCategories();

        JPanel parent = jPanelSearchSkill;
        GridBagConstraints cc;

        parent.removeAll();
        parent.setLayout(new GridBagLayout());

        SkillKind prevSkillKind = null;
        SkillSet skills = session.searchSkills;

        for (String categoryName : categories.listCategoryNames()) {
            cc = new java.awt.GridBagConstraints();
            cc.gridx = 0;
            cc.fill = java.awt.GridBagConstraints.BOTH;
            cc.anchor = java.awt.GridBagConstraints.NORTHWEST;

            JLabelEx label = new JLabelEx("s" + categoryName + "t");
            label.setForegroundEx(Color.cyan);
            parent.add(label, cc);
            prevSkillKind = null;

            for (SkillPoint point : categories.listPointByCategory(categoryName)) {
                cc = new java.awt.GridBagConstraints();
                cc.gridx = 0;
                cc.fill = java.awt.GridBagConstraints.BOTH;
                cc.anchor = java.awt.GridBagConstraints.NORTHWEST;

                boolean selected;
                selected = (skills.pointOfKind(point.skillKind) == point.skillPoint);
                MyCheckBoxForSkillPoint box = new MyCheckBoxForSkillPoint(this, point, selected);
                parent.add(box, cc);

                if (point.skillPoint < 0 && point.positiveRange == false) {
                    SkillPoint negative = new SkillPoint(point.skillKind, point.skillPoint + 1, true, point.pointName + "O");

                    cc = new java.awt.GridBagConstraints();
                    cc.gridx = 0;
                    cc.fill = java.awt.GridBagConstraints.BOTH;
                    cc.anchor = java.awt.GridBagConstraints.NORTHWEST;

                    selected = (skills.pointOfKind(negative.skillKind) == negative.skillPoint);
                    box = new MyCheckBoxForSkillPoint(this, negative, selected);
                    parent.add(box, cc);
                }
            }
        }

        cc = new java.awt.GridBagConstraints();
        cc.gridx = 0;
        cc.fill = java.awt.GridBagConstraints.BOTH;
        cc.anchor = java.awt.GridBagConstraints.NORTHWEST;
        cc.weightx = 1.0;
        cc.weighty = 1.0;

        JPanel fit = new JPanel();
        parent.add(fit, cc);

        SwingUtilities.updateComponentTreeUI(parent);
    }

    public void onMySkillPointCheck(SkillPoint skillPoint) {
        JPanel parent = jPanelSearchSkill;

        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (c instanceof MyCheckBoxForSkillPoint) {
                MyCheckBoxForSkillPoint box = (MyCheckBoxForSkillPoint) c;
                if (box.skillPoint.skillKind == skillPoint.skillKind) {
                    if (box.skillPoint.skillPoint == skillPoint.skillPoint) {
                        continue;
                    }
                    box.setSelected(false);
                }
            }
        }
        doRepaintStatusLabel();
    }

    public void doRepaintStatusLabel() {
        catchupSession();
        StringBuilder str = new StringBuilder();

        str.append("F");

        String[] genderTypeNameList = {"jp", "j", ""};
        String[] hunderTypeNameList = {"m^Ki[p", "m", "Ki["};

        String gender = genderTypeNameList[session.searchGenderType];
        String hunter = hunderTypeNameList[session.searchHunterType];
        String hr = "HR" + session.searchHunterRank;
        String tr = "" + session.searchTownRank;
        List<String> armorSkill = session.searchSkills.getNamedSkillNameForSearch();
        int weaponSlot = session.searchWeaponSlotCount;

        str.append("");
        str.append(hr);
        str.append(tr);
        str.append("");
        str.append(gender);
        str.append("/");
        str.append(hunter);
        boolean first = true;
        for (String name : armorSkill) {
            if (first) {
                str.append("");
                first = false;
            } else {
                str.append("");
            }
            str.append(name);
        }
        if (!first) {
            str.append("");
        }
        this.jLabelStatus.setText(str.toString());
    }

    public static String Zenkaku(String value) {
        String hankaku = "+-0123456789"
                + "abcdefghijklmnopqrstuvwxyz"
                + "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String zenkaku = "{[OPQRSTUVWX"
                + ""
                + "`abcdefghijklmnopqrstuvwxy";
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            int idx = hankaku.indexOf(c);
            if (idx >= 0) {
                str.append(zenkaku.charAt(idx));
            } else {
                str.append(c);
            }
        }
        return str.toString();
    }

    public void doStyleResultList(final boolean wrapIcon) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                if (wrapIcon) {
                    jListResult.setLayoutOrientation(JList.HORIZONTAL_WRAP);
                    jListResult.setVisibleRowCount(0);
                    //jListResult.setFixedCellWidth(JPanelArmorSet.defaultWidth);
                    //jListResult.setFixedCellHeight(JPanelArmorSet.defaultHeight);
                    MyListCellArmorSet comp = new MyListCellArmorSet(false);
                    jListResult.setCellRenderer(comp);
                    jScrollPane1.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
                    jScrollPane1.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
                } else {
                    jListResult.setLayoutOrientation(JList.VERTICAL);
                    jListResult.setVisibleRowCount(0);
                    MyListCellArmorSetText comp = new MyListCellArmorSetText();
                    //jListResult.setFixedCellWidth(-1);
                    //jListResult.setFixedCellHeight(-1);
                    jListResult.setCellRenderer(comp);
                    jScrollPane1.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
                    jScrollPane1.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
                }
            }
        });
    }
    public static final int RESULT_ORDER_DEFFENCE = 1;
    public static final int RESULT_ORDER_SLOTCOUNT = 2;
    public static final int RESULT_ORDER_WEAPONSLOTCOUNT = 3;
    public static final int RESULT_ORDER_SHELL_FIRE = 4;
    public static final int RESULT_ORDER_SHELL_WATER = 5;
    public static final int RESULT_ORDER_SHELL_ICE = 6;
    public static final int RESULT_ORDER_SHELL_THUNDER = 7;
    public static final int RESULT_ORDER_SHELL_TOTAL = 8;
    public static final int RESULT_ORDER_SHELL_DRAGON = 9;
    public static final int RESULT_ORDER_HEAD = 10;
    public static final int RESULT_ORDER_BODY = 11;
    public static final int RESULT_ORDER_ARM = 12;
    public static final int RESULT_ORDER_WEIST = 13;
    public static final int RESULT_ORDER_LEG = 14;
    public static final int RESULT_ORDER_CHARM = 15;

    public static class ArmorSetComparator implements Comparator<PSArmorSet> {

        int key;

        public ArmorSetComparator(int key) {
            this.key = key;
        }

        public int compare(PSArmorSet set1, PSArmorSet set2) {
            switch (key) {
                case RESULT_ORDER_DEFFENCE:
                    return set2.defMax - set1.defMax;
                case RESULT_ORDER_SLOTCOUNT:
                    return set2.totalSlotCount - set1.totalSlotCount;
                case RESULT_ORDER_WEAPONSLOTCOUNT:
                    return set1.weaponSlotCount - set2.weaponSlotCount;
                case RESULT_ORDER_SHELL_FIRE:
                    return set2.shellFire - set1.shellFire;
                case RESULT_ORDER_SHELL_WATER:
                    return set2.shellWater - set1.shellWater;
                case RESULT_ORDER_SHELL_ICE:
                    return set2.shellIce - set1.shellIce;
                case RESULT_ORDER_SHELL_THUNDER:
                    return set2.shellThunder - set1.shellThunder;
                case RESULT_ORDER_SHELL_DRAGON:
                    return set2.shellDragon - set1.shellDragon;
                case RESULT_ORDER_SHELL_TOTAL:
                    return (set2.shellFire + set2.shellWater + set2.shellIce + set2.shellThunder + set2.shellDragon)
                            - (set1.shellFire + set1.shellWater + set1.shellIce + set1.shellThunder + set1.shellDragon);
                case RESULT_ORDER_HEAD:
                    return set1.listItems.get(0).item.name.compareTo(set2.listItems.get(0).item.name);
                case RESULT_ORDER_BODY:
                    return set1.listItems.get(1).item.name.compareTo(set2.listItems.get(1).item.name);
                case RESULT_ORDER_ARM:
                    return set1.listItems.get(2).item.name.compareTo(set2.listItems.get(2).item.name);
                case RESULT_ORDER_WEIST:
                    return set1.listItems.get(3).item.name.compareTo(set2.listItems.get(3).item.name);
                case RESULT_ORDER_LEG:
                    return set1.listItems.get(4).item.name.compareTo(set2.listItems.get(4).item.name);
                case RESULT_ORDER_CHARM:
                    return set1.listItems.get(5).item.name.compareTo(set2.listItems.get(5).item.name);
                default:
                    return set2.defMax - set1.defMax;
            }
        }
    }

    public ComboBoxModel createResultOrderModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        model.addElement(new MyComboBoxElement("h", RESULT_ORDER_DEFFENCE));
        model.addElement(new MyComboBoxElement("X", RESULT_ORDER_SLOTCOUNT));
        model.addElement(new MyComboBoxElement("X", RESULT_ORDER_WEAPONSLOTCOUNT));
        model.addElement(new MyComboBoxElement("Αϐ", RESULT_ORDER_SHELL_FIRE));
        model.addElement(new MyComboBoxElement("ϐ", RESULT_ORDER_SHELL_WATER));
        model.addElement(new MyComboBoxElement("Xϐ", RESULT_ORDER_SHELL_ICE));
        model.addElement(new MyComboBoxElement("ϐ", RESULT_ORDER_SHELL_THUNDER));
        model.addElement(new MyComboBoxElement("ϐ", RESULT_ORDER_SHELL_DRAGON));
        model.addElement(new MyComboBoxElement("ϐv", RESULT_ORDER_SHELL_TOTAL));
        model.addElement(new MyComboBoxElement("h", RESULT_ORDER_HEAD));
        model.addElement(new MyComboBoxElement("h", RESULT_ORDER_BODY));
        model.addElement(new MyComboBoxElement("rh", RESULT_ORDER_ARM));
        model.addElement(new MyComboBoxElement("h", RESULT_ORDER_WEIST));
        model.addElement(new MyComboBoxElement("h", RESULT_ORDER_LEG));
        model.addElement(new MyComboBoxElement("", RESULT_ORDER_CHARM));
        return model;
    }

    public static String[] MySplit(String str) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer segment = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == ' ' || c == '@' || c == ',' || c == '/') {
                if (segment.length() > 0) {
                    result.add(segment.toString());
                    segment.setLength(0);
                }
            } else {
                segment.append(c);
            }
        }
        if (segment.length() > 0) {
            result.add(segment.toString());
            segment.setLength(0);
        }
        String[] ret = new String[result.size()];
        result.toArray(ret);
        return ret;
    }

    public void doStyleMysetList(final boolean wrapIcon, final String findPhrase) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                DefaultListModel model = new DefaultListModel();
                for (PSArmorSet set : Repository.getMySet().listMyset) {
                    if (findPhrase != null && findPhrase.length() > 0) {
                        String[] list = MySplit(findPhrase);
                        boolean hit = false;

                        for (int x = 0; x < list.length; ++x) {
                            if (list[x].length() == 0) {
                                continue;
                            }
                            hit = false;
                            if (set.mysetName.contains(list[x])) {
                                hit = true;
                            }
                            if (!hit) {
                                List<String> listStr = set.targetSkills.getNamedSkillNameForSearch();
                                if (listStr.toString().contains(list[x])) {
                                    hit = true;
                                }
                            }
                            if (!hit) {
                                for (int i = 0; i < set.listItems.size(); ++i) {
                                    if (set.listItems.get(i).toString().contains(list[x])) {
                                        hit = true;
                                    }
                                }
                            }
                            if (!hit) {
                                break;
                            }
                            continue;
                        }
                        if (hit) {
                            model.addElement(set);
                        }
                    } else {
                        model.addElement(set);
                    }
                }
                jListMyset.setModel(model);
                if (wrapIcon) {
                    jListMyset.setLayoutOrientation(JList.HORIZONTAL_WRAP);
                    jListMyset.setVisibleRowCount(0);
                    //jListResult.setFixedCellWidth(JPanelArmorSet.defaultWidth);
                    //jListResult.setFixedCellHeight(JPanelArmorSet.defaultHeight);
                    MyListCellArmorSet comp = new MyListCellArmorSet(true);
                    jListMyset.setCellRenderer(comp);
                    jScrollPane7.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
                    jScrollPane7.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
                } else {
                    jListMyset.setLayoutOrientation(JList.VERTICAL);
                    jListMyset.setVisibleRowCount(0);
                    MyListCellArmorSetText comp = new MyListCellArmorSetText();
                    //jListResult.setFixedCellWidth(-1);
                    //jListResult.setFixedCellHeight(-1);
                    jListMyset.setCellRenderer(comp);
                    jScrollPane7.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
                    jScrollPane7.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
                }
            }
        });

    }

    PSArmorSet prevPrintedArmorSet = null;

    public void compactDecorationSlotList(PSArmorSet set, List<DecorationSlot> list) {
        Comparator<DecorationSlot> c = new Comparator<DecorationSlot>() {

            public int compare(DecorationSlot t, DecorationSlot t1) {
                int x = t.mapDecoration.compareTo(t1.mapDecoration);
                if (x == 0) {
                    x = t.mapBodyDecoration.compareTo(t1.mapBodyDecoration);
                }
                return x;
            }
        };
        TreeSet<DecorationSlot> tree = new TreeSet<DecorationSlot>(c);
        tree.addAll(list);
        if (tree.size() != list.size()) {
            list.clear();
            list.addAll(tree);
        }
    }

    public void printArmorSetDetail(PSArmorSet set, boolean skillSeek) {
        if (prevPrintedArmorSet == set) {
            return;
        }
        prevPrintedArmorSet = set;
        if (!skillSeek) {
            this.jButtonArmorSkillSeek.setEnabled(true);
        } else {
            this.jButtonArmorSkillSeek.setEnabled(false);
        }

        DecorationMatcherFull matcher = null;
        ArrayList<DecorationSlot> listSlot = new ArrayList<DecorationSlot>();

        boolean retireSearch = false;

        set.session.searchSkills = set.targetSkills;
        matcher = new DecorationMatcherFull(set.session);
        matcher.canHaveEnoughDecoration(set, true, listSlot);
        set.calculateUseList(null);

        if (skillSeek) {
            if (set.weaponSlotCount < 0) {
                PSArmorSet set2 = set.makeSetCopy();
                set2.weaponSlotCount = 0;
                set = set2;
            }

            PlusOneFinder finder = new PlusOneFinder(set.session, set.targetSkills, set.session == this.session ? items : null);
            finder.useNestedFind = true;
            ArrayList<DecorationSlot> prevResult = new ArrayList<DecorationSlot>(listSlot);
            finder.findAnyPlusOne(set, listSlot, 10000, prevResult, null);

            List<PSArmorSet> tryList = new ArrayList<PSArmorSet>();
            tryList.add(set);
            finder.tryFixMinus(tryList, listSlot);
            finder.getResultMap(tryList);
            retireSearch = finder.wasTimeout;
        }
        compactDecorationSlotList(set, listSlot);

        StringBuilder strArmor = new StringBuilder();
        StringBuilder strItem = new StringBuilder();

        String[] genderTypeNameList = {"jp", "j", ""};
        String[] hunderTypeNameList = {"mKi[p", "m", "Ki["};

        String gender = genderTypeNameList[set.session.searchGenderType];
        String hunter = hunderTypeNameList[set.session.searchHunterType];
        String hr = "HR" + set.session.searchHunterRank;
        String tr = "" + set.session.searchTownRank;
        int defInitial = set.defInitial;
        int defMax = set.defMax;
        int totalSlot = set.totalSlotCount;
        int weaponSlot = set.weaponSlotCount;

        String[] armorTitle = new String[]{
            "", "", "r", "", "", ""
        };

        strArmor.append("" + gender + "^" + hunter + "" + hr + "^" + tr);
        strArmor.append("---" + Engine.VERSION + "---\n");
        strArmor.append("h [" + defInitial + "" + defMax + "]^X[" + totalSlot + "]^X[" + weaponSlot + "]");
        strArmor.append("\n");
        for (int i = 0; i < set.listItems.size(); ++i) {
            PSWrap item = set.listItems.get(i);
            strArmor.append(armorTitle[i]);
            strArmor.append(":");
            strArmor.append(item.item.getArmorNameAndSlot());
            strArmor.append("\n");
        }
        strArmor.append("ϐl:");
        strArmor.append(set.getShellValuesAsText());
        strArmor.append("\n");
        strArmor.append("|Cg:").append(set.setSkills.skillToString(SkillSet.SKILLPOINT_POINT_COMPARATOR, false)).append("\n");
        strArmor.append("----------------------------------\n");

        TreeMap<SkillSet, List<DecorationSlot>> printMap = new TreeMap<SkillSet, List<DecorationSlot>>();
        for (DecorationSlot deco : listSlot) {
            SkillSet skills = new SkillSet();
            skills.sum_all(deco.getFullDecorationSkills());
            skills.sum_all(set.setSkills);

            SkillSet canonicalSkill = skills.getNamedSkillSetForDisplay();

            List<DecorationSlot> e = printMap.get(canonicalSkill);
            if (e == null) {
                e = new ArrayList<DecorationSlot>();
                printMap.put(canonicalSkill, e);
            }
            e.add(deco);
        }

        SkillSet temp2 = set.setSkills;
        for (SkillSet e : printMap.keySet()) {
            List<DecorationSlot> elist = printMap.get(e);
            for (int i = 0; i < elist.size(); ++i) {
                DecorationSlot deco = elist.get(i);
                SkillSet skills = new SkillSet();
                skills.sum_all(deco.getFullDecorationSkills());
                skills.sum_all(temp2);
                strArmor.append("i").append(Zenkaku(String.valueOf(i + 1)));
                strArmor.append(":");
                String emptyString = deco.countEmptyForDisp() == 0 ? "" : Zenkaku(String.valueOf(deco.countEmptyForDisp()));
                String decorationString = deco.toDecorationString();
                if (emptyString.length() > 0) {
                    strArmor.append("󂫃X~");
                    strArmor.append(emptyString);
                    if (decorationString.length() > 0) {
                        strArmor.append("A");
                    }
                }
                strArmor.append(decorationString);
                strArmor.append("\n");
                strArmor.append("|Cg:").append(skills.skillToString(SkillSet.SKILLPOINT_POINT_COMPARATOR, false)).append("\n");
            }
            strArmor.append("XLF").append("\n");
            for (String name : e.getNamedSkillNameForDisplay()) {
                strArmor.append("@");
                strArmor.append(name);
                strArmor.append("\n");
            }
            strArmor.append("----------------------------------\n");
        }

        if (retireSearch) {
            strArmor.append("---------ȏ\ł܂------- (10b[)\n");
        }

        strItem.append("\n");

        for (int i = 0; i < set.listItems.size(); ++i) {
            String text = set.listItems.get(i).item.getFormatted() + set.listItems.get(i).getAdditionalInfo();
            strItem.append(text);
            strItem.append("\n");
        }
        LinkedHashSet<PSItem> decoSet = new LinkedHashSet<PSItem>();
        for (DecorationSlot slot : listSlot) {
            for (int k = 0; k < slot.mapDecoration.size(); ++k) {
                if (slot.mapDecoration.count(k) != 0) {
                    decoSet.add(slot.mapDecoration.deco(k));
                }
            }
            for (int k = 0; k < slot.mapBodyDecoration.size(); ++k) {
                if (slot.mapBodyDecoration.count(k) != 0) {
                    decoSet.add(slot.mapBodyDecoration.deco(k));
                }
            }
        }
        for (PSItem item : decoSet) {
            String text = item.getFormatted();
            strItem.append(text);
            strItem.append("\n");
        }
        doPrintTextArea(strItem.toString(), "ACeڍ");
        doPrintTextArea(strArmor.toString(), "Zbg");
    }

    public ComboBoxModel createStyleModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        model.addElement(new MyComboBoxElement("X^C", ""));
        model.addElement(new MyComboBoxElement("Xg", ""));
        return model;
    }

    public ComboBoxModel createCharmNameModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        String[] names = null;
        if (Repository.getResource().existCharmG()) {
            names = new String[] {
                "m̌",
                "m̌",
                "Rm̌",
                "̌",
                "̌",
                "ǂ̌",
                "̌",
                "pY̌",
                "`̌",
                "V̌",
                "",
                "\"};
        }else {
            names = new String[] {
                "m̌",
                "m̌",
                "Rm̌",
                "̌",
                "̌",
                "ǂ̌",
                "̌",
                "",
                "\"};
        }
        for (int i = 0; i < names.length; ++i) {
            model.addElement(new MyComboBoxElement(names[i], names[i]));
        }

        return model;
    }


    public ComboBoxModel createSkillKindModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        model.addElement(new MyComboBoxElement("", null));
        for (SkillKind kind : Repository.getSkillCategories().listupKindOrdered()) {
            MyComboBoxElement item = new MyComboBoxElement(kind.name, kind);
            model.addElement(item);
        }
        return model;
    }

    public ComboBoxModel createMaterialNumberModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        for (int i = 0; i < 20; ++ i) {
            MyComboBoxElement item = new MyComboBoxElement(String.valueOf(i), i);
            model.addElement(item);
        }
        return model;
    }

    public ComboBoxModel createSkillPointModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        for (int i = -20; i <= 20; ++i) {
            String text = "";
            if (i == 0) {
                text = "";
            } else if (i > 0) {
                text = "+" + i;
            } else if (i < 0) {
                text = String.valueOf(i);
            }
            MyComboBoxElement item = new MyComboBoxElement(text, i);
            model.addElement(item);
            if (i == 0) {
                model.setSelectedItem(item);
            }
        }
        return model;
    }

    public ComboBoxModel createCharmSlotModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        for (int i = 0; i <= 3; ++i) {
            String text = "";
            if (i == 0) {
                text = "Ȃ";
            } else if (i > 0) {
                text = "" + i + "X";
            }
            MyComboBoxElement item = new MyComboBoxElement(text, i);
            model.addElement(item);
        }
        return model;
    }
    public static final int TYPE_ALL = -100;
    public static final int TYPE_ALL_EXCLUDE_CHARM = -101;
    public static final int TYPE_RANK_1TO3 = -102;

    public boolean isIMEEditing(javax.swing.JTextField field) {
        StyledDocument document = (StyledDocument) field.getDocument();
        for (int i = 0; i < document.getLength(); i++) {
            Element e = document.getCharacterElement(i);
            if (e.getAttributes().isDefined(StyleConstants.ComposedTextAttribute)) {
                return true;
            }
        }
        return false;
    }

    public void doTextSearchCandidate() {
        String text = jTextFieldCandidateSearch.getText();
        if (isIMEEditing(jTextFieldCandidateSearch)) {
            return;
        }
        for (MyCheckBoxForCandidate box : getCandidateList()) {
            if (text.length() == 0) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (box.item.name.contains(text)) {
                    visible = true;
                }
                if (!visible) {
                    SkillSet set = box.item.skills;
                    for (int x = 0; x < set.size(); ++x) {
                        if (set.kind(x).name.contains(text)) {
                            visible = true;
                            break;
                        }
                    }
                }
                box.setVisible(visible);
            }
        }
    }

    public void doSkillSearch() {
        String text = jTextFieldSkillSearch.getText();
        if (isIMEEditing(jTextFieldSkillSearch)) {
            return;
        }
        //TODO
        for (MyCheckBoxForSkillPoint box : getSkillSelectList()) {
            if (text.length() == 0) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (box.skillPoint.pointName.contains(text)) {
                    visible = true;
                }
                if (!visible) {
                    SkillKind kind = box.skillPoint.skillKind;
                    if (kind.name.contains(text)) {
                        visible = true;
                    }
                }
                box.setVisible(visible);
            }
        }
    }
    
    public void doTextSearchCandidate2() {
        String text = jTextFieldCandidate2Search.getText();
        if (isIMEEditing(jTextFieldCandidate2Search)) {
            return;
        }
        for (MyComboBoxForUsableCount box : getCandidate2List()) {
            if (text.length() == 0) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (box.item.name.contains(text)) {
                    visible = true;
                }
                if (!visible) {
                    SkillSet set = box.item.skills;
                    for (int x = 0; x < set.size(); ++x) {
                        if (set.kind(x).name.contains(text)) {
                            visible = true;
                            break;
                        }
                    }
                }
                box.setVisible(visible);
            }
        }
    }

    public void doTextSearchCandidate3() {
        String text = jTextFieldCandidate3Search.getText();
        if (isIMEEditing(jTextFieldCandidate3Search)) {
            return;
        }
        for (MyCheckBoxForCandidate box : getCandidate3List()) {
            if (text.length() == 0) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (box.item.name.contains(text)) {
                    visible = true;
                }
                if (!visible) {
                    SkillSet set = box.item.skills;
                    for (int x = 0; x < set.size(); ++x) {
                        if (set.kind(x).name.contains(text)) {
                            visible = true;
                            break;
                        }
                    }
                }
                box.setVisible(visible);
            }
        }
    }

    public void doTextSearchMySetFind() {
        String text = jTextFieldMySetFind.getText();
        if (isIMEEditing(jTextFieldMySetFind)) {
            return;
        }
        doStyleMysetList(true, text);
    }

    public void doTextSearchCheck() {
        String text = jTextFieldCheckSearch.getText();
        if (isIMEEditing(jTextFieldCheckSearch)) {
            return;
        }
        JPanel parent = jPanelCheckArmor;
        for (MyCheckBoxForCheckTool box : getChecktoolList()) {
            if (text.length() == 0) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (box.wrap.item.name.contains(text)) {
                    visible = true;
                }
                if (!visible) {
                    SkillSet set = box.wrap.item.skills;
                    for (int x = 0; x < set.size(); ++x) {
                        if (set.kind(x).name.contains(text)) {
                            visible = true;
                            break;
                        }
                    }
                }
                box.setVisible(visible);
            }
        }
    }

    public List<MyCheckBoxForSkillPoint> getSkillSelectList() {
        List<MyCheckBoxForSkillPoint> boxList = new ArrayList<MyCheckBoxForSkillPoint>();
        JPanel parent = jPanelSearchSkill;

        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (c instanceof MyCheckBoxForSkillPoint) {
                MyCheckBoxForSkillPoint box = (MyCheckBoxForSkillPoint) c;
                boxList.add(box);
            }
        }
        return boxList;
    }

    public List<MyCheckBoxForCandidate> getCandidateList() {
        List<MyCheckBoxForCandidate> boxList = new ArrayList<MyCheckBoxForCandidate>();
        JPanel parent = jPanelCandidateArmor;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (c instanceof MyCheckBoxForCandidate) {
                MyCheckBoxForCandidate box = (MyCheckBoxForCandidate) c;
                boxList.add(box);
            }
        }
        return boxList;
    }

    public List<MyComboBoxForUsableCount> getCandidate2List() {
        List<MyComboBoxForUsableCount> boxList = new ArrayList<MyComboBoxForUsableCount>();
        JPanel parent = jPanelCandidate2Armor;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (c instanceof MyComboBoxForUsableCount) {
                MyComboBoxForUsableCount box = (MyComboBoxForUsableCount) c;
                boxList.add(box);
            }
        }
        return boxList;
    }

    public List<MyCheckBoxForCandidate> getCandidate3List() {
        List<MyCheckBoxForCandidate> boxList = new ArrayList<MyCheckBoxForCandidate>();
        JPanel parent = jPanelCandidate3Armor;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (c instanceof MyCheckBoxForCandidate) {
                MyCheckBoxForCandidate box = (MyCheckBoxForCandidate) c;
                boxList.add(box);
            }
        }
        return boxList;
    }

    public List<MyCheckBoxForCheckTool> getChecktoolList() {
        List<MyCheckBoxForCheckTool> boxList = new ArrayList<MyCheckBoxForCheckTool>();
        JPanel parent = this.jPanelCheckArmor;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (c instanceof MyCheckBoxForCheckTool) {
                MyCheckBoxForCheckTool box = (MyCheckBoxForCheckTool) c;
                boxList.add(box);
            }
        }
        return boxList;
    }

    public void doPaintPictureWithArmorSet(PSArmorSet set) {
        for (int i = 0; i < jPanelMysetPicture.getComponentCount(); ++i) {
            Component c = jPanelMysetPicture.getComponent(i);
            if (c instanceof MyPanelForImage) {
                jPanelMysetPicture.remove(i);
                jPanelMysetPicture.updateUI();
                i--;
            }
        }
        if (set.mysetPicturePath == null) {
            return;
        }
        File file = new File(set.mysetPicturePath);
        if (file.isFile()) {
            Image image = null;
            try {
                image = ImageIO.read(file);
                jPanelMysetPicture.setLayout(new BoxLayout(jPanelMysetPicture, BoxLayout.X_AXIS));
                jPanelMysetPicture.add(new MyPanelForImage(image));
                jPanelMysetPicture.updateUI();
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private boolean listElementMatch(String[] list1, String[] list2) {
        if (list1.length == list2.length) {
            for (int i = 0; i < list1.length; ++i) {
                boolean found = false;
                for (int j = 0; j < list2.length; ++j) {
                    if (list1[i].equals(list2[j])) {
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean alreadyFailed(SkillSet slotSkill, List<SkillSet> listFailed) {
        for (SkillSet failed : listFailed) {
            boolean hit = true;
            boolean nocolumn = false;
            //failedׂ̂Ă𖞂 -> return true
            for(int i = 0; i < failed.size(); ++ i) {
                SkillKind kind = failed.kind(i);
                boolean positive = failed.positive(i);

                int targetX = slotSkill.indexOfKind(kind);
                if (targetX < 0) {
                    nocolumn = true;
                    break;
                }

                int value1 = failed.point(i);
                int value2 = slotSkill.point(targetX);

                if (positive) {
                    if (value1 > value2) {
                        hit = false;
                        break;
                    }
                }else {
                    if (value1 < value2) {
                        hit = false;
                        break;
                    }
                }
            }
            if (nocolumn) {
                //System.out.println("nocolumn " + slotSkill +" failed " + failed);
            }
            else if(hit) {
                //System.out.println("true " + slotSkill +" failed " + failed);
                return true;
            }
            else {
                //System.out.println("skip " + slotSkill +" failed " + failed);
            }
        }
        //System.out.println("false " + slotSkill +" failed " + listFailed);
        return false;
    }

    public ArrayList<PSItem> filterItems(List<PSItem> itemList) {
        ArrayList<PSItem> list = new ArrayList<PSItem>();
        for (PSItem item : itemList) {
            list.add(item);
        }
        return list;
    }

    public void doRepaintBaseArmor() {
        PSBaseItems items = Repository.getBaseItems();
        LinkedHashMap<String, List<PSItem>> map = new LinkedHashMap<String, List<PSItem>>();
        map.put("sht", filterItems(items.listBaseEquipHead));
        map.put("sht", filterItems(items.listBaseEquipBody));
        map.put("srht", filterItems(items.listBaseEquipArm));
        map.put("sht", filterItems(items.listBaseEquipWeist));
        map.put("sht", filterItems(items.listBaseEquipLeg));
        map.put("sit", filterItems(items.listBaseDecoration));
        repaintUserItemsSub(jPanelUserArmorMaster, map);
        SwingUtilities.updateComponentTreeUI(jPanelUserArmorMaster);
        doTextSearchUserArmorMaster();
        doTextSearchUserArmorUser();
        doTextSearchUserArmorTrash();

        //jToggleCandidateBySearchCondition.setSelected(false);
    }

    public void doRepaintUserArmor() {
        PSBaseItems items = Repository.getBaseItems();
        LinkedHashMap<String, List<PSItem>> map = new LinkedHashMap<String, List<PSItem>>();
        map.put("sht", filterItems(items.listUserEquipHead));
        map.put("sht", filterItems(items.listUserEquipBody));
        map.put("srht", filterItems(items.listUserEquipArm));
        map.put("sht", filterItems(items.listUserEquipWeist));
        map.put("sht", filterItems(items.listUserEquipLeg));
        map.put("sit", filterItems(items.listUserDecoration));
        repaintUserItemsSub(jPanelUserArmorUser, map);
        SwingUtilities.updateComponentTreeUI(jPanelUserArmorUser);
    }

    public void doRepaintTrashArmor() {
        PSBaseItems items = Repository.getBaseItems();
        LinkedHashMap<String, List<PSItem>> map = new LinkedHashMap<String, List<PSItem>>();
        map.put("sht", filterItems(items.listTrashEquipHead));
        map.put("sht", filterItems(items.listTrashEquipBody));
        map.put("srht", filterItems(items.listTrashEquipArm));
        map.put("sht", filterItems(items.listTrashEquipWeist));
        map.put("sht", filterItems(items.listTrashEquipLeg));
        map.put("sit", filterItems(items.listTrashDecoration));
        repaintUserItemsSub(jPanelUserArmorTrash, map);
        SwingUtilities.updateComponentTreeUI(jPanelUserArmorTrash);
    }

    private void repaintUserItemsSub(JPanel parent, Map<String, List<PSItem>> map) {
        parent.removeAll();
        parent.setLayout(new GridBagLayout());
        DecorationCount counter = items.searchUsableCount;
        ButtonGroup group = new ButtonGroup();

        GridBagConstraints cc;
        for (String name : map.keySet()) {
            cc = new java.awt.GridBagConstraints();
            cc.gridx = 0;
            cc.fill = java.awt.GridBagConstraints.BOTH;
            cc.anchor = java.awt.GridBagConstraints.NORTHWEST;

            JLabel label = new JLabel(name);
            parent.add(label, cc);

            for (PSItem item : map.get(name)) {
                cc = new java.awt.GridBagConstraints();
                cc.gridx = 0;
                cc.fill = java.awt.GridBagConstraints.BOTH;
                cc.anchor = java.awt.GridBagConstraints.NORTHWEST;

                MyRadioButtonForItems box = new MyRadioButtonForItems(this, item);
                box.setForegroundEx(Repository.getResource().getArmorColor(item));
                parent.add(box, cc);
                group.add(box);
            }
        }

        cc = new java.awt.GridBagConstraints();
        cc.gridx = 0;
        cc.fill = java.awt.GridBagConstraints.BOTH;
        cc.anchor = java.awt.GridBagConstraints.NORTHWEST;
        cc.weightx = 1.0;
        cc.weighty = 1.0;

        JPanel fit = new JPanel();
        parent.add(fit, cc);
    }

    HashSet already = new HashSet();

    public void tabMoved(JComponent c) {
        while(c.getParent() != null) {
            if(c.getParent().getClass() == JTabbedPane.class) {
                JTabbedPane pane = (JTabbedPane)c.getParent();
                for(int x = 0; x < pane.getTabCount(); ++ x) {
                    Component c2 = pane.getComponentAt(x);
                    if (c2 == c) {
                        String title = pane.getTitleAt(x);
                        initializeData(title);
                        return;
                    }
                }
            }else {
                c = (JComponent)c.getParent();
            }
        }
    }

    public void initializeData(String title) {
        if (already.contains(title) == false) {
            already.add(title);
            if (title.equals("")) {
                doStyleResultList(true);
            }else if (title.equals("Ώۖh")) {
                doRepaintCandidateItems();
                doRepaintCandidate2Items();
                doRepaintCandidate3Items();
            }else if (title.equals("}CZbg")) {
                doStyleMysetList(true, "");
            }else if (title.equals("ǉh")) {
                doRepaintBaseArmor();
                doRepaintUserArmor();
                doRepaintTrashArmor();
            }
        }
    }

    public PSItem readUserArmorPanel() {
        String name = jTextFieldUserArmorName.getText();
        int itemType = MyComboBoxUtil.getComboSelectedInt(jComboBoxUserArmorPartsType, 0);
        int genderType = MyComboBoxUtil.getComboSelectedInt(jComboBoxUserArmorGender, 0);
        int hunterType = MyComboBoxUtil.getComboSelectedInt(jComboBoxUserArmorHunterType, 0);

        PSItem item = new PSItem(itemType, name);
        item.genderType = genderType;
        item.hunterType = hunterType;
        item.rareRank = ((Number)jSpinnerUserArmorRare.getValue()).intValue();
        item.slotCount = ((Number)jSpinnerUserArmorSlot.getValue()).intValue();
        item.existHunterRank = ((Number)jSpinnerUserArmorHunterRank.getValue()).intValue();
        item.existTownRank = ((Number)jSpinnerUserArmorTownRank.getValue()).intValue();
        item.defInitial = ((Number)jSpinnerUserArmorInitialDeffence.getValue()).intValue();
        item.defMax = ((Number)jSpinnerUserArmorFinalDeffence.getValue()).intValue();
        item.shellFire = ((Number)jSpinnerUserArmorShellFire.getValue()).intValue();
        item.shellWater = ((Number)jSpinnerUserArmorShellWater.getValue()).intValue();
        item.shellIce = ((Number)jSpinnerUserArmorShellBrizard.getValue()).intValue();
        item.shellThunder = ((Number)jSpinnerUserArmorShellThunder.getValue()).intValue();
        item.shellDragon = ((Number)jSpinnerUserArmorShellDragon.getValue()).intValue();
        
        JComboBox[] boxList = {
            jComboBoxUserArmorSkill1,
            jComboBoxUserArmorSkill2,
            jComboBoxUserArmorSkill3,
            jComboBoxUserArmorSkill4,
            jComboBoxUserArmorSkill5
        };

        JSpinner[] spinList = {
            jSpinnerUserArmorSkillPoint1,
            jSpinnerUserArmorSkillPoint2,
            jSpinnerUserArmorSkillPoint3,
            jSpinnerUserArmorSkillPoint4,
            jSpinnerUserArmorSkillPoint5
        };

        SkillSet skills = new SkillSet();
        item.skills = skills;

        for(int i = 0; i < 5; ++ i) {
            SkillKind kind = (SkillKind)MyComboBoxUtil.getComboSelectedValue(boxList[i]);
            int point = ((Number)spinList[i].getValue()).intValue();

            if (point != 0 && kind != null) {
                skills.set(kind, point, point >= 0);
            }
        }

        item.isCopieSkill = jCheckBoxDuplicateSkill.isSelected();

        ArrayList<PSItemMaterial> listMaterialA = new ArrayList<PSItemMaterial>();
        ArrayList<PSItemMaterial> listMaterialB = new ArrayList<PSItemMaterial>();
        JTextField[] materialA = {
            jTextFieldMaterialA1,
            jTextFieldMaterialA2,
            jTextFieldMaterialA3,
            jTextFieldMaterialA4,
        };
        JTextField[] materialB = {
            jTextFieldMaterialA1,
            jTextFieldMaterialA2,
            jTextFieldMaterialA3,
            jTextFieldMaterialA4,
        };
        JSpinner[] materialACount = {
            jSpinnerMaterialCountA1,
            jSpinnerMaterialCountA2,
            jSpinnerMaterialCountA3,
            jSpinnerMaterialCountA4,
        };
        JSpinner[] materialBCount = {
            jSpinnerMaterialCountB1,
            jSpinnerMaterialCountB2,
            jSpinnerMaterialCountB3,
            jSpinnerMaterialCountB4,
        };

        for (int i = 0; i < materialA.length; ++ i) {
            PSItemMaterial material = new PSItemMaterial();
            material.name = materialA[i].getText();
            material.count = ((Number)materialACount[i].getValue()).intValue();
            if (material.name.length() == 0 || material.count == 0) {
                continue;
            }
            listMaterialA.add(material);
        }
        for (int i = 0; i < materialB.length; ++ i) {
            PSItemMaterial material = new PSItemMaterial();
            material.name = materialB[i].getText();
            material.count = ((Number)materialBCount[i].getValue()).intValue();
            if (material.name.length() == 0 || material.count == 0) {
                continue;
            }
            listMaterialB.add(material);
        }

        item.materialAList = listMaterialA;
        item.materialBList = listMaterialB;

        return item;
    }

    public void userArmorSave(PSItem item) {
        PSBaseItems items = Repository.getBaseItems();
        ArrayList<PSItem> listBase = null;
        ArrayList<PSItem> listUser = null;
        ArrayList<PSItem> listTrash = null;

        switch(item.itemType) {
            case PSItemType.TYPE_HEAD:
                listBase = items.listBaseEquipHead;
                listUser = items.listUserEquipHead;
                listTrash = items.listTrashEquipHead;
                break;
            case PSItemType.TYPE_BODY:
                listBase = items.listBaseEquipBody;
                listUser = items.listUserEquipBody;
                listTrash = items.listTrashEquipBody;
                break;
            case PSItemType.TYPE_ARM:
                listBase = items.listBaseEquipArm;
                listUser = items.listUserEquipArm;
                listTrash = items.listTrashEquipArm;
                break;
            case PSItemType.TYPE_WEIST:
                listBase = items.listBaseEquipWeist;
                listUser = items.listUserEquipWeist;
                listTrash = items.listTrashEquipWeist;
                break;
            case PSItemType.TYPE_LEG:
                listBase = items.listBaseEquipLeg;
                listUser = items.listUserEquipLeg;
                listTrash = items.listTrashEquipLeg;
                break;
            case PSItemType.TYPE_CHARM:
                listBase = items.listBaseCharm;
                listUser = items.listUserCharm;
                listTrash = items.listTrashCharm;
                break;
            case PSItemType.TYPE_DECORATION:
                listBase = items.listBaseDecoration;
                listUser = items.listUserDecoration;
                listTrash = items.listTrashDecoration;
                break;
        }
        if (listBase == null) {
            JOptionPane.showMessageDialog(this, "ACe^Cvُ");
            return;
        }
        int i;
        while(true) {
            i = PSBaseItems.seekOverwriteSource(listUser, item);
            if (i < 0) break;
            listUser.remove(i);
        }
        while(true) {
            i = PSBaseItems.seekOverwriteSource(listTrash, item);
            if (i < 0) break;
            listUser.remove(i);
        }
        listUser.add(item);
        items.invalidate();
        //System.out.println("save " + item);
        doRepaintBaseArmor();
        doRepaintUserArmor();
        doRepaintTrashArmor();
    }

    public void userArmorTrash(PSItem item) {
        PSBaseItems items = Repository.getBaseItems();
        ArrayList<PSItem> listBase = null;
        ArrayList<PSItem> listUser = null;
        ArrayList<PSItem> listTrash = null;

        switch(item.itemType) {
            case PSItemType.TYPE_HEAD:
                listBase = items.listBaseEquipHead;
                listUser = items.listUserEquipHead;
                listTrash = items.listTrashEquipHead;
                break;
            case PSItemType.TYPE_BODY:
                listBase = items.listBaseEquipBody;
                listUser = items.listUserEquipBody;
                listTrash = items.listTrashEquipBody;
                break;
            case PSItemType.TYPE_ARM:
                listBase = items.listBaseEquipArm;
                listUser = items.listUserEquipArm;
                listTrash = items.listTrashEquipArm;
                break;
            case PSItemType.TYPE_WEIST:
                listBase = items.listBaseEquipWeist;
                listUser = items.listUserEquipWeist;
                listTrash = items.listTrashEquipWeist;
                break;
            case PSItemType.TYPE_LEG:
                listBase = items.listBaseEquipLeg;
                listUser = items.listUserEquipLeg;
                listTrash = items.listTrashEquipLeg;
                break;
            case PSItemType.TYPE_CHARM:
                listBase = items.listBaseCharm;
                listUser = items.listUserCharm;
                listTrash = items.listTrashCharm;
                break;
            case PSItemType.TYPE_DECORATION:
                listBase = items.listBaseDecoration;
                listUser = items.listUserDecoration;
                listTrash = items.listTrashDecoration;
                break;
        }
        if (listBase == null) {
            JOptionPane.showMessageDialog(this, "ACe^Cvُ");
            return;
        }
        int i;
        while(true) {
            i = PSBaseItems.seekOverwriteSource(listUser, item);
            if (i < 0) break;
            listUser.remove(i);
        }
        while(true) {
            i = PSBaseItems.seekOverwriteSource(listTrash, item);
            if (i < 0) break;
            listUser.remove(i);
        }
        listTrash.add(item);
        items.invalidate();
        //System.out.println("trash " + item);
        doRepaintBaseArmor();
        doRepaintUserArmor();
        doRepaintTrashArmor();
    }

    public void userArmorInit(PSItem item) {
        jTextFieldUserArmorName.setText(item.name);
        MyComboBoxUtil.setComboSelectedInt(jComboBoxUserArmorPartsType, item.itemType);
        MyComboBoxUtil.setComboSelectedInt(jComboBoxUserArmorGender, item.genderType);
        MyComboBoxUtil.setComboSelectedInt(jComboBoxUserArmorHunterType, item.hunterType);

        jSpinnerUserArmorRare.setValue(item.rareRank);
        jSpinnerUserArmorSlot.setValue(item.slotCount);
        jSpinnerUserArmorHunterRank.setValue(item.existHunterRank);
        jSpinnerUserArmorTownRank.setValue(item.existTownRank);
        jSpinnerUserArmorInitialDeffence.setValue(item.defInitial);
        jSpinnerUserArmorFinalDeffence.setValue(item.defMax);
        jSpinnerUserArmorShellFire.setValue(item.shellFire);
        jSpinnerUserArmorShellWater.setValue(item.shellWater);
        jSpinnerUserArmorShellBrizard.setValue(item.shellIce);
        jSpinnerUserArmorShellThunder.setValue(item.shellThunder);
        jSpinnerUserArmorShellDragon.setValue(item.shellDragon);

        JTextField[] materialA = {
            jTextFieldMaterialA1,
            jTextFieldMaterialA2,
            jTextFieldMaterialA3,
            jTextFieldMaterialA4,
        };
        JTextField[] materialB = {
            jTextFieldMaterialB1,
            jTextFieldMaterialB2,
            jTextFieldMaterialB3,
            jTextFieldMaterialB4,
        };
        JSpinner[] materialACount = {
            jSpinnerMaterialCountA1,
            jSpinnerMaterialCountA2,
            jSpinnerMaterialCountA3,
            jSpinnerMaterialCountA4,
        };
        JSpinner[] materialBCount = {
            jSpinnerMaterialCountB1,
            jSpinnerMaterialCountB2,
            jSpinnerMaterialCountB3,
            jSpinnerMaterialCountB4,
        };

        for (int i = 0; i < materialA.length; ++ i) {
            if (i < item.materialAList.size()) {
                PSItemMaterial mat = item.materialAList.get(i);
                materialA[i].setText(mat.name);
                materialACount[i].setValue(mat.count);
            }else {
                materialA[i].setText("");
                materialACount[i].setValue(0);
            }
        }
        for (int i = 0; i < materialB.length; ++ i) {
            if (i < item.materialBList.size()) {
                PSItemMaterial mat = item.materialBList.get(i);
                materialB[i].setText(mat.name);
                materialBCount[i].setValue(mat.count);
            }else {
                materialB[i].setText("");
                materialBCount[i].setValue(0);
            }
        }

        JComboBox[] boxList = {
            jComboBoxUserArmorSkill1,
            jComboBoxUserArmorSkill2,
            jComboBoxUserArmorSkill3,
            jComboBoxUserArmorSkill4,
            jComboBoxUserArmorSkill5
        };

        JSpinner[] spinList = {
            jSpinnerUserArmorSkillPoint1,
            jSpinnerUserArmorSkillPoint2,
            jSpinnerUserArmorSkillPoint3,
            jSpinnerUserArmorSkillPoint4,
            jSpinnerUserArmorSkillPoint5
        };

        for(int i = 0; i < 5; ++ i) {
            boxList[i].setSelectedIndex(0);
            spinList[i].setValue(0);
        }

        SkillSet skills = item.skills;
        for(int i = 0; i < skills.size() && i < 5; ++ i) {
            SkillKind kind = skills.kind(i);
            int point = skills.point(i);

            MyComboBoxUtil.setComboSelectedValue(boxList[i], kind);
            spinList[i].setValue(point);
        }

        jCheckBoxDuplicateSkill.setSelected(item.isCopieSkill);
    }

    public void setHighlight(JComponent c, boolean primaryKey, boolean highlight) {
        if (c instanceof JLabel || c instanceof JCheckBox) {
            PSConfig config = Repository.getConfig();
            Font font = new Font(config.fontName, Font.BOLD | Font.ITALIC, config.fontSize);
            c.setFont(font);
            if (primaryKey) {
                c.setForeground(Color.yellow.darker());
            }else {
                if (highlight) {
                    c.setForeground(Color.pink.darker());
                }else {
                    c.setForeground(UIManager.getColor("Label.foreground"));
                }
            }
        }else {
            System.out.println("Logic error");
        }
        /*
        if (c instanceof JSpinner) {
            JSpinner s = (JSpinner)c;
            JTextField editor = ((JSpinner.DefaultEditor)s.getEditor()).getTextField();
            if (highlight){
                System.out.println(editor);
            }
            c = editor;
        }
        if (highlight) {
            c.setForeground(Color.black);
            c.setBackground(Color.pink);
        }else {
            c.setForeground(UIManager.getColor("FormattedTextField.foreground"));
            c.setBackground(UIManager.getColor("FormattedTextField.background"));
        }
         *
         */
    }

    public void colorUserArmor(PSItem item) {
        ArrayList<PSItem> list = null;
        switch(item.itemType) {
            case PSItemType.TYPE_HEAD:
                list = Repository.getBaseItems().listBaseEquipHead;
                break;
            case PSItemType.TYPE_BODY:
                list = Repository.getBaseItems().listBaseEquipBody;
                break;
            case PSItemType.TYPE_ARM:
                list = Repository.getBaseItems().listBaseEquipArm;
                break;
            case PSItemType.TYPE_WEIST:
                list = Repository.getBaseItems().listBaseEquipWeist;
                break;
            case PSItemType.TYPE_LEG:
                list = Repository.getBaseItems().listBaseEquipLeg;
                break;
            case PSItemType.TYPE_DECORATION:
                list = Repository.getBaseItems().listBaseDecoration;
                break;
            case PSItemType.TYPE_CHARM:
                list = Repository.getBaseItems().listBaseCharm;
                break;
        }
        PSItem hit = null;
        if (item != null) {
            int x = PSBaseItems.seekOverwriteSource(list, item);
            if (x >= 0) {
                hit = list.get(x);
            }
        }

        if (hit == null) {
            if (item.itemType == PSItemType.TYPE_DECORATION) {
                setHighlight(jLabelUserArmorPartsType, true, true);
                setHighlight(jLabelUserArmorName, true, true);
                setHighlight(jLabelUserArmorGender, false, true);
                setHighlight(jLabelUserArmorSlot, true, true);
            } else {
                setHighlight(jLabelUserArmorPartsType, true, true);
                setHighlight(jLabelUserArmorName, true, true);
                setHighlight(jLabelUserArmorGender, true, true);
                setHighlight(jLabelUserArmorSlot, false, true);
            }

            setHighlight(jLabelUserArmorHunterType, false, true);

            setHighlight(jLabelUserArmorRare, false, true);
            setHighlight(jLabelUserArmorHunterRank, false, true);
            setHighlight(jLabelUserArmorTownRank, false, true);
            setHighlight(jLabelUserArmorInitialDeffence, false, true);
            setHighlight(jLabelUserArmorFinalDeffence, false, true);
            setHighlight(jLabelUserArmorShellFire, false, true);
            setHighlight(jLabelUserArmorShellWater, false, true);
            setHighlight(jLabelUserArmorShellBrizard, false, true);
            setHighlight(jLabelUserArmorShellThunder, false, true);
            setHighlight(jLabelUserArmorShellDragon, false, true);

            setHighlight(jLabelUserArmorMaterialA, false, true);
            setHighlight(jLabelUserArmorMaterialB, false, true);

            setHighlight(jLabelUserArmorSkill1, false, true);
            setHighlight(jLabelUserArmorSkill2, false, true);
            setHighlight(jLabelUserArmorSkill3, false, true);
            setHighlight(jLabelUserArmorSkill4, false, true);
            setHighlight(jLabelUserArmorSkill5, false, true);

            setHighlight(jCheckBoxDuplicateSkill, false, true);
        }else {
            if (item.itemType == PSItemType.TYPE_DECORATION) {
                setHighlight(jLabelUserArmorName, true, !item.name.equals(hit.name));
                setHighlight(jLabelUserArmorPartsType, true, item.itemType != hit.itemType);
                setHighlight(jLabelUserArmorGender, false, item.genderType != hit.genderType);
                setHighlight(jLabelUserArmorSlot, true, item.slotCount != hit.slotCount);
            } else {
                setHighlight(jLabelUserArmorName, true, !item.name.equals(hit.name));
                setHighlight(jLabelUserArmorPartsType, true, item.itemType != hit.itemType);
                setHighlight(jLabelUserArmorGender, true, item.genderType != hit.genderType);
                setHighlight(jLabelUserArmorSlot, false, item.slotCount != hit.slotCount);
            }
            setHighlight(jLabelUserArmorHunterType, false, item.hunterType != hit.hunterType );
            setHighlight(jLabelUserArmorRare, false, item.rareRank != hit.rareRank);
            setHighlight(jLabelUserArmorHunterRank, false, item.existHunterRank != hit.existHunterRank);
            setHighlight(jLabelUserArmorTownRank, false, item.existTownRank != hit.existTownRank);
            setHighlight(jLabelUserArmorInitialDeffence, false, item.defInitial != hit.defInitial);
            setHighlight(jLabelUserArmorFinalDeffence, false, item.defMax != hit.defMax);
            setHighlight(jLabelUserArmorShellFire, false, item.shellFire != hit.shellFire);
            setHighlight(jLabelUserArmorShellWater, false, item.shellWater != hit.shellWater);
            setHighlight(jLabelUserArmorShellBrizard, false, item.shellIce != hit.shellIce);
            setHighlight(jLabelUserArmorShellThunder, false, item.shellThunder != hit.shellThunder);
            setHighlight(jLabelUserArmorShellDragon, false, item.shellDragon != hit.shellDragon);

            boolean highlight = false;
            if (item.materialAList.size() != hit.materialAList.size()) {
                highlight = true;
            }else {
                for (int i = 0; i < item.materialAList.size(); ++ i) {
                    if (item.materialAList.get(i).equals(hit.materialAList.get(i))) {
                        continue;
                    }else {
                        highlight = true;
                        break;
                    }
                }
            }
            setHighlight(jLabelUserArmorMaterialA, false, highlight);

            highlight = false;
            if (item.materialBList.size() != hit.materialBList.size()) {
                highlight = true;
            }else {
                for (int i = 0; i < item.materialBList.size(); ++ i) {
                    if (item.materialBList.get(i).equals(hit.materialBList.get(i))) {
                        continue;
                    }else {
                        highlight = true;
                        break;
                    }
                }
            }
            setHighlight(jLabelUserArmorMaterialB, false, highlight);

            if (item.skills.equals(hit.skills)) {
                highlight = false;
            }else {
                highlight = true;
            }

            setHighlight(jLabelUserArmorSkill1, false, highlight);
            setHighlight(jLabelUserArmorSkill2, false, highlight);
            setHighlight(jLabelUserArmorSkill3, false, highlight);
            setHighlight(jLabelUserArmorSkill4, false, highlight);
            setHighlight(jLabelUserArmorSkill5, false, highlight);

            setHighlight(jCheckBoxDuplicateSkill, false, item.isCopieSkill != hit.isCopieSkill);
        }
    }

    public List<MyRadioButtonForItems> getUserArmorPanelItemList(JPanel panel) {
        List<MyRadioButtonForItems> boxList = new ArrayList<MyRadioButtonForItems>();
        JPanel parent = panel;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (c instanceof MyRadioButtonForItems) {
                MyRadioButtonForItems box = (MyRadioButtonForItems) c;
                boxList.add(box);
            }
        }
        return boxList;
    }

    public void doTextSearchUserArmorMaster() {
        String text = jTextFieldUserArmorMaster.getText();
        if (isIMEEditing(jTextFieldUserArmorMaster)) {
            return;
        }
        for (MyRadioButtonForItems box : getUserArmorPanelItemList(jPanelUserArmorMaster)) {
            if (text.length() == 0) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (box.item.name.contains(text)) {
                    visible = true;
                }
                if (!visible) {
                    SkillSet set = box.item.skills;
                    for (int x = 0; x < set.size(); ++x) {
                        if (set.kind(x).name.contains(text)) {
                            visible = true;
                            break;
                        }
                    }
                }
                box.setVisible(visible);
            }
        }
    }

    public void doTextSearchUserArmorUser() {
        String text = jTextFieldUserArmorUser.getText();
        if (isIMEEditing(jTextFieldUserArmorUser)) {
            return;
        }
        for (MyRadioButtonForItems box : getUserArmorPanelItemList(jPanelUserArmorUser)) {
            if (text.length() == 0) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (box.item.name.contains(text)) {
                    visible = true;
                }
                if (!visible) {
                    SkillSet set = box.item.skills;
                    for (int x = 0; x < set.size(); ++x) {
                        if (set.kind(x).name.contains(text)) {
                            visible = true;
                            break;
                        }
                    }
                }
                box.setVisible(visible);
            }
        }
    }

    public void doTextSearchUserArmorTrash() {
        String text = jTextFieldUserArmorTrash.getText();
        if (isIMEEditing(jTextFieldUserArmorTrash)) {
            return;
        }
        for (MyRadioButtonForItems box : getUserArmorPanelItemList(jPanelUserArmorTrash)) {
            if (text.length() == 0) {
                box.setVisible(true);
            } else {
                boolean visible = false;
                if (box.item.name.contains(text)) {
                    visible = true;
                }
                if (!visible) {
                    SkillSet set = box.item.skills;
                    for (int x = 0; x < set.size(); ++x) {
                        if (set.kind(x).name.contains(text)) {
                            visible = true;
                            break;
                        }
                    }
                }
                box.setVisible(visible);
            }
        }
    }
}
