/*
 * Decompiled with CFR 0.152.
 */
package data.data_mhp3;

import data.data_mhp3.MHP3DataIO;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import portablesimulator.PSItem;
import portablesimulator.csv.GameResource;

public class MHP3Resource
implements GameResource {
    private MHP3DataIO reader = new MHP3DataIO();
    private boolean monoArmor = false;

    @Override
    public String nameOfGame() {
        return "MHP3";
    }

    @Override
    public boolean existCharm() {
        return true;
    }

    @Override
    public boolean existCharmG() {
        return false;
    }

    @Override
    public void readCSV() throws IOException {
        this.reader.readAll();
    }

    @Override
    public Color getArmorColor(PSItem item) {
        if (this.monoArmor) {
            return Color.black;
        }
        if (item.itemType == 6) {
            return Color.white;
        }
        if (item.itemType == 5) {
            if (item.name.startsWith("\u9f8d")) {
                return Color.red;
            }
            if (item.name.startsWith("\u5973\u738b")) {
                return Color.green;
            }
            if (item.name.startsWith("\u738b")) {
                return Color.cyan;
            }
            if (item.name.startsWith("\u57ce\u585e")) {
                return Color.pink;
            }
            if (item.name.startsWith("\u9a0e\u58eb")) {
                return Color.yellow;
            }
            if (item.name.startsWith("\u95d8\u58eb")) {
                return Color.magenta;
            }
            return Color.white;
        }
        switch (item.rareRank) {
            case 1: {
                return Color.white;
            }
            case 2: {
                return Color.magenta;
            }
            case 3: {
                return Color.yellow;
            }
            case 4: {
                return Color.pink;
            }
            case 5: {
                return Color.green;
            }
            case 6: {
                return Color.cyan;
            }
            case 7: {
                return Color.red;
            }
        }
        return Color.white;
    }

    @Override
    public String getConfigFile() {
        return "PSConfig.ini";
    }

    @Override
    public String getMysetFile() {
        return "PSMySet.ini";
    }

    @Override
    public List<PSItem> readCharmCSV(String fileName) throws IOException {
        ArrayList<PSItem> listCharm = new ArrayList<PSItem>();
        this.reader.readCharmCSVFile(5, fileName, listCharm);
        return listCharm;
    }

    @Override
    public boolean existFukugo() {
        return false;
    }
}

