/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.csv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import portablesimulator.PSArmorSet;
import portablesimulator.PSItem;
import portablesimulator.PSWrap;
import portablesimulator.csv.CSVReader;
import portablesimulator.csv.PSBaseItems;
import portablesimulator.csv.PSSession;
import portablesimulator.csv.Repository;
import portablesimulator.decoration.DecorationMatcherFull;
import portablesimulator.decoration.DecorationSlot;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class PSMySet {
    public List<PSArmorSet> listMyset = new ArrayList<PSArmorSet>();
    File file;
    List<String> cache1 = new ArrayList<String>();

    public PSMySet(String mysetFile) {
        this.file = new File(mysetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readProperties() throws IOException {
        if (!this.file.isFile()) {
            return;
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        try (FileInputStream in = new FileInputStream(this.file);){
            String line;
            InputStreamReader reader = new InputStreamReader(in);
            BufferedReader buff = new BufferedReader(reader);
            while ((line = buff.readLine()) != null) {
                int x;
                if (line.length() == 0 || line.charAt(0) == '#' || (x = line.indexOf(61)) < 0) continue;
                String key = line.substring(0, x);
                String value = line.substring(x + 1);
                properties.put(key, value);
            }
        }
        LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
        for (String key : properties.keySet()) {
            if (!key.startsWith("myset.")) continue;
            int startIndex = 6;
            int x = key.indexOf(46, startIndex);
            int num = -1;
            if (x < 0) continue;
            try {
                num = Integer.parseInt(key.substring(startIndex, x));
            }
            catch (Throwable e) {
                continue;
            }
            prefixes.add("myset." + num + ".");
        }
        this.listMyset.clear();
        int counter = 1;
        ArrayList<String> strCache1 = new ArrayList<String>();
        for (String prefix : prefixes) {
            try {
                String name = (String)properties.get(prefix + "name");
                String picturePath = (String)properties.get(prefix + "picture");
                SkillSet skill = this.StringToSkillSet((String)properties.get(prefix + "skill"));
                ArrayList<String> armorList = strCache1;
                CSVReader.bunkatu((String)properties.get(prefix + "armor"), ',', strCache1);
                SkillSet charmSkill = null;
                int charmSlot = 0;
                if (Repository.getResource().existCharm()) {
                    charmSkill = this.StringToSkillSet((String)properties.get(prefix + "charmSkill"));
                    charmSlot = Integer.parseInt((String)properties.get(prefix + "charmSlot"));
                }
                PSArmorSet set = new PSArmorSet();
                set.mysetNumber = counter++;
                set.mysetName = name;
                set.mysetPicturePath = picturePath;
                set.targetSkills = skill;
                PSBaseItems datas = Repository.getBaseItems();
                for (int itemType = 0; itemType < armorList.size(); ++itemType) {
                    PSItem found = null;
                    if (itemType != 5) {
                        found = PSItem.getInstanceByName(itemType, (String)armorList.get(itemType));
                    }
                    if (found == null && itemType == 5) {
                        found = new PSItem(5, (String)armorList.get(itemType));
                        found.skills = charmSkill;
                        found.slotCount = charmSlot;
                    }
                    if (found == null) {
                        throw new Exception("not found " + (String)armorList.get(itemType));
                    }
                    set.listItems.add(new PSWrap(found));
                }
                set.calculateUseList(null);
                try {
                    set.session.searchHunterType = Integer.parseInt((String)properties.get(prefix + "hunterType"));
                    set.session.searchGenderType = Integer.parseInt((String)properties.get(prefix + "genderType"));
                    set.session.searchHunterRank = Integer.parseInt((String)properties.get(prefix + "hunterRank"));
                    set.session.searchTownRank = Integer.parseInt((String)properties.get(prefix + "townRank"));
                    set.weaponSlotCount = set.session.searchWeaponSlotCount = Integer.parseInt((String)properties.get(prefix + "weaponSlotCount"));
                }
                catch (Throwable e) {
                    PSMySet.fixArmorSetRank(set);
                }
                PSMySet.fixArmorSetVirtual(set);
                this.listMyset.add(set);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        prefixes.clear();
        for (String key : properties.keySet()) {
            if (!key.startsWith("charm.")) continue;
            int startIndex = 6;
            int x = key.indexOf(46, startIndex);
            int num = -1;
            if (x < 0) continue;
            try {
                num = Integer.parseInt(key.substring(startIndex, x));
            }
            catch (Throwable e) {
                continue;
            }
            prefixes.add("charm." + num + ".");
        }
        ArrayList<PSItem> listCharm = Repository.getBaseItems().listBaseCharm;
        for (String prefix : prefixes) {
            try {
                String name = (String)properties.get(prefix + "name");
                String skills = (String)properties.get(prefix + "skill");
                int slotCount = Integer.parseInt((String)properties.get(prefix + "slotCount"));
                PSItem item = new PSItem(5, name);
                item.skills = this.StringToSkillSet(skills);
                item.slotCount = slotCount;
                if (listCharm.contains(item)) continue;
                listCharm.add(item);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        Collections.sort(listCharm);
    }

    public static void fixArmorSetRank(PSArmorSet set) {
        set.session = new PSSession();
        set.session.searchHunterType = 0;
        set.session.searchGenderType = 0;
        set.session.searchHunterRank = 0;
        set.session.searchTownRank = 0;
        set.weaponSlotCount = set.session.searchWeaponSlotCount = 0;
        for (int i = 0; i < set.listItems.size(); ++i) {
            PSWrap wrap = set.listItems.get(i);
            PSItem item = wrap.item;
            if (set.session.searchHunterType == 0 && item.hunterType != 0) {
                set.session.searchHunterType = item.hunterType;
            }
            if (set.session.searchGenderType == 0 && item.genderType != 0) {
                set.session.searchGenderType = item.genderType;
            }
            if (set.session.searchHunterRank < item.existHunterRank) {
                set.session.searchHunterRank = item.existHunterRank;
            }
            if (set.session.searchTownRank >= item.existTownRank) continue;
            set.session.searchTownRank = item.existTownRank;
        }
        int width = -1;
        while (width <= 3) {
            set.session.searchWeaponSlotCount = width;
            set.weaponSlotCount = width++;
            set.session.searchSkills = set.targetSkills;
            DecorationMatcherFull matcher = new DecorationMatcherFull(set.session);
            if (matcher.canHaveEnoughDecoration(set, false, null)) break;
        }
    }

    public static void fixArmorSetVirtual(PSArmorSet set) {
        for (PSWrap item : set.listItems) {
            if (!item.item.isVirtual || item.item.isVirtualNone) continue;
            ArrayList<PSItem> base = null;
            switch (item.item.itemType) {
                case 0: {
                    base = Repository.getBaseItems().listEquipHead;
                    break;
                }
                case 1: {
                    base = Repository.getBaseItems().listEquipBody;
                    break;
                }
                case 2: {
                    base = Repository.getBaseItems().listEquipArm;
                    break;
                }
                case 3: {
                    base = Repository.getBaseItems().listEquipWeist;
                    break;
                }
                case 4: {
                    base = Repository.getBaseItems().listEquipLeg;
                }
            }
            if (base == null) continue;
            item.virtualList = new ArrayList();
            for (PSItem seek : base) {
                if (!set.session.isExistForThisHunter(seek)) continue;
                if (item.item.isCopieSkill) {
                    if (!seek.isCopieSkill) continue;
                    item.virtualList.add(new PSWrap(seek));
                    continue;
                }
                if (set.session.isExistForSkill(seek) || set.session.isExistForNegativeSkill(seek) || item.item.slotCount != seek.slotCount) continue;
                item.virtualList.add(new PSWrap(seek));
            }
        }
        set.calculateUseList(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readMySetTXTFile(String path, List<PSArmorSet> listArmorSet) throws IOException {
        try (CSVReader reader = new CSVReader(path);){
            ArrayList<String> line = new ArrayList<String>();
            while (reader.readLine(line)) {
                if (line.size() < 5 || line.get(0).startsWith("#")) continue;
                int x = 0;
                int genderType = Integer.parseInt(line.get(x++));
                int hunterType = Integer.parseInt(line.get(x++));
                int weaponSlot = Integer.parseInt(line.get(x++));
                String setName = line.get(x++);
                String strHead = line.get(x++);
                String strBody = line.get(x++);
                String strArm = line.get(x++);
                String strWeist = line.get(x++);
                String strLeg = line.get(x++);
                String charm = line.get(x++);
                String decorationBody = line.get(x++);
                String decoration = line.get(x++);
                PSItem itemHead = PSItem.getInstanceByName(0, PSMySet.renameImport(strHead));
                PSItem itemBody = PSItem.getInstanceByName(1, PSMySet.renameImport(strBody));
                PSItem itemArm = PSItem.getInstanceByName(2, PSMySet.renameImport(strArm));
                PSItem itemWeist = PSItem.getInstanceByName(3, PSMySet.renameImport(strWeist));
                PSItem itemLeg = PSItem.getInstanceByName(4, PSMySet.renameImport(strLeg));
                if (itemHead == null) {
                    throw new IllegalArgumentException("Invalid Head: " + strHead);
                }
                if (itemBody == null) {
                    throw new IllegalArgumentException("Invalid Head: " + strBody);
                }
                if (itemArm == null) {
                    throw new IllegalArgumentException("Invalid Head: " + strArm);
                }
                if (itemWeist == null) {
                    throw new IllegalArgumentException("Invalid Head: " + strWeist);
                }
                if (itemLeg == null) {
                    throw new IllegalArgumentException("Invalid Head: " + strLeg);
                }
                ArrayList<String> charmSplit = new ArrayList<String>();
                CSVReader.bunkatu(charm, ';', charmSplit);
                x = 0;
                String charmName = charmSplit.get(x++);
                int charmSlot = 0;
                String skill1Name = "";
                String skill1Point = "";
                String skill2Name = "";
                String skill2Point = "";
                try {
                    charmSlot = Integer.parseInt(charmSplit.get(x++));
                    skill1Name = charmSplit.get(x++);
                    skill1Point = charmSplit.get(x++);
                    skill2Name = charmSplit.get(x++);
                    skill2Point = charmSplit.get(x++);
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
                PSItem itemCharm = null;
                if (charmName.equals("\u306a\u3057")) {
                    itemCharm = PSItem.getVirtualItem(5, -2);
                } else {
                    int point;
                    SkillKind kind;
                    PSItem item = new PSItem(5, charmName);
                    item.slotCount = charmSlot;
                    item.skills = new SkillSet();
                    if (skill1Name.length() > 0) {
                        kind = Repository.getSkillCategories().findKindByName(skill1Name);
                        point = Integer.parseInt(skill1Point);
                        item.skills.set(kind, point, true);
                    }
                    if (skill2Name.length() > 0) {
                        kind = Repository.getSkillCategories().findKindByName(skill2Name);
                        point = Integer.parseInt(skill2Point);
                        item.skills.set(kind, point, true);
                    }
                    itemCharm = item;
                }
                PSArmorSet set = new PSArmorSet();
                set.listItems.add(new PSWrap(itemHead));
                set.listItems.add(new PSWrap(itemBody));
                set.listItems.add(new PSWrap(itemArm));
                set.listItems.add(new PSWrap(itemWeist));
                set.listItems.add(new PSWrap(itemLeg));
                set.listItems.add(new PSWrap(itemCharm));
                List<PSItem> decoBody = PSMySet.importSubDecoration(decorationBody);
                List<PSItem> decoNormal = PSMySet.importSubDecoration(decoration);
                DecorationSlot slot = new DecorationSlot(Repository.getBaseItems().listDecoration);
                slot.construct(new SkillSet(), set, weaponSlot);
                for (PSItem item : decoBody) {
                    slot.mapBodyDecoration.increment(item);
                }
                for (PSItem item : decoNormal) {
                    slot.mapDecoration.increment(item);
                }
                SkillSet skills = new SkillSet();
                set.calculateUseList(null);
                skills.set_all(set.setSkills);
                skills.sum_all(slot.getFullDecorationSkills());
                PSMySet.fixArmorSetRank(set);
                PSMySet.fixArmorSetVirtual(set);
                set.calculateUseList(null);
                listArmorSet.add(set);
            }
        }
    }

    public static List<PSItem> importSubDecoration(String text) {
        ArrayList<PSItem> ret = new ArrayList<PSItem>();
        ArrayList<String> line = new ArrayList<String>();
        CSVReader.bunkatu(text, ';', line);
        for (int i = 0; i < line.size(); ++i) {
            PSItem item = PSItem.getInstanceByName(6, line.get(i));
            if (item == null) {
                throw new IllegalArgumentException("Unknow deco [" + text + "]");
            }
            ret.add(item);
        }
        return ret;
    }

    public static String renameImport(String equip) {
        if (equip.equals("\u88c5\u5099\u306a\u3057")) {
            return PSItem.getVirtualItem((int)0, (int)-2).name;
        }
        if (equip.equals("\u3010\uff11\u30b9\u30ed\u88c5\u5099\u3011")) {
            return PSItem.getVirtualItem((int)0, (int)1).name;
        }
        if (equip.equals("\u3010\uff12\u30b9\u30ed\u88c5\u5099\u3011")) {
            return PSItem.getVirtualItem((int)0, (int)2).name;
        }
        if (equip.equals("\u3010\uff13\u30b9\u30ed\u88c5\u5099\u3011")) {
            return PSItem.getVirtualItem((int)0, (int)3).name;
        }
        if (equip.equals("\u3010\u80f4\u7cfb\u7d71\u8907\u88fd\u3011")) {
            return PSItem.getVirtualItem((int)0, (int)-1).name;
        }
        return equip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProperties() throws IOException {
        String prefix;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        int number = 1;
        for (PSArmorSet set : this.listMyset) {
            prefix = "myset." + number + ".";
            ++number;
            String[] armorStr = new String[set.listItems.size()];
            for (int i = 0; i < set.listItems.size(); ++i) {
                armorStr[i] = set.listItems.get((int)i).item.name;
            }
            properties.put(prefix + "name", set.mysetName);
            properties.put(prefix + "picture", set.mysetPicturePath);
            properties.put(prefix + "hunterType", String.valueOf(set.session.searchHunterType));
            properties.put(prefix + "genderType", String.valueOf(set.session.searchGenderType));
            properties.put(prefix + "hunterRank", String.valueOf(set.session.searchHunterRank));
            properties.put(prefix + "townRank", String.valueOf(set.session.searchTownRank));
            properties.put(prefix + "weaponSlotCount", String.valueOf(set.weaponSlotCount));
            properties.put(prefix + "skill", this.SkillSetToString(set.targetSkills));
            properties.put(prefix + "armor", this.renketu(armorStr));
            if (!Repository.getResource().existCharm()) continue;
            properties.put(prefix + "charmSkill", this.SkillSetToString(set.listItems.get((int)5).item.skills));
            properties.put(prefix + "charmSlot", String.valueOf(set.listItems.get((int)5).item.slotCount));
        }
        number = 1;
        for (PSItem item : Repository.getBaseItems().listCharm) {
            prefix = "charm." + number + ".";
            ++number;
            properties.put(prefix + "name", item.name);
            properties.put(prefix + "skill", this.SkillSetToString(item.skills));
            properties.put(prefix + "slotCount", String.valueOf(item.slotCount));
        }
        try (FileOutputStream out = new FileOutputStream(this.file);){
            OutputStreamWriter writer = new OutputStreamWriter(out);
            BufferedWriter buff = new BufferedWriter(writer);
            for (String key : properties.keySet()) {
                String value = (String)properties.get(key);
                buff.write(key);
                buff.write("=");
                if (value == null) {
                    value = "";
                }
                buff.write(value);
                buff.write("\n");
            }
            buff.flush();
        }
    }

    public String renketu(Collection<String> list) {
        String[] array = new String[list.size()];
        list.toArray(array);
        return this.renketu(array);
    }

    public String renketu(String[] values) {
        StringBuilder str = new StringBuilder();
        for (String elem : values) {
            if (str.length() != 0) {
                str.append(",");
            }
            if (elem.indexOf(44) > 0) {
                str.append('\"');
                str.append(elem);
                str.append('\"');
                continue;
            }
            str.append(elem);
        }
        return str.toString();
    }

    public String SkillSetToString(SkillSet set) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < set.size(); ++i) {
            list.add(set.kind((int)i).name + "=" + set.point(i) + (set.positive(i) ? "+" : "-"));
        }
        return this.renketu(list);
    }

    public SkillSet StringToSkillSet(String str) {
        SkillSet set = new SkillSet();
        CSVReader.bunkatu(str, ',', this.cache1);
        for (String value : this.cache1) {
            int x = value.indexOf("=");
            String kind = value.substring(0, x);
            value = value.substring(x + 1);
            boolean positiveRange = false;
            if (value.endsWith("+")) {
                positiveRange = true;
                value = value.substring(0, value.length() - 1);
            } else if (value.endsWith("-")) {
                positiveRange = false;
                value = value.substring(0, value.length() - 1);
            }
            SkillKind kindObj = Repository.getSkillCategories().findKindByName(kind);
            set.set(kindObj, Integer.valueOf(value), positiveRange);
        }
        return set;
    }
}

