/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.decoration;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import portablesimulator.PSArmorSet;
import portablesimulator.PSItem;
import portablesimulator.PSWrap;
import portablesimulator.csv.PSSession;
import portablesimulator.csv.Repository;
import portablesimulator.decoration.DecorationCount;
import portablesimulator.decoration.DecorationMatcherFixed;
import portablesimulator.decoration.DecorationSlot;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class DecorationMatcherFull {
    public ArrayList<PSItem> _listDeco;
    public ArrayList<PSItem> _listDecoMatome;
    public int[] _relationDeco;
    public boolean _quickScan = true;
    public PSSession _session;
    public SkillSet _targetSkills;
    public boolean _useAnotherCheck = false;
    public boolean _existAnotherSlot = false;
    public boolean _existAnotherSkill = false;
    public int[] decosScore;
    public boolean _debug = false;
    public DecorationMatcherFull _conflictMatcher = null;
    public int[] _existRelation = null;
    public boolean _existConflict = false;
    public boolean useFixed = false;
    DecorationSlot slot;
    HashMap<SkillKind, Double[]> weight = new HashMap();
    HashMap<RelationKey, int[]> relationCache = new HashMap();
    RelationKey pool1 = new RelationKey();
    int[] step_cache = null;
    SkillSet cache1 = new SkillSet();
    static int maxQueue = 0;

    public DecorationMatcherFull(PSSession session) {
        this(session, false);
    }

    public DecorationMatcherFull(PSSession session, boolean useFixed) {
        int i;
        this._session = session;
        this._targetSkills = this._session.searchSkills;
        this._listDeco = new ArrayList();
        ArrayList<PSItem> deco0 = new ArrayList<PSItem>();
        ArrayList<PSItem> deco1 = new ArrayList<PSItem>();
        ArrayList<PSItem> deco2 = new ArrayList<PSItem>();
        ArrayList<PSItem> deco3 = new ArrayList<PSItem>();
        block12: for (i = 0; i < Repository.getBaseItems().listDecoration.size(); ++i) {
            PSItem deco = Repository.getBaseItems().listDecoration.get(i);
            if (!this.decoIsForSkillKind(deco, this._session.searchSkills)) continue;
            if (this._session.searchWithUsableStatus && this._session.items.searchUsableCount != null) {
                int uc = this._session.items.searchUsableCount.get(deco);
                if (uc == 0) continue;
                if (uc != Integer.MAX_VALUE) {
                    this._quickScan = false;
                }
            } else if (deco.existHunterRank > this._session.searchHunterRank && deco.existTownRank > this._session.searchTownRank) continue;
            switch (deco.slotCount) {
                case 0: {
                    deco0.add(deco);
                    continue block12;
                }
                case 1: {
                    deco1.add(deco);
                    continue block12;
                }
                case 2: {
                    deco2.add(deco);
                    continue block12;
                }
                case 3: {
                    deco3.add(deco);
                }
            }
        }
        for (int x = 1; x <= 3; ++x) {
            ArrayList<PSItem> list = null;
            switch (x) {
                case 0: {
                    list = deco0;
                    break;
                }
                case 1: {
                    list = deco1;
                    break;
                }
                case 2: {
                    list = deco2;
                    break;
                }
                case 3: {
                    list = deco3;
                }
            }
            ArrayList<PSItem> dummyList = new ArrayList<PSItem>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                PSItem i1 = (PSItem)list.get(i2);
                if (i1.isVirtual) continue;
                SkillSet is = i1.skills.fixColumnBy(this._targetSkills);
                PSItem dummy = null;
                for (int j = i2 + 1; j < list.size(); ++j) {
                    SkillSet js;
                    PSItem j1 = (PSItem)list.get(j);
                    if (j1.isVirtual || !is.equals(js = j1.skills.fixColumnBy(this._targetSkills))) continue;
                    if (dummy == null) {
                        dummy = new PSItem(5, "\u73e0 [" + is.canonicalString() + "]");
                        dummy.slotCount = x;
                        dummy.isVirtual = true;
                        dummyList.add(dummy);
                    }
                    if (dummy.sameGroup == null) {
                        dummy.sameGroup = new ArrayList();
                    }
                    dummy.sameGroup.add(j1);
                    list.remove(j);
                    --j;
                }
                if (dummy == null) continue;
                if (dummy.sameGroup == null) {
                    dummy.sameGroup = new ArrayList();
                }
                dummy.sameGroup.add(i1);
                list.remove(i2);
                --i2;
            }
            list.addAll(dummyList);
            this._listDeco.addAll(list);
        }
        this._existRelation = this.getPlusRelation(this._session.searchSkills);
        if (this._existRelation != null) {
            for (i = 0; i < this._existRelation.length; ++i) {
                if (this._existRelation[i] == 0) continue;
                this._existConflict = true;
            }
        }
        if (this._existConflict) {
            SkillSet skill1 = this._session.searchSkills;
            SkillSet skill2 = new SkillSet();
            for (int x = 0; x < skill1.size(); ++x) {
                if (!skill1.positive(x) || skill1.point(x) <= 0) continue;
                skill2.set(skill1.kind(x), skill1.point(x), skill1.positive(x));
            }
            PSSession search2 = this._session.makeCopy();
            search2.searchSkills.set_all(skill2);
            this._conflictMatcher = new DecorationMatcherFull(search2);
        } else {
            this._existRelation = null;
        }
        if (useFixed) {
            TreeSet<PSItem> matome = new TreeSet<PSItem>(new DecorationMatcherFixed.DecosComparator());
            this.createMatomeDeco(matome, 1, Repository.getBaseItems().listDecoration);
            this.createMatomeDeco(matome, 2, Repository.getBaseItems().listDecoration);
            this.createMatomeDeco(matome, 3, Repository.getBaseItems().listDecoration);
            ArrayList<PSItem> matomeDeco = new ArrayList<PSItem>(matome);
            this._listDecoMatome = new ArrayList();
            Iterator<PSItem> it = matomeDeco.iterator();
            block18: while (it.hasNext()) {
                PSItem item = it.next();
                item.name = item.skills.toString();
                for (int i3 = 0; i3 < matomeDeco.size(); ++i3) {
                    PSItem item2 = matomeDeco.get(i3);
                    if (item == item2 || item.slotCount != item2.slotCount || !item2.skills.isOver(item.skills)) continue;
                    it.remove();
                    continue block18;
                }
            }
            this._listDecoMatome.addAll(matome);
        }
    }

    public void createMatomeDeco(TreeSet<PSItem> matomeDeco, int slotCount, ArrayList<PSItem> listDeco) {
        PSItem dummy1 = new PSItem(6, "dummy1");
        dummy1.skills = new SkillSet().fixColumnBy(this._targetSkills);
        dummy1.slotCount = slotCount;
        this.catDeco(matomeDeco, slotCount, dummy1, listDeco);
    }

    public void catDeco(TreeSet<PSItem> matomeDeco, int maxSlotCount, PSItem dummy, List<PSItem> listDeco) {
        if (maxSlotCount <= 0) {
            matomeDeco.add(dummy);
            return;
        }
        for (int i = 0; i < listDeco.size(); ++i) {
            PSItem deco = listDeco.get(i);
            if (!this.decoIsForSkillKind(deco, this._targetSkills) || maxSlotCount < deco.slotCount) continue;
            SkillSet skills = new SkillSet().fixColumnBy(this._targetSkills);
            skills.add_only(dummy.skills);
            skills.add_only(deco.skills);
            skills = skills.fixColumnBy(this._targetSkills);
            PSItem next = new PSItem(6, skills.toString());
            next.slotCount = dummy.slotCount;
            next.skills = skills;
            this.catDeco(matomeDeco, maxSlotCount - deco.slotCount, next, listDeco);
        }
    }

    public double getDecorationWeight(SkillKind kind, boolean range, int slotMax) {
        Double[] x = this.weight.get(kind);
        if (x == null) {
            x = new Double[5];
            for (int width = 0; width <= 3; ++width) {
                double savedWeight = 10.0;
                for (int i = 0; i < this._listDeco.size(); ++i) {
                    SkillSet skills = this._listDeco.get((int)i).skills;
                    int n = skills.indexOfKind(kind);
                    if (n < 0 || this._listDeco.get((int)i).slotCount > width) continue;
                    int point = skills.point(n);
                    if (!range) {
                        point = -point;
                    }
                    if (point < 1) continue;
                    double weight = point;
                    if (!((weight = (double)this._listDeco.get((int)i).slotCount / weight) < savedWeight)) continue;
                    savedWeight = weight;
                }
                x[width] = savedWeight;
            }
            this.weight.put(kind, x);
        }
        return x[slotMax];
    }

    public int[] getPlusRelationCached(SkillSet diffSkills) {
        this.pool1.set(diffSkills);
        if (this.relationCache.containsKey(this.pool1)) {
            return this.relationCache.get(this.pool1);
        }
        int[] ret = this.getPlusRelation(diffSkills);
        this.relationCache.put(this.pool1.makeCopy(), ret);
        return ret;
    }

    public int[] getPlusRelation(SkillSet diffSkills) {
        int i;
        int[] relation = new int[diffSkills.size()];
        boolean found = false;
        int counter = 1;
        for (i = 0; i < relation.length; ++i) {
            relation[i] = 0;
        }
        for (i = 0; i < diffSkills.size(); ++i) {
            SkillKind kind = diffSkills.kind(i);
            boolean range = diffSkills.positive(i);
            int point = diffSkills.point(i);
            if (range && point <= 0 || !range && point >= 0) continue;
            for (int k = 0; k < this._listDeco.size(); ++k) {
                PSItem deco = this._listDeco.get(k);
                int x = deco.skills.indexOfKind(kind);
                if (x < 0) continue;
                int decoPoint = deco.skills.point(x);
                if (range && decoPoint <= 0 || !range && decoPoint >= 0) continue;
                SkillKind anotherDecoSkill = deco.skills.kind(1 - x);
                int anotherDecoPoint = deco.skills.point(1 - x);
                for (int j = 0; j < diffSkills.size(); ++j) {
                    int m;
                    int org;
                    SkillKind kind2;
                    if (i == j || (kind2 = diffSkills.kind(j)) != anotherDecoSkill) continue;
                    boolean range2 = diffSkills.positive(j);
                    int point2 = diffSkills.point(j);
                    if (range2 && point2 <= 0 || !range2 && point2 >= 0 || range2 && anotherDecoPoint <= 0 || !range2 && anotherDecoPoint >= 0) continue;
                    found = true;
                    if (relation[i] >= 1) {
                        if (relation[i] == relation[j]) continue;
                        if (relation[j] >= 1) {
                            org = relation[j];
                            for (m = 0; m < relation.length; ++m) {
                                if (relation[m] != org) continue;
                                relation[m] = relation[i];
                            }
                            continue;
                        }
                        relation[j] = relation[i];
                        continue;
                    }
                    if (relation[j] >= 1) {
                        if (relation[i] == relation[j]) continue;
                        if (relation[i] >= 1) {
                            org = relation[i];
                            for (m = 0; m < relation.length; ++m) {
                                if (relation[m] != org) continue;
                                relation[m] = relation[j];
                            }
                            continue;
                        }
                        relation[i] = relation[j];
                        continue;
                    }
                    relation[i] = counter;
                    relation[j] = counter++;
                }
            }
        }
        if (found) {
            return relation;
        }
        return null;
    }

    public int getNeedSlotCount(DecorationSlot slot) {
        int i;
        int width = slot.getSlotMaxCount();
        int width2 = slot.getBodyAvailable();
        if (width2 > width) {
            width = width2;
        }
        if (this.step_cache == null || this.step_cache.length != slot.diffSkills.size()) {
            this.step_cache = new int[slot.diffSkills.size()];
        }
        int[] stepCount = this.step_cache;
        for (int i2 = 0; i2 < stepCount.length; ++i2) {
            stepCount[i2] = 0;
        }
        int needSlotCount = 0;
        for (i = 0; i < slot.diffSkills.size(); ++i) {
            SkillKind kind = slot.diffSkills.kind(i);
            boolean range = slot.diffSkills.positive(i);
            int point = slot.diffSkills.point(i);
            if (!range) {
                point = -point;
            }
            if (point < 1) continue;
            double weight = this.getDecorationWeight(kind, range, width);
            stepCount[i] = (int)Math.ceil(weight * (double)point - 0.1);
        }
        needSlotCount = 0;
        for (i = 0; i < slot.diffSkills.size(); ++i) {
            needSlotCount += stepCount[i];
        }
        if (needSlotCount == 0) {
            return 0;
        }
        if (this._existRelation != null) {
            int[] relation = this.getPlusRelationCached(slot.diffSkills);
            if (relation != null) {
                int[] sumPositive = new int[slot.diffSkills.size()];
                int[] sumNegative = new int[slot.diffSkills.size()];
                for (int x = 0; x < relation.length; ++x) {
                    int pos = relation[x];
                    if (pos == 0 || slot.diffSkills.positive(x)) {
                        int n = pos;
                        sumPositive[n] = sumPositive[n] + stepCount[x];
                        continue;
                    }
                    int n = pos;
                    sumNegative[n] = sumNegative[n] + stepCount[x];
                }
                needSlotCount = 0;
                for (int i3 = 0; i3 < sumPositive.length; ++i3) {
                    if (i3 == 0) {
                        needSlotCount += sumPositive[i3] + sumNegative[i3];
                        continue;
                    }
                    if (sumPositive[i3] > sumNegative[i3]) {
                        needSlotCount += sumPositive[i3];
                        continue;
                    }
                    needSlotCount += sumNegative[i3];
                }
                return needSlotCount;
            }
            return needSlotCount;
        }
        return needSlotCount;
    }

    public boolean canHaveEnoughDecoration(PSArmorSet set, boolean fullScan, List<DecorationSlot> result) {
        int cntCheck = 0;
        int cntSkip = 0;
        if (this._useAnotherCheck) {
            this._existAnotherSlot = false;
            this._existAnotherSkill = false;
        }
        if (this._conflictMatcher != null && !this._conflictMatcher.canHaveEnoughDecoration(set, fullScan, null)) {
            return false;
        }
        boolean isCached = false;
        TreeSet<DecorationSlot> queue = new TreeSet<DecorationSlot>(new QueueComparator(fullScan));
        HashSet<DecorationSlot> already = new HashSet<DecorationSlot>();
        boolean found = false;
        set.calculateUseList(this._targetSkills);
        SkillSet masked = set.setSkills;
        SkillSet diffSkill = this.cache1;
        diffSkill.set_all(this._session.searchSkills);
        diffSkill.minus_fixed(masked);
        DecorationSlot slot = this.useFixed ? new DecorationSlot(this._listDecoMatome) : new DecorationSlot(this._listDeco);
        int slotCount = set.weaponSlotCount;
        if (slotCount < 0) {
            slotCount = 0;
        }
        slot.construct(diffSkill, set, slotCount);
        int needSlotCount = this.getNeedSlotCount(slot);
        if (set.weaponSlotCount < 0) {
            if (needSlotCount == 0) {
                if (result != null) {
                    result.add(slot);
                }
                return true;
            }
            return false;
        }
        if (needSlotCount > slot.totalAvailCount()) {
            return false;
        }
        if (this._debug) {
            System.out.println("enter       " + set);
            System.out.println("searchSkill " + this._session.searchSkills);
            System.out.println("setSkill    " + set.setSkills);
            System.out.println("diffSkill   " + slot.diffSkills);
            System.out.println("test        " + needSlotCount + " <= " + slot.totalAvailCount());
        }
        queue.add(slot);
        while (!queue.isEmpty()) {
            DecorationSlot next;
            PSItem deco;
            int i;
            boolean hit;
            slot = (DecorationSlot)queue.pollLast();
            if (!this.useFixed) {
                if (already.contains(slot)) {
                    ++cntSkip;
                    continue;
                }
                ++cntCheck;
                already.add(slot);
            }
            boolean bl = hit = (needSlotCount = this.getNeedSlotCount(slot)) <= 0;
            if (hit && this._session.searchWithUsableStatus && this._session.items != null && !this.checkUsableCount(slot) || needSlotCount > slot.totalAvailCount()) continue;
            if (hit) {
                found = true;
                if (result != null) {
                    result.add(slot);
                }
                if (fullScan) continue;
                return found;
            }
            if (this._debug) {
                System.out.println("diffSkill   " + slot.diffSkills);
                System.out.println("test        " + needSlotCount + " <= " + slot.totalAvailCount());
            }
            int bodyWidth = slot.getBodyAvailable();
            int maxWidth = slot.getSlotMaxCount();
            if (this.useFixed) {
                for (i = 0; i < this._listDecoMatome.size(); ++i) {
                    deco = this._listDecoMatome.get(i);
                    if (!this.decoIsForDiffSkillFixed(deco, slot.diffSkills, this._quickScan && result != null)) continue;
                    if (bodyWidth == deco.slotCount && (next = slot.applyToBody(deco)) != null) {
                        queue.add(next);
                    }
                    if (maxWidth != deco.slotCount || (next = slot.applyAutoFixed(deco)) == null) continue;
                    queue.add(next);
                }
                continue;
            }
            for (i = 0; i < this._listDeco.size(); ++i) {
                deco = this._listDeco.get(i);
                if (!this.decoIsForDiffSkill(deco, slot.diffSkills, this._quickScan && result != null)) continue;
                if (bodyWidth >= deco.slotCount && (next = slot.applyToBody(deco)) != null) {
                    queue.add(next);
                }
                if (maxWidth < deco.slotCount || (next = slot.applyAuto(deco)) == null) continue;
                queue.add(next);
            }
        }
        return found;
    }

    public boolean checkUsableCount(DecorationSlot set) {
        int i;
        if (this._session.items.searchUsableCount == null) {
            return true;
        }
        DecorationCount map = new DecorationCount(this._listDeco);
        for (i = 0; i < set.mapDecoration.size(); ++i) {
            map.add(set.mapDecoration.deco(i), set.mapDecoration.count(i));
        }
        for (i = 0; i < set.mapBodyDecoration.size(); ++i) {
            map.add(set.mapDecoration.deco(i), set.mapDecoration.count(i));
        }
        for (i = 0; i < map.size(); ++i) {
            PSItem item = map.deco(i);
            int count = map.count(i);
            Integer x = this._session.items.searchUsableCount.get(item);
            if (x == null || x == Integer.MAX_VALUE || count <= x) continue;
            return false;
        }
        return true;
    }

    public boolean decoIsForDiffSkill(PSItem item, SkillSet skills, boolean quickScan) {
        for (int i = 0; i < skills.size(); ++i) {
            int x;
            SkillKind kind = skills.kind(i);
            boolean range = skills.positive(i);
            int point1 = skills.point(i);
            if ((!range || point1 < 1) && !(!range & point1 <= -1) || (x = item.skills.indexOfKind(kind)) < 0) continue;
            if (this._existRelation != null && this._existRelation[i] != 0) {
                return true;
            }
            int point2 = item.skills.point(x);
            if (!(range ? point2 >= 1 : point2 <= -1)) continue;
            return true;
        }
        return false;
    }

    public boolean decoIsForDiffSkillFixed(PSItem item, SkillSet diffSkill, boolean quickScan) {
        for (int i = 0; i < diffSkill.size(); ++i) {
            SkillKind kind = diffSkill.kind(i);
            boolean range = diffSkill.positive(i);
            int point1 = diffSkill.point(i);
            if (range ? point1 >= 0 : point1 <= 0) continue;
            for (int x = 0; x < item.skills.size; ++x) {
                SkillKind kind2 = item.skills.kind(x);
                boolean range2 = item.skills.positive(x);
                int point2 = item.skills.point(x);
                if (kind != kind2 || !(range ? point2 > 0 : point2 < 0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean decoIsForSkillKind(PSItem item, SkillSet skills) {
        for (int i = 0; i < skills.size(); ++i) {
            SkillKind kind = skills.kind(i);
            boolean range = skills.positive(i);
            int point1 = skills.point(i);
            int x = item.skills.indexOfKind(kind);
            if (x < 0) continue;
            int point2 = item.skills.point(x);
            if (!(range ? point2 >= 1 : point2 <= -1)) continue;
            return true;
        }
        return false;
    }

    public static boolean existMoreSlot(List<DecorationSlot> prevResult) {
        for (DecorationSlot slot : prevResult) {
            int x = slot.totalAvailCount();
            if (x < 1) continue;
            return true;
        }
        return false;
    }

    public int fixRealWeaponSlot(PSArmorSet set, List<DecorationSlot> prevResult) {
        if (set.weaponSlotCount <= 0) {
            return set.weaponSlotCount;
        }
        int maxAvailable = 0;
        for (DecorationSlot slot : prevResult) {
            int x = slot.getWeaponSlotAvailable();
            if (x < maxAvailable) continue;
            maxAvailable = x;
        }
        return set.weaponSlotCount - maxAvailable;
    }

    public boolean isCharmHaveReplacement(PSArmorSet set, PSWrap noneItem) {
        PSWrap charm = set.listItems.get(5);
        boolean found = false;
        if (charm == null) {
            return false;
        }
        if (charm != noneItem) {
            set.listItems.set(5, noneItem);
            set.calculateUseList(this._targetSkills);
            if (this.canHaveEnoughDecoration(set, false, null)) {
                found = true;
            }
        }
        if (!found) {
            for (PSWrap replace : charm.childArmors) {
                if (replace.item == charm.item) continue;
                set.listItems.set(5, replace);
                set.calculateUseList(this._targetSkills);
                if (!this.canHaveEnoughDecoration(set, false, null)) continue;
                found = true;
                break;
            }
        }
        set.listItems.set(5, charm);
        set.calculateUseList(this._targetSkills);
        return found;
    }

    class QueueComparator
    implements Comparator {
        boolean _fullScan = false;

        public QueueComparator(boolean fullScan) {
            this._fullScan = fullScan;
        }

        public int compare(Object t, Object t1) {
            int x;
            int i;
            DecorationSlot slot1 = (DecorationSlot)t;
            DecorationSlot slot2 = (DecorationSlot)t1;
            for (i = 0; i < slot1.slotAvail.length; ++i) {
                x = slot1.slotAvail[i] - slot2.slotAvail[i];
                if (x < 0) {
                    return -1;
                }
                if (x <= 0) continue;
                return 1;
            }
            for (i = 0; i < slot1.diffSkills.size; ++i) {
                x = slot1.diffSkills.listPoint[i] - slot2.diffSkills.listPoint[i];
                if (x < 0) {
                    return -1;
                }
                if (x <= 0) continue;
                return 1;
            }
            if (this._fullScan) {
                for (i = 0; i < slot1.listDeco.size(); ++i) {
                    x = slot1.mapDecoration.count(i) - slot1.mapDecoration.count(i);
                    if (x < 0) {
                        return -1;
                    }
                    if (x > 0) {
                        return 1;
                    }
                    x = slot1.mapBodyDecoration.count(i) - slot1.mapBodyDecoration.count(i);
                    if (x < 0) {
                        return -1;
                    }
                    if (x <= 0) continue;
                    return 1;
                }
            }
            return 0;
        }
    }

    public static class RelationKey {
        boolean[] key;
        int hashCode;

        public void set(SkillSet diffSkills) {
            if (this.key == null || this.key.length != diffSkills.size()) {
                this.key = new boolean[diffSkills.size()];
            }
            StringBuilder str = new StringBuilder();
            this.hashCode = 0;
            for (int i = 0; i < diffSkills.size(); ++i) {
                this.hashCode <<= 1;
                this.key[i] = false;
                SkillKind kind = diffSkills.kind(i);
                boolean range = diffSkills.positive(i);
                int point = diffSkills.point(i);
                if (range && point <= 0 || !range && point >= 0) continue;
                this.key[i] = true;
                ++this.hashCode;
            }
        }

        public RelationKey makeCopy() {
            RelationKey another = new RelationKey();
            another.key = new boolean[this.key.length];
            another.hashCode = this.hashCode;
            for (int i = 0; i < this.key.length; ++i) {
                another.key[i] = this.key[i];
            }
            return another;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object t) {
            RelationKey target = (RelationKey)t;
            if (this.hashCode != target.hashCode) {
                return false;
            }
            if (this.key.length != target.key.length) {
                return false;
            }
            for (int i = 0; i < this.key.length; ++i) {
                if (this.key[i] == target.key[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class DecosComparator
    implements Comparator<PSItem> {
        @Override
        public int compare(PSItem t1, PSItem t2) {
            if (t1.slotCount < t2.slotCount) {
                return -1;
            }
            if (t1.slotCount > t2.slotCount) {
                return 1;
            }
            return t1.skills.compareTo(t2.skills);
        }
    }
}

