/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import portablesimulator.PSItem;
import portablesimulator.csv.Repository;
import portablesimulator.gui.JCheckBoxEx;
import portablesimulator.gui.PSFrame;

public class MyCheckBoxForCandidate
extends JCheckBoxEx {
    public final PSItem item;
    public final PSFrame frame;
    private static Timer timer = new Timer(true);
    private TimerTask task;
    private ActionListener al;
    private JPopupMenu menu;
    private JMenuItem menuItemSelectOnly;
    private JMenuItem menuItemSelectExclude;
    private JMenuItem menuItemSelectSame;
    private JMenuItem menuItemSelectAll;
    private JMenuItem menuItemCancel;

    public MyCheckBoxForCandidate(PSFrame frame, PSItem item) {
        this.frame = frame;
        this.item = item;
        this.task = null;
        this.setSelected(Repository.getConfig().lastSession.items.isCandidateChecked(item));
        if (item.itemType == 5) {
            this.setText(item.name + item.skills.skillToString(null, true) + "[" + item.slotCount + "]");
        } else {
            this.setText(item.name + "[" + item.slotCount + "]");
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 1) {
                    if (me.getButton() != 1) {
                        MyCheckBoxForCandidate.this.showPopupMenu(me.getX(), me.getY());
                    } else if ((me.getModifiers() & 2) != 0) {
                        MyCheckBoxForCandidate.this.showPopupMenu(me.getX(), me.getY());
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                MyCheckBoxForCandidate.this.schedulePopup(me.getX(), me.getY());
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                MyCheckBoxForCandidate.this.cancelPopup();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                MyCheckBoxForCandidate.this.cancelPopup();
            }
        });
        this.al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MyCheckBoxForCandidate.this.menuActionPerformed(ae);
            }
        };
        this.addActionListener(this.al);
    }

    public void showPopupMenu(final int x, final int y) {
        PSItem e = this.item;
        this.menu = new JPopupMenu();
        this.menuItemSelectOnly = new JMenuItem(e.getArmorName() + "\u306e\u307f");
        this.menuItemSelectOnly.addActionListener(this.al);
        this.menu.add(this.menuItemSelectOnly);
        this.menuItemSelectExclude = new JMenuItem(e.getArmorName() + "\u4ee5\u5916");
        this.menuItemSelectExclude.addActionListener(this.al);
        this.menu.add(this.menuItemSelectExclude);
        this.menuItemSelectSame = new JMenuItem(e.formatPartsName() + "\u5168\u3066");
        this.menuItemSelectSame.addActionListener(this.al);
        this.menu.add(this.menuItemSelectSame);
        this.menuItemSelectAll = new JMenuItem("\u5168\u90e8\u4f4d\u306e\u5168\u3066");
        this.menuItemSelectAll.addActionListener(this.al);
        this.menu.add(this.menuItemSelectAll);
        this.menuItemCancel = new JMenuItem("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.menu.add(this.menuItemCancel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyCheckBoxForCandidate.this.menu.show(MyCheckBoxForCandidate.this, x, y);
            }
        });
    }

    public void menuActionPerformed(ActionEvent ae) {
        block5: {
            List<MyCheckBoxForCandidate> list;
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (ae.getSource() != this) break block4;
                            this.frame.doPrintTextArea(this.item.getFormatted(), "\u30a2\u30a4\u30c6\u30e0\u8a73\u7d30");
                            break block5;
                        }
                        list = this.item.itemType == 5 ? this.frame.getCandidate3List() : this.frame.getCandidateList();
                        if (ae.getSource() != this.menuItemSelectOnly) break block6;
                        for (MyCheckBoxForCandidate box : list) {
                            if (box.item.itemType != this.item.itemType) continue;
                            box.setSelected(box.item == this.item);
                        }
                        break block5;
                    }
                    if (ae.getSource() != this.menuItemSelectExclude) break block7;
                    for (MyCheckBoxForCandidate box : list) {
                        if (box.item.itemType != this.item.itemType) continue;
                        box.setSelected(box.item != this.item);
                    }
                    break block5;
                }
                if (ae.getSource() != this.menuItemSelectAll) break block8;
                for (MyCheckBoxForCandidate box : list) {
                    box.setSelected(true);
                }
                break block5;
            }
            if (ae.getSource() != this.menuItemSelectSame) break block5;
            for (MyCheckBoxForCandidate box : list) {
                if (box.item.itemType != this.item.itemType) continue;
                box.setSelected(true);
            }
        }
    }

    public void schedulePopup(final int x, final int y) {
        this.task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Timer timer = timer;
                synchronized (timer) {
                    MyCheckBoxForCandidate.this.task = null;
                    MyCheckBoxForCandidate.this.showPopupMenu(x, y);
                }
            }
        };
        timer.schedule(this.task, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPopup() {
        Timer timer = MyCheckBoxForCandidate.timer;
        synchronized (timer) {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

