/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import portablesimulator.PSItem;
import portablesimulator.PSWrap;
import portablesimulator.csv.Repository;
import portablesimulator.gui.JCheckBoxEx;
import portablesimulator.gui.PSFrame;

public class MyCheckBoxForCheckTool
extends JCheckBoxEx {
    public final PSWrap wrap;
    public final PSFrame frame;
    private static Timer timer = new Timer(true);
    private TimerTask task = null;
    private TimerTask task2 = null;
    private JPopupMenu menu = null;
    private ActionListener al = null;
    private JMenuItem menuItemSelectOnly;
    private JMenuItem menuItemSelectExclude;
    private JMenuItem menuItemSelectSame;
    private JMenuItem menuItemSelectAll;
    private JMenuItem menuItemCancel;

    public void updateViewCount() {
        PSItem item = this.wrap.item;
        int count = item.viewCount;
        if (item.itemType == 5) {
            this.setText(item.name + item.skills.skillToString(null, true) + "[" + item.slotCount + "] = " + count);
        } else {
            this.setText(item.name + "[" + item.slotCount + "] = " + count);
        }
    }

    public MyCheckBoxForCheckTool(PSFrame frame, PSWrap wrap) {
        this.frame = frame;
        this.wrap = wrap;
        this.task = null;
        this.updateViewCount();
        this.setSelected(Repository.getConfig().lastSession.items.isViewChecked(wrap.item));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 1) {
                    if (me.getButton() != 1) {
                        MyCheckBoxForCheckTool.this.showPopupMenu(me.getX(), me.getY());
                    } else if ((me.getModifiers() & 2) != 0) {
                        MyCheckBoxForCheckTool.this.showPopupMenu(me.getX(), me.getY());
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                MyCheckBoxForCheckTool.this.schedulePopup(me.getX(), me.getY());
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                MyCheckBoxForCheckTool.this.cancelPopup();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                MyCheckBoxForCheckTool.this.cancelPopup();
            }
        });
        this.al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MyCheckBoxForCheckTool.this.menuActionPerformed(ae);
            }
        };
        this.addActionListener(this.al);
    }

    public void showPopupMenu(final int x, final int y) {
        PSItem item = this.wrap.item;
        this.menu = new JPopupMenu();
        this.menuItemSelectOnly = new JMenuItem(item.getArmorName() + "\u306e\u307f");
        this.menuItemSelectOnly.addActionListener(this.al);
        this.menu.add(this.menuItemSelectOnly);
        this.menuItemSelectExclude = new JMenuItem(item.getArmorName() + "\u4ee5\u5916");
        this.menuItemSelectExclude.addActionListener(this.al);
        this.menu.add(this.menuItemSelectExclude);
        this.menuItemSelectSame = new JMenuItem(item.formatPartsName() + "\u5168\u3066");
        this.menuItemSelectSame.addActionListener(this.al);
        this.menu.add(this.menuItemSelectSame);
        this.menuItemSelectAll = new JMenuItem("\u5168\u90e8\u4f4d\u306e\u5168\u3066");
        this.menuItemSelectAll.addActionListener(this.al);
        this.menu.add(this.menuItemSelectAll);
        this.menuItemCancel = new JMenuItem("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.menu.add(this.menuItemCancel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyCheckBoxForCheckTool.this.menu.show(MyCheckBoxForCheckTool.this, x, y);
            }
        });
    }

    public void menuActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this) {
            this.frame.doPrintTextArea(this.wrap.item.getFormatted() + this.wrap.getAdditionalInfo(), "\u30a2\u30a4\u30c6\u30e0\u8a73\u7d30");
        } else if (ae.getSource() == this.menuItemSelectOnly) {
            for (MyCheckBoxForCheckTool box : this.frame.getChecktoolList()) {
                if (box.wrap.item.itemType != this.wrap.item.itemType) continue;
                box.setSelected(box.wrap.item == this.wrap.item);
            }
        } else if (ae.getSource() == this.menuItemSelectExclude) {
            for (MyCheckBoxForCheckTool box : this.frame.getChecktoolList()) {
                if (box.wrap.item.itemType != this.wrap.item.itemType) continue;
                box.setSelected(box.wrap.item != this.wrap.item);
            }
        } else if (ae.getSource() == this.menuItemSelectAll) {
            for (MyCheckBoxForCheckTool box : this.frame.getChecktoolList()) {
                box.setSelected(true);
            }
        } else if (ae.getSource() == this.menuItemSelectSame) {
            for (MyCheckBoxForCheckTool box : this.frame.getChecktoolList()) {
                if (box.wrap.item.itemType != this.wrap.item.itemType) continue;
                box.setSelected(true);
            }
        }
        this.scheduleRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRepaint() {
        Timer timer = MyCheckBoxForCheckTool.timer;
        synchronized (timer) {
            if (this.task2 != null) {
                this.task2.cancel();
            }
            this.task2 = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Timer timer = timer;
                    synchronized (timer) {
                        MyCheckBoxForCheckTool.this.task2 = null;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MyCheckBoxForCheckTool.this.frame.doRepaintResultList();
                            }
                        });
                    }
                }
            };
            MyCheckBoxForCheckTool.timer.schedule(this.task2, 1500L);
        }
    }

    public void schedulePopup(final int x, final int y) {
        this.task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Timer timer = timer;
                synchronized (timer) {
                    MyCheckBoxForCheckTool.this.task = null;
                    MyCheckBoxForCheckTool.this.showPopupMenu(x, y);
                }
            }
        };
        timer.schedule(this.task, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPopup() {
        Timer timer = MyCheckBoxForCheckTool.timer;
        synchronized (timer) {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

