/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.skillset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillPoint;

public class SkillCategories {
    private ArrayList<SkillKind> listKind = new ArrayList();
    private Map<String, List<SkillPoint>> mapCategory = new LinkedHashMap<String, List<SkillPoint>>();
    private String DEFAULT_NAME = "\u30ab\u30c6\u30b4\u30ea\u306a\u3057";

    public SkillCategories() {
        this.mapCategory.put(this.DEFAULT_NAME, new ArrayList());
    }

    public SkillPoint getNearSkillPoint(SkillPoint point) {
        SkillPoint found = null;
        for (List<SkillPoint> listPoint : this.mapCategory.values()) {
            for (SkillPoint seek : listPoint) {
                if (seek.skillPoint % 5 != 0 || seek.skillKind != point.skillKind) continue;
                if (point.skillPoint >= 0) {
                    if (point.skillPoint < seek.skillPoint || seek.skillPoint < 0 || found != null && found.skillPoint >= seek.skillPoint) continue;
                    found = seek;
                    continue;
                }
                if (point.skillPoint > seek.skillPoint || seek.skillPoint > 0 || found != null && found.skillPoint <= seek.skillPoint) continue;
                found = seek;
            }
        }
        return found;
    }

    public SkillPoint getMatchSkillPoint(SkillPoint point) {
        Object found = null;
        for (List<SkillPoint> listPoint : this.mapCategory.values()) {
            for (SkillPoint seek : listPoint) {
                if (seek.skillKind != point.skillKind || seek.skillPoint != point.skillPoint) continue;
                return seek;
            }
        }
        return null;
    }

    public ArrayList<SkillPoint> listPoints() {
        ArrayList<SkillPoint> result = new ArrayList<SkillPoint>();
        for (List<SkillPoint> listPoint : this.mapCategory.values()) {
            result.addAll(listPoint);
        }
        return result;
    }

    public SkillPoint findPointByFixedName(String name) {
        for (List<SkillPoint> listPoint : this.mapCategory.values()) {
            for (SkillPoint pt : listPoint) {
                if (pt.pointName == null || !pt.pointName.equals(name)) continue;
                return pt;
            }
        }
        return null;
    }

    public void addPoint(SkillPoint point) {
        List<SkillPoint> list = this.mapCategory.get(this.DEFAULT_NAME);
        list.add(point);
    }

    public List<SkillPoint> addCategory(String categoryName) {
        List<SkillPoint> ret = this.mapCategory.get(categoryName);
        if (ret == null) {
            ret = new ArrayList<SkillPoint>(9);
            this.mapCategory.put(categoryName, ret);
        }
        return ret;
    }

    public Collection<String> listCategoryNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.mapCategory.keySet());
        result.remove(this.DEFAULT_NAME);
        result.add(this.DEFAULT_NAME);
        return result;
    }

    public List<SkillKind> listupKindOrdered() {
        ArrayList<SkillKind> result = new ArrayList<SkillKind>();
        for (String categoryName : this.listCategoryNames()) {
            List<SkillPoint> pointList = this.listPointByCategory(categoryName);
            for (int i = 0; i < pointList.size(); ++i) {
                SkillKind kind = pointList.get((int)i).skillKind;
                if (result.contains(kind)) continue;
                result.add(kind);
            }
        }
        return result;
    }

    public List<SkillPoint> listPointByCategory(String categoryName) {
        final List<SkillPoint> oldList = this.mapCategory.get(categoryName);
        ArrayList<SkillPoint> result = new ArrayList<SkillPoint>(oldList);
        Collections.sort(result, new Comparator<SkillPoint>(){

            @Override
            public int compare(SkillPoint p1, SkillPoint p2) {
                if (p1.skillPoint < 0 && p2.skillPoint >= 0) {
                    return 1;
                }
                if (p2.skillPoint < 0 && p1.skillPoint >= 0) {
                    return -1;
                }
                if (p1.skillKind != p2.skillKind) {
                    int x2;
                    int x1 = oldList.indexOf(p1);
                    if (x1 < (x2 = oldList.indexOf(p2))) {
                        return -1;
                    }
                    if (x1 > x2) {
                        return 1;
                    }
                }
                if (p1.skillPoint > p2.skillPoint) {
                    return -1;
                }
                if (p1.skillPoint < p2.skillPoint) {
                    return 1;
                }
                if (p1.positiveRange != p2.positiveRange) {
                    if (p1.positiveRange) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
        return result;
    }

    public String pointNameToCategory(String pointName) {
        for (String cate : this.mapCategory.keySet()) {
            List<SkillPoint> listPoint = this.mapCategory.get(cate);
            for (int i = 0; i < listPoint.size(); ++i) {
                SkillPoint pt = listPoint.get(i);
                if (!pt.pointName.equals(pointName)) continue;
                return cate;
            }
        }
        return null;
    }

    public SkillPoint pointNameToPoint(String pointName) {
        for (String cate : this.mapCategory.keySet()) {
            List<SkillPoint> listPoint = this.mapCategory.get(cate);
            for (int i = 0; i < listPoint.size(); ++i) {
                SkillPoint pt = listPoint.get(i);
                if (!pt.pointName.equals(pointName)) continue;
                return pt;
            }
        }
        return null;
    }

    public void setCategory(String categoryName, String pointName) {
        SkillPoint pt = this.pointNameToPoint(pointName);
        String cate = this.pointNameToCategory(pointName);
        if (pt == null || cate == null) {
            return;
        }
        List<SkillPoint> oldList = this.mapCategory.get(cate);
        if (cate.equals(categoryName)) {
            return;
        }
        List<SkillPoint> newList = this.mapCategory.get(categoryName);
        if (newList == null) {
            newList = this.addCategory(categoryName);
        }
        if (cate.equals(this.DEFAULT_NAME)) {
            for (int i = 0; i < oldList.size(); ++i) {
                SkillPoint old = oldList.get(i);
                if (pt.skillKind != old.skillKind) continue;
                oldList.remove(i);
                --i;
                newList.add(old);
            }
        } else {
            oldList.remove(pt);
            newList.add(pt);
        }
    }

    public SkillKind findKindByName(String name) {
        int i = this.indexOfKind(name);
        if (i >= 0) {
            return this.listKind.get(i);
        }
        return null;
    }

    public int indexOfKind(String name) {
        for (int i = 0; i < this.listKind.size(); ++i) {
            if (!name.equals(this.listKind.get((int)i).name)) continue;
            return i;
        }
        return -1;
    }

    public void addSkillKind(SkillKind sk) {
        int i = this.indexOfKind(sk.name);
        if (i >= 0) {
            this.listKind.set(i, sk);
        } else {
            this.listKind.add(sk);
        }
    }

    public List<SkillKind> listupKind() {
        return this.listKind;
    }
}

