/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.ITimingLogger;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LauncherLoggingTransformer
extends LauncherTransformer
implements ITimingLogger {
    private static final Logger log = Logger.getLogger(LauncherLoggingTransformer.class);
    private static final String CLASS_NAME = LauncherLoggingTransformer.class.getName();
    private volatile long transformAbstractTime;
    private volatile long transformAbstractCall;
    private volatile long createCtClassTime;
    private volatile long createCtClassCall;
    private volatile long transformTime;
    private volatile long transformCall;
    private volatile long weaveUptimeMethodTime;
    private volatile long weaveUptimeMethodCall;
    private volatile long weaveStartTranslationAspectTime;
    private volatile long weaveStartTranslationAspectCall;

    public LauncherLoggingTransformer() {
        Pleiades.getInstance().registTimingLogger(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String internalName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytecode) throws IllegalClassFormatException {
        long startTime = System.currentTimeMillis();
        byte[] result = super.transform(loader, internalName, classBeingRedefined, protectionDomain, bytecode);
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.transformAbstractTime += System.currentTimeMillis() - startTime;
            ++this.transformAbstractCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        byte[] result = super.transform(loader, className, protectionDomain, bytecode);
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.transformTime += System.currentTimeMillis() - startTime;
            ++this.transformCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] weaveStartTranslationAspect(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        byte[] result = super.weaveStartTranslationAspect(protectionDomain, bytecode);
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.weaveStartTranslationAspectTime += System.currentTimeMillis() - startTime;
            ++this.weaveStartTranslationAspectCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] weaveUptimeMethod(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        CtClass ctClass = this.createCtClass(bytecode, protectionDomain);
        CtMethod runStartupWithProgress = ctClass.getMethod("runStartupWithProgress", "(ILjava/lang/Runnable;)V");
        runStartupWithProgress.insertAfter(String.valueOf(CLASS_NAME) + ".logUptimeAll();");
        byte[] result = ctClass.toBytecode();
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.weaveUptimeMethodTime += System.currentTimeMillis() - startTime;
            ++this.weaveUptimeMethodCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CtClass createCtClass(byte[] bytecode, ProtectionDomain protectionDomain) throws IOException, NotFoundException {
        long startTime = System.currentTimeMillis();
        CtClass result = super.createCtClass(bytecode, protectionDomain);
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.createCtClassTime += System.currentTimeMillis() - startTime;
            ++this.createCtClassCall;
        }
        return result;
    }

    public static void logUptimeAll() {
        for (ITimingLogger logger : Pleiades.getInstance().getTimeingLoggers()) {
            logger.logUptime();
        }
        long startTime = Long.valueOf(System.getProperty("eclipse.startTime"));
        long curTime = System.currentTimeMillis();
        double time = (double)(curTime - startTime) / 1000.0;
        log.debug(String.format("Eclipse \u306e\u8d77\u52d5\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002\u8d77\u52d5\u6642\u9593: %.3f \u79d2", time));
    }

    @Override
    public void logUptime() {
        String msg = "%-31s %6.3f \u79d2\u3001%8d \u56de";
        log.debug(String.format(msg, "transform (Abstract)", (double)this.transformAbstractTime / 1000.0, this.transformAbstractCall));
        log.debug(String.format(msg, "  transform", (double)this.transformTime / 1000.0, this.transformCall));
        log.debug(String.format(msg, "    createCtClass (Abstract)", (double)this.createCtClassTime / 1000.0, this.createCtClassCall));
        log.debug(String.format(msg, "    weaveStartTranslationAspect", (double)this.weaveStartTranslationAspectTime / 1000.0, this.weaveStartTranslationAspectCall));
        log.debug(String.format(msg, "    weaveUptimeMethod", (double)this.weaveUptimeMethodTime / 1000.0, this.weaveUptimeMethodCall));
    }
}

